/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// GRPCRouteRuleApplyConfiguration represents an declarative configuration of the GRPCRouteRule type for use
// with apply.
type GRPCRouteRuleApplyConfiguration struct {
	Matches            []GRPCRouteMatchApplyConfiguration    `json:"matches,omitempty"`
	Filters            []GRPCRouteFilterApplyConfiguration   `json:"filters,omitempty"`
	BackendRefs        []GRPCBackendRefApplyConfiguration    `json:"backendRefs,omitempty"`
	SessionPersistence *SessionPersistenceApplyConfiguration `json:"sessionPersistence,omitempty"`
}

// GRPCRouteRuleApplyConfiguration constructs an declarative configuration of the GRPCRouteRule type for use with
// apply.
func GRPCRouteRule() *GRPCRouteRuleApplyConfiguration {
	return &GRPCRouteRuleApplyConfiguration{}
}

// WithMatches adds the given value to the Matches field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Matches field.
func (b *GRPCRouteRuleApplyConfiguration) WithMatches(values ...*GRPCRouteMatchApplyConfiguration) *GRPCRouteRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithMatches")
		}
		b.Matches = append(b.Matches, *values[i])
	}
	return b
}

// WithFilters adds the given value to the Filters field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Filters field.
func (b *GRPCRouteRuleApplyConfiguration) WithFilters(values ...*GRPCRouteFilterApplyConfiguration) *GRPCRouteRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithFilters")
		}
		b.Filters = append(b.Filters, *values[i])
	}
	return b
}

// WithBackendRefs adds the given value to the BackendRefs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the BackendRefs field.
func (b *GRPCRouteRuleApplyConfiguration) WithBackendRefs(values ...*GRPCBackendRefApplyConfiguration) *GRPCRouteRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithBackendRefs")
		}
		b.BackendRefs = append(b.BackendRefs, *values[i])
	}
	return b
}

// WithSessionPersistence sets the SessionPersistence field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SessionPersistence field is set to the value of the last call.
func (b *GRPCRouteRuleApplyConfiguration) WithSessionPersistence(value *SessionPersistenceApplyConfiguration) *GRPCRouteRuleApplyConfiguration {
	b.SessionPersistence = value
	return b
}
