use strict;
use warnings;

use RT::Test tests => undef;

sub set_fails {
    my $col  = shift;
    my $obj  = shift;
    my $to   = ref $_[0] ? +shift->Id : shift;
    my $from = $obj->$col;
    my $meth = "Set$col";

    my ($ok, $msg) = $obj->$meth($to);
    ok !$ok, "$meth denied: $msg";
    is $obj->$col, $from, "$col left alone";
}

sub set_ok {
    my $col  = shift;
    my $obj  = shift;
    my $to   = ref $_[0] ? +shift->Id : shift;
    my $from = $obj->$col;
    my $meth = "Set$col";

    my ($ok, $msg) = $obj->$meth($to);
    ok $ok, "$meth allowed: $msg";
    is $obj->$col, $to, "$col updated";
}

my $qa = RT::Test->load_or_create_queue( Name => 'Queue A' );
my $qb = RT::Test->load_or_create_queue( Name => 'Queue B' );
ok $qa->id, "created Queue A";
ok $qb->id, "created Queue B";

my $user = RT::Test->load_or_create_user( Name => 'testuser' );
my $cu   = RT::CurrentUser->new( $user );
ok $user->id, "created testuser";

diag "ModifyScrips";
{
    my $scrip = RT::Scrip->new( RT->SystemUser );
    my ($scrip_id, $msg) = $scrip->Create(
        Description     => 'Testing',
        Queue           => $qa->Id,
        ScripCondition  => 'User Defined',
        ScripAction     => 'User Defined',
        Template        => 'Blank',
        CustomIsApplicableCode  => 'if ($self->TicketObj->Subject =~ /fire/) { return (1);} else { return(0)}',
        CustomPrepareCode       => '1;',
        CustomCommitCode        => 'warn "scrip fired!";',
    );
    ok $scrip_id, $msg;

    RT::Test->set_rights(
        { Principal => $user, Right => 'ShowScrips' },
        { Principal => $user, Right => 'ModifyScrips', Object => $qa },
    );

    $scrip = RT::Scrip->new( $cu );
    $scrip->Load( $scrip_id );
    ok $scrip->id, "loaded scrip as test user";
    ok $scrip->IsAdded( $qa->Id ), 'queue is A';

    ok +($scrip->SetName('Testing ModifyScrips'));

    for my $value ($qb->id, 0, undef, '') {
        my ($ok, $why) = $scrip->AddToObject( $value );
        my $disp = (defined($value) ? "'$value'" : "undef");
        ok( !$ok, "Correctly not added to $disp: $why" );
    }

    RT::Test->add_rights( Principal => $user, Right => 'ModifyScrips', Object => $qb );

    for my $value ($qb->id, 0, undef, '') {
        my ($ok, $why) = $scrip->AddToObject( $value );
        my $disp = (defined($value) ? "'$value'" : "undef");
        if ($value) {
            ok( $ok, "Correctly added to $disp: $why" );
        } else {
            ok( !$ok, "Correctly not added to $disp: $why" );
        }
    }

    RT::Test->add_rights( Principal => $user, Right => 'ModifyScrips' );

    my ($ok, $why) = $scrip->AddToObject( 0 );
    ok( $ok, "Correctly added globally: $why" );

    set_fails( Template => $scrip => "Autoreply" );

    RT::Test->add_rights( Principal => $user, Right => 'ShowTemplate' );

    set_ok( Template => $scrip => "Autoreply" );
    is $scrip->Template, 'Autoreply', 'template name is right';
}

diag "ModifyTemplate";
{
    RT::Test->set_rights(
        { Principal => $user, Right => 'ShowTemplate' },
        { Principal => $user, Right => 'ModifyTemplate', Object => $qa },
    );

    my $template = RT::Template->new( RT->SystemUser );
    my ($id, $msg) = $template->Create(
        Queue   => $qa->Id,
        Name    => 'Testing',
        Type    => 'Perl',
        Content => "\n\nThis is a test template.\n",
    );
    ok $id, $msg;

    $template = RT::Template->new( $cu );
    $template->Load( $id );
    ok $template->id, "loaded template as test user";
    is $template->ObjectId, $qa->Id, 'queue is A';

    ok +($template->SetName('Testing ModifyTemplate'));

    set_fails( ObjectId => $template => $qb );
    set_fails( ObjectId => $template => 0 );

    RT::Test->add_rights( Principal => $user, Right => 'ModifyTemplate', Object => $qb );

    set_fails( ObjectId => $template => $qb );
    set_fails( ObjectId => $template => 0 );

    RT::Test->add_rights( Principal => $user, Right => 'ModifyTemplate' );

    set_fails( ObjectId => $template => 0 );
}

done_testing;
