// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//	https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.8
// 	protoc        v6.32.0
// source: internal/mdx/metadata_exchange.proto

package mdx

import (
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the socket-level protocol used by the database client, useful for
// the MySQL caching_sha2_password, which detects the socket type as part
// of the authentication protocol.
type MetadataExchangeRequest_ClientProtocolType int32

const (
	// Client protocol type is unspecified, TCP is used as default.
	MetadataExchangeRequest_CLIENT_PROTOCOL_TYPE_UNSPECIFIED MetadataExchangeRequest_ClientProtocolType = 0
	// TCP socket connection, used for connections through the auth proxy's
	// TCP ports.
	MetadataExchangeRequest_TCP MetadataExchangeRequest_ClientProtocolType = 1
	// TLS socket over TCP, used in the connectors which pass an already
	// connected TCP socket with a complete handshake to the mysql driver.
	MetadataExchangeRequest_TLS MetadataExchangeRequest_ClientProtocolType = 2
	// Unix Domain socket connection, used for connections through the auth
	// proxy's unix sockets.
	MetadataExchangeRequest_UDS MetadataExchangeRequest_ClientProtocolType = 3
)

// Enum value maps for MetadataExchangeRequest_ClientProtocolType.
var (
	MetadataExchangeRequest_ClientProtocolType_name = map[int32]string{
		0: "CLIENT_PROTOCOL_TYPE_UNSPECIFIED",
		1: "TCP",
		2: "TLS",
		3: "UDS",
	}
	MetadataExchangeRequest_ClientProtocolType_value = map[string]int32{
		"CLIENT_PROTOCOL_TYPE_UNSPECIFIED": 0,
		"TCP":                              1,
		"TLS":                              2,
		"UDS":                              3,
	}
)

func (x MetadataExchangeRequest_ClientProtocolType) Enum() *MetadataExchangeRequest_ClientProtocolType {
	p := new(MetadataExchangeRequest_ClientProtocolType)
	*p = x
	return p
}

func (x MetadataExchangeRequest_ClientProtocolType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataExchangeRequest_ClientProtocolType) Descriptor() protoreflect.EnumDescriptor {
	return file_internal_mdx_metadata_exchange_proto_enumTypes[0].Descriptor()
}

func (MetadataExchangeRequest_ClientProtocolType) Type() protoreflect.EnumType {
	return &file_internal_mdx_metadata_exchange_proto_enumTypes[0]
}

func (x MetadataExchangeRequest_ClientProtocolType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataExchangeRequest_ClientProtocolType.Descriptor instead.
func (MetadataExchangeRequest_ClientProtocolType) EnumDescriptor() ([]byte, []int) {
	return file_internal_mdx_metadata_exchange_proto_rawDescGZIP(), []int{0, 0}
}

// The status of the server metadata exchange.
type MetadataExchangeResponse_ResponseStatusCode int32

const (
	// Unknown response code
	MetadataExchangeResponse_RESPONSE_STATUS_CODE_UNSPECIFIED MetadataExchangeResponse_ResponseStatusCode = 0
	// Success
	MetadataExchangeResponse_OK MetadataExchangeResponse_ResponseStatusCode = 1
	// Failure
	MetadataExchangeResponse_ERROR MetadataExchangeResponse_ResponseStatusCode = 2
)

// Enum value maps for MetadataExchangeResponse_ResponseStatusCode.
var (
	MetadataExchangeResponse_ResponseStatusCode_name = map[int32]string{
		0: "RESPONSE_STATUS_CODE_UNSPECIFIED",
		1: "OK",
		2: "ERROR",
	}
	MetadataExchangeResponse_ResponseStatusCode_value = map[string]int32{
		"RESPONSE_STATUS_CODE_UNSPECIFIED": 0,
		"OK":                               1,
		"ERROR":                            2,
	}
)

func (x MetadataExchangeResponse_ResponseStatusCode) Enum() *MetadataExchangeResponse_ResponseStatusCode {
	p := new(MetadataExchangeResponse_ResponseStatusCode)
	*p = x
	return p
}

func (x MetadataExchangeResponse_ResponseStatusCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataExchangeResponse_ResponseStatusCode) Descriptor() protoreflect.EnumDescriptor {
	return file_internal_mdx_metadata_exchange_proto_enumTypes[1].Descriptor()
}

func (MetadataExchangeResponse_ResponseStatusCode) Type() protoreflect.EnumType {
	return &file_internal_mdx_metadata_exchange_proto_enumTypes[1]
}

func (x MetadataExchangeResponse_ResponseStatusCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataExchangeResponse_ResponseStatusCode.Descriptor instead.
func (MetadataExchangeResponse_ResponseStatusCode) EnumDescriptor() ([]byte, []int) {
	return file_internal_mdx_metadata_exchange_proto_rawDescGZIP(), []int{1, 0}
}

// Message used by Cloud SQL connectors, including the Cloud SQL Auth Proxy and
// the Cloud SQL Language Connectors, to exchange client and connection
// metadata.
type MetadataExchangeRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// User agent from the connector sending the request.
	UserAgent *string `protobuf:"bytes,1,opt,name=user_agent,json=userAgent,proto3,oneof" json:"user_agent,omitempty"`
	// Client protocol type, the network protocol used by the database driver to
	// connect, which can affect the database login protocol as it does in MySQL.
	// The client should set this field when the
	// ConnectSettings.mdx_protocol_support field contains CLIENT_PROTOCOL_TYPE.
	ClientProtocolType *MetadataExchangeRequest_ClientProtocolType `protobuf:"varint,2,opt,name=client_protocol_type,json=clientProtocolType,proto3,enum=mdx.MetadataExchangeRequest_ClientProtocolType,oneof" json:"client_protocol_type,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *MetadataExchangeRequest) Reset() {
	*x = MetadataExchangeRequest{}
	mi := &file_internal_mdx_metadata_exchange_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataExchangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataExchangeRequest) ProtoMessage() {}

func (x *MetadataExchangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_internal_mdx_metadata_exchange_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataExchangeRequest.ProtoReflect.Descriptor instead.
func (*MetadataExchangeRequest) Descriptor() ([]byte, []int) {
	return file_internal_mdx_metadata_exchange_proto_rawDescGZIP(), []int{0}
}

func (x *MetadataExchangeRequest) GetUserAgent() string {
	if x != nil && x.UserAgent != nil {
		return *x.UserAgent
	}
	return ""
}

func (x *MetadataExchangeRequest) GetClientProtocolType() MetadataExchangeRequest_ClientProtocolType {
	if x != nil && x.ClientProtocolType != nil {
		return *x.ClientProtocolType
	}
	return MetadataExchangeRequest_CLIENT_PROTOCOL_TYPE_UNSPECIFIED
}

// The response from the Cloud SQL instance back to the connector
// following an MetadataExchangeRequest.
type MetadataExchangeResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Status code.
	ResponseStatusCode *MetadataExchangeResponse_ResponseStatusCode `protobuf:"varint,1,opt,name=response_status_code,json=responseStatusCode,proto3,enum=mdx.MetadataExchangeResponse_ResponseStatusCode,oneof" json:"response_status_code,omitempty"`
	// Error message.
	ErrorMessage  *string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3,oneof" json:"error_message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MetadataExchangeResponse) Reset() {
	*x = MetadataExchangeResponse{}
	mi := &file_internal_mdx_metadata_exchange_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataExchangeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataExchangeResponse) ProtoMessage() {}

func (x *MetadataExchangeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_internal_mdx_metadata_exchange_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataExchangeResponse.ProtoReflect.Descriptor instead.
func (*MetadataExchangeResponse) Descriptor() ([]byte, []int) {
	return file_internal_mdx_metadata_exchange_proto_rawDescGZIP(), []int{1}
}

func (x *MetadataExchangeResponse) GetResponseStatusCode() MetadataExchangeResponse_ResponseStatusCode {
	if x != nil && x.ResponseStatusCode != nil {
		return *x.ResponseStatusCode
	}
	return MetadataExchangeResponse_RESPONSE_STATUS_CODE_UNSPECIFIED
}

func (x *MetadataExchangeResponse) GetErrorMessage() string {
	if x != nil && x.ErrorMessage != nil {
		return *x.ErrorMessage
	}
	return ""
}

var File_internal_mdx_metadata_exchange_proto protoreflect.FileDescriptor

const file_internal_mdx_metadata_exchange_proto_rawDesc = "" +
	"\n" +
	"$internal/mdx/metadata_exchange.proto\x12\x03mdx\"\xa4\x02\n" +
	"\x17MetadataExchangeRequest\x12\"\n" +
	"\n" +
	"user_agent\x18\x01 \x01(\tH\x00R\tuserAgent\x88\x01\x01\x12f\n" +
	"\x14client_protocol_type\x18\x02 \x01(\x0e2/.mdx.MetadataExchangeRequest.ClientProtocolTypeH\x01R\x12clientProtocolType\x88\x01\x01\"U\n" +
	"\x12ClientProtocolType\x12$\n" +
	" CLIENT_PROTOCOL_TYPE_UNSPECIFIED\x10\x00\x12\a\n" +
	"\x03TCP\x10\x01\x12\a\n" +
	"\x03TLS\x10\x02\x12\a\n" +
	"\x03UDS\x10\x03B\r\n" +
	"\v_user_agentB\x17\n" +
	"\x15_client_protocol_type\"\xa7\x02\n" +
	"\x18MetadataExchangeResponse\x12g\n" +
	"\x14response_status_code\x18\x01 \x01(\x0e20.mdx.MetadataExchangeResponse.ResponseStatusCodeH\x00R\x12responseStatusCode\x88\x01\x01\x12(\n" +
	"\rerror_message\x18\x02 \x01(\tH\x01R\ferrorMessage\x88\x01\x01\"M\n" +
	"\x12ResponseStatusCode\x12$\n" +
	" RESPONSE_STATUS_CODE_UNSPECIFIED\x10\x00\x12\x06\n" +
	"\x02OK\x10\x01\x12\t\n" +
	"\x05ERROR\x10\x02B\x17\n" +
	"\x15_response_status_codeB\x10\n" +
	"\x0e_error_messageB\x0eZ\finternal/mdxb\x06proto3"

var (
	file_internal_mdx_metadata_exchange_proto_rawDescOnce sync.Once
	file_internal_mdx_metadata_exchange_proto_rawDescData []byte
)

func file_internal_mdx_metadata_exchange_proto_rawDescGZIP() []byte {
	file_internal_mdx_metadata_exchange_proto_rawDescOnce.Do(func() {
		file_internal_mdx_metadata_exchange_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_internal_mdx_metadata_exchange_proto_rawDesc), len(file_internal_mdx_metadata_exchange_proto_rawDesc)))
	})
	return file_internal_mdx_metadata_exchange_proto_rawDescData
}

var file_internal_mdx_metadata_exchange_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_internal_mdx_metadata_exchange_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_internal_mdx_metadata_exchange_proto_goTypes = []any{
	(MetadataExchangeRequest_ClientProtocolType)(0),  // 0: mdx.MetadataExchangeRequest.ClientProtocolType
	(MetadataExchangeResponse_ResponseStatusCode)(0), // 1: mdx.MetadataExchangeResponse.ResponseStatusCode
	(*MetadataExchangeRequest)(nil),                  // 2: mdx.MetadataExchangeRequest
	(*MetadataExchangeResponse)(nil),                 // 3: mdx.MetadataExchangeResponse
}
var file_internal_mdx_metadata_exchange_proto_depIdxs = []int32{
	0, // 0: mdx.MetadataExchangeRequest.client_protocol_type:type_name -> mdx.MetadataExchangeRequest.ClientProtocolType
	1, // 1: mdx.MetadataExchangeResponse.response_status_code:type_name -> mdx.MetadataExchangeResponse.ResponseStatusCode
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_internal_mdx_metadata_exchange_proto_init() }
func file_internal_mdx_metadata_exchange_proto_init() {
	if File_internal_mdx_metadata_exchange_proto != nil {
		return
	}
	file_internal_mdx_metadata_exchange_proto_msgTypes[0].OneofWrappers = []any{}
	file_internal_mdx_metadata_exchange_proto_msgTypes[1].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_internal_mdx_metadata_exchange_proto_rawDesc), len(file_internal_mdx_metadata_exchange_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_internal_mdx_metadata_exchange_proto_goTypes,
		DependencyIndexes: file_internal_mdx_metadata_exchange_proto_depIdxs,
		EnumInfos:         file_internal_mdx_metadata_exchange_proto_enumTypes,
		MessageInfos:      file_internal_mdx_metadata_exchange_proto_msgTypes,
	}.Build()
	File_internal_mdx_metadata_exchange_proto = out.File
	file_internal_mdx_metadata_exchange_proto_goTypes = nil
	file_internal_mdx_metadata_exchange_proto_depIdxs = nil
}
