//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-metal")]
use objc2_metal::*;

use crate::*;

/// CIImageProvider.
#[cfg(feature = "CIImage")]
impl CIImage {
    extern_methods!(
        #[cfg(feature = "objc2-core-graphics")]
        /// Create an image object based on pixels from an image provider object.
        ///
        /// Core Image retains the provider object until the image is deallocated.
        /// The image provider object will not be called until the image is rendered.
        ///
        /// - Parameters:
        /// - provider: An object that implements the `CIImageProvider` protocol.
        /// - width: The width of the image.
        /// - height: The height of the image.
        /// - format: The ``CIFormat`` of the provided pixels.
        /// - colorSpace: The color space that the image is defined in.
        /// If `nil`, then the pixels will not be is not color matched to the Core Image working color space.
        /// - options: A dictionary that contains various ``CIImageOption`` keys that affect the resulting ``CIImage``.
        /// The option ``kCIImageProviderTileSize`` controls if and how the provider object is called in tiles.
        /// The option ``kCIImageProviderUserInfo`` allows additional state to be passed to the provider object.
        /// - Returns:
        /// An autoreleased ``CIImage`` object based on the data provider.
        ///
        /// # Safety
        ///
        /// - `provider` should be of the correct type.
        /// - `options` generic should be of the correct type.
        #[unsafe(method(imageWithImageProvider:size::format:colorSpace:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithImageProvider_size__format_colorSpace_options(
            provider: &AnyObject,
            width: usize,
            height: usize,
            format: CIFormat,
            color_space: Option<&CGColorSpace>,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<CIImage>;

        #[cfg(feature = "objc2-core-graphics")]
        /// Initializes an image object based on pixels from an image provider object.
        ///
        /// Core Image retains the provider object until the image is deallocated.
        /// The image provider object will not be called until the image is rendered.
        ///
        /// - Parameters:
        /// - provider: An object that implements the `CIImageProvider` protocol.
        /// - width: The width of the image.
        /// - height: The height of the image.
        /// - format: The ``CIFormat`` of the provided pixels.
        /// - colorSpace: The color space that the image is defined in.
        /// If `nil`, then the pixels will not be is not color matched to the Core Image working color space.
        /// - options: A dictionary that contains various ``CIImageOption`` keys that affect the resulting ``CIImage``.
        /// The option ``kCIImageProviderTileSize`` controls if and how the provider object is called in tiles.
        /// The option ``kCIImageProviderUserInfo`` allows additional state to be passed to the provider object.
        /// - Returns:
        /// An initialized ``CIImage`` object based on the data provider.
        ///
        /// # Safety
        ///
        /// - `provider` should be of the correct type.
        /// - `options` generic should be of the correct type.
        #[unsafe(method(initWithImageProvider:size::format:colorSpace:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithImageProvider_size__format_colorSpace_options(
            this: Allocated<Self>,
            provider: &AnyObject,
            width: usize,
            height: usize,
            format: CIFormat,
            color_space: Option<&CGColorSpace>,
            options: Option<&NSDictionary<CIImageOption, AnyObject>>,
        ) -> Retained<Self>;
    );
}

mod private_NSObjectCIImageProvider {
    pub trait Sealed {}
}

/// Category "CIImageProvider" on [`NSObject`].
///
/// Protocol used to lazily supply image data.
#[doc(alias = "CIImageProvider")]
pub unsafe trait NSObjectCIImageProvider:
    ClassType + Sized + private_NSObjectCIImageProvider::Sealed
{
    extern_methods!(
        /// The method that an image provider object must implement.
        /// This method provides pixel data when the image object is rendered.
        ///
        /// The implementation should provide pixels for the requested sub-rect `x,y,width,height` of the image.
        /// The sub-rect is in defined in the image's local coordinate space,
        /// where the origin is relative to the top left corner of the image.
        ///
        /// By default, this method will be called to request the full image
        /// regardless of what sub-rect is needed for the current render.
        /// In this case the requested `x,y,width,height` will be `0,0,imageWidth,imageHeight`
        ///
        /// If the ``kCIImageProviderTileSize`` option is specified when the ``CIImage`` was created,
        /// then this method may be called once for each tile that is needed for the current render.
        ///
        /// - Parameters:
        /// - data: A pointer into which the provider should copy the pixels for the requested sub-rect.
        /// - rowbytes: The number of bytes per row for the requested pixels.
        /// - originx: The x origin of the requested sub-rect relative to the upper left corner of the image.
        /// - originy: The y origin of the requested sub-rect relative to the upper left corner of the image.
        /// - width: The width of the requested sub-rect.
        /// - height: The height of the requested sub-rect.
        /// - info: The value of the `kCIImageProviderTileSize`` option specified when calling:
        /// * ``/CIImage/imageWithImageProvider:size::format:colorSpace:options:``
        /// * ``/CIImage/initWithImageProvider:size::format:colorSpace:options:``
        ///
        /// # Safety
        ///
        /// - `data` must be a valid pointer.
        /// - `info` should be of the correct type.
        #[unsafe(method(provideImageData:bytesPerRow:origin::size::userInfo:))]
        #[unsafe(method_family = none)]
        unsafe fn provideImageData_bytesPerRow_origin__size__userInfo(
            &self,
            data: NonNull<c_void>,
            rowbytes: usize,
            originx: usize,
            originy: usize,
            width: usize,
            height: usize,
            info: Option<&AnyObject>,
        );

        #[cfg(feature = "objc2-metal")]
        /// An optional method that an image provider object way implement.
        /// With this method, the provider object can use the Metal API to provide pixel
        /// data into a MTLTexture when the image object is rendered.
        ///
        /// The implementation should provide pixels for the requested sub-rect `x,y,width,height` of the image.
        /// The sub-rect is in defined in the image's local coordinate space,
        /// where the origin is relative to the top left corner of the image.
        ///
        /// The work to fill the `MTLTexture` should be encoded on the specified `commandBuffer`.
        /// If the implementation uses its own commandBuffer,
        /// then it should call `waitUntilCompleted` before returning.
        /// If the texture is surface-backed then you only need to
        /// call `waitUntilScheduled` before returning.
        ///
        /// By default, this method will be called to request the full image
        /// regardless of what sub-rect is needed for the current render.
        /// In this case the requested `x,y,width,height` will be `0,0,imageWidth,imageHeight`
        ///
        /// If the ``kCIImageProviderTileSize`` option is specified when the ``CIImage`` was created,
        /// then this method may be called once for each tile that is needed for the current render.
        ///
        /// - Parameters:
        /// - texture: The `
        /// <id
        /// >MTLTexture` into which the provider should copy the pixels for the requested sub-rect.
        /// - commandBuffer: The `
        /// <id
        /// >MTLCommandBuffer` that the provider should use encoded the copy.
        /// - originx: The x origin of the requested sub-rect relative to the upper left corner of the image.
        /// - originy: The y origin of the requested sub-rect relative to the upper left corner of the image.
        /// - width: The width of the requested sub-rect.
        /// - height: The height of the requested sub-rect.
        /// - info: The value of the `kCIImageProviderTileSize`` option specified when calling:
        /// * ``/CIImage/imageWithImageProvider:size::format:colorSpace:options:``
        /// * ``/CIImage/initWithImageProvider:size::format:colorSpace:options:``
        ///
        /// # Safety
        ///
        /// - `texture` may need to be synchronized.
        /// - `texture` may be unretained, you must ensure it is kept alive while in use.
        /// - `info` should be of the correct type.
        #[unsafe(method(provideImageToMTLTexture:commandBuffer:originx:originy:width:height:userInfo:))]
        #[unsafe(method_family = none)]
        unsafe fn provideImageToMTLTexture_commandBuffer_originx_originy_width_height_userInfo(
            &self,
            texture: &ProtocolObject<dyn MTLTexture>,
            command_buffer: &ProtocolObject<dyn MTLCommandBuffer>,
            originx: usize,
            originy: usize,
            width: usize,
            height: usize,
            info: Option<&AnyObject>,
        );
    );
}

impl private_NSObjectCIImageProvider::Sealed for NSObject {}
unsafe impl NSObjectCIImageProvider for NSObject {}

extern "C" {
    /// Specifies the tile size that the Provide Image Data method will be called for.
    ///
    /// This key and its value may be passed to:
    /// * ``/CIImage/imageWithImageProvider:size::format:colorSpace:options:``
    /// * ``/CIImage/initWithImageProvider:size::format:colorSpace:options:``
    ///
    /// If the value of this key is:
    /// Value                      | Behavior of sub-rect passed to ``provideImageData:bytesPerRow:origin::size::userData:``
    /// -------------------------- | ----------------------------
    /// Not specified              |  the entire image
    /// `NSNumber`                 |  square tiles of size x size
    /// `NSArray` with 2 numbers   |  rectangular tiles of width x height.
    /// ``CIVector`` with 2 values |  rectangular tiles of width x height.
    /// `NSNull`                   |  can be called for any possible origin and size.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageprovidertilesize?language=objc)
    #[cfg(feature = "CIImage")]
    pub static kCIImageProviderTileSize: &'static CIImageOption;
}

extern "C" {
    /// A key for any data needed by the image provider object.
    /// The associated value is an object that contains the needed data.
    ///
    /// This key and its value may be passed to:
    /// * ``/CIImage/imageWithImageProvider:size::format:colorSpace:options:``
    /// * ``/CIImage/initWithImageProvider:size::format:colorSpace:options:``
    ///
    /// The value object is retained until the image is deallocated.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciimageprovideruserinfo?language=objc)
    #[cfg(feature = "CIImage")]
    pub static kCIImageProviderUserInfo: &'static CIImageOption;
}
