// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"go.opentelemetry.io/collector/pdata/internal"
)

// Metrics is the top-level struct that is propagated through the metrics pipeline.
// Use NewMetrics to create new instance, zero-initialized instance is not valid for use.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Metrics internal.MetricsWrapper

func newMetrics(orig *internal.ExportMetricsServiceRequest, state *internal.State) Metrics {
	return Metrics(internal.NewMetricsWrapper(orig, state))
}

// NewMetrics creates a new empty Metrics.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewMetrics() Metrics {
	return newMetrics(internal.NewExportMetricsServiceRequest(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Metrics) MoveTo(dest Metrics) {
	ms.getState().AssertMutable()
	dest.getState().AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.getOrig() == dest.getOrig() {
		return
	}
	internal.DeleteExportMetricsServiceRequest(dest.getOrig(), false)
	*dest.getOrig(), *ms.getOrig() = *ms.getOrig(), *dest.getOrig()
}

// ResourceMetrics returns the ResourceMetrics associated with this Metrics.
func (ms Metrics) ResourceMetrics() ResourceMetricsSlice {
	return newResourceMetricsSlice(&ms.getOrig().ResourceMetrics, ms.getState())
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Metrics) CopyTo(dest Metrics) {
	dest.getState().AssertMutable()
	internal.CopyExportMetricsServiceRequest(dest.getOrig(), ms.getOrig())
}

func (ms Metrics) getOrig() *internal.ExportMetricsServiceRequest {
	return internal.GetMetricsOrig(internal.MetricsWrapper(ms))
}

func (ms Metrics) getState() *internal.State {
	return internal.GetMetricsState(internal.MetricsWrapper(ms))
}
