// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlptrace "go.opentelemetry.io/proto/slim/otlp/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyStatus(t *testing.T) {
	for name, src := range genTestEncodingValuesStatus() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewStatus()
				CopyStatus(dest, src)
				assert.Equal(t, src, dest)
				CopyStatus(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyStatusSlice(t *testing.T) {
	src := []Status{}
	dest := []Status{}
	// Test CopyTo empty
	dest = CopyStatusSlice(dest, src)
	assert.Equal(t, []Status{}, dest)

	// Test CopyTo larger slice
	src = GenTestStatusSlice()
	dest = CopyStatusSlice(dest, src)
	assert.Equal(t, GenTestStatusSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyStatusSlice(dest, src)
	assert.Equal(t, GenTestStatusSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyStatusSlice(dest, []Status{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyStatusSlice(dest, src)
	assert.Equal(t, GenTestStatusSlice(), dest)
}

func TestCopyStatusPtrSlice(t *testing.T) {
	src := []*Status{}
	dest := []*Status{}
	// Test CopyTo empty
	dest = CopyStatusPtrSlice(dest, src)
	assert.Equal(t, []*Status{}, dest)

	// Test CopyTo larger slice
	src = GenTestStatusPtrSlice()
	dest = CopyStatusPtrSlice(dest, src)
	assert.Equal(t, GenTestStatusPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyStatusPtrSlice(dest, src)
	assert.Equal(t, GenTestStatusPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyStatusPtrSlice(dest, []*Status{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyStatusPtrSlice(dest, src)
	assert.Equal(t, GenTestStatusPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONStatusUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewStatus()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewStatus(), dest)
}

func TestMarshalAndUnmarshalJSONStatus(t *testing.T) {
	for name, src := range genTestEncodingValuesStatus() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewStatus()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteStatus(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoStatusFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesStatus() {
		t.Run(name, func(t *testing.T) {
			dest := NewStatus()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoStatusUnknown(t *testing.T) {
	dest := NewStatus()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewStatus(), dest)
}

func TestMarshalAndUnmarshalProtoStatus(t *testing.T) {
	for name, src := range genTestEncodingValuesStatus() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewStatus()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteStatus(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufStatus(t *testing.T) {
	for name, src := range genTestEncodingValuesStatus() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlptrace.Status{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewStatus()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesStatus() map[string][]byte {
	return map[string][]byte{
		"invalid_field":           {0x02},
		"Message/wrong_wire_type": {0x14},
		"Message/missing_value":   {0x12},
		"Code/wrong_wire_type":    {0x1c},
		"Code/missing_value":      {0x18},
	}
}

func genTestEncodingValuesStatus() map[string]*Status {
	return map[string]*Status{
		"empty":        NewStatus(),
		"Message/test": {Message: "test_message"},
		"Code/test":    {Code: StatusCode(13)},
	}
}
