// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogram() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewHistogram()
				CopyHistogram(dest, src)
				assert.Equal(t, src, dest)
				CopyHistogram(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyHistogramSlice(t *testing.T) {
	src := []Histogram{}
	dest := []Histogram{}
	// Test CopyTo empty
	dest = CopyHistogramSlice(dest, src)
	assert.Equal(t, []Histogram{}, dest)

	// Test CopyTo larger slice
	src = GenTestHistogramSlice()
	dest = CopyHistogramSlice(dest, src)
	assert.Equal(t, GenTestHistogramSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyHistogramSlice(dest, src)
	assert.Equal(t, GenTestHistogramSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyHistogramSlice(dest, []Histogram{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyHistogramSlice(dest, src)
	assert.Equal(t, GenTestHistogramSlice(), dest)
}

func TestCopyHistogramPtrSlice(t *testing.T) {
	src := []*Histogram{}
	dest := []*Histogram{}
	// Test CopyTo empty
	dest = CopyHistogramPtrSlice(dest, src)
	assert.Equal(t, []*Histogram{}, dest)

	// Test CopyTo larger slice
	src = GenTestHistogramPtrSlice()
	dest = CopyHistogramPtrSlice(dest, src)
	assert.Equal(t, GenTestHistogramPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyHistogramPtrSlice(dest, src)
	assert.Equal(t, GenTestHistogramPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyHistogramPtrSlice(dest, []*Histogram{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyHistogramPtrSlice(dest, src)
	assert.Equal(t, GenTestHistogramPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONHistogramUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewHistogram()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewHistogram(), dest)
}

func TestMarshalAndUnmarshalJSONHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogram() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewHistogram()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteHistogram(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoHistogramFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesHistogram() {
		t.Run(name, func(t *testing.T) {
			dest := NewHistogram()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoHistogramUnknown(t *testing.T) {
	dest := NewHistogram()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewHistogram(), dest)
}

func TestMarshalAndUnmarshalProtoHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogram() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewHistogram()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteHistogram(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesHistogram() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.Histogram{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewHistogram()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesHistogram() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"DataPoints/wrong_wire_type":             {0xc},
		"DataPoints/missing_value":               {0xa},
		"AggregationTemporality/wrong_wire_type": {0x14},
		"AggregationTemporality/missing_value":   {0x10},
	}
}

func genTestEncodingValuesHistogram() map[string]*Histogram {
	return map[string]*Histogram{
		"empty":                       NewHistogram(),
		"DataPoints/test":             {DataPoints: []*HistogramDataPoint{{}, GenTestHistogramDataPoint()}},
		"AggregationTemporality/test": {AggregationTemporality: AggregationTemporality(13)},
	}
}
