// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectormetrics "go.opentelemetry.io/proto/slim/otlp/collector/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportMetricsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportMetricsServiceRequest()
				CopyExportMetricsServiceRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyExportMetricsServiceRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportMetricsServiceRequestSlice(t *testing.T) {
	src := []ExportMetricsServiceRequest{}
	dest := []ExportMetricsServiceRequest{}
	// Test CopyTo empty
	dest = CopyExportMetricsServiceRequestSlice(dest, src)
	assert.Equal(t, []ExportMetricsServiceRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportMetricsServiceRequestSlice()
	dest = CopyExportMetricsServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceRequestSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportMetricsServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceRequestSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportMetricsServiceRequestSlice(dest, []ExportMetricsServiceRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportMetricsServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceRequestSlice(), dest)
}

func TestCopyExportMetricsServiceRequestPtrSlice(t *testing.T) {
	src := []*ExportMetricsServiceRequest{}
	dest := []*ExportMetricsServiceRequest{}
	// Test CopyTo empty
	dest = CopyExportMetricsServiceRequestPtrSlice(dest, src)
	assert.Equal(t, []*ExportMetricsServiceRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportMetricsServiceRequestPtrSlice()
	dest = CopyExportMetricsServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceRequestPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportMetricsServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceRequestPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportMetricsServiceRequestPtrSlice(dest, []*ExportMetricsServiceRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportMetricsServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsServiceRequestPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportMetricsServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportMetricsServiceRequest()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportMetricsServiceRequest(), dest)
}

func TestMarshalAndUnmarshalJSONExportMetricsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportMetricsServiceRequest()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportMetricsServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportMetricsServiceRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportMetricsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportMetricsServiceRequest()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportMetricsServiceRequestUnknown(t *testing.T) {
	dest := NewExportMetricsServiceRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportMetricsServiceRequest(), dest)
}

func TestMarshalAndUnmarshalProtoExportMetricsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportMetricsServiceRequest()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportMetricsServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportMetricsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectormetrics.ExportMetricsServiceRequest{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportMetricsServiceRequest()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportMetricsServiceRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                   {0x02},
		"ResourceMetrics/wrong_wire_type": {0xc},
		"ResourceMetrics/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportMetricsServiceRequest() map[string]*ExportMetricsServiceRequest {
	return map[string]*ExportMetricsServiceRequest{
		"empty":                NewExportMetricsServiceRequest(),
		"ResourceMetrics/test": {ResourceMetrics: []*ResourceMetrics{{}, GenTestResourceMetrics()}},
	}
}
