/*
Personal Tokens - OpenAPI

The Personal Tokens API allows you to manage your existing personal tokens. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package personal_tokens

import (
	"encoding/json"
	"time"
)

// checks if the PersonalTokenResponseGet type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PersonalTokenResponseGet{}

// PersonalTokenResponseGet struct for PersonalTokenResponseGet
type PersonalTokenResponseGet struct {
	Uuid *string `json:"uuid,omitempty"`
	Name *string `json:"name,omitempty"`
	Created *time.Time `json:"created,omitempty"`
	ExpiresAt *time.Time `json:"expires_at,omitempty"`
	Description NullableString `json:"description,omitempty"`
}

// NewPersonalTokenResponseGet instantiates a new PersonalTokenResponseGet object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPersonalTokenResponseGet() *PersonalTokenResponseGet {
	this := PersonalTokenResponseGet{}
	return &this
}

// NewPersonalTokenResponseGetWithDefaults instantiates a new PersonalTokenResponseGet object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPersonalTokenResponseGetWithDefaults() *PersonalTokenResponseGet {
	this := PersonalTokenResponseGet{}
	return &this
}

// GetUuid returns the Uuid field value if set, zero value otherwise.
func (o *PersonalTokenResponseGet) GetUuid() string {
	if o == nil || IsNil(o.Uuid) {
		var ret string
		return ret
	}
	return *o.Uuid
}

// GetUuidOk returns a tuple with the Uuid field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PersonalTokenResponseGet) GetUuidOk() (*string, bool) {
	if o == nil || IsNil(o.Uuid) {
		return nil, false
	}
	return o.Uuid, true
}

// HasUuid returns a boolean if a field has been set.
func (o *PersonalTokenResponseGet) HasUuid() bool {
	if o != nil && !IsNil(o.Uuid) {
		return true
	}

	return false
}

// SetUuid gets a reference to the given string and assigns it to the Uuid field.
func (o *PersonalTokenResponseGet) SetUuid(v string) {
	o.Uuid = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *PersonalTokenResponseGet) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PersonalTokenResponseGet) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *PersonalTokenResponseGet) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *PersonalTokenResponseGet) SetName(v string) {
	o.Name = &v
}

// GetCreated returns the Created field value if set, zero value otherwise.
func (o *PersonalTokenResponseGet) GetCreated() time.Time {
	if o == nil || IsNil(o.Created) {
		var ret time.Time
		return ret
	}
	return *o.Created
}

// GetCreatedOk returns a tuple with the Created field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PersonalTokenResponseGet) GetCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.Created) {
		return nil, false
	}
	return o.Created, true
}

// HasCreated returns a boolean if a field has been set.
func (o *PersonalTokenResponseGet) HasCreated() bool {
	if o != nil && !IsNil(o.Created) {
		return true
	}

	return false
}

// SetCreated gets a reference to the given time.Time and assigns it to the Created field.
func (o *PersonalTokenResponseGet) SetCreated(v time.Time) {
	o.Created = &v
}

// GetExpiresAt returns the ExpiresAt field value if set, zero value otherwise.
func (o *PersonalTokenResponseGet) GetExpiresAt() time.Time {
	if o == nil || IsNil(o.ExpiresAt) {
		var ret time.Time
		return ret
	}
	return *o.ExpiresAt
}

// GetExpiresAtOk returns a tuple with the ExpiresAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PersonalTokenResponseGet) GetExpiresAtOk() (*time.Time, bool) {
	if o == nil || IsNil(o.ExpiresAt) {
		return nil, false
	}
	return o.ExpiresAt, true
}

// HasExpiresAt returns a boolean if a field has been set.
func (o *PersonalTokenResponseGet) HasExpiresAt() bool {
	if o != nil && !IsNil(o.ExpiresAt) {
		return true
	}

	return false
}

// SetExpiresAt gets a reference to the given time.Time and assigns it to the ExpiresAt field.
func (o *PersonalTokenResponseGet) SetExpiresAt(v time.Time) {
	o.ExpiresAt = &v
}

// GetDescription returns the Description field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PersonalTokenResponseGet) GetDescription() string {
	if o == nil || IsNil(o.Description.Get()) {
		var ret string
		return ret
	}
	return *o.Description.Get()
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PersonalTokenResponseGet) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Description.Get(), o.Description.IsSet()
}

// HasDescription returns a boolean if a field has been set.
func (o *PersonalTokenResponseGet) HasDescription() bool {
	if o != nil && o.Description.IsSet() {
		return true
	}

	return false
}

// SetDescription gets a reference to the given NullableString and assigns it to the Description field.
func (o *PersonalTokenResponseGet) SetDescription(v string) {
	o.Description.Set(&v)
}
// SetDescriptionNil sets the value for Description to be an explicit nil
func (o *PersonalTokenResponseGet) SetDescriptionNil() {
	o.Description.Set(nil)
}

// UnsetDescription ensures that no value is present for Description, not even an explicit nil
func (o *PersonalTokenResponseGet) UnsetDescription() {
	o.Description.Unset()
}

func (o PersonalTokenResponseGet) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PersonalTokenResponseGet) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Uuid) {
		toSerialize["uuid"] = o.Uuid
	}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.Created) {
		toSerialize["created"] = o.Created
	}
	if !IsNil(o.ExpiresAt) {
		toSerialize["expires_at"] = o.ExpiresAt
	}
	if o.Description.IsSet() {
		toSerialize["description"] = o.Description.Get()
	}
	return toSerialize, nil
}

type NullablePersonalTokenResponseGet struct {
	value *PersonalTokenResponseGet
	isSet bool
}

func (v NullablePersonalTokenResponseGet) Get() *PersonalTokenResponseGet {
	return v.value
}

func (v *NullablePersonalTokenResponseGet) Set(val *PersonalTokenResponseGet) {
	v.value = val
	v.isSet = true
}

func (v NullablePersonalTokenResponseGet) IsSet() bool {
	return v.isSet
}

func (v *NullablePersonalTokenResponseGet) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePersonalTokenResponseGet(val *PersonalTokenResponseGet) *NullablePersonalTokenResponseGet {
	return &NullablePersonalTokenResponseGet{value: val, isSet: true}
}

func (v NullablePersonalTokenResponseGet) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePersonalTokenResponseGet) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


