//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
	"strings"
)

// Airspeed sensor flags
type AIRSPEED_SENSOR_FLAGS uint64

const (
	// Airspeed sensor is unhealthy
	AIRSPEED_SENSOR_UNHEALTHY AIRSPEED_SENSOR_FLAGS = 1
	// True if the data from this sensor is being actively used by the flight controller for guidance, navigation or control.
	AIRSPEED_SENSOR_USING AIRSPEED_SENSOR_FLAGS = 2
)

var values_AIRSPEED_SENSOR_FLAGS = []AIRSPEED_SENSOR_FLAGS{
	AIRSPEED_SENSOR_UNHEALTHY,
	AIRSPEED_SENSOR_USING,
}

var value_to_label_AIRSPEED_SENSOR_FLAGS = map[AIRSPEED_SENSOR_FLAGS]string{
	AIRSPEED_SENSOR_UNHEALTHY: "AIRSPEED_SENSOR_UNHEALTHY",
	AIRSPEED_SENSOR_USING:     "AIRSPEED_SENSOR_USING",
}

var label_to_value_AIRSPEED_SENSOR_FLAGS = map[string]AIRSPEED_SENSOR_FLAGS{
	"AIRSPEED_SENSOR_UNHEALTHY": AIRSPEED_SENSOR_UNHEALTHY,
	"AIRSPEED_SENSOR_USING":     AIRSPEED_SENSOR_USING,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e AIRSPEED_SENSOR_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_AIRSPEED_SENSOR_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_AIRSPEED_SENSOR_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *AIRSPEED_SENSOR_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask AIRSPEED_SENSOR_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_AIRSPEED_SENSOR_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= AIRSPEED_SENSOR_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e AIRSPEED_SENSOR_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
