//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Possible responses from a WIFI_CONFIG_AP message.
type WIFI_CONFIG_AP_RESPONSE uint64

const (
	// Undefined response. Likely an indicative of a system that doesn't support this request.
	WIFI_CONFIG_AP_RESPONSE_UNDEFINED WIFI_CONFIG_AP_RESPONSE = 0
	// Changes accepted.
	WIFI_CONFIG_AP_RESPONSE_ACCEPTED WIFI_CONFIG_AP_RESPONSE = 1
	// Changes rejected.
	WIFI_CONFIG_AP_RESPONSE_REJECTED WIFI_CONFIG_AP_RESPONSE = 2
	// Invalid Mode.
	WIFI_CONFIG_AP_RESPONSE_MODE_ERROR WIFI_CONFIG_AP_RESPONSE = 3
	// Invalid SSID.
	WIFI_CONFIG_AP_RESPONSE_SSID_ERROR WIFI_CONFIG_AP_RESPONSE = 4
	// Invalid Password.
	WIFI_CONFIG_AP_RESPONSE_PASSWORD_ERROR WIFI_CONFIG_AP_RESPONSE = 5
)

var value_to_label_WIFI_CONFIG_AP_RESPONSE = map[WIFI_CONFIG_AP_RESPONSE]string{
	WIFI_CONFIG_AP_RESPONSE_UNDEFINED:      "WIFI_CONFIG_AP_RESPONSE_UNDEFINED",
	WIFI_CONFIG_AP_RESPONSE_ACCEPTED:       "WIFI_CONFIG_AP_RESPONSE_ACCEPTED",
	WIFI_CONFIG_AP_RESPONSE_REJECTED:       "WIFI_CONFIG_AP_RESPONSE_REJECTED",
	WIFI_CONFIG_AP_RESPONSE_MODE_ERROR:     "WIFI_CONFIG_AP_RESPONSE_MODE_ERROR",
	WIFI_CONFIG_AP_RESPONSE_SSID_ERROR:     "WIFI_CONFIG_AP_RESPONSE_SSID_ERROR",
	WIFI_CONFIG_AP_RESPONSE_PASSWORD_ERROR: "WIFI_CONFIG_AP_RESPONSE_PASSWORD_ERROR",
}

var label_to_value_WIFI_CONFIG_AP_RESPONSE = map[string]WIFI_CONFIG_AP_RESPONSE{
	"WIFI_CONFIG_AP_RESPONSE_UNDEFINED":      WIFI_CONFIG_AP_RESPONSE_UNDEFINED,
	"WIFI_CONFIG_AP_RESPONSE_ACCEPTED":       WIFI_CONFIG_AP_RESPONSE_ACCEPTED,
	"WIFI_CONFIG_AP_RESPONSE_REJECTED":       WIFI_CONFIG_AP_RESPONSE_REJECTED,
	"WIFI_CONFIG_AP_RESPONSE_MODE_ERROR":     WIFI_CONFIG_AP_RESPONSE_MODE_ERROR,
	"WIFI_CONFIG_AP_RESPONSE_SSID_ERROR":     WIFI_CONFIG_AP_RESPONSE_SSID_ERROR,
	"WIFI_CONFIG_AP_RESPONSE_PASSWORD_ERROR": WIFI_CONFIG_AP_RESPONSE_PASSWORD_ERROR,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e WIFI_CONFIG_AP_RESPONSE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_WIFI_CONFIG_AP_RESPONSE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *WIFI_CONFIG_AP_RESPONSE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_WIFI_CONFIG_AP_RESPONSE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = WIFI_CONFIG_AP_RESPONSE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e WIFI_CONFIG_AP_RESPONSE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
