//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Specifies the conditions under which the MAV_CMD_PREFLIGHT_REBOOT_SHUTDOWN command should be accepted.
type REBOOT_SHUTDOWN_CONDITIONS uint64

const (
	// Reboot/Shutdown only if allowed by safety checks, such as being landed.
	REBOOT_SHUTDOWN_CONDITIONS_SAFETY_INTERLOCKED REBOOT_SHUTDOWN_CONDITIONS = 0
	// Force reboot/shutdown of the autopilot/component regardless of system state.
	REBOOT_SHUTDOWN_CONDITIONS_FORCE REBOOT_SHUTDOWN_CONDITIONS = 20190226
)

var value_to_label_REBOOT_SHUTDOWN_CONDITIONS = map[REBOOT_SHUTDOWN_CONDITIONS]string{
	REBOOT_SHUTDOWN_CONDITIONS_SAFETY_INTERLOCKED: "REBOOT_SHUTDOWN_CONDITIONS_SAFETY_INTERLOCKED",
	REBOOT_SHUTDOWN_CONDITIONS_FORCE:              "REBOOT_SHUTDOWN_CONDITIONS_FORCE",
}

var label_to_value_REBOOT_SHUTDOWN_CONDITIONS = map[string]REBOOT_SHUTDOWN_CONDITIONS{
	"REBOOT_SHUTDOWN_CONDITIONS_SAFETY_INTERLOCKED": REBOOT_SHUTDOWN_CONDITIONS_SAFETY_INTERLOCKED,
	"REBOOT_SHUTDOWN_CONDITIONS_FORCE":              REBOOT_SHUTDOWN_CONDITIONS_FORCE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e REBOOT_SHUTDOWN_CONDITIONS) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_REBOOT_SHUTDOWN_CONDITIONS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *REBOOT_SHUTDOWN_CONDITIONS) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_REBOOT_SHUTDOWN_CONDITIONS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = REBOOT_SHUTDOWN_CONDITIONS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e REBOOT_SHUTDOWN_CONDITIONS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
