//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Enumeration of VTOL states
type MAV_VTOL_STATE uint64

const (
	// MAV is not configured as VTOL
	MAV_VTOL_STATE_UNDEFINED MAV_VTOL_STATE = 0
	// VTOL is in transition from multicopter to fixed-wing
	MAV_VTOL_STATE_TRANSITION_TO_FW MAV_VTOL_STATE = 1
	// VTOL is in transition from fixed-wing to multicopter
	MAV_VTOL_STATE_TRANSITION_TO_MC MAV_VTOL_STATE = 2
	// VTOL is in multicopter state
	MAV_VTOL_STATE_MC MAV_VTOL_STATE = 3
	// VTOL is in fixed-wing state
	MAV_VTOL_STATE_FW MAV_VTOL_STATE = 4
)

var value_to_label_MAV_VTOL_STATE = map[MAV_VTOL_STATE]string{
	MAV_VTOL_STATE_UNDEFINED:        "MAV_VTOL_STATE_UNDEFINED",
	MAV_VTOL_STATE_TRANSITION_TO_FW: "MAV_VTOL_STATE_TRANSITION_TO_FW",
	MAV_VTOL_STATE_TRANSITION_TO_MC: "MAV_VTOL_STATE_TRANSITION_TO_MC",
	MAV_VTOL_STATE_MC:               "MAV_VTOL_STATE_MC",
	MAV_VTOL_STATE_FW:               "MAV_VTOL_STATE_FW",
}

var label_to_value_MAV_VTOL_STATE = map[string]MAV_VTOL_STATE{
	"MAV_VTOL_STATE_UNDEFINED":        MAV_VTOL_STATE_UNDEFINED,
	"MAV_VTOL_STATE_TRANSITION_TO_FW": MAV_VTOL_STATE_TRANSITION_TO_FW,
	"MAV_VTOL_STATE_TRANSITION_TO_MC": MAV_VTOL_STATE_TRANSITION_TO_MC,
	"MAV_VTOL_STATE_MC":               MAV_VTOL_STATE_MC,
	"MAV_VTOL_STATE_FW":               MAV_VTOL_STATE_FW,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_VTOL_STATE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_VTOL_STATE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_VTOL_STATE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_VTOL_STATE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_VTOL_STATE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_VTOL_STATE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
