/*╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌
 * qtModels/tableModels/EquipmentTableModel.h is part of Brewtarget, and is copyright the following authors 2023-2025:
 *   • Matt Young <mfsy@yahoo.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Brewtarget is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌*/
#ifndef TABLEMODELS_EQUIPMENTTABLEMODEL_H
#define TABLEMODELS_EQUIPMENTTABLEMODEL_H
#pragma once

#include <QStyledItemDelegate>
#include <QMetaProperty>
#include <QModelIndex>
#include <QVariant>
#include <QWidget>

#include "model/Equipment.h"
#include "qtModels/tableModels/ItemDelegate.h"
#include "qtModels/tableModels/TableModelBase.h"

class BtStringConst;
class Recipe;

// Define the columns on this table
COLUMN_NAMES(EquipmentTableModel, Name            ,
                                  MashTunVolume   ,
                                  KettleVolume    ,
                                  FermenterVolume ,
                                  NumRecipesUsedIn,)

/*!
 * \class EquipmentTableModel
 *
 * \brief Table model for a list of equipment records.
 */
class EquipmentTableModel : public BtTableModel, public TableModelBase<EquipmentTableModel, Equipment> {
   Q_OBJECT

   TABLE_MODEL_COMMON_DECL(Equipment)
};

//============================================== CLASS EquipmentItemDelegate ===============================================
/*!
 * \class EquipmentItemDelegate
 *
 * \brief Item delegate for equipment tables.
 * \sa EquipmentTableModel
 */
class EquipmentItemDelegate : public QStyledItemDelegate, public ItemDelegate<EquipmentItemDelegate, EquipmentTableModel> {
   Q_OBJECT

   ITEM_DELEGATE_COMMON_DECL(Equipment)
};

#endif
