/* This file is part of the Spring engine (GPL v2 or later), see LICENSE.html */

#ifndef _METAL_TEXTURE_H
#define _METAL_TEXTURE_H

#include "ModernInfoTexture.h"
#include "System/EventHandler.h"


class CMetalTexture : public CModernInfoTexture, public CEventClient
{
public:
	CMetalTexture();
public:
	// CEventClient interface
	bool WantsEvent(const std::string& eventName) override {
		return (eventName == "MetalMapChanged");
	}
	bool GetFullRead() const override { return true; }
	int  GetReadAllyTeam() const override { return AllAccessTeam; }

	void MetalMapChanged(const int x, const int z) override;

public:
	// IInfoTexture interface
	void Update() override;
	bool IsUpdateNeeded() override;

private:
	bool metalMapChanged;
};

#endif // _METAL_TEXTURE_H
