/* This file is part of the Spring engine (GPL v2 or later), see LICENSE.html */

#include "CppTestAI.h"


#include "ExternalAI/Interface/AISEvents.h"
#include "ExternalAI/Interface/AISCommands.h"

// generated by the C++ Wrapper scripts
#include "OOAICallback.h"
#include "Unit.h"
#include "UnitDef.h"
#include "Game.h"

#include <string>
#include <memory>

cpptestai::CCppTestAI::CCppTestAI(springai::OOAICallback* callback):
		callback(callback),
		skirmishAIId(callback != NULL ? callback->GetSkirmishAIId() : -1)
		{}

cpptestai::CCppTestAI::~CCppTestAI() {}

static inline std::string IntToString(int i, const std::string& format = "%i")
{
	char buf[64];
	SNPRINTF(buf, sizeof(buf), format.c_str(), i);
	return std::string(buf);
}
int cpptestai::CCppTestAI::HandleEvent(int topic, const void* data) {

	switch (topic) {
		case EVENT_UNIT_CREATED: {
			//struct SUnitCreatedEvent* evt = (struct SUnitCreatedEvent*) data;
			//int unitId = evt->unit;

			// TODO: wrapp events and commands too

			const std::vector<springai::Unit*> friendlyUnits = callback->GetFriendlyUnits();
			std::string msgText = std::string("/say Hello Engine (from CppTestAI), num my units is ") + IntToString(friendlyUnits.size());
			if (!friendlyUnits.empty()) {
				springai::Unit* unit = friendlyUnits[0];
				const std::unique_ptr<springai::UnitDef> unitDef(unit->GetDef());
				std::string unitDefName = unitDef->GetName();
				msgText = msgText + ", first friendly units def name is: " + unitDefName;
			}
			const std::unique_ptr<springai::Game> game(callback->GetGame());
			game->SendTextMessage(msgText.c_str(), 0);

			for (springai::Unit* unit : friendlyUnits)
				delete unit;
			break;
		}
		default: {
			break;
		}
	}

	// signal: everything went OK
	return 0;
}
