// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may not
// use this file except in compliance with the License. A copy of the
// License is located at
//
// http://aws.amazon.com/apache2.0/
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
// implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by mockery v1.0.0
package packageservice_mock

import mock "github.com/stretchr/testify/mock"

// ManifestCache is an autogenerated mock type for the ManifestCache type
type ManifestCache struct {
	mock.Mock
}

// ReadManifest provides a mock function with given fields: packageArn, packageVersion
func (_m *ManifestCache) ReadManifest(packageArn string, packageVersion string) ([]byte, error) {
	ret := _m.Called(packageArn, packageVersion)

	var r0 []byte
	if rf, ok := ret.Get(0).(func(string, string) []byte); ok {
		r0 = rf(packageArn, packageVersion)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(packageArn, packageVersion)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ReadManifestHash provides a mock function with given fields: packageArn, documentVersion
func (_m *ManifestCache) ReadManifestHash(packageArn string, documentVersion string) ([]byte, error) {
	ret := _m.Called(packageArn, documentVersion)

	var r0 []byte
	if rf, ok := ret.Get(0).(func(string, string) []byte); ok {
		r0 = rf(packageArn, documentVersion)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, string) error); ok {
		r1 = rf(packageArn, documentVersion)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// WriteManifest provides a mock function with given fields: packageArn, packageVersion, content
func (_m *ManifestCache) WriteManifest(packageArn string, packageVersion string, content []byte) error {
	ret := _m.Called(packageArn, packageVersion, content)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, []byte) error); ok {
		r0 = rf(packageArn, packageVersion, content)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteManifest provides a mock function with given fields: packageArn, packageVersion
func (_m *ManifestCache) DeleteManifest(packageArn string, packageVersion string) error {
	ret := _m.Called(packageArn, packageVersion)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(packageArn, packageVersion)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// WriteManifestHash provides a mock function with given fields: packageArn, documentVersion, content
func (_m *ManifestCache) WriteManifestHash(packageArn string, documentVersion string, content []byte) error {
	ret := _m.Called(packageArn, documentVersion, content)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, []byte) error); ok {
		r0 = rf(packageArn, documentVersion, content)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
