// Code generated by bpf2go; DO NOT EDIT.
//go:build arm64

package tctracer

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type BpfDebugConnectionInfoT struct {
	_      structs.HostLayout
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type BpfDebugEgressKeyT struct {
	_      structs.HostLayout
	S_port uint16
	D_port uint16
}

type BpfDebugGoAddrKeyT struct {
	_    structs.HostLayout
	Pid  uint64
	Addr uint64
}

type BpfDebugHttpFuncInvocationT struct {
	_               structs.HostLayout
	StartMonotimeNs uint64
	Tp              struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type BpfDebugHttpInfoT struct {
	_               structs.HostLayout
	Flags           uint8
	Type            uint8
	Ssl             uint8
	Delayed         uint8
	ConnInfo        BpfDebugConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ExtraId         uint64
	Tp              struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Len     uint32
	RespLen uint32
	TaskTid uint32
	Status  uint16
	Buf     [256]uint8
	Pad     [6]uint8
}

type BpfDebugPidConnectionInfoT struct {
	_    structs.HostLayout
	Conn BpfDebugConnectionInfoT
	Pid  uint32
}

type BpfDebugTpInfoPidT struct {
	_  structs.HostLayout
	Tp struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type BpfDebugTraceMapKeyT struct {
	_    structs.HostLayout
	Conn BpfDebugConnectionInfoT
	Type uint32
}

// LoadBpfDebug returns the embedded CollectionSpec for BpfDebug.
func LoadBpfDebug() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfDebugBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load BpfDebug: %w", err)
	}

	return spec, err
}

// LoadBpfDebugObjects loads BpfDebug and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*BpfDebugObjects
//	*BpfDebugPrograms
//	*BpfDebugMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadBpfDebugObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadBpfDebug()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// BpfDebugSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugSpecs struct {
	BpfDebugProgramSpecs
	BpfDebugMapSpecs
	BpfDebugVariableSpecs
}

// BpfDebugProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugProgramSpecs struct {
	ObiAppEgress  *ebpf.ProgramSpec `ebpf:"obi_app_egress"`
	ObiAppIngress *ebpf.ProgramSpec `ebpf:"obi_app_ingress"`
}

// BpfDebugMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugMapSpecs struct {
	DebugEvents                 *ebpf.MapSpec `ebpf:"debug_events"`
	GoOngoingHttp               *ebpf.MapSpec `ebpf:"go_ongoing_http"`
	GoOngoingHttpClientRequests *ebpf.MapSpec `ebpf:"go_ongoing_http_client_requests"`
	IncomingTraceMap            *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	OngoingHttp                 *ebpf.MapSpec `ebpf:"ongoing_http"`
	OutgoingTraceMap            *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	SockDir                     *ebpf.MapSpec `ebpf:"sock_dir"`
	TraceMap                    *ebpf.MapSpec `ebpf:"trace_map"`
}

// BpfDebugVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugVariableSpecs struct {
	EXTEND_SIZE       *ebpf.VariableSpec `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.VariableSpec `ebpf:"INVALID_POS"`
	TP                *ebpf.VariableSpec `ebpf:"TP"`
	TP_PREFIX         *ebpf.VariableSpec `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.VariableSpec `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	Ip4ip6Prefix      *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2       *ebpf.VariableSpec `ebpf:"unused_http2"`
}

// BpfDebugObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugObjects struct {
	BpfDebugPrograms
	BpfDebugMaps
	BpfDebugVariables
}

func (o *BpfDebugObjects) Close() error {
	return _BpfDebugClose(
		&o.BpfDebugPrograms,
		&o.BpfDebugMaps,
	)
}

// BpfDebugMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugMaps struct {
	DebugEvents                 *ebpf.Map `ebpf:"debug_events"`
	GoOngoingHttp               *ebpf.Map `ebpf:"go_ongoing_http"`
	GoOngoingHttpClientRequests *ebpf.Map `ebpf:"go_ongoing_http_client_requests"`
	IncomingTraceMap            *ebpf.Map `ebpf:"incoming_trace_map"`
	OngoingHttp                 *ebpf.Map `ebpf:"ongoing_http"`
	OutgoingTraceMap            *ebpf.Map `ebpf:"outgoing_trace_map"`
	SockDir                     *ebpf.Map `ebpf:"sock_dir"`
	TraceMap                    *ebpf.Map `ebpf:"trace_map"`
}

func (m *BpfDebugMaps) Close() error {
	return _BpfDebugClose(
		m.DebugEvents,
		m.GoOngoingHttp,
		m.GoOngoingHttpClientRequests,
		m.IncomingTraceMap,
		m.OngoingHttp,
		m.OutgoingTraceMap,
		m.SockDir,
		m.TraceMap,
	)
}

// BpfDebugVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugVariables struct {
	EXTEND_SIZE       *ebpf.Variable `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.Variable `ebpf:"INVALID_POS"`
	TP                *ebpf.Variable `ebpf:"TP"`
	TP_PREFIX         *ebpf.Variable `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.Variable `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.Variable `ebpf:"disable_black_box_cp"`
	Ip4ip6Prefix      *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2       *ebpf.Variable `ebpf:"unused_http2"`
}

// BpfDebugPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugPrograms struct {
	ObiAppEgress  *ebpf.Program `ebpf:"obi_app_egress"`
	ObiAppIngress *ebpf.Program `ebpf:"obi_app_ingress"`
}

func (p *BpfDebugPrograms) Close() error {
	return _BpfDebugClose(
		p.ObiAppEgress,
		p.ObiAppIngress,
	)
}

func _BpfDebugClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpfdebug_arm64_bpfel.o
var _BpfDebugBytes []byte
