# Cloudwatch Receiver

<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [alpha]: logs   |
| Distributions | [contrib] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aopen%20label%3Areceiver%2Fawscloudwatch%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aopen+is%3Aissue+label%3Areceiver%2Fawscloudwatch) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aclosed%20label%3Areceiver%2Fawscloudwatch%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aclosed+is%3Aissue+label%3Areceiver%2Fawscloudwatch) |
| Code coverage | [![codecov](https://codecov.io/github/open-telemetry/opentelemetry-collector-contrib/graph/main/badge.svg?component=receiver_awscloudwatch)](https://app.codecov.io/gh/open-telemetry/opentelemetry-collector-contrib/tree/main/?components%5B0%5D=receiver_awscloudwatch&displayType=list) |
| [Code Owners](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/CONTRIBUTING.md#becoming-a-code-owner)    | [@schmikei](https://www.github.com/schmikei) \| Seeking more code owners! |
| Emeritus      | [@djaglowski](https://www.github.com/djaglowski) |

[alpha]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#alpha
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
<!-- end autogenerated section -->

Receives Cloudwatch events from [AWS Cloudwatch](https://aws.amazon.com/cloudwatch/) via the [AWS SDK for Cloudwatch Logs](https://docs.aws.amazon.com/sdk-for-go/api/service/cloudwatchlogs/)

## Getting Started

This receiver uses the [AWS SDK](https://docs.aws.amazon.com/sdk-for-go/v1/developer-guide/configuring-sdk.html) as mode of authentication, which includes [Credentials File](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-files.html) and [IMDS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html) authentication for EC2 instances.

## Configuration

### Top Level Parameters

| Parameter       | Notes      | type   | Description                                                                                                                                                                                                                                                                       |
| --------------- | ---------- | ------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `region`        | *required* | string | The AWS recognized region string                                                                                                                                                                                                                                                  |
| `profile`       | *optional* | string | The AWS profile used to authenticate, if none is specified the default is chosen from the list of profiles                                                                                                                                                                        |
| `imds_endpoint` | *optional* | string | A way of specifying a custom URL to be used by the EC2 IMDS client to validate the session. If unset, and the environment variable `AWS_EC2_METADATA_SERVICE_ENDPOINT` has a value the client will use the value of the environment variable as the endpoint for operation calls. |
| `logs`          | *optional* | `Logs` | Configuration for Logs ingestion of this receiver                                                                                                                                                                                                                                 |
| `storage`       | *optional* | string | The ID of a storage extension to be used for state persistence.                                                                                                                                                                                                                   |

### Logs Parameters

| Parameter                | Type     | Default                                    | Description                                                                                            |
|--------------------------|----------|--------------------------------------------|--------------------------------------------------------------------------------------------------------|
| `start_from`             | String   | Read all available logs from the beginning | Timestamp in `RFC3339` format (e.g., 2006-01-02T15:04:05Z07:00) indicating where to start reading logs |
| `poll_interval`          | Duration | 1 minute                                   | Time to wait between log requests                                                                      |
| `max_events_per_request` | Integer  | 1,000                                      | The maximum number of events to process per request to Cloudwatch                                      |
| `groups`                 | Optional | All Log Groups and Streams                 | Configuration for Log Groups, by default all Log Groups and Log Streams will be collected.             |

### Group Parameters

`autodiscover` and `named` are ways to control and filter which log groups and log streams which are collected from. They are mutually exclusive and are incompatible to be configured at the same time.

- `autodiscover`
  - `limit`: (optional; default = 50) Limits the number of discovered log groups. This does not limit how large each API call to discover the log groups will be.
  - `prefix`: (optional) A prefix for log groups to limit the number of log groups discovered.
    - Only one of `prefix` or `pattern` can be specified. If both are omitted, all log streams up to the limit are collected.
  - `pattern`: (optional) A case-sensitive substring (not a regular expression) that must be present in the log group names, used to limit the number of log groups discovered.
    - Only one of `prefix` or `pattern` can be specified. If both are omitted, all log streams up to the limit are collected.
  - `streams`: (optional) If `streams` is omitted, then all streams will be attempted to retrieve events from.
    - `names`: A list of full log stream names to filter the discovered log groups to collect from.
    - `prefixes`: A list of prefixes to filter the discovered log groups to collect from.
- `named`
  - This is a map of log group name to stream filtering options
    - `streams`: (optional)
      - `names`: A list of full log stream names to filter the discovered log groups to collect from.
      - `prefixes`: A list of prefixes to filter the discovered log groups to collect from.

#### Autodiscovery Example Configuration

```yaml
awscloudwatch:
  region: us-west-1
  logs:
    poll_interval: 1m
    groups:
      autodiscover:
        limit: 100
        prefix: /aws/eks/
        streams:
          prefixes: [kube-api-controller]
```

#### Named Example

```yaml
awscloudwatch:
  region: us-west-1
  logs:
    poll_interval: 5m
    groups:
      named:
        /aws/eks/dev-0/cluster: 
          names: [kube-apiserver-ea9c831555adca1815ae04b87661klasdj]
```

## Sample Configs

This receiver has a number of sample configs for reference.

1. [Default](./testdata/sample-configs/default.yaml)

    - Minimal configuration of the receiver
    - Performs autodiscovery
    - Collects all log groups and log streams

2. [Autodiscover Filtering Log Groups](./testdata/sample-configs/autodiscover-filter-groups.yaml)

    - Performs autodiscovery
    - Only collects log groups matching a prefix
    - Limits the number of discovered Log Groups

3. [Autodiscover Filtering Log Streams](./testdata/sample-configs/autodiscover-filter-streams.yaml)

   - Performs autodiscovery for all Log Groups
   - Filters log streams

4. [Named Groups](./testdata/sample-configs/named-prefix.yaml)

   - Specifies and only collects from the desired Log Groups
   - Does not attempt autodiscovery

5. [Named Groups Filter Log Streams](./testdata/sample-configs/named-prefix-streams.yaml)

   - Specifies the names of the log groups to collect
   - Does not attempt autodiscovery
   - Only collects from log streams matching a prefix
