// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: pkg/logproto/pattern.proto

package logproto

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	push "github.com/grafana/loki/pkg/push"
	github_com_prometheus_common_model "github.com/prometheus/common/model"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type QueryPatternsRequest struct {
	Query string    `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	Start time.Time `protobuf:"bytes,2,opt,name=start,proto3,stdtime" json:"start"`
	End   time.Time `protobuf:"bytes,3,opt,name=end,proto3,stdtime" json:"end"`
	Step  int64     `protobuf:"varint,4,opt,name=step,proto3" json:"step,omitempty"`
}

func (m *QueryPatternsRequest) Reset()      { *m = QueryPatternsRequest{} }
func (*QueryPatternsRequest) ProtoMessage() {}
func (*QueryPatternsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_aaf4192acc66a4ea, []int{0}
}
func (m *QueryPatternsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryPatternsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryPatternsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryPatternsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryPatternsRequest.Merge(m, src)
}
func (m *QueryPatternsRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryPatternsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryPatternsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryPatternsRequest proto.InternalMessageInfo

func (m *QueryPatternsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *QueryPatternsRequest) GetStart() time.Time {
	if m != nil {
		return m.Start
	}
	return time.Time{}
}

func (m *QueryPatternsRequest) GetEnd() time.Time {
	if m != nil {
		return m.End
	}
	return time.Time{}
}

func (m *QueryPatternsRequest) GetStep() int64 {
	if m != nil {
		return m.Step
	}
	return 0
}

type QueryPatternsResponse struct {
	Series []*PatternSeries `protobuf:"bytes,1,rep,name=series,proto3" json:"series,omitempty"`
}

func (m *QueryPatternsResponse) Reset()      { *m = QueryPatternsResponse{} }
func (*QueryPatternsResponse) ProtoMessage() {}
func (*QueryPatternsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_aaf4192acc66a4ea, []int{1}
}
func (m *QueryPatternsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryPatternsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryPatternsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryPatternsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryPatternsResponse.Merge(m, src)
}
func (m *QueryPatternsResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryPatternsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryPatternsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryPatternsResponse proto.InternalMessageInfo

func (m *QueryPatternsResponse) GetSeries() []*PatternSeries {
	if m != nil {
		return m.Series
	}
	return nil
}

type PatternSeries struct {
	Pattern string           `protobuf:"bytes,1,opt,name=pattern,proto3" json:"pattern,omitempty"`
	Samples []*PatternSample `protobuf:"bytes,2,rep,name=samples,proto3" json:"samples,omitempty"`
	Level   string           `protobuf:"bytes,3,opt,name=level,proto3" json:"level,omitempty"`
}

func (m *PatternSeries) Reset()      { *m = PatternSeries{} }
func (*PatternSeries) ProtoMessage() {}
func (*PatternSeries) Descriptor() ([]byte, []int) {
	return fileDescriptor_aaf4192acc66a4ea, []int{2}
}
func (m *PatternSeries) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PatternSeries) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PatternSeries.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PatternSeries) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatternSeries.Merge(m, src)
}
func (m *PatternSeries) XXX_Size() int {
	return m.Size()
}
func (m *PatternSeries) XXX_DiscardUnknown() {
	xxx_messageInfo_PatternSeries.DiscardUnknown(m)
}

var xxx_messageInfo_PatternSeries proto.InternalMessageInfo

func (m *PatternSeries) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

func (m *PatternSeries) GetSamples() []*PatternSample {
	if m != nil {
		return m.Samples
	}
	return nil
}

func (m *PatternSeries) GetLevel() string {
	if m != nil {
		return m.Level
	}
	return ""
}

type PatternSample struct {
	Timestamp github_com_prometheus_common_model.Time `protobuf:"varint,1,opt,name=timestamp,proto3,customtype=github.com/prometheus/common/model.Time" json:"timestamp"`
	Value     int64                                   `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *PatternSample) Reset()      { *m = PatternSample{} }
func (*PatternSample) ProtoMessage() {}
func (*PatternSample) Descriptor() ([]byte, []int) {
	return fileDescriptor_aaf4192acc66a4ea, []int{3}
}
func (m *PatternSample) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PatternSample) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PatternSample.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PatternSample) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatternSample.Merge(m, src)
}
func (m *PatternSample) XXX_Size() int {
	return m.Size()
}
func (m *PatternSample) XXX_DiscardUnknown() {
	xxx_messageInfo_PatternSample.DiscardUnknown(m)
}

var xxx_messageInfo_PatternSample proto.InternalMessageInfo

func (m *PatternSample) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func init() {
	proto.RegisterType((*QueryPatternsRequest)(nil), "logproto.QueryPatternsRequest")
	proto.RegisterType((*QueryPatternsResponse)(nil), "logproto.QueryPatternsResponse")
	proto.RegisterType((*PatternSeries)(nil), "logproto.PatternSeries")
	proto.RegisterType((*PatternSample)(nil), "logproto.PatternSample")
}

func init() { proto.RegisterFile("pkg/logproto/pattern.proto", fileDescriptor_aaf4192acc66a4ea) }

var fileDescriptor_aaf4192acc66a4ea = []byte{
	// 494 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x53, 0xbf, 0x6e, 0xd3, 0x40,
	0x18, 0xf7, 0xd5, 0x49, 0xd3, 0x5c, 0xc5, 0x72, 0xa4, 0x60, 0x19, 0xe9, 0x1c, 0x79, 0x21, 0x93,
	0x0f, 0x52, 0x09, 0x24, 0xc6, 0x4c, 0x0c, 0x20, 0x15, 0xc3, 0x84, 0xc4, 0xe0, 0xb4, 0x5f, 0xed,
	0xa8, 0xb6, 0xcf, 0xf5, 0xdd, 0x45, 0x62, 0xe3, 0x11, 0xf2, 0x18, 0x3c, 0x00, 0x0f, 0xd1, 0x31,
	0x63, 0xc5, 0x50, 0x88, 0xb3, 0x30, 0xf6, 0x11, 0x90, 0xef, 0xec, 0x26, 0xad, 0xc8, 0xc0, 0x62,
	0xdf, 0xef, 0xfb, 0xfd, 0xee, 0xfb, 0xf3, 0xfb, 0x6c, 0xec, 0x16, 0x17, 0x31, 0x4b, 0x79, 0x5c,
	0x94, 0x5c, 0x72, 0x56, 0x44, 0x52, 0x42, 0x99, 0x07, 0x1a, 0x91, 0x83, 0x36, 0xee, 0x0e, 0x62,
	0x1e, 0x73, 0x23, 0xa9, 0x4f, 0x86, 0x77, 0xbd, 0x98, 0xf3, 0x38, 0x05, 0xa6, 0xd1, 0x54, 0x9d,
	0x33, 0x39, 0xcb, 0x40, 0xc8, 0x28, 0x2b, 0x1a, 0xc1, 0xb3, 0x7b, 0xc9, 0xdb, 0x43, 0x43, 0x3e,
	0xae, 0xc9, 0x42, 0x89, 0x44, 0x3f, 0x4c, 0xd0, 0xff, 0x81, 0xf0, 0xe0, 0x83, 0x82, 0xf2, 0xeb,
	0x89, 0xe9, 0x44, 0x84, 0x70, 0xa9, 0x40, 0x48, 0x32, 0xc0, 0xdd, 0xcb, 0x3a, 0xee, 0xa0, 0x21,
	0x1a, 0xf5, 0x43, 0x03, 0xc8, 0x1b, 0xdc, 0x15, 0x32, 0x2a, 0xa5, 0xb3, 0x37, 0x44, 0xa3, 0xc3,
	0xb1, 0x1b, 0x98, 0x8e, 0x82, 0xb6, 0xa3, 0xe0, 0x53, 0xdb, 0xd1, 0xe4, 0xe0, 0xea, 0xc6, 0xb3,
	0x16, 0xbf, 0x3c, 0x14, 0x9a, 0x2b, 0xe4, 0x15, 0xb6, 0x21, 0x3f, 0x73, 0xec, 0xff, 0xb8, 0x59,
	0x5f, 0x20, 0x04, 0x77, 0x84, 0x84, 0xc2, 0xe9, 0x0c, 0xd1, 0xc8, 0x0e, 0xf5, 0xd9, 0x7f, 0x8b,
	0x8f, 0x1e, 0x74, 0x2d, 0x0a, 0x9e, 0x0b, 0x20, 0x0c, 0xef, 0x0b, 0x28, 0x67, 0x20, 0x1c, 0x34,
	0xb4, 0x47, 0x87, 0xe3, 0xa7, 0xc1, 0x9d, 0x0b, 0x8d, 0xf6, 0xa3, 0xa6, 0xc3, 0x46, 0xe6, 0x97,
	0xf8, 0xd1, 0x3d, 0x82, 0x38, 0xb8, 0xd7, 0x6c, 0xa5, 0x19, 0xbd, 0x85, 0xe4, 0x25, 0xee, 0x89,
	0x28, 0x2b, 0x52, 0x10, 0xce, 0xde, 0xae, 0xe4, 0x9a, 0x0f, 0x5b, 0x5d, 0xed, 0x62, 0x0a, 0x73,
	0x48, 0xf5, 0xd4, 0xfd, 0xd0, 0x00, 0x5f, 0x6e, 0x6a, 0x6a, 0x1d, 0x79, 0x8f, 0xfb, 0x77, 0xab,
	0xd4, 0x55, 0xed, 0x09, 0xab, 0x4d, 0xf8, 0x79, 0xe3, 0x3d, 0x8f, 0x67, 0x32, 0x51, 0xd3, 0xe0,
	0x94, 0x67, 0xf5, 0xde, 0x33, 0x90, 0x09, 0x28, 0xc1, 0x4e, 0x79, 0x96, 0xf1, 0x9c, 0x65, 0xfc,
	0x0c, 0x52, 0x6d, 0x5d, 0xb8, 0xc9, 0x50, 0x57, 0x9d, 0x47, 0xa9, 0x02, 0xbd, 0x25, 0x3b, 0x34,
	0x60, 0xbc, 0x40, 0xb8, 0xd7, 0x94, 0x25, 0xaf, 0x71, 0xe7, 0x44, 0x89, 0x84, 0x1c, 0x6d, 0x4d,
	0xa0, 0x44, 0xd2, 0x2c, 0xdf, 0x7d, 0xf2, 0x30, 0x6c, 0xdc, 0xf5, 0x2d, 0xf2, 0x0e, 0x77, 0xb5,
	0xf1, 0x84, 0x6e, 0x24, 0xff, 0xfa, 0x7e, 0x5c, 0x6f, 0x27, 0xdf, 0xe6, 0x7a, 0x81, 0x26, 0x5f,
	0x96, 0x2b, 0x6a, 0x5d, 0xaf, 0xa8, 0x75, 0xbb, 0xa2, 0xe8, 0x5b, 0x45, 0xd1, 0xf7, 0x8a, 0xa2,
	0xab, 0x8a, 0xa2, 0x65, 0x45, 0xd1, 0xef, 0x8a, 0xa2, 0x3f, 0x15, 0xb5, 0x6e, 0x2b, 0x8a, 0x16,
	0x6b, 0x6a, 0x2d, 0xd7, 0xd4, 0xba, 0x5e, 0x53, 0xeb, 0xf3, 0xb6, 0x25, 0x71, 0x19, 0x9d, 0x47,
	0x79, 0xc4, 0x52, 0x7e, 0x31, 0x63, 0xf3, 0x63, 0xb6, 0xfd, 0x03, 0x4c, 0xf7, 0xf5, 0xeb, 0xf8,
	0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa4, 0xcc, 0x74, 0x32, 0x74, 0x03, 0x00, 0x00,
}

func (this *QueryPatternsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryPatternsRequest)
	if !ok {
		that2, ok := that.(QueryPatternsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Query != that1.Query {
		return false
	}
	if !this.Start.Equal(that1.Start) {
		return false
	}
	if !this.End.Equal(that1.End) {
		return false
	}
	if this.Step != that1.Step {
		return false
	}
	return true
}
func (this *QueryPatternsResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryPatternsResponse)
	if !ok {
		that2, ok := that.(QueryPatternsResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Series) != len(that1.Series) {
		return false
	}
	for i := range this.Series {
		if !this.Series[i].Equal(that1.Series[i]) {
			return false
		}
	}
	return true
}
func (this *PatternSeries) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PatternSeries)
	if !ok {
		that2, ok := that.(PatternSeries)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Pattern != that1.Pattern {
		return false
	}
	if len(this.Samples) != len(that1.Samples) {
		return false
	}
	for i := range this.Samples {
		if !this.Samples[i].Equal(that1.Samples[i]) {
			return false
		}
	}
	if this.Level != that1.Level {
		return false
	}
	return true
}
func (this *PatternSample) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PatternSample)
	if !ok {
		that2, ok := that.(PatternSample)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Timestamp.Equal(that1.Timestamp) {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *QueryPatternsRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&logproto.QueryPatternsRequest{")
	s = append(s, "Query: "+fmt.Sprintf("%#v", this.Query)+",\n")
	s = append(s, "Start: "+fmt.Sprintf("%#v", this.Start)+",\n")
	s = append(s, "End: "+fmt.Sprintf("%#v", this.End)+",\n")
	s = append(s, "Step: "+fmt.Sprintf("%#v", this.Step)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryPatternsResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&logproto.QueryPatternsResponse{")
	if this.Series != nil {
		s = append(s, "Series: "+fmt.Sprintf("%#v", this.Series)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PatternSeries) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&logproto.PatternSeries{")
	s = append(s, "Pattern: "+fmt.Sprintf("%#v", this.Pattern)+",\n")
	if this.Samples != nil {
		s = append(s, "Samples: "+fmt.Sprintf("%#v", this.Samples)+",\n")
	}
	s = append(s, "Level: "+fmt.Sprintf("%#v", this.Level)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PatternSample) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&logproto.PatternSample{")
	s = append(s, "Timestamp: "+fmt.Sprintf("%#v", this.Timestamp)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringPattern(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// PatternClient is the client API for Pattern service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PatternClient interface {
	Push(ctx context.Context, in *push.PushRequest, opts ...grpc.CallOption) (*push.PushResponse, error)
	Query(ctx context.Context, in *QueryPatternsRequest, opts ...grpc.CallOption) (Pattern_QueryClient, error)
}

type patternClient struct {
	cc *grpc.ClientConn
}

func NewPatternClient(cc *grpc.ClientConn) PatternClient {
	return &patternClient{cc}
}

func (c *patternClient) Push(ctx context.Context, in *push.PushRequest, opts ...grpc.CallOption) (*push.PushResponse, error) {
	out := new(push.PushResponse)
	err := c.cc.Invoke(ctx, "/logproto.Pattern/Push", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *patternClient) Query(ctx context.Context, in *QueryPatternsRequest, opts ...grpc.CallOption) (Pattern_QueryClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Pattern_serviceDesc.Streams[0], "/logproto.Pattern/Query", opts...)
	if err != nil {
		return nil, err
	}
	x := &patternQueryClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Pattern_QueryClient interface {
	Recv() (*QueryPatternsResponse, error)
	grpc.ClientStream
}

type patternQueryClient struct {
	grpc.ClientStream
}

func (x *patternQueryClient) Recv() (*QueryPatternsResponse, error) {
	m := new(QueryPatternsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// PatternServer is the server API for Pattern service.
type PatternServer interface {
	Push(context.Context, *push.PushRequest) (*push.PushResponse, error)
	Query(*QueryPatternsRequest, Pattern_QueryServer) error
}

// UnimplementedPatternServer can be embedded to have forward compatible implementations.
type UnimplementedPatternServer struct {
}

func (*UnimplementedPatternServer) Push(ctx context.Context, req *push.PushRequest) (*push.PushResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Push not implemented")
}
func (*UnimplementedPatternServer) Query(req *QueryPatternsRequest, srv Pattern_QueryServer) error {
	return status.Errorf(codes.Unimplemented, "method Query not implemented")
}

func RegisterPatternServer(s *grpc.Server, srv PatternServer) {
	s.RegisterService(&_Pattern_serviceDesc, srv)
}

func _Pattern_Push_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(push.PushRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PatternServer).Push(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/logproto.Pattern/Push",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PatternServer).Push(ctx, req.(*push.PushRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pattern_Query_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(QueryPatternsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PatternServer).Query(m, &patternQueryServer{stream})
}

type Pattern_QueryServer interface {
	Send(*QueryPatternsResponse) error
	grpc.ServerStream
}

type patternQueryServer struct {
	grpc.ServerStream
}

func (x *patternQueryServer) Send(m *QueryPatternsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _Pattern_serviceDesc = grpc.ServiceDesc{
	ServiceName: "logproto.Pattern",
	HandlerType: (*PatternServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Push",
			Handler:    _Pattern_Push_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Query",
			Handler:       _Pattern_Query_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "pkg/logproto/pattern.proto",
}

func (m *QueryPatternsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryPatternsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryPatternsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Step != 0 {
		i = encodeVarintPattern(dAtA, i, uint64(m.Step))
		i--
		dAtA[i] = 0x20
	}
	n1, err1 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.End, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.End):])
	if err1 != nil {
		return 0, err1
	}
	i -= n1
	i = encodeVarintPattern(dAtA, i, uint64(n1))
	i--
	dAtA[i] = 0x1a
	n2, err2 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Start, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.Start):])
	if err2 != nil {
		return 0, err2
	}
	i -= n2
	i = encodeVarintPattern(dAtA, i, uint64(n2))
	i--
	dAtA[i] = 0x12
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintPattern(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryPatternsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryPatternsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryPatternsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Series) > 0 {
		for iNdEx := len(m.Series) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Series[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPattern(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PatternSeries) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PatternSeries) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PatternSeries) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Level) > 0 {
		i -= len(m.Level)
		copy(dAtA[i:], m.Level)
		i = encodeVarintPattern(dAtA, i, uint64(len(m.Level)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Samples) > 0 {
		for iNdEx := len(m.Samples) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Samples[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPattern(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Pattern) > 0 {
		i -= len(m.Pattern)
		copy(dAtA[i:], m.Pattern)
		i = encodeVarintPattern(dAtA, i, uint64(len(m.Pattern)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PatternSample) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PatternSample) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PatternSample) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != 0 {
		i = encodeVarintPattern(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x10
	}
	if m.Timestamp != 0 {
		i = encodeVarintPattern(dAtA, i, uint64(m.Timestamp))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintPattern(dAtA []byte, offset int, v uint64) int {
	offset -= sovPattern(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *QueryPatternsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovPattern(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Start)
	n += 1 + l + sovPattern(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.End)
	n += 1 + l + sovPattern(uint64(l))
	if m.Step != 0 {
		n += 1 + sovPattern(uint64(m.Step))
	}
	return n
}

func (m *QueryPatternsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Series) > 0 {
		for _, e := range m.Series {
			l = e.Size()
			n += 1 + l + sovPattern(uint64(l))
		}
	}
	return n
}

func (m *PatternSeries) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Pattern)
	if l > 0 {
		n += 1 + l + sovPattern(uint64(l))
	}
	if len(m.Samples) > 0 {
		for _, e := range m.Samples {
			l = e.Size()
			n += 1 + l + sovPattern(uint64(l))
		}
	}
	l = len(m.Level)
	if l > 0 {
		n += 1 + l + sovPattern(uint64(l))
	}
	return n
}

func (m *PatternSample) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovPattern(uint64(m.Timestamp))
	}
	if m.Value != 0 {
		n += 1 + sovPattern(uint64(m.Value))
	}
	return n
}

func sovPattern(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPattern(x uint64) (n int) {
	return sovPattern(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *QueryPatternsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryPatternsRequest{`,
		`Query:` + fmt.Sprintf("%v", this.Query) + `,`,
		`Start:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Start), "Timestamp", "types.Timestamp", 1), `&`, ``, 1) + `,`,
		`End:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.End), "Timestamp", "types.Timestamp", 1), `&`, ``, 1) + `,`,
		`Step:` + fmt.Sprintf("%v", this.Step) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryPatternsResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForSeries := "[]*PatternSeries{"
	for _, f := range this.Series {
		repeatedStringForSeries += strings.Replace(f.String(), "PatternSeries", "PatternSeries", 1) + ","
	}
	repeatedStringForSeries += "}"
	s := strings.Join([]string{`&QueryPatternsResponse{`,
		`Series:` + repeatedStringForSeries + `,`,
		`}`,
	}, "")
	return s
}
func (this *PatternSeries) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForSamples := "[]*PatternSample{"
	for _, f := range this.Samples {
		repeatedStringForSamples += strings.Replace(f.String(), "PatternSample", "PatternSample", 1) + ","
	}
	repeatedStringForSamples += "}"
	s := strings.Join([]string{`&PatternSeries{`,
		`Pattern:` + fmt.Sprintf("%v", this.Pattern) + `,`,
		`Samples:` + repeatedStringForSamples + `,`,
		`Level:` + fmt.Sprintf("%v", this.Level) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PatternSample) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PatternSample{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringPattern(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *QueryPatternsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPattern
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryPatternsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryPatternsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPattern
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPattern
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPattern
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPattern
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Start, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPattern
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPattern
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.End, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Step", wireType)
			}
			m.Step = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Step |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPattern(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPattern
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPattern
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryPatternsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPattern
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryPatternsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryPatternsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Series", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPattern
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPattern
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Series = append(m.Series, &PatternSeries{})
			if err := m.Series[len(m.Series)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPattern(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPattern
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPattern
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PatternSeries) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPattern
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PatternSeries: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PatternSeries: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pattern", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPattern
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPattern
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Samples", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPattern
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPattern
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Samples = append(m.Samples, &PatternSample{})
			if err := m.Samples[len(m.Samples)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPattern
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPattern
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Level = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPattern(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPattern
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPattern
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PatternSample) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPattern
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PatternSample: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PatternSample: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= github_com_prometheus_common_model.Time(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPattern(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPattern
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPattern
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPattern(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPattern
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPattern
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPattern
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthPattern
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowPattern
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipPattern(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthPattern
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthPattern = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPattern   = fmt.Errorf("proto: integer overflow")
)
