// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: proto/process/connections.proto

package process

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type RuntimeCompilationResult int32

const (
	RuntimeCompilationResult_NotAttempted        RuntimeCompilationResult = 0
	RuntimeCompilationResult_CompilationSuccess  RuntimeCompilationResult = 1
	RuntimeCompilationResult_KernelVersionErr    RuntimeCompilationResult = 2
	RuntimeCompilationResult_VerificationError   RuntimeCompilationResult = 3
	RuntimeCompilationResult_OutputDirErr        RuntimeCompilationResult = 4
	RuntimeCompilationResult_OutputFileErr       RuntimeCompilationResult = 5
	RuntimeCompilationResult_NewCompilerErr      RuntimeCompilationResult = 6
	RuntimeCompilationResult_CompilationErr      RuntimeCompilationResult = 7
	RuntimeCompilationResult_ResultReadErr       RuntimeCompilationResult = 8
	RuntimeCompilationResult_HeaderFetchErr      RuntimeCompilationResult = 9
	RuntimeCompilationResult_CompiledOutputFound RuntimeCompilationResult = 10
	RuntimeCompilationResult_InputHashError      RuntimeCompilationResult = 11
)

var RuntimeCompilationResult_name = map[int32]string{
	0:  "NotAttempted",
	1:  "CompilationSuccess",
	2:  "KernelVersionErr",
	3:  "VerificationError",
	4:  "OutputDirErr",
	5:  "OutputFileErr",
	6:  "NewCompilerErr",
	7:  "CompilationErr",
	8:  "ResultReadErr",
	9:  "HeaderFetchErr",
	10: "CompiledOutputFound",
	11: "InputHashError",
}

var RuntimeCompilationResult_value = map[string]int32{
	"NotAttempted":        0,
	"CompilationSuccess":  1,
	"KernelVersionErr":    2,
	"VerificationError":   3,
	"OutputDirErr":        4,
	"OutputFileErr":       5,
	"NewCompilerErr":      6,
	"CompilationErr":      7,
	"ResultReadErr":       8,
	"HeaderFetchErr":      9,
	"CompiledOutputFound": 10,
	"InputHashError":      11,
}

func (x RuntimeCompilationResult) String() string {
	return proto.EnumName(RuntimeCompilationResult_name, int32(x))
}

func (RuntimeCompilationResult) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{0}
}

type KernelHeaderFetchResult int32

const (
	KernelHeaderFetchResult_FetchNotAttempted               KernelHeaderFetchResult = 0
	KernelHeaderFetchResult_CustomHeadersFound              KernelHeaderFetchResult = 1
	KernelHeaderFetchResult_DefaultHeadersFound             KernelHeaderFetchResult = 2
	KernelHeaderFetchResult_SysfsHeadersFound               KernelHeaderFetchResult = 3
	KernelHeaderFetchResult_DownloadedHeadersFound          KernelHeaderFetchResult = 4
	KernelHeaderFetchResult_DownloadSuccess                 KernelHeaderFetchResult = 5
	KernelHeaderFetchResult_HostVersionErr                  KernelHeaderFetchResult = 6
	KernelHeaderFetchResult_DownloadFailure                 KernelHeaderFetchResult = 7
	KernelHeaderFetchResult_ValidationFailure               KernelHeaderFetchResult = 8
	KernelHeaderFetchResult_ReposDirAccessFailure           KernelHeaderFetchResult = 9
	KernelHeaderFetchResult_HeadersNotFoundDownloadDisabled KernelHeaderFetchResult = 10
)

var KernelHeaderFetchResult_name = map[int32]string{
	0:  "FetchNotAttempted",
	1:  "CustomHeadersFound",
	2:  "DefaultHeadersFound",
	3:  "SysfsHeadersFound",
	4:  "DownloadedHeadersFound",
	5:  "DownloadSuccess",
	6:  "HostVersionErr",
	7:  "DownloadFailure",
	8:  "ValidationFailure",
	9:  "ReposDirAccessFailure",
	10: "HeadersNotFoundDownloadDisabled",
}

var KernelHeaderFetchResult_value = map[string]int32{
	"FetchNotAttempted":               0,
	"CustomHeadersFound":              1,
	"DefaultHeadersFound":             2,
	"SysfsHeadersFound":               3,
	"DownloadedHeadersFound":          4,
	"DownloadSuccess":                 5,
	"HostVersionErr":                  6,
	"DownloadFailure":                 7,
	"ValidationFailure":               8,
	"ReposDirAccessFailure":           9,
	"HeadersNotFoundDownloadDisabled": 10,
}

func (x KernelHeaderFetchResult) String() string {
	return proto.EnumName(KernelHeaderFetchResult_name, int32(x))
}

func (KernelHeaderFetchResult) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{1}
}

type COREResult int32

const (
	COREResult_SuccessCustomBTF       COREResult = 0
	COREResult_SuccessEmbeddedBTF     COREResult = 1
	COREResult_SuccessDefaultBTF      COREResult = 2
	COREResult_BtfNotFound            COREResult = 3
	COREResult_AssetReadError         COREResult = 4
	COREResult_VerifierError          COREResult = 5
	COREResult_LoaderError            COREResult = 6
	COREResult_SuccessRemoteConfigBTF COREResult = 7
)

var COREResult_name = map[int32]string{
	0: "SuccessCustomBTF",
	1: "SuccessEmbeddedBTF",
	2: "SuccessDefaultBTF",
	3: "BtfNotFound",
	4: "AssetReadError",
	5: "VerifierError",
	6: "LoaderError",
	7: "SuccessRemoteConfigBTF",
}

var COREResult_value = map[string]int32{
	"SuccessCustomBTF":       0,
	"SuccessEmbeddedBTF":     1,
	"SuccessDefaultBTF":      2,
	"BtfNotFound":            3,
	"AssetReadError":         4,
	"VerifierError":          5,
	"LoaderError":            6,
	"SuccessRemoteConfigBTF": 7,
}

func (x COREResult) String() string {
	return proto.EnumName(COREResult_name, int32(x))
}

func (COREResult) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{2}
}

type ConnectionFamily int32

const (
	ConnectionFamily_v4 ConnectionFamily = 0
	ConnectionFamily_v6 ConnectionFamily = 1
)

var ConnectionFamily_name = map[int32]string{
	0: "v4",
	1: "v6",
}

var ConnectionFamily_value = map[string]int32{
	"v4": 0,
	"v6": 1,
}

func (x ConnectionFamily) String() string {
	return proto.EnumName(ConnectionFamily_name, int32(x))
}

func (ConnectionFamily) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{3}
}

type ConnectionDirection int32

const (
	ConnectionDirection_unspecified ConnectionDirection = 0
	ConnectionDirection_incoming    ConnectionDirection = 1
	ConnectionDirection_outgoing    ConnectionDirection = 2
	ConnectionDirection_local       ConnectionDirection = 3
	ConnectionDirection_none        ConnectionDirection = 4
)

var ConnectionDirection_name = map[int32]string{
	0: "unspecified",
	1: "incoming",
	2: "outgoing",
	3: "local",
	4: "none",
}

var ConnectionDirection_value = map[string]int32{
	"unspecified": 0,
	"incoming":    1,
	"outgoing":    2,
	"local":       3,
	"none":        4,
}

func (x ConnectionDirection) String() string {
	return proto.EnumName(ConnectionDirection_name, int32(x))
}

func (ConnectionDirection) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{4}
}

type EphemeralPortState int32

const (
	EphemeralPortState_ephemeralUnspecified EphemeralPortState = 0
	EphemeralPortState_ephemeralTrue        EphemeralPortState = 1
	EphemeralPortState_ephemeralFalse       EphemeralPortState = 2
)

var EphemeralPortState_name = map[int32]string{
	0: "ephemeralUnspecified",
	1: "ephemeralTrue",
	2: "ephemeralFalse",
}

var EphemeralPortState_value = map[string]int32{
	"ephemeralUnspecified": 0,
	"ephemeralTrue":        1,
	"ephemeralFalse":       2,
}

func (x EphemeralPortState) String() string {
	return proto.EnumName(EphemeralPortState_name, int32(x))
}

func (EphemeralPortState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{5}
}

type ProtocolType int32

const (
	ProtocolType_protocolUnclassified ProtocolType = 0
	ProtocolType_protocolUnknown      ProtocolType = 1
	ProtocolType_protocolHTTP         ProtocolType = 2
	ProtocolType_protocolHTTP2        ProtocolType = 3
	ProtocolType_protocolTLS          ProtocolType = 4
	ProtocolType_protocolKafka        ProtocolType = 5
	ProtocolType_protocolMongo        ProtocolType = 6
	ProtocolType_protocolPostgres     ProtocolType = 7
	ProtocolType_protocolAMQP         ProtocolType = 8
	ProtocolType_protocolRedis        ProtocolType = 9
	ProtocolType_protocolMySQL        ProtocolType = 10
	ProtocolType_protocolGRPC         ProtocolType = 11
)

var ProtocolType_name = map[int32]string{
	0:  "protocolUnclassified",
	1:  "protocolUnknown",
	2:  "protocolHTTP",
	3:  "protocolHTTP2",
	4:  "protocolTLS",
	5:  "protocolKafka",
	6:  "protocolMongo",
	7:  "protocolPostgres",
	8:  "protocolAMQP",
	9:  "protocolRedis",
	10: "protocolMySQL",
	11: "protocolGRPC",
}

var ProtocolType_value = map[string]int32{
	"protocolUnclassified": 0,
	"protocolUnknown":      1,
	"protocolHTTP":         2,
	"protocolHTTP2":        3,
	"protocolTLS":          4,
	"protocolKafka":        5,
	"protocolMongo":        6,
	"protocolPostgres":     7,
	"protocolAMQP":         8,
	"protocolRedis":        9,
	"protocolMySQL":        10,
	"protocolGRPC":         11,
}

func (x ProtocolType) String() string {
	return proto.EnumName(ProtocolType_name, int32(x))
}

func (ProtocolType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{6}
}

type CollectorConnections struct {
	// the detected hostname for the agent that collected these connections
	HostName string `protobuf:"bytes,2,opt,name=hostName,proto3" json:"hostName,omitempty"`
	// this "ID" of the network. This is generally set to VPC ID in the major clouds.
	NetworkId   string        `protobuf:"bytes,12,opt,name=networkId,proto3" json:"networkId,omitempty"`
	Connections []*Connection `protobuf:"bytes,3,rep,name=connections,proto3" json:"connections,omitempty"`
	// Message batching metadata
	GroupId   int32 `protobuf:"varint,5,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize int32 `protobuf:"varint,6,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
	// Mapping of resourceID to metadata. For containers, each `connection` has a containerId field which can be mapped here.
	ResolvedResources map[string]*ResourceMetadata `protobuf:"bytes,8,rep,name=resolvedResources,proto3" json:"resolvedResources,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Mapping of processes running in each container
	ContainerForPid map[int32]string `protobuf:"bytes,10,rep,name=containerForPid,proto3" json:"containerForPid,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// encodedTags is an opaque byte format that stores several sets of tags in a way that
	// is both Go GC friendly and handles duplicate tags well.
	//
	// Think of it as a write-once datastructure that maps a TagIndex (int)  -> []string. Types like ResourceMetadata
	// and Host reference 'tagIndexes' that can be used with an `encodedTags` to get a list of actual tags (in the form of a []string)
	//
	// this tag buffer can be written with `NewV2TagEncoder` and read with the helpers `CollectorConnections#GetTags` and `CollectorConnections#UnsafeIterateTags`.
	//
	// see process/tags_v2.go for a detailed explanation of the format.
	EncodedTags []byte `protobuf:"bytes,11,opt,name=encodedTags,proto3" json:"encodedTags,omitempty"`
	// This uses the same encoding structure as `encodedTags` but specifically encodes tags for connection-level tags
	// (e.g. Connection#TagIdx)
	EncodedConnectionsTags []byte            `protobuf:"bytes,38,opt,name=encodedConnectionsTags,proto3" json:"encodedConnectionsTags,omitempty"`
	ContainerHostType      ContainerHostType `protobuf:"varint,15,opt,name=containerHostType,proto3,enum=datadog.process_agent.ContainerHostType" json:"containerHostType,omitempty"`
	// For now, we'll keep emitting telemetry from agents < 7.35
	ConnTelemetry    *CollectorConnectionsTelemetry `protobuf:"bytes,16,opt,name=connTelemetry,proto3" json:"connTelemetry,omitempty"`
	ConnTelemetryMap map[string]int64               `protobuf:"bytes,39,rep,name=connTelemetryMap,proto3" json:"connTelemetryMap,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// OS Telemetry
	Architecture    string `protobuf:"bytes,17,opt,name=architecture,proto3" json:"architecture,omitempty"`
	KernelVersion   string `protobuf:"bytes,18,opt,name=kernelVersion,proto3" json:"kernelVersion,omitempty"`
	Platform        string `protobuf:"bytes,19,opt,name=platform,proto3" json:"platform,omitempty"`
	PlatformVersion string `protobuf:"bytes,20,opt,name=platformVersion,proto3" json:"platformVersion,omitempty"`
	// Runtime compilation telemetry
	CompilationTelemetryByAsset map[string]*RuntimeCompilationTelemetry `protobuf:"bytes,21,rep,name=compilationTelemetryByAsset,proto3" json:"compilationTelemetryByAsset,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	KernelHeaderFetchResult     KernelHeaderFetchResult                 `protobuf:"varint,41,opt,name=kernelHeaderFetchResult,proto3,enum=datadog.process_agent.KernelHeaderFetchResult" json:"kernelHeaderFetchResult,omitempty"`
	// CO-RE telemetry
	CORETelemetryByAsset map[string]COREResult `protobuf:"bytes,42,rep,name=CORETelemetryByAsset,proto3" json:"CORETelemetryByAsset,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=datadog.process_agent.COREResult"`
	// Prebuilt EBPF assets in use
	PrebuiltEBPFAssets []string `protobuf:"bytes,44,rep,name=PrebuiltEBPFAssets,proto3" json:"PrebuiltEBPFAssets,omitempty"`
	// the machine-local routes used for all connections in this payload. At the time of writing, this
	// captures the subnet of the interface used to send traffic out of machine. This is also AWS only at the time
	// of writing.
	// see Connection#routeIdx
	Routes []*Route `protobuf:"bytes,31,rep,name=routes,proto3" json:"routes,omitempty"`
	// the next l3 route for all connections in this payload, AWS only.
	RouteMetadata      []*RouteMetadata    `protobuf:"bytes,34,rep,name=routeMetadata,proto3" json:"routeMetadata,omitempty"`
	AgentConfiguration *AgentConfiguration `protobuf:"bytes,35,opt,name=agentConfiguration,proto3" json:"agentConfiguration,omitempty"`
	// encoded dns is a map of (string) ip-> list of domains (DNSEntry)
	EncodedDNS []byte `protobuf:"bytes,14,opt,name=encodedDNS,proto3" json:"encodedDNS,omitempty"`
	// All queried DNS domains for which we have collected stats
	Domains []string `protobuf:"bytes,30,rep,name=domains,proto3" json:"domains,omitempty"`
	//////////////////
	// V2 encodings
	// all domain strings are now indexes into a single array of strings
	// hostname query information.  Encoded via V2DNSEncoder.EncodeDomainDatabase
	// is a single buffer; varint number of strings, followed by each string.
	EncodedDomainDatabase []byte `protobuf:"bytes,36,opt,name=encodedDomainDatabase,proto3" json:"encodedDomainDatabase,omitempty"`
	// new representation of encoded DNS.  This is a map of the string representation
	// of the IP --> DNSDatabaseEntry message. (was encodedDNS).  Encoded
	// via V2DNSEncoder.EncodeMapped.  Full buffer description provided there.
	EncodedDnsLookups   []byte                       `protobuf:"bytes,37,opt,name=encodedDnsLookups,proto3" json:"encodedDnsLookups,omitempty"`
	ResolvedHostsByName map[string]*Host             `protobuf:"bytes,40,rep,name=resolvedHostsByName,proto3" json:"resolvedHostsByName,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	EcsTask             string                       `protobuf:"bytes,45,opt,name=ecsTask,proto3" json:"ecsTask,omitempty"`
	ResolvedPublicIps   map[string]*PublicIpMetadata `protobuf:"bytes,46,rep,name=resolvedPublicIps,proto3" json:"resolvedPublicIps,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// hostTagsIndex is the index of the tags associated with the host that this connection was collected from.
	// Meant to be used with CollectorConnections#encodedTags.
	// Handled the built-in race for resolution of host tags in the backend.
	HostTagsIndex int32 `protobuf:"varint,47,opt,name=hostTagsIndex,proto3" json:"hostTagsIndex,omitempty"`
}

func (m *CollectorConnections) Reset()         { *m = CollectorConnections{} }
func (m *CollectorConnections) String() string { return proto.CompactTextString(m) }
func (*CollectorConnections) ProtoMessage()    {}
func (*CollectorConnections) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{0}
}
func (m *CollectorConnections) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorConnections) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorConnections.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorConnections) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorConnections.Merge(m, src)
}
func (m *CollectorConnections) XXX_Size() int {
	return m.Size()
}
func (m *CollectorConnections) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorConnections.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorConnections proto.InternalMessageInfo

func (m *CollectorConnections) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *CollectorConnections) GetNetworkId() string {
	if m != nil {
		return m.NetworkId
	}
	return ""
}

func (m *CollectorConnections) GetConnections() []*Connection {
	if m != nil {
		return m.Connections
	}
	return nil
}

func (m *CollectorConnections) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorConnections) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

func (m *CollectorConnections) GetResolvedResources() map[string]*ResourceMetadata {
	if m != nil {
		return m.ResolvedResources
	}
	return nil
}

func (m *CollectorConnections) GetContainerForPid() map[int32]string {
	if m != nil {
		return m.ContainerForPid
	}
	return nil
}

func (m *CollectorConnections) GetEncodedTags() []byte {
	if m != nil {
		return m.EncodedTags
	}
	return nil
}

func (m *CollectorConnections) GetEncodedConnectionsTags() []byte {
	if m != nil {
		return m.EncodedConnectionsTags
	}
	return nil
}

func (m *CollectorConnections) GetContainerHostType() ContainerHostType {
	if m != nil {
		return m.ContainerHostType
	}
	return ContainerHostType_notSpecified
}

func (m *CollectorConnections) GetConnTelemetry() *CollectorConnectionsTelemetry {
	if m != nil {
		return m.ConnTelemetry
	}
	return nil
}

func (m *CollectorConnections) GetConnTelemetryMap() map[string]int64 {
	if m != nil {
		return m.ConnTelemetryMap
	}
	return nil
}

func (m *CollectorConnections) GetArchitecture() string {
	if m != nil {
		return m.Architecture
	}
	return ""
}

func (m *CollectorConnections) GetKernelVersion() string {
	if m != nil {
		return m.KernelVersion
	}
	return ""
}

func (m *CollectorConnections) GetPlatform() string {
	if m != nil {
		return m.Platform
	}
	return ""
}

func (m *CollectorConnections) GetPlatformVersion() string {
	if m != nil {
		return m.PlatformVersion
	}
	return ""
}

func (m *CollectorConnections) GetCompilationTelemetryByAsset() map[string]*RuntimeCompilationTelemetry {
	if m != nil {
		return m.CompilationTelemetryByAsset
	}
	return nil
}

func (m *CollectorConnections) GetKernelHeaderFetchResult() KernelHeaderFetchResult {
	if m != nil {
		return m.KernelHeaderFetchResult
	}
	return KernelHeaderFetchResult_FetchNotAttempted
}

func (m *CollectorConnections) GetCORETelemetryByAsset() map[string]COREResult {
	if m != nil {
		return m.CORETelemetryByAsset
	}
	return nil
}

func (m *CollectorConnections) GetPrebuiltEBPFAssets() []string {
	if m != nil {
		return m.PrebuiltEBPFAssets
	}
	return nil
}

func (m *CollectorConnections) GetRoutes() []*Route {
	if m != nil {
		return m.Routes
	}
	return nil
}

func (m *CollectorConnections) GetRouteMetadata() []*RouteMetadata {
	if m != nil {
		return m.RouteMetadata
	}
	return nil
}

func (m *CollectorConnections) GetAgentConfiguration() *AgentConfiguration {
	if m != nil {
		return m.AgentConfiguration
	}
	return nil
}

func (m *CollectorConnections) GetEncodedDNS() []byte {
	if m != nil {
		return m.EncodedDNS
	}
	return nil
}

func (m *CollectorConnections) GetDomains() []string {
	if m != nil {
		return m.Domains
	}
	return nil
}

func (m *CollectorConnections) GetEncodedDomainDatabase() []byte {
	if m != nil {
		return m.EncodedDomainDatabase
	}
	return nil
}

func (m *CollectorConnections) GetEncodedDnsLookups() []byte {
	if m != nil {
		return m.EncodedDnsLookups
	}
	return nil
}

func (m *CollectorConnections) GetResolvedHostsByName() map[string]*Host {
	if m != nil {
		return m.ResolvedHostsByName
	}
	return nil
}

func (m *CollectorConnections) GetEcsTask() string {
	if m != nil {
		return m.EcsTask
	}
	return ""
}

func (m *CollectorConnections) GetResolvedPublicIps() map[string]*PublicIpMetadata {
	if m != nil {
		return m.ResolvedPublicIps
	}
	return nil
}

func (m *CollectorConnections) GetHostTagsIndex() int32 {
	if m != nil {
		return m.HostTagsIndex
	}
	return 0
}

// Connections is only used to communicate between the process agent and system-probe.
type Connections struct {
	Conns []*Connection        `protobuf:"bytes,1,rep,name=conns,proto3" json:"conns,omitempty"`
	Dns   map[string]*DNSEntry `protobuf:"bytes,2,rep,name=dns,proto3" json:"dns,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// For now, we'll keep emitting telemetry from agents < 7.35
	ConnTelemetry               *ConnectionsTelemetry                   `protobuf:"bytes,3,opt,name=connTelemetry,proto3" json:"connTelemetry,omitempty"`
	Domains                     []string                                `protobuf:"bytes,4,rep,name=domains,proto3" json:"domains,omitempty"`
	Routes                      []*Route                                `protobuf:"bytes,5,rep,name=routes,proto3" json:"routes,omitempty"`
	CompilationTelemetryByAsset map[string]*RuntimeCompilationTelemetry `protobuf:"bytes,6,rep,name=compilationTelemetryByAsset,proto3" json:"compilationTelemetryByAsset,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	AgentConfiguration          *AgentConfiguration                     `protobuf:"bytes,7,opt,name=agentConfiguration,proto3" json:"agentConfiguration,omitempty"`
	Tags                        []string                                `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	ConnTelemetryMap            map[string]int64                        `protobuf:"bytes,9,rep,name=connTelemetryMap,proto3" json:"connTelemetryMap,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	KernelHeaderFetchResult     KernelHeaderFetchResult                 `protobuf:"varint,10,opt,name=kernelHeaderFetchResult,proto3,enum=datadog.process_agent.KernelHeaderFetchResult" json:"kernelHeaderFetchResult,omitempty"`
	CORETelemetryByAsset        map[string]COREResult                   `protobuf:"bytes,11,rep,name=CORETelemetryByAsset,proto3" json:"CORETelemetryByAsset,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=datadog.process_agent.COREResult"`
	PrebuiltEBPFAssets          []string                                `protobuf:"bytes,12,rep,name=PrebuiltEBPFAssets,proto3" json:"PrebuiltEBPFAssets,omitempty"`
}

func (m *Connections) Reset()         { *m = Connections{} }
func (m *Connections) String() string { return proto.CompactTextString(m) }
func (*Connections) ProtoMessage()    {}
func (*Connections) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{1}
}
func (m *Connections) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Connections) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Connections.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Connections) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connections.Merge(m, src)
}
func (m *Connections) XXX_Size() int {
	return m.Size()
}
func (m *Connections) XXX_DiscardUnknown() {
	xxx_messageInfo_Connections.DiscardUnknown(m)
}

var xxx_messageInfo_Connections proto.InternalMessageInfo

func (m *Connections) GetConns() []*Connection {
	if m != nil {
		return m.Conns
	}
	return nil
}

func (m *Connections) GetDns() map[string]*DNSEntry {
	if m != nil {
		return m.Dns
	}
	return nil
}

func (m *Connections) GetConnTelemetry() *ConnectionsTelemetry {
	if m != nil {
		return m.ConnTelemetry
	}
	return nil
}

func (m *Connections) GetDomains() []string {
	if m != nil {
		return m.Domains
	}
	return nil
}

func (m *Connections) GetRoutes() []*Route {
	if m != nil {
		return m.Routes
	}
	return nil
}

func (m *Connections) GetCompilationTelemetryByAsset() map[string]*RuntimeCompilationTelemetry {
	if m != nil {
		return m.CompilationTelemetryByAsset
	}
	return nil
}

func (m *Connections) GetAgentConfiguration() *AgentConfiguration {
	if m != nil {
		return m.AgentConfiguration
	}
	return nil
}

func (m *Connections) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Connections) GetConnTelemetryMap() map[string]int64 {
	if m != nil {
		return m.ConnTelemetryMap
	}
	return nil
}

func (m *Connections) GetKernelHeaderFetchResult() KernelHeaderFetchResult {
	if m != nil {
		return m.KernelHeaderFetchResult
	}
	return KernelHeaderFetchResult_FetchNotAttempted
}

func (m *Connections) GetCORETelemetryByAsset() map[string]COREResult {
	if m != nil {
		return m.CORETelemetryByAsset
	}
	return nil
}

func (m *Connections) GetPrebuiltEBPFAssets() []string {
	if m != nil {
		return m.PrebuiltEBPFAssets
	}
	return nil
}

type Connection struct {
	Pid                  int32              `protobuf:"varint,1,opt,name=pid,proto3" json:"pid,omitempty"`
	Laddr                *Addr              `protobuf:"bytes,5,opt,name=laddr,proto3" json:"laddr,omitempty"`
	Raddr                *Addr              `protobuf:"bytes,6,opt,name=raddr,proto3" json:"raddr,omitempty"`
	Family               ConnectionFamily   `protobuf:"varint,10,opt,name=family,proto3,enum=datadog.process_agent.ConnectionFamily" json:"family,omitempty"`
	Type                 ConnectionType     `protobuf:"varint,11,opt,name=type,proto3,enum=datadog.process_agent.ConnectionType" json:"type,omitempty"`
	IsLocalPortEphemeral EphemeralPortState `protobuf:"varint,41,opt,name=isLocalPortEphemeral,proto3,enum=datadog.process_agent.EphemeralPortState" json:"isLocalPortEphemeral,omitempty"`
	// Relative counters since last check
	LastBytesSent       uint64              `protobuf:"varint,16,opt,name=lastBytesSent,proto3" json:"lastBytesSent,omitempty"`
	LastBytesReceived   uint64              `protobuf:"varint,17,opt,name=lastBytesReceived,proto3" json:"lastBytesReceived,omitempty"`
	LastRetransmits     uint32              `protobuf:"varint,18,opt,name=lastRetransmits,proto3" json:"lastRetransmits,omitempty"`
	Direction           ConnectionDirection `protobuf:"varint,19,opt,name=direction,proto3,enum=datadog.process_agent.ConnectionDirection" json:"direction,omitempty"`
	LastPacketsSent     uint64              `protobuf:"varint,38,opt,name=lastPacketsSent,proto3" json:"lastPacketsSent,omitempty"`
	LastPacketsReceived uint64              `protobuf:"varint,39,opt,name=lastPacketsReceived,proto3" json:"lastPacketsReceived,omitempty"`
	Protocol            *ProtocolStack      `protobuf:"bytes,48,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Network namespace
	NetNS uint32 `protobuf:"varint,20,opt,name=netNS,proto3" json:"netNS,omitempty"`
	// NetworkID of the remote address (post-resolution field)
	RemoteNetworkId string `protobuf:"bytes,32,opt,name=remoteNetworkId,proto3" json:"remoteNetworkId,omitempty"`
	// the conntrack entry associated with the connection. May be null on systems which don't support querying conntrack.
	IpTranslation *IPTranslation `protobuf:"bytes,21,opt,name=ipTranslation,proto3" json:"ipTranslation,omitempty"`
	// TCP-specific metrics
	Rtt    uint32 `protobuf:"varint,22,opt,name=rtt,proto3" json:"rtt,omitempty"`
	RttVar uint32 `protobuf:"varint,23,opt,name=rttVar,proto3" json:"rttVar,omitempty"`
	// Indicates that this connection begins and ends on the same host
	IntraHost bool `protobuf:"varint,24,opt,name=intraHost,proto3" json:"intraHost,omitempty"`
	// DNS-specific metrics
	DnsSuccessfulResponses uint32            `protobuf:"varint,25,opt,name=dnsSuccessfulResponses,proto3" json:"dnsSuccessfulResponses,omitempty"`
	DnsFailedResponses     uint32            `protobuf:"varint,26,opt,name=dnsFailedResponses,proto3" json:"dnsFailedResponses,omitempty"`
	DnsTimeouts            uint32            `protobuf:"varint,27,opt,name=dnsTimeouts,proto3" json:"dnsTimeouts,omitempty"`
	DnsSuccessLatencySum   uint64            `protobuf:"varint,28,opt,name=dnsSuccessLatencySum,proto3" json:"dnsSuccessLatencySum,omitempty"`
	DnsFailureLatencySum   uint64            `protobuf:"varint,29,opt,name=dnsFailureLatencySum,proto3" json:"dnsFailureLatencySum,omitempty"`
	DnsCountByRcode        map[uint32]uint32 `protobuf:"bytes,33,rep,name=dnsCountByRcode,proto3" json:"dnsCountByRcode,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// TCP state transition counters relative to last check
	LastTcpEstablished uint32 `protobuf:"varint,30,opt,name=lastTcpEstablished,proto3" json:"lastTcpEstablished,omitempty"`
	LastTcpClosed      uint32 `protobuf:"varint,31,opt,name=lastTcpClosed,proto3" json:"lastTcpClosed,omitempty"`
	// dns stats based on domain queried, the key corresponds to an index into the `domains` field
	// dnsStatsByDomain is deprecated field, left in for handling old agent versions
	DnsStatsByDomain map[int32]*DNSStats `protobuf:"bytes,34,rep,name=dnsStatsByDomain,proto3" json:"dnsStatsByDomain,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// dnsStatsByDomainByQueryType is new field
	DnsStatsByDomainByQueryType map[int32]*DNSStatsByQueryType `protobuf:"bytes,42,rep,name=dnsStatsByDomainByQueryType,proto3" json:"dnsStatsByDomainByQueryType,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// int32 index into map is the offset into the CollectorConnections.encodedDomainDatabase
	DnsStatsByDomainOffsetByQueryType map[int32]*DNSStatsByQueryType `protobuf:"bytes,43,rep,name=dnsStatsByDomainOffsetByQueryType,proto3" json:"dnsStatsByDomainOffsetByQueryType,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// routeIdx is the index of the route used to exit the host that this connection was collected from. It is an index into
	// the CollectorConnections#routes field.
	RouteIdx int32 `protobuf:"varint,36,opt,name=routeIdx,proto3" json:"routeIdx,omitempty"`
	// the index of the resolved target of the route (post-resolution field)
	RouteTargetIdx int32 `protobuf:"varint,40,opt,name=routeTargetIdx,proto3" json:"routeTargetIdx,omitempty"`
	// serialized HTTPAggregations object summarizing all http transactions recorded for this connection, organized by request path
	HttpAggregations []byte `protobuf:"bytes,37,opt,name=httpAggregations,proto3" json:"httpAggregations,omitempty"`
	// The stored values corresponds to an index into the `Connections.tags` field
	Tags []uint32 `protobuf:"varint,44,rep,name=tags,proto3" json:"tags,omitempty"`
	// Pointer to tags for this connection, see CollectorConnections#encodedConnectionsTags.
	TagsIdx int32 `protobuf:"varint,45,opt,name=tagsIdx,proto3" json:"tagsIdx,omitempty"`
	// a checksum of all the tags in this connection. Populated by the agent, but used by the backend to know when tags have changed for a connection.
	TagsChecksum uint32 `protobuf:"varint,47,opt,name=tagsChecksum,proto3" json:"tagsChecksum,omitempty"`
	// Used for offset state management (backend)
	StateIndex uint32 `protobuf:"varint,46,opt,name=stateIndex,proto3" json:"stateIndex,omitempty"`
	// serialized DataStreamsAggregations object summarizing all data streams transactions (Kafka produce & Kafka fetch) recorded for this connection organized by topic
	DataStreamsAggregations []byte `protobuf:"bytes,49,opt,name=dataStreamsAggregations,proto3" json:"dataStreamsAggregations,omitempty"`
	// serialized HTTP2Aggregations object summarizing all http2 transactions recorded for this connection, organized by request path
	Http2Aggregations []byte `protobuf:"bytes,50,opt,name=http2Aggregations,proto3" json:"http2Aggregations,omitempty"`
	// serialized DatabaseAggregations object summarizing all database transactions recorded for this connection.
	DatabaseAggregations []byte `protobuf:"bytes,51,opt,name=databaseAggregations,proto3" json:"databaseAggregations,omitempty"`
	// serialized map of POSIX error codes to the number of times they have been encountered in the context of this connection (ex [110: 3] would mean that the connection has seen 3 ETIMEDOUT errors)
	TcpFailuresByErrCode map[uint32]uint32 `protobuf:"bytes,52,rep,name=tcpFailuresByErrCode,proto3" json:"tcpFailuresByErrCode,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	RemoteEcsTask        string            `protobuf:"bytes,53,opt,name=remoteEcsTask,proto3" json:"remoteEcsTask,omitempty"`
	// localContainerTagsIndex is the index of the tags associated with the container that this connection was collected from.
	// Meant to be used with CollectorConnections#encodedTags.
	// Handled the built-in race for resolution of container tags in the backend.
	LocalContainerTagsIndex int32 `protobuf:"varint,54,opt,name=localContainerTagsIndex,proto3" json:"localContainerTagsIndex,omitempty"`
}

func (m *Connection) Reset()         { *m = Connection{} }
func (m *Connection) String() string { return proto.CompactTextString(m) }
func (*Connection) ProtoMessage()    {}
func (*Connection) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{2}
}
func (m *Connection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Connection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Connection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Connection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connection.Merge(m, src)
}
func (m *Connection) XXX_Size() int {
	return m.Size()
}
func (m *Connection) XXX_DiscardUnknown() {
	xxx_messageInfo_Connection.DiscardUnknown(m)
}

var xxx_messageInfo_Connection proto.InternalMessageInfo

func (m *Connection) GetPid() int32 {
	if m != nil {
		return m.Pid
	}
	return 0
}

func (m *Connection) GetLaddr() *Addr {
	if m != nil {
		return m.Laddr
	}
	return nil
}

func (m *Connection) GetRaddr() *Addr {
	if m != nil {
		return m.Raddr
	}
	return nil
}

func (m *Connection) GetFamily() ConnectionFamily {
	if m != nil {
		return m.Family
	}
	return ConnectionFamily_v4
}

func (m *Connection) GetType() ConnectionType {
	if m != nil {
		return m.Type
	}
	return ConnectionType_tcp
}

func (m *Connection) GetIsLocalPortEphemeral() EphemeralPortState {
	if m != nil {
		return m.IsLocalPortEphemeral
	}
	return EphemeralPortState_ephemeralUnspecified
}

func (m *Connection) GetLastBytesSent() uint64 {
	if m != nil {
		return m.LastBytesSent
	}
	return 0
}

func (m *Connection) GetLastBytesReceived() uint64 {
	if m != nil {
		return m.LastBytesReceived
	}
	return 0
}

func (m *Connection) GetLastRetransmits() uint32 {
	if m != nil {
		return m.LastRetransmits
	}
	return 0
}

func (m *Connection) GetDirection() ConnectionDirection {
	if m != nil {
		return m.Direction
	}
	return ConnectionDirection_unspecified
}

func (m *Connection) GetLastPacketsSent() uint64 {
	if m != nil {
		return m.LastPacketsSent
	}
	return 0
}

func (m *Connection) GetLastPacketsReceived() uint64 {
	if m != nil {
		return m.LastPacketsReceived
	}
	return 0
}

func (m *Connection) GetProtocol() *ProtocolStack {
	if m != nil {
		return m.Protocol
	}
	return nil
}

func (m *Connection) GetNetNS() uint32 {
	if m != nil {
		return m.NetNS
	}
	return 0
}

func (m *Connection) GetRemoteNetworkId() string {
	if m != nil {
		return m.RemoteNetworkId
	}
	return ""
}

func (m *Connection) GetIpTranslation() *IPTranslation {
	if m != nil {
		return m.IpTranslation
	}
	return nil
}

func (m *Connection) GetRtt() uint32 {
	if m != nil {
		return m.Rtt
	}
	return 0
}

func (m *Connection) GetRttVar() uint32 {
	if m != nil {
		return m.RttVar
	}
	return 0
}

func (m *Connection) GetIntraHost() bool {
	if m != nil {
		return m.IntraHost
	}
	return false
}

func (m *Connection) GetDnsSuccessfulResponses() uint32 {
	if m != nil {
		return m.DnsSuccessfulResponses
	}
	return 0
}

func (m *Connection) GetDnsFailedResponses() uint32 {
	if m != nil {
		return m.DnsFailedResponses
	}
	return 0
}

func (m *Connection) GetDnsTimeouts() uint32 {
	if m != nil {
		return m.DnsTimeouts
	}
	return 0
}

func (m *Connection) GetDnsSuccessLatencySum() uint64 {
	if m != nil {
		return m.DnsSuccessLatencySum
	}
	return 0
}

func (m *Connection) GetDnsFailureLatencySum() uint64 {
	if m != nil {
		return m.DnsFailureLatencySum
	}
	return 0
}

func (m *Connection) GetDnsCountByRcode() map[uint32]uint32 {
	if m != nil {
		return m.DnsCountByRcode
	}
	return nil
}

func (m *Connection) GetLastTcpEstablished() uint32 {
	if m != nil {
		return m.LastTcpEstablished
	}
	return 0
}

func (m *Connection) GetLastTcpClosed() uint32 {
	if m != nil {
		return m.LastTcpClosed
	}
	return 0
}

func (m *Connection) GetDnsStatsByDomain() map[int32]*DNSStats {
	if m != nil {
		return m.DnsStatsByDomain
	}
	return nil
}

func (m *Connection) GetDnsStatsByDomainByQueryType() map[int32]*DNSStatsByQueryType {
	if m != nil {
		return m.DnsStatsByDomainByQueryType
	}
	return nil
}

func (m *Connection) GetDnsStatsByDomainOffsetByQueryType() map[int32]*DNSStatsByQueryType {
	if m != nil {
		return m.DnsStatsByDomainOffsetByQueryType
	}
	return nil
}

func (m *Connection) GetRouteIdx() int32 {
	if m != nil {
		return m.RouteIdx
	}
	return 0
}

func (m *Connection) GetRouteTargetIdx() int32 {
	if m != nil {
		return m.RouteTargetIdx
	}
	return 0
}

func (m *Connection) GetHttpAggregations() []byte {
	if m != nil {
		return m.HttpAggregations
	}
	return nil
}

func (m *Connection) GetTags() []uint32 {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Connection) GetTagsIdx() int32 {
	if m != nil {
		return m.TagsIdx
	}
	return 0
}

func (m *Connection) GetTagsChecksum() uint32 {
	if m != nil {
		return m.TagsChecksum
	}
	return 0
}

func (m *Connection) GetStateIndex() uint32 {
	if m != nil {
		return m.StateIndex
	}
	return 0
}

func (m *Connection) GetDataStreamsAggregations() []byte {
	if m != nil {
		return m.DataStreamsAggregations
	}
	return nil
}

func (m *Connection) GetHttp2Aggregations() []byte {
	if m != nil {
		return m.Http2Aggregations
	}
	return nil
}

func (m *Connection) GetDatabaseAggregations() []byte {
	if m != nil {
		return m.DatabaseAggregations
	}
	return nil
}

func (m *Connection) GetTcpFailuresByErrCode() map[uint32]uint32 {
	if m != nil {
		return m.TcpFailuresByErrCode
	}
	return nil
}

func (m *Connection) GetRemoteEcsTask() string {
	if m != nil {
		return m.RemoteEcsTask
	}
	return ""
}

func (m *Connection) GetLocalContainerTagsIndex() int32 {
	if m != nil {
		return m.LocalContainerTagsIndex
	}
	return 0
}

// ResourceMetadata only holds enough information to identify a resource in connection data
type ResourceMetadata struct {
	Id      string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	ByteKey []byte `protobuf:"bytes,3,opt,name=byteKey,proto3" json:"byteKey,omitempty"`
	// backend use only, associates tags with a given ResourceMetadata.
	// when this type is serialized, always use tagIndex to point to an entry
	// in encodedTags.
	Tags []string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
	// points to an index in CollectorConnections#encodedTags. Use the helpers defined in process/connections.go to access
	// the tags associated with this resource metadata.
	// `CollectorConnections#GetTags`, `CollectorConnections#UnsafeIterateTags',
	// `CollectorConnections#IterateResourceTags`, `CollectorConnections#GetResourceTags`
	TagIndex int32 `protobuf:"varint,5,opt,name=tagIndex,proto3" json:"tagIndex,omitempty"`
	// if set this is a unix timestamp of the last time the tags for a given resource changed.
	// if tags have been decoded for a given (byteKey, tagsModified) tuple, that set of tags will not change.
	TagsModified int64 `protobuf:"varint,6,opt,name=tagsModified,proto3" json:"tagsModified,omitempty"`
}

func (m *ResourceMetadata) Reset()         { *m = ResourceMetadata{} }
func (m *ResourceMetadata) String() string { return proto.CompactTextString(m) }
func (*ResourceMetadata) ProtoMessage()    {}
func (*ResourceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{3}
}
func (m *ResourceMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceMetadata.Merge(m, src)
}
func (m *ResourceMetadata) XXX_Size() int {
	return m.Size()
}
func (m *ResourceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceMetadata proto.InternalMessageInfo

func (m *ResourceMetadata) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ResourceMetadata) GetByteKey() []byte {
	if m != nil {
		return m.ByteKey
	}
	return nil
}

func (m *ResourceMetadata) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ResourceMetadata) GetTagIndex() int32 {
	if m != nil {
		return m.TagIndex
	}
	return 0
}

func (m *ResourceMetadata) GetTagsModified() int64 {
	if m != nil {
		return m.TagsModified
	}
	return 0
}

type ConnectionsTelemetry struct {
	MonotonicKprobesTriggered          int64 `protobuf:"varint,1,opt,name=monotonicKprobesTriggered,proto3" json:"monotonicKprobesTriggered,omitempty"`
	MonotonicKprobesMissed             int64 `protobuf:"varint,2,opt,name=monotonicKprobesMissed,proto3" json:"monotonicKprobesMissed,omitempty"`
	MonotonicConntrackRegisters        int64 `protobuf:"varint,3,opt,name=monotonicConntrackRegisters,proto3" json:"monotonicConntrackRegisters,omitempty"`
	MonotonicConntrackRegistersDropped int64 `protobuf:"varint,4,opt,name=monotonicConntrackRegistersDropped,proto3" json:"monotonicConntrackRegistersDropped,omitempty"`
	MonotonicDnsPacketsProcessed       int64 `protobuf:"varint,5,opt,name=monotonicDnsPacketsProcessed,proto3" json:"monotonicDnsPacketsProcessed,omitempty"`
	MonotonicConnsClosed               int64 `protobuf:"varint,6,opt,name=monotonicConnsClosed,proto3" json:"monotonicConnsClosed,omitempty"`
	ConnsBpfMapSize                    int64 `protobuf:"varint,7,opt,name=connsBpfMapSize,proto3" json:"connsBpfMapSize,omitempty"`
	MonotonicUdpSendsProcessed         int64 `protobuf:"varint,8,opt,name=monotonicUdpSendsProcessed,proto3" json:"monotonicUdpSendsProcessed,omitempty"`
	MonotonicUdpSendsMissed            int64 `protobuf:"varint,9,opt,name=monotonicUdpSendsMissed,proto3" json:"monotonicUdpSendsMissed,omitempty"`
	ConntrackSamplingPercent           int64 `protobuf:"varint,10,opt,name=conntrackSamplingPercent,proto3" json:"conntrackSamplingPercent,omitempty"`
	DnsStatsDropped                    int64 `protobuf:"varint,11,opt,name=dnsStatsDropped,proto3" json:"dnsStatsDropped,omitempty"`
}

func (m *ConnectionsTelemetry) Reset()         { *m = ConnectionsTelemetry{} }
func (m *ConnectionsTelemetry) String() string { return proto.CompactTextString(m) }
func (*ConnectionsTelemetry) ProtoMessage()    {}
func (*ConnectionsTelemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{4}
}
func (m *ConnectionsTelemetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectionsTelemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectionsTelemetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectionsTelemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectionsTelemetry.Merge(m, src)
}
func (m *ConnectionsTelemetry) XXX_Size() int {
	return m.Size()
}
func (m *ConnectionsTelemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectionsTelemetry.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectionsTelemetry proto.InternalMessageInfo

func (m *ConnectionsTelemetry) GetMonotonicKprobesTriggered() int64 {
	if m != nil {
		return m.MonotonicKprobesTriggered
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicKprobesMissed() int64 {
	if m != nil {
		return m.MonotonicKprobesMissed
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicConntrackRegisters() int64 {
	if m != nil {
		return m.MonotonicConntrackRegisters
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicConntrackRegistersDropped() int64 {
	if m != nil {
		return m.MonotonicConntrackRegistersDropped
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicDnsPacketsProcessed() int64 {
	if m != nil {
		return m.MonotonicDnsPacketsProcessed
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicConnsClosed() int64 {
	if m != nil {
		return m.MonotonicConnsClosed
	}
	return 0
}

func (m *ConnectionsTelemetry) GetConnsBpfMapSize() int64 {
	if m != nil {
		return m.ConnsBpfMapSize
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicUdpSendsProcessed() int64 {
	if m != nil {
		return m.MonotonicUdpSendsProcessed
	}
	return 0
}

func (m *ConnectionsTelemetry) GetMonotonicUdpSendsMissed() int64 {
	if m != nil {
		return m.MonotonicUdpSendsMissed
	}
	return 0
}

func (m *ConnectionsTelemetry) GetConntrackSamplingPercent() int64 {
	if m != nil {
		return m.ConntrackSamplingPercent
	}
	return 0
}

func (m *ConnectionsTelemetry) GetDnsStatsDropped() int64 {
	if m != nil {
		return m.DnsStatsDropped
	}
	return 0
}

type CollectorConnectionsTelemetry struct {
	KprobesTriggered          int64 `protobuf:"varint,1,opt,name=kprobesTriggered,proto3" json:"kprobesTriggered,omitempty"`
	KprobesMissed             int64 `protobuf:"varint,2,opt,name=kprobesMissed,proto3" json:"kprobesMissed,omitempty"`
	ConntrackRegisters        int64 `protobuf:"varint,3,opt,name=conntrackRegisters,proto3" json:"conntrackRegisters,omitempty"`
	ConntrackRegistersDropped int64 `protobuf:"varint,4,opt,name=conntrackRegistersDropped,proto3" json:"conntrackRegistersDropped,omitempty"`
	DnsPacketsProcessed       int64 `protobuf:"varint,5,opt,name=dnsPacketsProcessed,proto3" json:"dnsPacketsProcessed,omitempty"`
	ConnsClosed               int64 `protobuf:"varint,6,opt,name=connsClosed,proto3" json:"connsClosed,omitempty"`
	ConnsBpfMapSize           int64 `protobuf:"varint,7,opt,name=connsBpfMapSize,proto3" json:"connsBpfMapSize,omitempty"`
	UdpSendsProcessed         int64 `protobuf:"varint,8,opt,name=udpSendsProcessed,proto3" json:"udpSendsProcessed,omitempty"`
	UdpSendsMissed            int64 `protobuf:"varint,9,opt,name=udpSendsMissed,proto3" json:"udpSendsMissed,omitempty"`
	ConntrackSamplingPercent  int64 `protobuf:"varint,10,opt,name=conntrackSamplingPercent,proto3" json:"conntrackSamplingPercent,omitempty"`
	DnsStatsDropped           int64 `protobuf:"varint,11,opt,name=dnsStatsDropped,proto3" json:"dnsStatsDropped,omitempty"`
}

func (m *CollectorConnectionsTelemetry) Reset()         { *m = CollectorConnectionsTelemetry{} }
func (m *CollectorConnectionsTelemetry) String() string { return proto.CompactTextString(m) }
func (*CollectorConnectionsTelemetry) ProtoMessage()    {}
func (*CollectorConnectionsTelemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{5}
}
func (m *CollectorConnectionsTelemetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorConnectionsTelemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorConnectionsTelemetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorConnectionsTelemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorConnectionsTelemetry.Merge(m, src)
}
func (m *CollectorConnectionsTelemetry) XXX_Size() int {
	return m.Size()
}
func (m *CollectorConnectionsTelemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorConnectionsTelemetry.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorConnectionsTelemetry proto.InternalMessageInfo

func (m *CollectorConnectionsTelemetry) GetKprobesTriggered() int64 {
	if m != nil {
		return m.KprobesTriggered
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetKprobesMissed() int64 {
	if m != nil {
		return m.KprobesMissed
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetConntrackRegisters() int64 {
	if m != nil {
		return m.ConntrackRegisters
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetConntrackRegistersDropped() int64 {
	if m != nil {
		return m.ConntrackRegistersDropped
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetDnsPacketsProcessed() int64 {
	if m != nil {
		return m.DnsPacketsProcessed
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetConnsClosed() int64 {
	if m != nil {
		return m.ConnsClosed
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetConnsBpfMapSize() int64 {
	if m != nil {
		return m.ConnsBpfMapSize
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetUdpSendsProcessed() int64 {
	if m != nil {
		return m.UdpSendsProcessed
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetUdpSendsMissed() int64 {
	if m != nil {
		return m.UdpSendsMissed
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetConntrackSamplingPercent() int64 {
	if m != nil {
		return m.ConntrackSamplingPercent
	}
	return 0
}

func (m *CollectorConnectionsTelemetry) GetDnsStatsDropped() int64 {
	if m != nil {
		return m.DnsStatsDropped
	}
	return 0
}

type RuntimeCompilationTelemetry struct {
	RuntimeCompilationEnabled  bool                     `protobuf:"varint,1,opt,name=runtimeCompilationEnabled,proto3" json:"runtimeCompilationEnabled,omitempty"`
	RuntimeCompilationResult   RuntimeCompilationResult `protobuf:"varint,2,opt,name=runtimeCompilationResult,proto3,enum=datadog.process_agent.RuntimeCompilationResult" json:"runtimeCompilationResult,omitempty"`
	RuntimeCompilationDuration int64                    `protobuf:"varint,3,opt,name=runtimeCompilationDuration,proto3" json:"runtimeCompilationDuration,omitempty"`
	// Field below was deprecated in agent 7.41
	KernelHeaderFetchResult KernelHeaderFetchResult `protobuf:"varint,4,opt,name=kernelHeaderFetchResult,proto3,enum=datadog.process_agent.KernelHeaderFetchResult" json:"kernelHeaderFetchResult,omitempty"`
}

func (m *RuntimeCompilationTelemetry) Reset()         { *m = RuntimeCompilationTelemetry{} }
func (m *RuntimeCompilationTelemetry) String() string { return proto.CompactTextString(m) }
func (*RuntimeCompilationTelemetry) ProtoMessage()    {}
func (*RuntimeCompilationTelemetry) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{6}
}
func (m *RuntimeCompilationTelemetry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RuntimeCompilationTelemetry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RuntimeCompilationTelemetry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RuntimeCompilationTelemetry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeCompilationTelemetry.Merge(m, src)
}
func (m *RuntimeCompilationTelemetry) XXX_Size() int {
	return m.Size()
}
func (m *RuntimeCompilationTelemetry) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeCompilationTelemetry.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeCompilationTelemetry proto.InternalMessageInfo

func (m *RuntimeCompilationTelemetry) GetRuntimeCompilationEnabled() bool {
	if m != nil {
		return m.RuntimeCompilationEnabled
	}
	return false
}

func (m *RuntimeCompilationTelemetry) GetRuntimeCompilationResult() RuntimeCompilationResult {
	if m != nil {
		return m.RuntimeCompilationResult
	}
	return RuntimeCompilationResult_NotAttempted
}

func (m *RuntimeCompilationTelemetry) GetRuntimeCompilationDuration() int64 {
	if m != nil {
		return m.RuntimeCompilationDuration
	}
	return 0
}

func (m *RuntimeCompilationTelemetry) GetKernelHeaderFetchResult() KernelHeaderFetchResult {
	if m != nil {
		return m.KernelHeaderFetchResult
	}
	return KernelHeaderFetchResult_FetchNotAttempted
}

type AgentConfiguration struct {
	NpmEnabled bool `protobuf:"varint,1,opt,name=npmEnabled,proto3" json:"npmEnabled,omitempty"`
	UsmEnabled bool `protobuf:"varint,2,opt,name=usmEnabled,proto3" json:"usmEnabled,omitempty"`
	DsmEnabled bool `protobuf:"varint,3,opt,name=dsmEnabled,proto3" json:"dsmEnabled,omitempty"`
	CcmEnabled bool `protobuf:"varint,4,opt,name=ccmEnabled,proto3" json:"ccmEnabled,omitempty"`
	CsmEnabled bool `protobuf:"varint,5,opt,name=csmEnabled,proto3" json:"csmEnabled,omitempty"`
}

func (m *AgentConfiguration) Reset()         { *m = AgentConfiguration{} }
func (m *AgentConfiguration) String() string { return proto.CompactTextString(m) }
func (*AgentConfiguration) ProtoMessage()    {}
func (*AgentConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{7}
}
func (m *AgentConfiguration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AgentConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AgentConfiguration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AgentConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AgentConfiguration.Merge(m, src)
}
func (m *AgentConfiguration) XXX_Size() int {
	return m.Size()
}
func (m *AgentConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_AgentConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_AgentConfiguration proto.InternalMessageInfo

func (m *AgentConfiguration) GetNpmEnabled() bool {
	if m != nil {
		return m.NpmEnabled
	}
	return false
}

func (m *AgentConfiguration) GetUsmEnabled() bool {
	if m != nil {
		return m.UsmEnabled
	}
	return false
}

func (m *AgentConfiguration) GetDsmEnabled() bool {
	if m != nil {
		return m.DsmEnabled
	}
	return false
}

func (m *AgentConfiguration) GetCcmEnabled() bool {
	if m != nil {
		return m.CcmEnabled
	}
	return false
}

func (m *AgentConfiguration) GetCsmEnabled() bool {
	if m != nil {
		return m.CsmEnabled
	}
	return false
}

// Route refers to a route out of a host (think `ip route get`).
// this is used primarily in AWS where we discover the subnet a
// that a connection was associated with
type Route struct {
	Subnet    *Subnet    `protobuf:"bytes,1,opt,name=subnet,proto3" json:"subnet,omitempty"`
	Interface *Interface `protobuf:"bytes,2,opt,name=interface,proto3" json:"interface,omitempty"`
}

func (m *Route) Reset()         { *m = Route{} }
func (m *Route) String() string { return proto.CompactTextString(m) }
func (*Route) ProtoMessage()    {}
func (*Route) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{8}
}
func (m *Route) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Route) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Route.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Route) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Route.Merge(m, src)
}
func (m *Route) XXX_Size() int {
	return m.Size()
}
func (m *Route) XXX_DiscardUnknown() {
	xxx_messageInfo_Route.DiscardUnknown(m)
}

var xxx_messageInfo_Route proto.InternalMessageInfo

func (m *Route) GetSubnet() *Subnet {
	if m != nil {
		return m.Subnet
	}
	return nil
}

func (m *Route) GetInterface() *Interface {
	if m != nil {
		return m.Interface
	}
	return nil
}

type Interface struct {
	HardwareAddr string `protobuf:"bytes,1,opt,name=HardwareAddr,proto3" json:"HardwareAddr,omitempty"`
}

func (m *Interface) Reset()         { *m = Interface{} }
func (m *Interface) String() string { return proto.CompactTextString(m) }
func (*Interface) ProtoMessage()    {}
func (*Interface) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{9}
}
func (m *Interface) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Interface) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Interface.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Interface) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Interface.Merge(m, src)
}
func (m *Interface) XXX_Size() int {
	return m.Size()
}
func (m *Interface) XXX_DiscardUnknown() {
	xxx_messageInfo_Interface.DiscardUnknown(m)
}

var xxx_messageInfo_Interface proto.InternalMessageInfo

func (m *Interface) GetHardwareAddr() string {
	if m != nil {
		return m.HardwareAddr
	}
	return ""
}

type Subnet struct {
	Alias string `protobuf:"bytes,1,opt,name=alias,proto3" json:"alias,omitempty"`
}

func (m *Subnet) Reset()         { *m = Subnet{} }
func (m *Subnet) String() string { return proto.CompactTextString(m) }
func (*Subnet) ProtoMessage()    {}
func (*Subnet) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{10}
}
func (m *Subnet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Subnet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Subnet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Subnet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subnet.Merge(m, src)
}
func (m *Subnet) XXX_Size() int {
	return m.Size()
}
func (m *Subnet) XXX_DiscardUnknown() {
	xxx_messageInfo_Subnet.DiscardUnknown(m)
}

var xxx_messageInfo_Subnet proto.InternalMessageInfo

func (m *Subnet) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

// RouteMetadata
type RouteMetadata struct {
	Alias string `protobuf:"bytes,1,opt,name=alias,proto3" json:"alias,omitempty"`
	// the tags for the inferred route target (see Connection#routeTargetIdx)
	// whenever this type is encoded on the wire, use tagsIndex and tagsModified -- not tags.
	TagIndex     int32    `protobuf:"varint,2,opt,name=tagIndex,proto3" json:"tagIndex,omitempty"`
	TagsModified int64    `protobuf:"varint,3,opt,name=tagsModified,proto3" json:"tagsModified,omitempty"`
	Tags         []string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *RouteMetadata) Reset()         { *m = RouteMetadata{} }
func (m *RouteMetadata) String() string { return proto.CompactTextString(m) }
func (*RouteMetadata) ProtoMessage()    {}
func (*RouteMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{11}
}
func (m *RouteMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RouteMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RouteMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteMetadata.Merge(m, src)
}
func (m *RouteMetadata) XXX_Size() int {
	return m.Size()
}
func (m *RouteMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RouteMetadata proto.InternalMessageInfo

func (m *RouteMetadata) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *RouteMetadata) GetTagIndex() int32 {
	if m != nil {
		return m.TagIndex
	}
	return 0
}

func (m *RouteMetadata) GetTagsModified() int64 {
	if m != nil {
		return m.TagsModified
	}
	return 0
}

func (m *RouteMetadata) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type IPTranslation struct {
	ReplSrcIP   string `protobuf:"bytes,1,opt,name=replSrcIP,proto3" json:"replSrcIP,omitempty"`
	ReplDstIP   string `protobuf:"bytes,2,opt,name=replDstIP,proto3" json:"replDstIP,omitempty"`
	ReplSrcPort int32  `protobuf:"varint,3,opt,name=replSrcPort,proto3" json:"replSrcPort,omitempty"`
	ReplDstPort int32  `protobuf:"varint,4,opt,name=replDstPort,proto3" json:"replDstPort,omitempty"`
}

func (m *IPTranslation) Reset()         { *m = IPTranslation{} }
func (m *IPTranslation) String() string { return proto.CompactTextString(m) }
func (*IPTranslation) ProtoMessage()    {}
func (*IPTranslation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{12}
}
func (m *IPTranslation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPTranslation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPTranslation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPTranslation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPTranslation.Merge(m, src)
}
func (m *IPTranslation) XXX_Size() int {
	return m.Size()
}
func (m *IPTranslation) XXX_DiscardUnknown() {
	xxx_messageInfo_IPTranslation.DiscardUnknown(m)
}

var xxx_messageInfo_IPTranslation proto.InternalMessageInfo

func (m *IPTranslation) GetReplSrcIP() string {
	if m != nil {
		return m.ReplSrcIP
	}
	return ""
}

func (m *IPTranslation) GetReplDstIP() string {
	if m != nil {
		return m.ReplDstIP
	}
	return ""
}

func (m *IPTranslation) GetReplSrcPort() int32 {
	if m != nil {
		return m.ReplSrcPort
	}
	return 0
}

func (m *IPTranslation) GetReplDstPort() int32 {
	if m != nil {
		return m.ReplDstPort
	}
	return 0
}

type Addr struct {
	Ip   string `protobuf:"bytes,2,opt,name=ip,proto3" json:"ip,omitempty"`
	Port int32  `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// the containerID associated with the addr. This value can be used to look up a value in
	// CollectorConnections#resolvedResources.
	//
	// Despite the name, this can be either a containerID or a cloud loadbalancer.
	//
	// this will usually be added during resolution, but if the container is on the same host
	// where the connection was collected this will be set by the agent
	ContainerId string `protobuf:"bytes,5,opt,name=containerId,proto3" json:"containerId,omitempty"`
	// the host associated with the addr. This value can be used to look up a value in
	// CollectorConnections#resolvedHostsByName.
	HostName string `protobuf:"bytes,7,opt,name=hostName,proto3" json:"hostName,omitempty"`
}

func (m *Addr) Reset()         { *m = Addr{} }
func (m *Addr) String() string { return proto.CompactTextString(m) }
func (*Addr) ProtoMessage()    {}
func (*Addr) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{13}
}
func (m *Addr) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Addr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Addr.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Addr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Addr.Merge(m, src)
}
func (m *Addr) XXX_Size() int {
	return m.Size()
}
func (m *Addr) XXX_DiscardUnknown() {
	xxx_messageInfo_Addr.DiscardUnknown(m)
}

var xxx_messageInfo_Addr proto.InternalMessageInfo

func (m *Addr) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *Addr) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Addr) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *Addr) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

type ProtocolStack struct {
	Stack []ProtocolType `protobuf:"varint,1,rep,name=stack,proto3,enum=datadog.process_agent.ProtocolType" json:"stack,omitempty"`
}

func (m *ProtocolStack) Reset()         { *m = ProtocolStack{} }
func (m *ProtocolStack) String() string { return proto.CompactTextString(m) }
func (*ProtocolStack) ProtoMessage()    {}
func (*ProtocolStack) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{14}
}
func (m *ProtocolStack) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProtocolStack) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProtocolStack.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProtocolStack) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProtocolStack.Merge(m, src)
}
func (m *ProtocolStack) XXX_Size() int {
	return m.Size()
}
func (m *ProtocolStack) XXX_DiscardUnknown() {
	xxx_messageInfo_ProtocolStack.DiscardUnknown(m)
}

var xxx_messageInfo_ProtocolStack proto.InternalMessageInfo

func (m *ProtocolStack) GetStack() []ProtocolType {
	if m != nil {
		return m.Stack
	}
	return nil
}

type DNSEntry struct {
	Names []string `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
}

func (m *DNSEntry) Reset()         { *m = DNSEntry{} }
func (m *DNSEntry) String() string { return proto.CompactTextString(m) }
func (*DNSEntry) ProtoMessage()    {}
func (*DNSEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{15}
}
func (m *DNSEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DNSEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DNSEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DNSEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DNSEntry.Merge(m, src)
}
func (m *DNSEntry) XXX_Size() int {
	return m.Size()
}
func (m *DNSEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_DNSEntry.DiscardUnknown(m)
}

var xxx_messageInfo_DNSEntry proto.InternalMessageInfo

func (m *DNSEntry) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

type DNSStats struct {
	DnsTimeouts          uint32            `protobuf:"varint,1,opt,name=dnsTimeouts,proto3" json:"dnsTimeouts,omitempty"`
	DnsSuccessLatencySum uint64            `protobuf:"varint,2,opt,name=dnsSuccessLatencySum,proto3" json:"dnsSuccessLatencySum,omitempty"`
	DnsFailureLatencySum uint64            `protobuf:"varint,3,opt,name=dnsFailureLatencySum,proto3" json:"dnsFailureLatencySum,omitempty"`
	DnsCountByRcode      map[uint32]uint32 `protobuf:"bytes,4,rep,name=dnsCountByRcode,proto3" json:"dnsCountByRcode,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (m *DNSStats) Reset()         { *m = DNSStats{} }
func (m *DNSStats) String() string { return proto.CompactTextString(m) }
func (*DNSStats) ProtoMessage()    {}
func (*DNSStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{16}
}
func (m *DNSStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DNSStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DNSStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DNSStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DNSStats.Merge(m, src)
}
func (m *DNSStats) XXX_Size() int {
	return m.Size()
}
func (m *DNSStats) XXX_DiscardUnknown() {
	xxx_messageInfo_DNSStats.DiscardUnknown(m)
}

var xxx_messageInfo_DNSStats proto.InternalMessageInfo

func (m *DNSStats) GetDnsTimeouts() uint32 {
	if m != nil {
		return m.DnsTimeouts
	}
	return 0
}

func (m *DNSStats) GetDnsSuccessLatencySum() uint64 {
	if m != nil {
		return m.DnsSuccessLatencySum
	}
	return 0
}

func (m *DNSStats) GetDnsFailureLatencySum() uint64 {
	if m != nil {
		return m.DnsFailureLatencySum
	}
	return 0
}

func (m *DNSStats) GetDnsCountByRcode() map[uint32]uint32 {
	if m != nil {
		return m.DnsCountByRcode
	}
	return nil
}

type DNSStatsByQueryType struct {
	DnsStatsByQueryType map[int32]*DNSStats `protobuf:"bytes,1,rep,name=dnsStatsByQueryType,proto3" json:"dnsStatsByQueryType,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *DNSStatsByQueryType) Reset()         { *m = DNSStatsByQueryType{} }
func (m *DNSStatsByQueryType) String() string { return proto.CompactTextString(m) }
func (*DNSStatsByQueryType) ProtoMessage()    {}
func (*DNSStatsByQueryType) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{17}
}
func (m *DNSStatsByQueryType) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DNSStatsByQueryType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DNSStatsByQueryType.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DNSStatsByQueryType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DNSStatsByQueryType.Merge(m, src)
}
func (m *DNSStatsByQueryType) XXX_Size() int {
	return m.Size()
}
func (m *DNSStatsByQueryType) XXX_DiscardUnknown() {
	xxx_messageInfo_DNSStatsByQueryType.DiscardUnknown(m)
}

var xxx_messageInfo_DNSStatsByQueryType proto.InternalMessageInfo

func (m *DNSStatsByQueryType) GetDnsStatsByQueryType() map[int32]*DNSStats {
	if m != nil {
		return m.DnsStatsByQueryType
	}
	return nil
}

type PublicIpMetadata struct {
	Ip            string   `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	CloudProvider string   `protobuf:"bytes,2,opt,name=cloudProvider,proto3" json:"cloudProvider,omitempty"`
	Region        string   `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	Tags          []string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (m *PublicIpMetadata) Reset()         { *m = PublicIpMetadata{} }
func (m *PublicIpMetadata) String() string { return proto.CompactTextString(m) }
func (*PublicIpMetadata) ProtoMessage()    {}
func (*PublicIpMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8f660660e88b5927, []int{18}
}
func (m *PublicIpMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PublicIpMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PublicIpMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PublicIpMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublicIpMetadata.Merge(m, src)
}
func (m *PublicIpMetadata) XXX_Size() int {
	return m.Size()
}
func (m *PublicIpMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_PublicIpMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_PublicIpMetadata proto.InternalMessageInfo

func (m *PublicIpMetadata) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *PublicIpMetadata) GetCloudProvider() string {
	if m != nil {
		return m.CloudProvider
	}
	return ""
}

func (m *PublicIpMetadata) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *PublicIpMetadata) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func init() {
	proto.RegisterEnum("datadog.process_agent.RuntimeCompilationResult", RuntimeCompilationResult_name, RuntimeCompilationResult_value)
	proto.RegisterEnum("datadog.process_agent.KernelHeaderFetchResult", KernelHeaderFetchResult_name, KernelHeaderFetchResult_value)
	proto.RegisterEnum("datadog.process_agent.COREResult", COREResult_name, COREResult_value)
	proto.RegisterEnum("datadog.process_agent.ConnectionFamily", ConnectionFamily_name, ConnectionFamily_value)
	proto.RegisterEnum("datadog.process_agent.ConnectionDirection", ConnectionDirection_name, ConnectionDirection_value)
	proto.RegisterEnum("datadog.process_agent.EphemeralPortState", EphemeralPortState_name, EphemeralPortState_value)
	proto.RegisterEnum("datadog.process_agent.ProtocolType", ProtocolType_name, ProtocolType_value)
	proto.RegisterType((*CollectorConnections)(nil), "datadog.process_agent.CollectorConnections")
	proto.RegisterMapType((map[string]COREResult)(nil), "datadog.process_agent.CollectorConnections.CORETelemetryByAssetEntry")
	proto.RegisterMapType((map[string]*RuntimeCompilationTelemetry)(nil), "datadog.process_agent.CollectorConnections.CompilationTelemetryByAssetEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.CollectorConnections.ConnTelemetryMapEntry")
	proto.RegisterMapType((map[int32]string)(nil), "datadog.process_agent.CollectorConnections.ContainerForPidEntry")
	proto.RegisterMapType((map[string]*Host)(nil), "datadog.process_agent.CollectorConnections.ResolvedHostsByNameEntry")
	proto.RegisterMapType((map[string]*PublicIpMetadata)(nil), "datadog.process_agent.CollectorConnections.ResolvedPublicIpsEntry")
	proto.RegisterMapType((map[string]*ResourceMetadata)(nil), "datadog.process_agent.CollectorConnections.ResolvedResourcesEntry")
	proto.RegisterType((*Connections)(nil), "datadog.process_agent.Connections")
	proto.RegisterMapType((map[string]COREResult)(nil), "datadog.process_agent.Connections.CORETelemetryByAssetEntry")
	proto.RegisterMapType((map[string]*RuntimeCompilationTelemetry)(nil), "datadog.process_agent.Connections.CompilationTelemetryByAssetEntry")
	proto.RegisterMapType((map[string]int64)(nil), "datadog.process_agent.Connections.ConnTelemetryMapEntry")
	proto.RegisterMapType((map[string]*DNSEntry)(nil), "datadog.process_agent.Connections.DnsEntry")
	proto.RegisterType((*Connection)(nil), "datadog.process_agent.Connection")
	proto.RegisterMapType((map[uint32]uint32)(nil), "datadog.process_agent.Connection.DnsCountByRcodeEntry")
	proto.RegisterMapType((map[int32]*DNSStatsByQueryType)(nil), "datadog.process_agent.Connection.DnsStatsByDomainByQueryTypeEntry")
	proto.RegisterMapType((map[int32]*DNSStats)(nil), "datadog.process_agent.Connection.DnsStatsByDomainEntry")
	proto.RegisterMapType((map[int32]*DNSStatsByQueryType)(nil), "datadog.process_agent.Connection.DnsStatsByDomainOffsetByQueryTypeEntry")
	proto.RegisterMapType((map[uint32]uint32)(nil), "datadog.process_agent.Connection.TcpFailuresByErrCodeEntry")
	proto.RegisterType((*ResourceMetadata)(nil), "datadog.process_agent.ResourceMetadata")
	proto.RegisterType((*ConnectionsTelemetry)(nil), "datadog.process_agent.ConnectionsTelemetry")
	proto.RegisterType((*CollectorConnectionsTelemetry)(nil), "datadog.process_agent.CollectorConnectionsTelemetry")
	proto.RegisterType((*RuntimeCompilationTelemetry)(nil), "datadog.process_agent.RuntimeCompilationTelemetry")
	proto.RegisterType((*AgentConfiguration)(nil), "datadog.process_agent.AgentConfiguration")
	proto.RegisterType((*Route)(nil), "datadog.process_agent.Route")
	proto.RegisterType((*Interface)(nil), "datadog.process_agent.Interface")
	proto.RegisterType((*Subnet)(nil), "datadog.process_agent.Subnet")
	proto.RegisterType((*RouteMetadata)(nil), "datadog.process_agent.RouteMetadata")
	proto.RegisterType((*IPTranslation)(nil), "datadog.process_agent.IPTranslation")
	proto.RegisterType((*Addr)(nil), "datadog.process_agent.Addr")
	proto.RegisterType((*ProtocolStack)(nil), "datadog.process_agent.ProtocolStack")
	proto.RegisterType((*DNSEntry)(nil), "datadog.process_agent.DNSEntry")
	proto.RegisterType((*DNSStats)(nil), "datadog.process_agent.DNSStats")
	proto.RegisterMapType((map[uint32]uint32)(nil), "datadog.process_agent.DNSStats.DnsCountByRcodeEntry")
	proto.RegisterType((*DNSStatsByQueryType)(nil), "datadog.process_agent.DNSStatsByQueryType")
	proto.RegisterMapType((map[int32]*DNSStats)(nil), "datadog.process_agent.DNSStatsByQueryType.DnsStatsByQueryTypeEntry")
	proto.RegisterType((*PublicIpMetadata)(nil), "datadog.process_agent.PublicIpMetadata")
}

func init() { proto.RegisterFile("proto/process/connections.proto", fileDescriptor_8f660660e88b5927) }

var fileDescriptor_8f660660e88b5927 = []byte{
	// 3429 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xcd, 0x73, 0xdb, 0x48,
	0x76, 0x37, 0xf8, 0x21, 0x91, 0x8f, 0xa2, 0x04, 0xb5, 0x25, 0x19, 0x96, 0x3d, 0x32, 0xcd, 0xf1,
	0xce, 0x68, 0x35, 0x33, 0xf2, 0xae, 0xd6, 0xf6, 0x4c, 0x36, 0x3b, 0x1b, 0x8b, 0xa2, 0xb4, 0x92,
	0x6c, 0xcb, 0x34, 0x48, 0x7b, 0x2b, 0x5b, 0x95, 0x0f, 0x08, 0x68, 0x51, 0x58, 0x81, 0x68, 0x54,
	0x77, 0xc3, 0x5e, 0xce, 0x21, 0x95, 0x4a, 0x25, 0xd7, 0x24, 0x95, 0xc3, 0x56, 0xe5, 0xb6, 0xd7,
	0xdc, 0x53, 0xa9, 0xfc, 0x09, 0xb9, 0x65, 0x8f, 0x39, 0xa6, 0x66, 0x6e, 0x39, 0xa6, 0x2a, 0x87,
	0xdc, 0x52, 0xdd, 0x0d, 0x90, 0x00, 0x09, 0x88, 0x92, 0xe3, 0x6c, 0xe5, 0x24, 0xf6, 0xef, 0x7d,
	0x75, 0x3f, 0xbc, 0xee, 0xf7, 0xfa, 0xb5, 0xe0, 0x5e, 0x40, 0x09, 0x27, 0x0f, 0x03, 0x4a, 0x6c,
	0xcc, 0xd8, 0x43, 0x9b, 0xf8, 0x3e, 0xb6, 0xb9, 0x4b, 0x7c, 0xb6, 0x2d, 0x29, 0x68, 0xd5, 0xb1,
	0xb8, 0xe5, 0x90, 0xfe, 0x76, 0xc4, 0xf2, 0x27, 0x56, 0x1f, 0xfb, 0x7c, 0xfd, 0x76, 0x5a, 0x4e,
	0x82, 0x4a, 0xa2, 0xf9, 0x1f, 0xab, 0xb0, 0xb2, 0x47, 0x3c, 0x0f, 0xdb, 0x9c, 0xd0, 0xbd, 0xb1,
	0x42, 0xb4, 0x0e, 0x95, 0x73, 0xc2, 0xf8, 0x89, 0x35, 0xc0, 0x46, 0xa1, 0xa1, 0x6d, 0x56, 0xcd,
	0xd1, 0x18, 0xdd, 0x85, 0xaa, 0x8f, 0xf9, 0x3b, 0x42, 0x2f, 0x8e, 0x1c, 0x63, 0x41, 0x12, 0xc7,
	0x00, 0xda, 0x83, 0x5a, 0x62, 0x66, 0x46, 0xb1, 0x51, 0xdc, 0xac, 0xed, 0xdc, 0xdf, 0xce, 0x9c,
	0xda, 0xf6, 0xd8, 0xa4, 0x99, 0x94, 0x42, 0x06, 0xcc, 0xf7, 0x29, 0x09, 0x83, 0x23, 0xc7, 0x28,
	0x37, 0xb4, 0xcd, 0xb2, 0x19, 0x0f, 0x85, 0x71, 0xf9, 0xb3, 0xeb, 0x7e, 0x83, 0x8d, 0x39, 0x49,
	0x1b, 0x03, 0x28, 0x80, 0x65, 0x8a, 0x19, 0xf1, 0xde, 0x62, 0xc7, 0xc4, 0x8c, 0x84, 0xd4, 0xc6,
	0xcc, 0xa8, 0xc8, 0x29, 0xb4, 0x72, 0xa7, 0x30, 0xbd, 0xfc, 0x6d, 0x73, 0x52, 0xc9, 0xbe, 0xcf,
	0xe9, 0xd0, 0x9c, 0x56, 0x8e, 0x7e, 0x09, 0x4b, 0x36, 0xf1, 0xb9, 0xe5, 0xfa, 0x98, 0x1e, 0x10,
	0xda, 0x71, 0x1d, 0x03, 0xa4, 0xbd, 0xa7, 0xd7, 0xb1, 0xb7, 0x97, 0x56, 0xa1, 0xac, 0x4d, 0x2a,
	0x46, 0x0d, 0xa8, 0x61, 0xdf, 0x26, 0x0e, 0x76, 0x7a, 0x56, 0x9f, 0x19, 0xb5, 0x86, 0xb6, 0xb9,
	0x60, 0x26, 0x21, 0xf4, 0x04, 0xd6, 0xa2, 0x61, 0x42, 0xbb, 0x64, 0xfe, 0x44, 0x32, 0xe7, 0x50,
	0xd1, 0x1b, 0x58, 0x1e, 0x19, 0x3b, 0x24, 0x8c, 0xf7, 0x86, 0x01, 0x36, 0x96, 0x1a, 0xda, 0xe6,
	0xe2, 0xce, 0x66, 0xfe, 0xa7, 0x4b, 0xf3, 0x9b, 0xd3, 0x2a, 0xd0, 0x2f, 0xa0, 0x2e, 0x3e, 0x6b,
	0x0f, 0x7b, 0x78, 0x80, 0x39, 0x1d, 0x1a, 0x7a, 0x43, 0xdb, 0xac, 0xed, 0x3c, 0xba, 0x86, 0x6f,
	0x46, 0xb2, 0x66, 0x5a, 0x15, 0x1a, 0x80, 0x9e, 0x02, 0x5e, 0x58, 0x81, 0xf1, 0xa9, 0x74, 0xfd,
	0xee, 0x35, 0x5d, 0x9f, 0xd2, 0xa1, 0x7c, 0x3f, 0xa5, 0x1a, 0x35, 0x61, 0xc1, 0xa2, 0xf6, 0xb9,
	0xcb, 0xb1, 0xcd, 0x43, 0x8a, 0x8d, 0x65, 0x19, 0xf8, 0x29, 0x0c, 0x3d, 0x80, 0xfa, 0x05, 0xa6,
	0x3e, 0xf6, 0xde, 0x60, 0xca, 0x5c, 0xe2, 0x1b, 0x48, 0x32, 0xa5, 0x41, 0xb1, 0xb7, 0x02, 0xcf,
	0xe2, 0x67, 0x84, 0x0e, 0x8c, 0x9b, 0x6a, 0x6f, 0xc5, 0x63, 0xb4, 0x09, 0x4b, 0xf1, 0xef, 0x58,
	0xc7, 0x8a, 0x64, 0x99, 0x84, 0xd1, 0x5f, 0x6b, 0x70, 0xc7, 0x26, 0x83, 0xc0, 0xf5, 0x2c, 0xb1,
	0x90, 0xd1, 0x5c, 0x5b, 0xc3, 0x5d, 0xc6, 0x30, 0x37, 0x56, 0xa5, 0x2b, 0x9e, 0x5f, 0xcf, 0x15,
	0xb9, 0xea, 0x94, 0x57, 0x2e, 0x33, 0x88, 0xce, 0xe1, 0x96, 0x5a, 0xe7, 0x21, 0xb6, 0x1c, 0x4c,
	0x0f, 0x30, 0xb7, 0xcf, 0x4d, 0xcc, 0x42, 0x8f, 0x1b, 0xdf, 0x97, 0x91, 0xb4, 0x9d, 0x33, 0x97,
	0x67, 0xd9, 0x52, 0x66, 0x9e, 0x3a, 0x34, 0x84, 0x95, 0xbd, 0x97, 0xe6, 0xfe, 0xd4, 0x92, 0xb7,
	0xe4, 0x92, 0xf7, 0xaf, 0xb5, 0xe4, 0x0c, 0x3d, 0x6a, 0xad, 0x99, 0x26, 0xd0, 0x36, 0xa0, 0x0e,
	0xc5, 0xa7, 0xa1, 0xeb, 0xf1, 0xfd, 0x56, 0xe7, 0x40, 0x82, 0xcc, 0xf8, 0xbc, 0x51, 0xdc, 0xac,
	0x9a, 0x19, 0x14, 0xf4, 0x08, 0xe6, 0x28, 0x09, 0x39, 0x66, 0xc6, 0x3d, 0x39, 0xb9, 0xbb, 0x39,
	0x93, 0x33, 0x05, 0x93, 0x19, 0xf1, 0xa2, 0x63, 0xa8, 0xcb, 0x5f, 0x2f, 0x30, 0xb7, 0x04, 0xbf,
	0xd1, 0x94, 0xc2, 0x0f, 0x2e, 0x13, 0x8e, 0x79, 0xcd, 0xb4, 0x28, 0xfa, 0x43, 0x40, 0x92, 0x6b,
	0x8f, 0xf8, 0x67, 0x6e, 0x3f, 0xa4, 0xf2, 0xe3, 0x19, 0x1f, 0xcb, 0x7d, 0xf8, 0xfd, 0x1c, 0x85,
	0xbb, 0x53, 0x02, 0x66, 0x86, 0x12, 0xb4, 0x01, 0x10, 0x9d, 0x27, 0xed, 0x93, 0xae, 0xb1, 0x28,
	0x4f, 0x98, 0x04, 0x22, 0x4e, 0x71, 0x87, 0x0c, 0x2c, 0xd7, 0x67, 0xc6, 0x86, 0xf4, 0x50, 0x3c,
	0x44, 0x8f, 0x60, 0x35, 0xe6, 0x93, 0x48, 0xdb, 0xe2, 0xd6, 0xa9, 0xc5, 0xb0, 0xf1, 0x40, 0x2a,
	0xc9, 0x26, 0xa2, 0xcf, 0x61, 0x39, 0x26, 0xf8, 0xec, 0x39, 0x21, 0x17, 0x61, 0xc0, 0x8c, 0xef,
	0x49, 0x89, 0x69, 0x02, 0x7a, 0x0b, 0x37, 0xe3, 0xe3, 0x5a, 0x9c, 0x47, 0xac, 0x35, 0x94, 0xd9,
	0x6c, 0x53, 0xba, 0xb2, 0xfd, 0x3e, 0xd9, 0x20, 0xa1, 0x46, 0xc5, 0x48, 0x96, 0x01, 0xb1, 0x6a,
	0x6c, 0xb3, 0x9e, 0xc5, 0x2e, 0x8c, 0x2f, 0xe4, 0xd6, 0x8d, 0x87, 0xc9, 0xec, 0xd4, 0x09, 0x4f,
	0x3d, 0xd7, 0x3e, 0x0a, 0x98, 0xb1, 0xfd, 0xfe, 0xd9, 0x69, 0xa4, 0x64, 0x22, 0x3b, 0x8d, 0x70,
	0x71, 0x20, 0x89, 0xb4, 0x2d, 0xce, 0xf8, 0x23, 0xdf, 0xc1, 0xbf, 0x32, 0x1e, 0xca, 0x8c, 0x99,
	0x06, 0xd7, 0x07, 0xb0, 0x96, 0x9d, 0xf0, 0x90, 0x0e, 0xc5, 0x0b, 0x3c, 0x34, 0x34, 0xb9, 0x0e,
	0xf1, 0x13, 0x7d, 0x0d, 0xe5, 0xb7, 0x96, 0x17, 0xaa, 0xaa, 0xa0, 0xb6, 0xf3, 0x69, 0x5e, 0x48,
	0x46, 0x7a, 0x46, 0x51, 0xa9, 0xa4, 0x7e, 0x5c, 0xf8, 0x4a, 0x5b, 0x6f, 0x89, 0x9a, 0x63, 0x3a,
	0xdf, 0x25, 0x8d, 0x95, 0x95, 0xb1, 0x95, 0xa4, 0xb1, 0x6a, 0x52, 0xc7, 0x1e, 0xac, 0x66, 0x1e,
	0xdc, 0x19, 0x33, 0x4e, 0x29, 0x29, 0x26, 0x95, 0xfc, 0x85, 0x06, 0x8d, 0x59, 0x67, 0x5e, 0x86,
	0xc2, 0xc3, 0xb4, 0x0b, 0x76, 0xf2, 0x5c, 0x10, 0xfa, 0xdc, 0x1d, 0xe0, 0x2c, 0x03, 0xc9, 0x49,
	0xfc, 0x12, 0x6e, 0xe7, 0x1e, 0x42, 0x19, 0xc6, 0xbf, 0x4c, 0x1a, 0x5f, 0xcc, 0x2f, 0xac, 0x5e,
	0x9a, 0xfb, 0xd1, 0x31, 0x9a, 0xb0, 0x65, 0x83, 0x91, 0x17, 0xcb, 0x19, 0xa6, 0x7e, 0x98, 0x5e,
	0xe7, 0x9d, 0x1c, 0x53, 0x42, 0x53, 0xd2, 0x48, 0x22, 0x9a, 0xd2, 0x01, 0xfa, 0xfe, 0xd1, 0x14,
	0xeb, 0xc9, 0x88, 0xa6, 0xe3, 0x52, 0x45, 0xd3, 0x0b, 0xc7, 0xa5, 0x4a, 0x49, 0x2f, 0x1f, 0x97,
	0x2a, 0xf3, 0x7a, 0xe5, 0xb8, 0x54, 0xa9, 0xea, 0x70, 0x5c, 0xaa, 0xd4, 0xf5, 0xc5, 0xe3, 0x52,
	0xa5, 0xa1, 0xdf, 0x3f, 0x2e, 0x55, 0xee, 0xeb, 0xcd, 0xe6, 0x6f, 0x00, 0x6a, 0xc9, 0x1a, 0xf7,
	0x4b, 0x28, 0x8b, 0x2c, 0xcf, 0x0c, 0xed, 0xaa, 0x35, 0xaa, 0xe2, 0x47, 0x5f, 0x43, 0xd1, 0xf1,
	0x99, 0x51, 0x90, 0x62, 0x9f, 0xcd, 0x14, 0x63, 0xdb, 0x6d, 0x3f, 0xda, 0xa2, 0x42, 0x0e, 0xbd,
	0x9a, 0x2c, 0x8a, 0x8a, 0x72, 0xf1, 0x57, 0x50, 0x94, 0x5b, 0x0b, 0x25, 0x4e, 0xda, 0xd2, 0xe4,
	0x49, 0x1b, 0x27, 0xa0, 0xf2, 0x35, 0x12, 0xd0, 0x5f, 0xcd, 0x28, 0x2e, 0xe6, 0xa4, 0xae, 0xbd,
	0x2b, 0x2c, 0xfd, 0x7f, 0x57, 0x53, 0x64, 0x27, 0xaf, 0xf9, 0x0f, 0x91, 0xbc, 0x10, 0x94, 0xb8,
	0x28, 0x8c, 0x2b, 0xd2, 0x5f, 0xf2, 0x37, 0x72, 0x32, 0x4a, 0xca, 0xaa, 0x5c, 0xea, 0x57, 0x57,
	0x5a, 0xea, 0xd5, 0x2a, 0xc9, 0x4b, 0x0a, 0x25, 0xf8, 0xb0, 0x85, 0x52, 0x90, 0x53, 0x28, 0xd5,
	0xe4, 0x9a, 0x7e, 0x72, 0x95, 0x35, 0x7d, 0x90, 0xfa, 0x68, 0x21, 0xaf, 0x3e, 0x5a, 0xff, 0x39,
	0x54, 0xe2, 0xcd, 0x91, 0x71, 0x3c, 0x3c, 0x4e, 0x1f, 0x0f, 0xf7, 0x72, 0x26, 0xdc, 0x3e, 0xe9,
	0xaa, 0x39, 0xfd, 0x7f, 0x3b, 0xdb, 0x3f, 0x48, 0x96, 0xfa, 0x1d, 0x26, 0x88, 0xe6, 0xbf, 0xae,
	0x01, 0x8c, 0x3f, 0xbf, 0xd0, 0x1e, 0xb8, 0x4e, 0x9c, 0x91, 0x03, 0xd7, 0x11, 0x39, 0xc1, 0xb3,
	0x1c, 0x87, 0xca, 0x6b, 0x79, 0x7e, 0x4e, 0xd8, 0x75, 0x1c, 0x6a, 0x2a, 0x4e, 0x21, 0x42, 0xa5,
	0xc8, 0xdc, 0x15, 0x44, 0x24, 0x27, 0xfa, 0x03, 0x98, 0x3b, 0xb3, 0x06, 0xae, 0x37, 0x8c, 0x36,
	0xc4, 0xa7, 0x33, 0x23, 0xf5, 0x40, 0xb2, 0x9b, 0x91, 0x18, 0xfa, 0x3d, 0x28, 0x71, 0x71, 0x85,
	0xad, 0x49, 0xf1, 0xef, 0xcd, 0x14, 0x97, 0xf7, 0x57, 0x29, 0x82, 0xfe, 0x08, 0x56, 0x5c, 0xf6,
	0x9c, 0xd8, 0x96, 0xd7, 0x21, 0x94, 0xef, 0x07, 0xe7, 0x78, 0x80, 0xa9, 0xe5, 0x45, 0x77, 0x98,
	0xbc, 0x43, 0x67, 0xc4, 0x27, 0x84, 0xba, 0xdc, 0xe2, 0xd8, 0xcc, 0x54, 0x23, 0x2a, 0x32, 0xcf,
	0x62, 0xbc, 0x35, 0xe4, 0x98, 0x75, 0xb1, 0xcf, 0xe5, 0x8d, 0xb8, 0x64, 0xa6, 0x41, 0x51, 0xe9,
	0x8e, 0x00, 0x13, 0xdb, 0xd8, 0x7d, 0x8b, 0x1d, 0x79, 0xe3, 0x2c, 0x99, 0xd3, 0x04, 0x71, 0x69,
	0x14, 0xa0, 0x89, 0x39, 0xb5, 0x7c, 0x36, 0x70, 0x39, 0x93, 0x17, 0xcf, 0xba, 0x39, 0x09, 0xa3,
	0x43, 0xa8, 0x3a, 0x2e, 0x55, 0x6b, 0x96, 0x77, 0xcf, 0xc5, 0x9d, 0xad, 0x99, 0xce, 0x69, 0xc7,
	0x12, 0xe6, 0x58, 0x38, 0xb6, 0xd9, 0xb1, 0xec, 0x0b, 0xcc, 0xd5, 0x4a, 0x3e, 0x91, 0xf3, 0x9b,
	0x84, 0xd1, 0x0f, 0xe0, 0x66, 0x02, 0x1a, 0xad, 0xe6, 0x53, 0xc9, 0x9d, 0x45, 0x42, 0x4f, 0xa1,
	0x22, 0xdb, 0x53, 0x36, 0xf1, 0x8c, 0x1f, 0xc8, 0xa0, 0xc9, 0xbb, 0xf9, 0x74, 0x22, 0xb6, 0x2e,
	0xb7, 0xec, 0x0b, 0x73, 0x24, 0x25, 0x76, 0x93, 0x8f, 0xf9, 0x49, 0x57, 0x5e, 0x9e, 0xeb, 0xa6,
	0x1a, 0x88, 0x39, 0x53, 0x3c, 0x20, 0x1c, 0x9f, 0x8c, 0xda, 0x57, 0x0d, 0x75, 0xb9, 0x9e, 0x80,
	0xc5, 0x05, 0xcc, 0x0d, 0x7a, 0xc2, 0x6d, 0x6a, 0x77, 0x1b, 0xab, 0x97, 0x4e, 0xe3, 0xa8, 0x93,
	0xe0, 0x35, 0xd3, 0xa2, 0x62, 0x13, 0x51, 0xce, 0x8d, 0x35, 0x39, 0x13, 0xf1, 0x13, 0xad, 0xc1,
	0x1c, 0xe5, 0xfc, 0x8d, 0x45, 0x8d, 0x5b, 0x12, 0x8c, 0x46, 0xe8, 0x2e, 0x54, 0x5d, 0x9f, 0x53,
	0x4b, 0x54, 0x54, 0x86, 0xd1, 0xd0, 0x36, 0x2b, 0xe6, 0x18, 0x40, 0x4f, 0x60, 0xcd, 0xf1, 0x59,
	0x37, 0xb4, 0x85, 0xe1, 0xb3, 0xd0, 0x33, 0x31, 0x0b, 0x88, 0xcf, 0x30, 0x33, 0x6e, 0x4b, 0x2d,
	0x39, 0x54, 0x71, 0x24, 0x3b, 0x3e, 0x3b, 0xb0, 0x5c, 0x4f, 0x96, 0xf7, 0x91, 0xcc, 0xba, 0x94,
	0xc9, 0xa0, 0xa0, 0x06, 0xd4, 0x1c, 0x9f, 0xf5, 0xdc, 0x01, 0x26, 0x21, 0x67, 0xc6, 0x1d, 0xc9,
	0x98, 0x84, 0xd0, 0x0e, 0xac, 0x8c, 0x6d, 0x3d, 0xb7, 0x38, 0xf6, 0xed, 0x61, 0x37, 0x1c, 0x18,
	0x77, 0xe5, 0x27, 0xcd, 0xa4, 0x45, 0x32, 0xc2, 0x56, 0x48, 0x71, 0x42, 0xe6, 0xa3, 0x91, 0xcc,
	0x14, 0x0d, 0xfd, 0x29, 0x2c, 0x39, 0x3e, 0xdb, 0x23, 0xa1, 0xcf, 0x5b, 0x43, 0x53, 0xdc, 0xef,
	0x8c, 0xfb, 0x32, 0x73, 0x3d, 0x99, 0x19, 0xb3, 0xa2, 0xe4, 0x4a, 0x0a, 0x46, 0x1d, 0xb5, 0x09,
	0x75, 0xc2, 0x37, 0x22, 0x00, 0x7b, 0x76, 0xb0, 0xcf, 0xb8, 0x75, 0xea, 0xb9, 0xec, 0x1c, 0x3b,
	0xc6, 0x86, 0xf2, 0xcd, 0x34, 0x25, 0xde, 0xbd, 0x3d, 0x3b, 0xd8, 0xf3, 0x08, 0xc3, 0x8e, 0x71,
	0x4f, 0xb2, 0xa6, 0x41, 0x64, 0x83, 0x2e, 0x7c, 0xc0, 0x2d, 0x51, 0x61, 0xab, 0x3b, 0x6c, 0x74,
	0x83, 0xff, 0xf2, 0x4a, 0x13, 0x4f, 0x49, 0x46, 0x55, 0xc4, 0xa4, 0x42, 0xf4, 0x97, 0x1a, 0xdc,
	0x99, 0x04, 0x5b, 0xc3, 0x57, 0x21, 0xa6, 0x43, 0xd9, 0xbd, 0xdb, 0x9a, 0x71, 0xaf, 0xcc, 0x35,
	0x98, 0x50, 0x12, 0x55, 0x68, 0x97, 0x98, 0x41, 0xbf, 0xd6, 0xe0, 0xfe, 0x24, 0xfd, 0xe5, 0xd9,
	0x19, 0xc3, 0x3c, 0x39, 0x99, 0xcf, 0xe4, 0x64, 0x0e, 0xaf, 0x3f, 0x99, 0x29, 0x55, 0x6a, 0x4a,
	0xb3, 0x4d, 0xa2, 0x75, 0xa8, 0xc8, 0x62, 0xf6, 0xc8, 0xf9, 0x95, 0xec, 0x2a, 0x94, 0xcd, 0xd1,
	0x18, 0x7d, 0x02, 0x8b, 0xf2, 0x77, 0xcf, 0xa2, 0x7d, 0xcc, 0x05, 0xc7, 0xa6, 0xe4, 0x98, 0x40,
	0xd1, 0x16, 0xe8, 0xe7, 0x9c, 0x07, 0xbb, 0xfd, 0x3e, 0xc5, 0x7d, 0x4b, 0x35, 0xb4, 0x55, 0xbf,
	0x61, 0x0a, 0x47, 0x6b, 0x51, 0x3d, 0xf9, 0x79, 0xa3, 0xb8, 0x59, 0x6f, 0x15, 0xf4, 0x1b, 0x51,
	0x4d, 0x69, 0xc0, 0xbc, 0xf8, 0x2b, 0x8c, 0x7c, 0xa1, 0x5a, 0xd9, 0xd1, 0x10, 0x35, 0x61, 0x41,
	0xfc, 0xdc, 0x3b, 0xc7, 0xf6, 0x05, 0x0b, 0x07, 0xf2, 0x6e, 0x5e, 0x37, 0x53, 0x18, 0xda, 0x00,
	0x60, 0x22, 0x9b, 0xa8, 0xdb, 0xfb, 0xb6, 0xe4, 0x48, 0x20, 0xe8, 0x2b, 0xb8, 0x25, 0x7c, 0xda,
	0xe5, 0x14, 0x5b, 0x03, 0x96, 0x9a, 0xe8, 0x0f, 0xe5, 0x44, 0xf3, 0xc8, 0x22, 0xc5, 0x88, 0x35,
	0xec, 0xa4, 0x64, 0x76, 0x54, 0x33, 0x65, 0x8a, 0x20, 0xb7, 0x6f, 0xd4, 0x86, 0x49, 0x09, 0xfc,
	0x48, 0x0a, 0x64, 0xd2, 0x10, 0x81, 0x15, 0x6e, 0x07, 0xd1, 0xb6, 0x66, 0xad, 0xe1, 0x3e, 0xa5,
	0x7b, 0x62, 0x0f, 0x3f, 0x92, 0xc1, 0xf0, 0xfb, 0xb3, 0x83, 0xa1, 0x97, 0x21, 0x1d, 0x15, 0x9f,
	0x59, 0x8a, 0xc5, 0xee, 0x54, 0x07, 0xf9, 0x7e, 0xd4, 0x7f, 0x79, 0xac, 0xda, 0xaf, 0x29, 0x50,
	0xb8, 0xcc, 0x13, 0x79, 0x79, 0xd4, 0x83, 0x18, 0x77, 0x47, 0x9e, 0xc8, 0x0f, 0x94, 0x47, 0x5e,
	0x6f, 0xc1, 0x4a, 0xd6, 0xb1, 0x92, 0x2c, 0xc2, 0xea, 0x19, 0xd5, 0x5c, 0x3d, 0x59, 0xcd, 0x39,
	0xb0, 0x9a, 0xb9, 0xc3, 0x33, 0xba, 0x1f, 0x57, 0xaf, 0x7e, 0xa5, 0xba, 0xa4, 0x95, 0x6f, 0xa0,
	0x31, 0x6b, 0x5b, 0x67, 0x18, 0x7c, 0x9a, 0x36, 0xb8, 0x35, 0xc3, 0x60, 0x42, 0x63, 0xd2, 0xf6,
	0x9f, 0x6b, 0xf0, 0xc9, 0xd5, 0xb6, 0xf1, 0xff, 0xd9, 0x14, 0x7e, 0x06, 0xb7, 0x73, 0x63, 0xe7,
	0x3a, 0x5f, 0xeb, 0xb8, 0x54, 0x29, 0xe8, 0xc5, 0xe3, 0x52, 0xa5, 0xa8, 0x97, 0x26, 0x5a, 0x0c,
	0x15, 0xbd, 0x3a, 0x6a, 0x34, 0x2c, 0xe8, 0xf5, 0x51, 0xbb, 0x61, 0x51, 0x5f, 0x3a, 0x2e, 0x55,
	0x96, 0x74, 0xfd, 0xb8, 0x54, 0xf9, 0x58, 0x7f, 0xd0, 0xfc, 0xb5, 0x06, 0xfa, 0x64, 0x33, 0x0c,
	0x2d, 0x42, 0x21, 0x2a, 0xab, 0xab, 0x66, 0xc1, 0x75, 0xc4, 0x19, 0x71, 0x3a, 0xe4, 0xf8, 0x19,
	0x56, 0xbd, 0x80, 0x05, 0x33, 0x1e, 0x8e, 0x6e, 0xa9, 0xa5, 0xc4, 0x2d, 0x75, 0x1d, 0x2a, 0xdc,
	0xea, 0xab, 0x88, 0x55, 0xaf, 0x63, 0xa3, 0x71, 0x7c, 0xa6, 0xbc, 0x20, 0x8e, 0x7b, 0xe6, 0x62,
	0x47, 0xd6, 0xdc, 0x45, 0x33, 0x85, 0xa9, 0x45, 0x35, 0x7f, 0x53, 0x96, 0x6d, 0xb8, 0xa9, 0xd6,
	0x02, 0xfa, 0x09, 0xdc, 0x1e, 0x10, 0x9f, 0x70, 0xe2, 0xbb, 0xf6, 0xb3, 0x80, 0x92, 0x53, 0xcc,
	0x7a, 0xd4, 0xed, 0xf7, 0x31, 0xc5, 0x6a, 0xce, 0x45, 0x33, 0x9f, 0x41, 0x54, 0x29, 0x93, 0xc4,
	0x17, 0x2e, 0x13, 0xa9, 0x52, 0x5d, 0x6c, 0x72, 0xa8, 0xe8, 0x29, 0xdc, 0x19, 0x51, 0xc4, 0xb4,
	0x38, 0x15, 0x15, 0x1d, 0xee, 0xbb, 0x8c, 0x63, 0xca, 0xa4, 0x5b, 0x8a, 0xe6, 0x65, 0x2c, 0xe8,
	0x04, 0x9a, 0x97, 0x90, 0xdb, 0x94, 0x04, 0x01, 0x76, 0x8c, 0x92, 0x54, 0x74, 0x05, 0x4e, 0xd4,
	0x82, 0xbb, 0x23, 0xae, 0xb6, 0xcf, 0xa2, 0x22, 0xb5, 0xa3, 0xe2, 0x10, 0xab, 0x87, 0xc9, 0xa2,
	0x79, 0x29, 0x8f, 0x38, 0x36, 0x53, 0x96, 0x58, 0x54, 0x36, 0xa8, 0xcf, 0x92, 0x49, 0x13, 0x55,
	0xaa, 0x6c, 0x33, 0xb5, 0x82, 0xb3, 0x17, 0x96, 0x7a, 0xe7, 0x9c, 0x97, 0xec, 0x93, 0x30, 0xfa,
	0x29, 0xac, 0x8f, 0x34, 0xbc, 0x76, 0x82, 0x2e, 0xf6, 0x9d, 0xc4, 0xfc, 0x2a, 0x52, 0xe8, 0x12,
	0x0e, 0x71, 0x12, 0x4e, 0x51, 0xa3, 0x8f, 0x55, 0x95, 0xc2, 0x79, 0x64, 0xf4, 0x63, 0x30, 0xec,
	0xd8, 0x71, 0x5d, 0x6b, 0x10, 0x78, 0xae, 0xdf, 0xef, 0x60, 0x6a, 0x8b, 0x6b, 0x00, 0x48, 0xd1,
	0x5c, 0xba, 0x58, 0x5f, 0x9c, 0xbd, 0xe3, 0x8f, 0x52, 0x53, 0xeb, 0x9b, 0x80, 0x9b, 0x7f, 0x5f,
	0x82, 0x8f, 0x2e, 0x7d, 0x12, 0x14, 0x09, 0xfa, 0x22, 0x3b, 0x44, 0xa7, 0x70, 0xf9, 0x38, 0x97,
	0x11, 0x90, 0x69, 0x50, 0x54, 0x84, 0x76, 0x5e, 0xf8, 0x65, 0x50, 0xc4, 0x6e, 0xb1, 0x67, 0x04,
	0x5b, 0x3e, 0x83, 0xb8, 0x1b, 0x39, 0xb9, 0xa1, 0x95, 0x45, 0x12, 0xd5, 0xb9, 0x3d, 0x15, 0x48,
	0x49, 0xe8, 0x1a, 0xf1, 0xf3, 0x39, 0x2c, 0x87, 0x39, 0x61, 0x33, 0x4d, 0x10, 0x45, 0x53, 0x98,
	0x15, 0x24, 0x13, 0xe8, 0xef, 0x28, 0x36, 0xfe, 0xb3, 0x00, 0x77, 0x2e, 0xe9, 0xc2, 0x88, 0xef,
	0x42, 0xa7, 0xc8, 0xfb, 0xbe, 0x75, 0xea, 0x45, 0x21, 0x52, 0x31, 0xf3, 0x19, 0xd0, 0x05, 0x18,
	0xd3, 0xc4, 0xa8, 0x47, 0xa7, 0xfa, 0x2a, 0x0f, 0xaf, 0xdc, 0x19, 0x8a, 0xba, 0x2c, 0xb9, 0x0a,
	0xc5, 0x36, 0x9e, 0xa6, 0xb5, 0xe3, 0x66, 0xa7, 0x0a, 0xbd, 0x4b, 0x38, 0x2e, 0xeb, 0x27, 0x96,
	0x3e, 0x68, 0x3f, 0xb1, 0xf9, 0x8f, 0x1a, 0xa0, 0xdd, 0xcc, 0x77, 0x40, 0x3f, 0x18, 0xa4, 0x9d,
	0x9b, 0x40, 0x04, 0x3d, 0x64, 0x23, 0x7a, 0x41, 0xd1, 0xc7, 0x88, 0xa0, 0x3b, 0x63, 0x7a, 0x51,
	0xd1, 0x9d, 0x14, 0xdd, 0xb6, 0x47, 0xf4, 0x92, 0xa2, 0x8f, 0x11, 0x49, 0x1f, 0xcb, 0x97, 0x23,
	0xfa, 0x08, 0x69, 0xfe, 0x19, 0x94, 0x65, 0x7b, 0x1b, 0x3d, 0x86, 0x39, 0x16, 0x9e, 0xfa, 0x98,
	0xcb, 0x49, 0xd6, 0x76, 0x3e, 0xca, 0x71, 0x4c, 0x57, 0x32, 0x99, 0x11, 0x33, 0xfa, 0xa9, 0xbc,
	0x97, 0x63, 0x7a, 0x66, 0xd9, 0x71, 0x61, 0xd2, 0xc8, 0xeb, 0x04, 0xc4, 0x7c, 0xe6, 0x58, 0xa4,
	0xf9, 0x10, 0xaa, 0x23, 0x5c, 0x64, 0xe8, 0x43, 0x8b, 0x3a, 0xef, 0x2c, 0x8a, 0x77, 0x1d, 0x87,
	0x46, 0x55, 0x40, 0x0a, 0x6b, 0x6e, 0xc0, 0x9c, 0x9a, 0x82, 0x28, 0x4d, 0x2c, 0xcf, 0xb5, 0x58,
	0xc4, 0xa6, 0x06, 0xcd, 0x21, 0xd4, 0x53, 0x6f, 0xbe, 0xd9, 0x6c, 0xa9, 0x42, 0xa1, 0x30, 0xa3,
	0x50, 0x28, 0x4e, 0x17, 0x0a, 0x59, 0xc5, 0x47, 0xf3, 0x6f, 0x34, 0xa8, 0xa7, 0xda, 0x1d, 0xe8,
	0x2e, 0x54, 0x29, 0x0e, 0xbc, 0x2e, 0xb5, 0x8f, 0x3a, 0x91, 0xfd, 0x31, 0x10, 0x53, 0xdb, 0x8c,
	0x1f, 0x75, 0xa2, 0x67, 0xbc, 0x31, 0x20, 0x4e, 0xb3, 0x88, 0xb5, 0x43, 0x28, 0x97, 0x93, 0x28,
	0x9b, 0x49, 0x28, 0xe6, 0x68, 0x33, 0x2e, 0x39, 0x4a, 0x63, 0x8e, 0x08, 0x6a, 0x7e, 0x03, 0x25,
	0xe1, 0x34, 0x59, 0x54, 0x05, 0x91, 0x89, 0x82, 0x1b, 0x88, 0xd9, 0x07, 0x63, 0xa5, 0xf2, 0x77,
	0x74, 0x7a, 0xaa, 0xba, 0x3e, 0xfa, 0xdf, 0xa2, 0xaa, 0x99, 0x84, 0x52, 0xff, 0xf8, 0x34, 0x9f,
	0xfe, 0xc7, 0xa7, 0x89, 0xa7, 0xa6, 0x39, 0x7d, 0xbe, 0x79, 0x02, 0xf5, 0x54, 0x0b, 0x0a, 0x7d,
	0x0d, 0x65, 0x26, 0x7e, 0xc8, 0x37, 0xa5, 0xc5, 0x9d, 0x8f, 0x67, 0xf4, 0xad, 0x44, 0xe1, 0x2a,
	0xef, 0x8a, 0x4a, 0xaa, 0xd9, 0x80, 0x4a, 0xdc, 0xcc, 0x96, 0x3d, 0x2c, 0x6b, 0x80, 0xd5, 0xf3,
	0x54, 0xd5, 0x54, 0x83, 0xe6, 0x3f, 0x17, 0x24, 0x8b, 0x3c, 0x0b, 0x27, 0x5b, 0x35, 0xda, 0xd5,
	0x5b, 0x35, 0x85, 0xf7, 0x68, 0xd5, 0x14, 0x2f, 0x69, 0xd5, 0xfc, 0xf1, 0x74, 0xab, 0xa6, 0x24,
	0xaf, 0x79, 0x8f, 0x66, 0x54, 0xf0, 0x57, 0x6b, 0xd4, 0x7c, 0x88, 0xab, 0x57, 0xf3, 0xbf, 0x34,
	0xb8, 0x99, 0x71, 0x71, 0x40, 0xa1, 0x4c, 0xc2, 0x93, 0x70, 0xf4, 0x2a, 0xb8, 0x77, 0xf5, 0x1b,
	0x48, 0xa2, 0x79, 0x31, 0xd1, 0xae, 0xc8, 0xd2, 0xbf, 0xde, 0x07, 0x23, 0x4f, 0xe0, 0x83, 0x5e,
	0x06, 0x9b, 0x1c, 0xf4, 0xc9, 0x07, 0xd4, 0x68, 0xb3, 0x68, 0xa3, 0xcd, 0xf2, 0x00, 0xea, 0xb6,
	0x47, 0x42, 0xa7, 0x43, 0xc9, 0x5b, 0xd7, 0xc1, 0x34, 0xda, 0x47, 0x69, 0x50, 0x36, 0x2e, 0x71,
	0x3f, 0xce, 0x4a, 0x55, 0x33, 0x1a, 0x65, 0x1d, 0x14, 0x5b, 0x7f, 0x57, 0x00, 0x23, 0x2f, 0x19,
	0x22, 0x1d, 0x16, 0x4e, 0x08, 0xdf, 0xe5, 0x1c, 0x0f, 0x02, 0x8e, 0x1d, 0xfd, 0x06, 0x5a, 0x03,
	0x94, 0x60, 0x8b, 0x82, 0x52, 0xd7, 0xd0, 0x0a, 0xe8, 0xcf, 0x92, 0xff, 0x3d, 0xb5, 0x4f, 0xa9,
	0x5e, 0x40, 0xab, 0xb0, 0xfc, 0x06, 0x53, 0xf7, 0xcc, 0xb5, 0x55, 0xda, 0xa6, 0x94, 0x50, 0xbd,
	0x28, 0xd4, 0xbe, 0x0c, 0x79, 0x10, 0xf2, 0xb6, 0x4b, 0x05, 0x63, 0x09, 0x2d, 0x43, 0x5d, 0x21,
	0x07, 0xae, 0x87, 0x05, 0x54, 0x46, 0x08, 0x16, 0x4f, 0xf0, 0x3b, 0x65, 0x0c, 0x4b, 0xb6, 0x39,
	0x81, 0x25, 0xab, 0x00, 0x4a, 0xf5, 0x79, 0x21, 0x1a, 0xe5, 0x43, 0x6c, 0x39, 0x02, 0xaa, 0x08,
	0xb6, 0x44, 0x52, 0x14, 0x58, 0x15, 0xdd, 0x82, 0x9b, 0x91, 0x2e, 0x27, 0xb2, 0x44, 0x42, 0xdf,
	0xd1, 0x41, 0x30, 0x1f, 0xf9, 0x41, 0xc8, 0x0f, 0x2d, 0x76, 0xae, 0x26, 0x58, 0xdb, 0xfa, 0x87,
	0x02, 0xdc, 0xca, 0xc9, 0xba, 0x62, 0x4d, 0x72, 0x98, 0xe1, 0x98, 0x90, 0x71, 0x32, 0x50, 0x12,
	0x4c, 0xa9, 0xd7, 0x84, 0xdd, 0x36, 0x3e, 0xb3, 0x42, 0x8f, 0xa7, 0x08, 0xd2, 0x37, 0xdd, 0x21,
	0x3b, 0x63, 0x29, 0xb8, 0x88, 0xd6, 0x61, 0xad, 0x4d, 0xde, 0xf9, 0x1e, 0xb1, 0x1c, 0xec, 0xa4,
	0x68, 0x25, 0x74, 0x13, 0x96, 0x62, 0x5a, 0xec, 0x79, 0xe9, 0xa7, 0x43, 0xc2, 0x78, 0xc2, 0xef,
	0x73, 0x49, 0xc6, 0xe8, 0x0c, 0xd0, 0xe7, 0xe5, 0xc7, 0xb0, 0x3c, 0xd7, 0xb1, 0xd4, 0x43, 0x8c,
	0x82, 0x2b, 0xe8, 0x36, 0xac, 0x9a, 0x38, 0x20, 0xac, 0xed, 0xd2, 0x5d, 0xa9, 0x33, 0x26, 0x55,
	0xd1, 0xc7, 0x70, 0x2f, 0x9a, 0xc1, 0x09, 0x51, 0xfe, 0x8a, 0xb5, 0xb6, 0x5d, 0x26, 0x73, 0xb6,
	0x0e, 0x5b, 0xff, 0xa4, 0x01, 0x8c, 0x5f, 0xa9, 0x44, 0x20, 0x44, 0x73, 0x53, 0xee, 0x68, 0xf5,
	0x0e, 0x94, 0x77, 0x22, 0x74, 0x7f, 0x70, 0x8a, 0x1d, 0x07, 0x3b, 0x02, 0xd7, 0xa4, 0x13, 0x14,
	0x1e, 0x39, 0x49, 0xc0, 0x05, 0xb4, 0x04, 0xb5, 0x16, 0x3f, 0x8b, 0x8d, 0xea, 0x45, 0xb1, 0x48,
	0xf9, 0x9a, 0x16, 0x7d, 0x63, 0x12, 0xc5, 0x8c, 0x0a, 0x2e, 0x19, 0x1d, 0x44, 0xc4, 0xcc, 0x12,
	0xd4, 0x9e, 0x0b, 0xc7, 0x45, 0xc0, 0x9c, 0xf0, 0x66, 0xa4, 0xdf, 0x94, 0xcd, 0x25, 0x55, 0x10,
	0x09, 0x23, 0xf3, 0x5b, 0x4d, 0xd0, 0x27, 0x1f, 0xa6, 0xd0, 0x1c, 0x14, 0xde, 0x3e, 0xd2, 0x6f,
	0xc8, 0xbf, 0x4f, 0x74, 0x6d, 0xeb, 0xe7, 0x22, 0x6a, 0xa6, 0x1e, 0x58, 0x84, 0x9d, 0xd0, 0x67,
	0x01, 0xb6, 0x65, 0x02, 0xd6, 0x6f, 0xa0, 0x05, 0xa8, 0xb8, 0xbe, 0x4d, 0x06, 0xae, 0xdf, 0xd7,
	0x35, 0x31, 0x22, 0x21, 0xef, 0x13, 0x31, 0x2a, 0xa0, 0x2a, 0x94, 0x65, 0xa7, 0x4a, 0x2f, 0xa2,
	0x0a, 0x94, 0x7c, 0xe2, 0x63, 0xbd, 0xb4, 0xf5, 0x1a, 0xd0, 0xf4, 0x5b, 0x14, 0x32, 0x60, 0x05,
	0xc7, 0xe8, 0xeb, 0x94, 0x81, 0x65, 0xa8, 0x8f, 0x28, 0x3d, 0x1a, 0x62, 0x5d, 0x13, 0x3e, 0x19,
	0x41, 0x07, 0x96, 0xc7, 0xb0, 0x5e, 0xd8, 0xfa, 0x6f, 0x0d, 0x16, 0x92, 0x49, 0x4b, 0x68, 0x8c,
	0x5f, 0x5b, 0x5e, 0xfb, 0xb6, 0x67, 0x31, 0x16, 0x6b, 0xbc, 0x09, 0x4b, 0x63, 0xca, 0x85, 0x4f,
	0xde, 0xf9, 0xba, 0x26, 0x76, 0x66, 0x0c, 0x1e, 0xf6, 0x7a, 0x1d, 0xbd, 0x20, 0x0c, 0x27, 0x91,
	0x1d, 0xbd, 0x28, 0x56, 0x1f, 0x43, 0xbd, 0xe7, 0x5d, 0xf5, 0x25, 0x62, 0xe0, 0x99, 0x75, 0x76,
	0x61, 0xe9, 0xe5, 0x24, 0xf4, 0x82, 0xf8, 0x7d, 0xa2, 0xcf, 0x89, 0xc8, 0x88, 0xa1, 0x0e, 0x61,
	0xbc, 0x4f, 0x31, 0xd3, 0xe7, 0x93, 0x16, 0x77, 0x5f, 0xbc, 0xea, 0xe8, 0x95, 0xa4, 0xa8, 0x89,
	0x1d, 0x97, 0xe9, 0xd5, 0x94, 0xb6, 0x61, 0xf7, 0xd5, 0x73, 0x1d, 0x92, 0x72, 0x3f, 0x33, 0x3b,
	0x7b, 0x7a, 0xad, 0xb5, 0xff, 0x2f, 0xdf, 0x6e, 0x68, 0xbf, 0xfd, 0x76, 0x43, 0xfb, 0xf7, 0x6f,
	0x37, 0xb4, 0xbf, 0xfd, 0x6e, 0xe3, 0xc6, 0x6f, 0xbf, 0xdb, 0xb8, 0xf1, 0x6f, 0xdf, 0x6d, 0xdc,
	0xf8, 0xc5, 0x67, 0x7d, 0x97, 0x9f, 0x87, 0xa7, 0xdb, 0x36, 0x19, 0x3c, 0x6c, 0x5b, 0xdc, 0x6a,
	0x93, 0xbe, 0xfa, 0xf7, 0xea, 0x2f, 0x02, 0x6b, 0x28, 0xc2, 0xf9, 0xe1, 0xdb, 0xc7, 0xf1, 0xff,
	0x5d, 0x9f, 0xce, 0x49, 0xb5, 0x3f, 0xfa, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf5, 0xcb, 0x8a,
	0xa0, 0xc7, 0x2d, 0x00, 0x00,
}

func (m *CollectorConnections) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorConnections) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorConnections) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.HostTagsIndex != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.HostTagsIndex))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xf8
	}
	if len(m.ResolvedPublicIps) > 0 {
		for k := range m.ResolvedPublicIps {
			v := m.ResolvedPublicIps[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xf2
		}
	}
	if len(m.EcsTask) > 0 {
		i -= len(m.EcsTask)
		copy(dAtA[i:], m.EcsTask)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EcsTask)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xea
	}
	if len(m.PrebuiltEBPFAssets) > 0 {
		for iNdEx := len(m.PrebuiltEBPFAssets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PrebuiltEBPFAssets[iNdEx])
			copy(dAtA[i:], m.PrebuiltEBPFAssets[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.PrebuiltEBPFAssets[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xe2
		}
	}
	if len(m.CORETelemetryByAsset) > 0 {
		for k := range m.CORETelemetryByAsset {
			v := m.CORETelemetryByAsset[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xd2
		}
	}
	if m.KernelHeaderFetchResult != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.KernelHeaderFetchResult))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc8
	}
	if len(m.ResolvedHostsByName) > 0 {
		for k := range m.ResolvedHostsByName {
			v := m.ResolvedHostsByName[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xc2
		}
	}
	if len(m.ConnTelemetryMap) > 0 {
		for k := range m.ConnTelemetryMap {
			v := m.ConnTelemetryMap[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xba
		}
	}
	if len(m.EncodedConnectionsTags) > 0 {
		i -= len(m.EncodedConnectionsTags)
		copy(dAtA[i:], m.EncodedConnectionsTags)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EncodedConnectionsTags)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb2
	}
	if len(m.EncodedDnsLookups) > 0 {
		i -= len(m.EncodedDnsLookups)
		copy(dAtA[i:], m.EncodedDnsLookups)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EncodedDnsLookups)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xaa
	}
	if len(m.EncodedDomainDatabase) > 0 {
		i -= len(m.EncodedDomainDatabase)
		copy(dAtA[i:], m.EncodedDomainDatabase)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EncodedDomainDatabase)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xa2
	}
	if m.AgentConfiguration != nil {
		{
			size, err := m.AgentConfiguration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x9a
	}
	if len(m.RouteMetadata) > 0 {
		for iNdEx := len(m.RouteMetadata) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.RouteMetadata[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnections(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x92
		}
	}
	if len(m.Routes) > 0 {
		for iNdEx := len(m.Routes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Routes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnections(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xfa
		}
	}
	if len(m.Domains) > 0 {
		for iNdEx := len(m.Domains) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Domains[iNdEx])
			copy(dAtA[i:], m.Domains[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Domains[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xf2
		}
	}
	if len(m.CompilationTelemetryByAsset) > 0 {
		for k := range m.CompilationTelemetryByAsset {
			v := m.CompilationTelemetryByAsset[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xaa
		}
	}
	if len(m.PlatformVersion) > 0 {
		i -= len(m.PlatformVersion)
		copy(dAtA[i:], m.PlatformVersion)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.PlatformVersion)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if len(m.Platform) > 0 {
		i -= len(m.Platform)
		copy(dAtA[i:], m.Platform)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Platform)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x9a
	}
	if len(m.KernelVersion) > 0 {
		i -= len(m.KernelVersion)
		copy(dAtA[i:], m.KernelVersion)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.KernelVersion)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if len(m.Architecture) > 0 {
		i -= len(m.Architecture)
		copy(dAtA[i:], m.Architecture)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Architecture)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.ConnTelemetry != nil {
		{
			size, err := m.ConnTelemetry.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.ContainerHostType != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ContainerHostType))
		i--
		dAtA[i] = 0x78
	}
	if len(m.EncodedDNS) > 0 {
		i -= len(m.EncodedDNS)
		copy(dAtA[i:], m.EncodedDNS)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EncodedDNS)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.NetworkId) > 0 {
		i -= len(m.NetworkId)
		copy(dAtA[i:], m.NetworkId)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.NetworkId)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.EncodedTags) > 0 {
		i -= len(m.EncodedTags)
		copy(dAtA[i:], m.EncodedTags)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.EncodedTags)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.ContainerForPid) > 0 {
		for k := range m.ContainerForPid {
			v := m.ContainerForPid[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintConnections(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.ResolvedResources) > 0 {
		for k := range m.ResolvedResources {
			v := m.ResolvedResources[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.GroupSize != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x30
	}
	if m.GroupId != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Connections) > 0 {
		for iNdEx := len(m.Connections) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Connections[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnections(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *Connections) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connections) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Connections) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.PrebuiltEBPFAssets) > 0 {
		for iNdEx := len(m.PrebuiltEBPFAssets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PrebuiltEBPFAssets[iNdEx])
			copy(dAtA[i:], m.PrebuiltEBPFAssets[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.PrebuiltEBPFAssets[iNdEx])))
			i--
			dAtA[i] = 0x62
		}
	}
	if len(m.CORETelemetryByAsset) > 0 {
		for k := range m.CORETelemetryByAsset {
			v := m.CORETelemetryByAsset[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x5a
		}
	}
	if m.KernelHeaderFetchResult != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.KernelHeaderFetchResult))
		i--
		dAtA[i] = 0x50
	}
	if len(m.ConnTelemetryMap) > 0 {
		for k := range m.ConnTelemetryMap {
			v := m.ConnTelemetryMap[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if m.AgentConfiguration != nil {
		{
			size, err := m.AgentConfiguration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.CompilationTelemetryByAsset) > 0 {
		for k := range m.CompilationTelemetryByAsset {
			v := m.CompilationTelemetryByAsset[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Routes) > 0 {
		for iNdEx := len(m.Routes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Routes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnections(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Domains) > 0 {
		for iNdEx := len(m.Domains) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Domains[iNdEx])
			copy(dAtA[i:], m.Domains[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Domains[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.ConnTelemetry != nil {
		{
			size, err := m.ConnTelemetry.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Dns) > 0 {
		for k := range m.Dns {
			v := m.Dns[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintConnections(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Conns) > 0 {
		for iNdEx := len(m.Conns) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conns[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintConnections(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Connection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connection) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Connection) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.LocalContainerTagsIndex != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LocalContainerTagsIndex))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xb0
	}
	if len(m.RemoteEcsTask) > 0 {
		i -= len(m.RemoteEcsTask)
		copy(dAtA[i:], m.RemoteEcsTask)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.RemoteEcsTask)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0xaa
	}
	if len(m.TcpFailuresByErrCode) > 0 {
		for k := range m.TcpFailuresByErrCode {
			v := m.TcpFailuresByErrCode[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3
			i--
			dAtA[i] = 0xa2
		}
	}
	if len(m.DatabaseAggregations) > 0 {
		i -= len(m.DatabaseAggregations)
		copy(dAtA[i:], m.DatabaseAggregations)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.DatabaseAggregations)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x9a
	}
	if len(m.Http2Aggregations) > 0 {
		i -= len(m.Http2Aggregations)
		copy(dAtA[i:], m.Http2Aggregations)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Http2Aggregations)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x92
	}
	if len(m.DataStreamsAggregations) > 0 {
		i -= len(m.DataStreamsAggregations)
		copy(dAtA[i:], m.DataStreamsAggregations)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.DataStreamsAggregations)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x8a
	}
	if m.Protocol != nil {
		{
			size, err := m.Protocol.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x82
	}
	if m.TagsChecksum != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagsChecksum))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xf8
	}
	if m.StateIndex != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.StateIndex))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xf0
	}
	if m.TagsIdx != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagsIdx))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xe8
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i = encodeVarintConnections(dAtA, i, uint64(m.Tags[iNdEx]))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xe0
		}
	}
	if len(m.DnsStatsByDomainOffsetByQueryType) > 0 {
		for k := range m.DnsStatsByDomainOffsetByQueryType {
			v := m.DnsStatsByDomainOffsetByQueryType[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xda
		}
	}
	if len(m.DnsStatsByDomainByQueryType) > 0 {
		for k := range m.DnsStatsByDomainByQueryType {
			v := m.DnsStatsByDomainByQueryType[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xd2
		}
	}
	if m.IsLocalPortEphemeral != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.IsLocalPortEphemeral))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc8
	}
	if m.RouteTargetIdx != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.RouteTargetIdx))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc0
	}
	if m.LastPacketsReceived != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastPacketsReceived))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb8
	}
	if m.LastPacketsSent != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastPacketsSent))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb0
	}
	if len(m.HttpAggregations) > 0 {
		i -= len(m.HttpAggregations)
		copy(dAtA[i:], m.HttpAggregations)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.HttpAggregations)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xaa
	}
	if m.RouteIdx != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.RouteIdx))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xa0
	}
	if len(m.DnsStatsByDomain) > 0 {
		for k := range m.DnsStatsByDomain {
			v := m.DnsStatsByDomain[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x92
		}
	}
	if len(m.DnsCountByRcode) > 0 {
		for k := range m.DnsCountByRcode {
			v := m.DnsCountByRcode[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x8a
		}
	}
	if len(m.RemoteNetworkId) > 0 {
		i -= len(m.RemoteNetworkId)
		copy(dAtA[i:], m.RemoteNetworkId)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.RemoteNetworkId)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x82
	}
	if m.LastTcpClosed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastTcpClosed))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf8
	}
	if m.LastTcpEstablished != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastTcpEstablished))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf0
	}
	if m.DnsFailureLatencySum != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsFailureLatencySum))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe8
	}
	if m.DnsSuccessLatencySum != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsSuccessLatencySum))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe0
	}
	if m.DnsTimeouts != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsTimeouts))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd8
	}
	if m.DnsFailedResponses != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsFailedResponses))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd0
	}
	if m.DnsSuccessfulResponses != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsSuccessfulResponses))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc8
	}
	if m.IntraHost {
		i--
		if m.IntraHost {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.RttVar != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.RttVar))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.Rtt != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Rtt))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.IpTranslation != nil {
		{
			size, err := m.IpTranslation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.NetNS != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.NetNS))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if m.Direction != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Direction))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.LastRetransmits != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastRetransmits))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if m.LastBytesReceived != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastBytesReceived))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.LastBytesSent != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.LastBytesSent))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.Type != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x58
	}
	if m.Family != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Family))
		i--
		dAtA[i] = 0x50
	}
	if m.Raddr != nil {
		{
			size, err := m.Raddr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Laddr != nil {
		{
			size, err := m.Laddr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Pid != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Pid))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ResourceMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TagsModified != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagsModified))
		i--
		dAtA[i] = 0x30
	}
	if m.TagIndex != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagIndex))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.ByteKey) > 0 {
		i -= len(m.ByteKey)
		copy(dAtA[i:], m.ByteKey)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.ByteKey)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConnectionsTelemetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectionsTelemetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectionsTelemetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DnsStatsDropped != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsStatsDropped))
		i--
		dAtA[i] = 0x58
	}
	if m.ConntrackSamplingPercent != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConntrackSamplingPercent))
		i--
		dAtA[i] = 0x50
	}
	if m.MonotonicUdpSendsMissed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicUdpSendsMissed))
		i--
		dAtA[i] = 0x48
	}
	if m.MonotonicUdpSendsProcessed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicUdpSendsProcessed))
		i--
		dAtA[i] = 0x40
	}
	if m.ConnsBpfMapSize != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConnsBpfMapSize))
		i--
		dAtA[i] = 0x38
	}
	if m.MonotonicConnsClosed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicConnsClosed))
		i--
		dAtA[i] = 0x30
	}
	if m.MonotonicDnsPacketsProcessed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicDnsPacketsProcessed))
		i--
		dAtA[i] = 0x28
	}
	if m.MonotonicConntrackRegistersDropped != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicConntrackRegistersDropped))
		i--
		dAtA[i] = 0x20
	}
	if m.MonotonicConntrackRegisters != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicConntrackRegisters))
		i--
		dAtA[i] = 0x18
	}
	if m.MonotonicKprobesMissed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicKprobesMissed))
		i--
		dAtA[i] = 0x10
	}
	if m.MonotonicKprobesTriggered != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.MonotonicKprobesTriggered))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CollectorConnectionsTelemetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorConnectionsTelemetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorConnectionsTelemetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DnsStatsDropped != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsStatsDropped))
		i--
		dAtA[i] = 0x58
	}
	if m.ConntrackSamplingPercent != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConntrackSamplingPercent))
		i--
		dAtA[i] = 0x50
	}
	if m.UdpSendsMissed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.UdpSendsMissed))
		i--
		dAtA[i] = 0x48
	}
	if m.UdpSendsProcessed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.UdpSendsProcessed))
		i--
		dAtA[i] = 0x40
	}
	if m.ConnsBpfMapSize != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConnsBpfMapSize))
		i--
		dAtA[i] = 0x38
	}
	if m.ConnsClosed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConnsClosed))
		i--
		dAtA[i] = 0x30
	}
	if m.DnsPacketsProcessed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsPacketsProcessed))
		i--
		dAtA[i] = 0x28
	}
	if m.ConntrackRegistersDropped != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConntrackRegistersDropped))
		i--
		dAtA[i] = 0x20
	}
	if m.ConntrackRegisters != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ConntrackRegisters))
		i--
		dAtA[i] = 0x18
	}
	if m.KprobesMissed != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.KprobesMissed))
		i--
		dAtA[i] = 0x10
	}
	if m.KprobesTriggered != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.KprobesTriggered))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RuntimeCompilationTelemetry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeCompilationTelemetry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RuntimeCompilationTelemetry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.KernelHeaderFetchResult != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.KernelHeaderFetchResult))
		i--
		dAtA[i] = 0x20
	}
	if m.RuntimeCompilationDuration != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.RuntimeCompilationDuration))
		i--
		dAtA[i] = 0x18
	}
	if m.RuntimeCompilationResult != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.RuntimeCompilationResult))
		i--
		dAtA[i] = 0x10
	}
	if m.RuntimeCompilationEnabled {
		i--
		if m.RuntimeCompilationEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *AgentConfiguration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AgentConfiguration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AgentConfiguration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CsmEnabled {
		i--
		if m.CsmEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.CcmEnabled {
		i--
		if m.CcmEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.DsmEnabled {
		i--
		if m.DsmEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.UsmEnabled {
		i--
		if m.UsmEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.NpmEnabled {
		i--
		if m.NpmEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Route) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Route) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Route) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Interface != nil {
		{
			size, err := m.Interface.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Subnet != nil {
		{
			size, err := m.Subnet.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintConnections(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Interface) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Interface) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Interface) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.HardwareAddr) > 0 {
		i -= len(m.HardwareAddr)
		copy(dAtA[i:], m.HardwareAddr)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.HardwareAddr)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Subnet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Subnet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Subnet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Alias) > 0 {
		i -= len(m.Alias)
		copy(dAtA[i:], m.Alias)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Alias)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RouteMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RouteMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.TagsModified != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagsModified))
		i--
		dAtA[i] = 0x18
	}
	if m.TagIndex != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.TagIndex))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Alias) > 0 {
		i -= len(m.Alias)
		copy(dAtA[i:], m.Alias)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Alias)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IPTranslation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPTranslation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IPTranslation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ReplDstPort != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ReplDstPort))
		i--
		dAtA[i] = 0x20
	}
	if m.ReplSrcPort != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.ReplSrcPort))
		i--
		dAtA[i] = 0x18
	}
	if len(m.ReplDstIP) > 0 {
		i -= len(m.ReplDstIP)
		copy(dAtA[i:], m.ReplDstIP)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.ReplDstIP)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ReplSrcIP) > 0 {
		i -= len(m.ReplSrcIP)
		copy(dAtA[i:], m.ReplSrcIP)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.ReplSrcIP)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Addr) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Addr) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Addr) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.HostName) > 0 {
		i -= len(m.HostName)
		copy(dAtA[i:], m.HostName)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.HostName)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Port != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Ip) > 0 {
		i -= len(m.Ip)
		copy(dAtA[i:], m.Ip)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Ip)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *ProtocolStack) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProtocolStack) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProtocolStack) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Stack) > 0 {
		for iNdEx := len(m.Stack) - 1; iNdEx >= 0; iNdEx-- {
			i = encodeVarintConnections(dAtA, i, uint64(m.Stack[iNdEx]))
			i--
			dAtA[i] = 0x8
		}
	}
	return len(dAtA) - i, nil
}

func (m *DNSEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DNSEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DNSEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Names) > 0 {
		for iNdEx := len(m.Names) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Names[iNdEx])
			copy(dAtA[i:], m.Names[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Names[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DNSStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DNSStats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DNSStats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DnsCountByRcode) > 0 {
		for k := range m.DnsCountByRcode {
			v := m.DnsCountByRcode[k]
			baseI := i
			i = encodeVarintConnections(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.DnsFailureLatencySum != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsFailureLatencySum))
		i--
		dAtA[i] = 0x18
	}
	if m.DnsSuccessLatencySum != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsSuccessLatencySum))
		i--
		dAtA[i] = 0x10
	}
	if m.DnsTimeouts != 0 {
		i = encodeVarintConnections(dAtA, i, uint64(m.DnsTimeouts))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DNSStatsByQueryType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DNSStatsByQueryType) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DNSStatsByQueryType) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DnsStatsByQueryType) > 0 {
		for k := range m.DnsStatsByQueryType {
			v := m.DnsStatsByQueryType[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintConnections(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintConnections(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintConnections(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PublicIpMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PublicIpMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PublicIpMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tags) > 0 {
		for iNdEx := len(m.Tags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Tags[iNdEx])
			copy(dAtA[i:], m.Tags[iNdEx])
			i = encodeVarintConnections(dAtA, i, uint64(len(m.Tags[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Region) > 0 {
		i -= len(m.Region)
		copy(dAtA[i:], m.Region)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Region)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.CloudProvider) > 0 {
		i -= len(m.CloudProvider)
		copy(dAtA[i:], m.CloudProvider)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.CloudProvider)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Ip) > 0 {
		i -= len(m.Ip)
		copy(dAtA[i:], m.Ip)
		i = encodeVarintConnections(dAtA, i, uint64(len(m.Ip)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintConnections(dAtA []byte, offset int, v uint64) int {
	offset -= sovConnections(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CollectorConnections) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if len(m.Connections) > 0 {
		for _, e := range m.Connections {
			l = e.Size()
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if m.GroupId != 0 {
		n += 1 + sovConnections(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovConnections(uint64(m.GroupSize))
	}
	if len(m.ResolvedResources) > 0 {
		for k, v := range m.ResolvedResources {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.ContainerForPid) > 0 {
		for k, v := range m.ContainerForPid {
			_ = k
			_ = v
			mapEntrySize := 1 + sovConnections(uint64(k)) + 1 + len(v) + sovConnections(uint64(len(v)))
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	l = len(m.EncodedTags)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.NetworkId)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.EncodedDNS)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.ContainerHostType != 0 {
		n += 1 + sovConnections(uint64(m.ContainerHostType))
	}
	if m.ConnTelemetry != nil {
		l = m.ConnTelemetry.Size()
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.Architecture)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.KernelVersion)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.Platform)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.PlatformVersion)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if len(m.CompilationTelemetryByAsset) > 0 {
		for k, v := range m.CompilationTelemetryByAsset {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.Domains) > 0 {
		for _, s := range m.Domains {
			l = len(s)
			n += 2 + l + sovConnections(uint64(l))
		}
	}
	if len(m.Routes) > 0 {
		for _, e := range m.Routes {
			l = e.Size()
			n += 2 + l + sovConnections(uint64(l))
		}
	}
	if len(m.RouteMetadata) > 0 {
		for _, e := range m.RouteMetadata {
			l = e.Size()
			n += 2 + l + sovConnections(uint64(l))
		}
	}
	if m.AgentConfiguration != nil {
		l = m.AgentConfiguration.Size()
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.EncodedDomainDatabase)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.EncodedDnsLookups)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.EncodedConnectionsTags)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if len(m.ConnTelemetryMap) > 0 {
		for k, v := range m.ConnTelemetryMap {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.ResolvedHostsByName) > 0 {
		for k, v := range m.ResolvedHostsByName {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.KernelHeaderFetchResult != 0 {
		n += 2 + sovConnections(uint64(m.KernelHeaderFetchResult))
	}
	if len(m.CORETelemetryByAsset) > 0 {
		for k, v := range m.CORETelemetryByAsset {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.PrebuiltEBPFAssets) > 0 {
		for _, s := range m.PrebuiltEBPFAssets {
			l = len(s)
			n += 2 + l + sovConnections(uint64(l))
		}
	}
	l = len(m.EcsTask)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if len(m.ResolvedPublicIps) > 0 {
		for k, v := range m.ResolvedPublicIps {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.HostTagsIndex != 0 {
		n += 2 + sovConnections(uint64(m.HostTagsIndex))
	}
	return n
}

func (m *Connections) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Conns) > 0 {
		for _, e := range m.Conns {
			l = e.Size()
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if len(m.Dns) > 0 {
		for k, v := range m.Dns {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.ConnTelemetry != nil {
		l = m.ConnTelemetry.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	if len(m.Domains) > 0 {
		for _, s := range m.Domains {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if len(m.Routes) > 0 {
		for _, e := range m.Routes {
			l = e.Size()
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if len(m.CompilationTelemetryByAsset) > 0 {
		for k, v := range m.CompilationTelemetryByAsset {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.AgentConfiguration != nil {
		l = m.AgentConfiguration.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if len(m.ConnTelemetryMap) > 0 {
		for k, v := range m.ConnTelemetryMap {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.KernelHeaderFetchResult != 0 {
		n += 1 + sovConnections(uint64(m.KernelHeaderFetchResult))
	}
	if len(m.CORETelemetryByAsset) > 0 {
		for k, v := range m.CORETelemetryByAsset {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovConnections(uint64(len(k))) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.PrebuiltEBPFAssets) > 0 {
		for _, s := range m.PrebuiltEBPFAssets {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	return n
}

func (m *Connection) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Pid != 0 {
		n += 1 + sovConnections(uint64(m.Pid))
	}
	if m.Laddr != nil {
		l = m.Laddr.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.Raddr != nil {
		l = m.Raddr.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.Family != 0 {
		n += 1 + sovConnections(uint64(m.Family))
	}
	if m.Type != 0 {
		n += 1 + sovConnections(uint64(m.Type))
	}
	if m.LastBytesSent != 0 {
		n += 2 + sovConnections(uint64(m.LastBytesSent))
	}
	if m.LastBytesReceived != 0 {
		n += 2 + sovConnections(uint64(m.LastBytesReceived))
	}
	if m.LastRetransmits != 0 {
		n += 2 + sovConnections(uint64(m.LastRetransmits))
	}
	if m.Direction != 0 {
		n += 2 + sovConnections(uint64(m.Direction))
	}
	if m.NetNS != 0 {
		n += 2 + sovConnections(uint64(m.NetNS))
	}
	if m.IpTranslation != nil {
		l = m.IpTranslation.Size()
		n += 2 + l + sovConnections(uint64(l))
	}
	if m.Rtt != 0 {
		n += 2 + sovConnections(uint64(m.Rtt))
	}
	if m.RttVar != 0 {
		n += 2 + sovConnections(uint64(m.RttVar))
	}
	if m.IntraHost {
		n += 3
	}
	if m.DnsSuccessfulResponses != 0 {
		n += 2 + sovConnections(uint64(m.DnsSuccessfulResponses))
	}
	if m.DnsFailedResponses != 0 {
		n += 2 + sovConnections(uint64(m.DnsFailedResponses))
	}
	if m.DnsTimeouts != 0 {
		n += 2 + sovConnections(uint64(m.DnsTimeouts))
	}
	if m.DnsSuccessLatencySum != 0 {
		n += 2 + sovConnections(uint64(m.DnsSuccessLatencySum))
	}
	if m.DnsFailureLatencySum != 0 {
		n += 2 + sovConnections(uint64(m.DnsFailureLatencySum))
	}
	if m.LastTcpEstablished != 0 {
		n += 2 + sovConnections(uint64(m.LastTcpEstablished))
	}
	if m.LastTcpClosed != 0 {
		n += 2 + sovConnections(uint64(m.LastTcpClosed))
	}
	l = len(m.RemoteNetworkId)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if len(m.DnsCountByRcode) > 0 {
		for k, v := range m.DnsCountByRcode {
			_ = k
			_ = v
			mapEntrySize := 1 + sovConnections(uint64(k)) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.DnsStatsByDomain) > 0 {
		for k, v := range m.DnsStatsByDomain {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + sovConnections(uint64(k)) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if m.RouteIdx != 0 {
		n += 2 + sovConnections(uint64(m.RouteIdx))
	}
	l = len(m.HttpAggregations)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if m.LastPacketsSent != 0 {
		n += 2 + sovConnections(uint64(m.LastPacketsSent))
	}
	if m.LastPacketsReceived != 0 {
		n += 2 + sovConnections(uint64(m.LastPacketsReceived))
	}
	if m.RouteTargetIdx != 0 {
		n += 2 + sovConnections(uint64(m.RouteTargetIdx))
	}
	if m.IsLocalPortEphemeral != 0 {
		n += 2 + sovConnections(uint64(m.IsLocalPortEphemeral))
	}
	if len(m.DnsStatsByDomainByQueryType) > 0 {
		for k, v := range m.DnsStatsByDomainByQueryType {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + sovConnections(uint64(k)) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.DnsStatsByDomainOffsetByQueryType) > 0 {
		for k, v := range m.DnsStatsByDomainOffsetByQueryType {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + sovConnections(uint64(k)) + l
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	if len(m.Tags) > 0 {
		for _, e := range m.Tags {
			n += 2 + sovConnections(uint64(e))
		}
	}
	if m.TagsIdx != 0 {
		n += 2 + sovConnections(uint64(m.TagsIdx))
	}
	if m.StateIndex != 0 {
		n += 2 + sovConnections(uint64(m.StateIndex))
	}
	if m.TagsChecksum != 0 {
		n += 2 + sovConnections(uint64(m.TagsChecksum))
	}
	if m.Protocol != nil {
		l = m.Protocol.Size()
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.DataStreamsAggregations)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.Http2Aggregations)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	l = len(m.DatabaseAggregations)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if len(m.TcpFailuresByErrCode) > 0 {
		for k, v := range m.TcpFailuresByErrCode {
			_ = k
			_ = v
			mapEntrySize := 1 + sovConnections(uint64(k)) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 2 + sovConnections(uint64(mapEntrySize))
		}
	}
	l = len(m.RemoteEcsTask)
	if l > 0 {
		n += 2 + l + sovConnections(uint64(l))
	}
	if m.LocalContainerTagsIndex != 0 {
		n += 2 + sovConnections(uint64(m.LocalContainerTagsIndex))
	}
	return n
}

func (m *ResourceMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.ByteKey)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	if m.TagIndex != 0 {
		n += 1 + sovConnections(uint64(m.TagIndex))
	}
	if m.TagsModified != 0 {
		n += 1 + sovConnections(uint64(m.TagsModified))
	}
	return n
}

func (m *ConnectionsTelemetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MonotonicKprobesTriggered != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicKprobesTriggered))
	}
	if m.MonotonicKprobesMissed != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicKprobesMissed))
	}
	if m.MonotonicConntrackRegisters != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicConntrackRegisters))
	}
	if m.MonotonicConntrackRegistersDropped != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicConntrackRegistersDropped))
	}
	if m.MonotonicDnsPacketsProcessed != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicDnsPacketsProcessed))
	}
	if m.MonotonicConnsClosed != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicConnsClosed))
	}
	if m.ConnsBpfMapSize != 0 {
		n += 1 + sovConnections(uint64(m.ConnsBpfMapSize))
	}
	if m.MonotonicUdpSendsProcessed != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicUdpSendsProcessed))
	}
	if m.MonotonicUdpSendsMissed != 0 {
		n += 1 + sovConnections(uint64(m.MonotonicUdpSendsMissed))
	}
	if m.ConntrackSamplingPercent != 0 {
		n += 1 + sovConnections(uint64(m.ConntrackSamplingPercent))
	}
	if m.DnsStatsDropped != 0 {
		n += 1 + sovConnections(uint64(m.DnsStatsDropped))
	}
	return n
}

func (m *CollectorConnectionsTelemetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KprobesTriggered != 0 {
		n += 1 + sovConnections(uint64(m.KprobesTriggered))
	}
	if m.KprobesMissed != 0 {
		n += 1 + sovConnections(uint64(m.KprobesMissed))
	}
	if m.ConntrackRegisters != 0 {
		n += 1 + sovConnections(uint64(m.ConntrackRegisters))
	}
	if m.ConntrackRegistersDropped != 0 {
		n += 1 + sovConnections(uint64(m.ConntrackRegistersDropped))
	}
	if m.DnsPacketsProcessed != 0 {
		n += 1 + sovConnections(uint64(m.DnsPacketsProcessed))
	}
	if m.ConnsClosed != 0 {
		n += 1 + sovConnections(uint64(m.ConnsClosed))
	}
	if m.ConnsBpfMapSize != 0 {
		n += 1 + sovConnections(uint64(m.ConnsBpfMapSize))
	}
	if m.UdpSendsProcessed != 0 {
		n += 1 + sovConnections(uint64(m.UdpSendsProcessed))
	}
	if m.UdpSendsMissed != 0 {
		n += 1 + sovConnections(uint64(m.UdpSendsMissed))
	}
	if m.ConntrackSamplingPercent != 0 {
		n += 1 + sovConnections(uint64(m.ConntrackSamplingPercent))
	}
	if m.DnsStatsDropped != 0 {
		n += 1 + sovConnections(uint64(m.DnsStatsDropped))
	}
	return n
}

func (m *RuntimeCompilationTelemetry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RuntimeCompilationEnabled {
		n += 2
	}
	if m.RuntimeCompilationResult != 0 {
		n += 1 + sovConnections(uint64(m.RuntimeCompilationResult))
	}
	if m.RuntimeCompilationDuration != 0 {
		n += 1 + sovConnections(uint64(m.RuntimeCompilationDuration))
	}
	if m.KernelHeaderFetchResult != 0 {
		n += 1 + sovConnections(uint64(m.KernelHeaderFetchResult))
	}
	return n
}

func (m *AgentConfiguration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NpmEnabled {
		n += 2
	}
	if m.UsmEnabled {
		n += 2
	}
	if m.DsmEnabled {
		n += 2
	}
	if m.CcmEnabled {
		n += 2
	}
	if m.CsmEnabled {
		n += 2
	}
	return n
}

func (m *Route) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Subnet != nil {
		l = m.Subnet.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.Interface != nil {
		l = m.Interface.Size()
		n += 1 + l + sovConnections(uint64(l))
	}
	return n
}

func (m *Interface) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.HardwareAddr)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	return n
}

func (m *Subnet) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Alias)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	return n
}

func (m *RouteMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Alias)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.TagIndex != 0 {
		n += 1 + sovConnections(uint64(m.TagIndex))
	}
	if m.TagsModified != 0 {
		n += 1 + sovConnections(uint64(m.TagsModified))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	return n
}

func (m *IPTranslation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ReplSrcIP)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.ReplDstIP)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.ReplSrcPort != 0 {
		n += 1 + sovConnections(uint64(m.ReplSrcPort))
	}
	if m.ReplDstPort != 0 {
		n += 1 + sovConnections(uint64(m.ReplDstPort))
	}
	return n
}

func (m *Addr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Ip)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovConnections(uint64(m.Port))
	}
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.HostName)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	return n
}

func (m *ProtocolStack) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Stack) > 0 {
		for _, e := range m.Stack {
			n += 1 + sovConnections(uint64(e))
		}
	}
	return n
}

func (m *DNSEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	return n
}

func (m *DNSStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DnsTimeouts != 0 {
		n += 1 + sovConnections(uint64(m.DnsTimeouts))
	}
	if m.DnsSuccessLatencySum != 0 {
		n += 1 + sovConnections(uint64(m.DnsSuccessLatencySum))
	}
	if m.DnsFailureLatencySum != 0 {
		n += 1 + sovConnections(uint64(m.DnsFailureLatencySum))
	}
	if len(m.DnsCountByRcode) > 0 {
		for k, v := range m.DnsCountByRcode {
			_ = k
			_ = v
			mapEntrySize := 1 + sovConnections(uint64(k)) + 1 + sovConnections(uint64(v))
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *DNSStatsByQueryType) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DnsStatsByQueryType) > 0 {
		for k, v := range m.DnsStatsByQueryType {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovConnections(uint64(l))
			}
			mapEntrySize := 1 + sovConnections(uint64(k)) + l
			n += mapEntrySize + 1 + sovConnections(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *PublicIpMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Ip)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.CloudProvider)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovConnections(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovConnections(uint64(l))
		}
	}
	return n
}

func sovConnections(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozConnections(x uint64) (n int) {
	return sovConnections(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CollectorConnections) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectorConnections: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectorConnections: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connections", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Connections = append(m.Connections, &Connection{})
			if err := m.Connections[len(m.Connections)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			m.GroupId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupSize", wireType)
			}
			m.GroupSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResolvedResources == nil {
				m.ResolvedResources = make(map[string]*ResourceMetadata)
			}
			var mapkey string
			var mapvalue *ResourceMetadata
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ResourceMetadata{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResolvedResources[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerForPid", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerForPid == nil {
				m.ContainerForPid = make(map[int32]string)
			}
			var mapkey int32
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ContainerForPid[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedTags", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodedTags = append(m.EncodedTags[:0], dAtA[iNdEx:postIndex]...)
			if m.EncodedTags == nil {
				m.EncodedTags = []byte{}
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedDNS", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodedDNS = append(m.EncodedDNS[:0], dAtA[iNdEx:postIndex]...)
			if m.EncodedDNS == nil {
				m.EncodedDNS = []byte{}
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerHostType", wireType)
			}
			m.ContainerHostType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ContainerHostType |= ContainerHostType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnTelemetry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnTelemetry == nil {
				m.ConnTelemetry = &CollectorConnectionsTelemetry{}
			}
			if err := m.ConnTelemetry.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Architecture", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Architecture = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KernelVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platform", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Platform = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PlatformVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PlatformVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompilationTelemetryByAsset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompilationTelemetryByAsset == nil {
				m.CompilationTelemetryByAsset = make(map[string]*RuntimeCompilationTelemetry)
			}
			var mapkey string
			var mapvalue *RuntimeCompilationTelemetry
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &RuntimeCompilationTelemetry{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CompilationTelemetryByAsset[mapkey] = mapvalue
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Domains", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Domains = append(m.Domains, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Routes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Routes = append(m.Routes, &Route{})
			if err := m.Routes[len(m.Routes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RouteMetadata = append(m.RouteMetadata, &RouteMetadata{})
			if err := m.RouteMetadata[len(m.RouteMetadata)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentConfiguration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentConfiguration == nil {
				m.AgentConfiguration = &AgentConfiguration{}
			}
			if err := m.AgentConfiguration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedDomainDatabase", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodedDomainDatabase = append(m.EncodedDomainDatabase[:0], dAtA[iNdEx:postIndex]...)
			if m.EncodedDomainDatabase == nil {
				m.EncodedDomainDatabase = []byte{}
			}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedDnsLookups", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodedDnsLookups = append(m.EncodedDnsLookups[:0], dAtA[iNdEx:postIndex]...)
			if m.EncodedDnsLookups == nil {
				m.EncodedDnsLookups = []byte{}
			}
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodedConnectionsTags", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodedConnectionsTags = append(m.EncodedConnectionsTags[:0], dAtA[iNdEx:postIndex]...)
			if m.EncodedConnectionsTags == nil {
				m.EncodedConnectionsTags = []byte{}
			}
			iNdEx = postIndex
		case 39:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnTelemetryMap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnTelemetryMap == nil {
				m.ConnTelemetryMap = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ConnTelemetryMap[mapkey] = mapvalue
			iNdEx = postIndex
		case 40:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedHostsByName", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResolvedHostsByName == nil {
				m.ResolvedHostsByName = make(map[string]*Host)
			}
			var mapkey string
			var mapvalue *Host
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Host{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResolvedHostsByName[mapkey] = mapvalue
			iNdEx = postIndex
		case 41:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelHeaderFetchResult", wireType)
			}
			m.KernelHeaderFetchResult = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KernelHeaderFetchResult |= KernelHeaderFetchResult(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CORETelemetryByAsset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CORETelemetryByAsset == nil {
				m.CORETelemetryByAsset = make(map[string]COREResult)
			}
			var mapkey string
			var mapvalue COREResult
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= COREResult(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CORETelemetryByAsset[mapkey] = mapvalue
			iNdEx = postIndex
		case 44:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrebuiltEBPFAssets", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrebuiltEBPFAssets = append(m.PrebuiltEBPFAssets, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 45:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EcsTask", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EcsTask = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 46:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedPublicIps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResolvedPublicIps == nil {
				m.ResolvedPublicIps = make(map[string]*PublicIpMetadata)
			}
			var mapkey string
			var mapvalue *PublicIpMetadata
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &PublicIpMetadata{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResolvedPublicIps[mapkey] = mapvalue
			iNdEx = postIndex
		case 47:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostTagsIndex", wireType)
			}
			m.HostTagsIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HostTagsIndex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connections) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Connections: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Connections: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Conns = append(m.Conns, &Connection{})
			if err := m.Conns[len(m.Conns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dns == nil {
				m.Dns = make(map[string]*DNSEntry)
			}
			var mapkey string
			var mapvalue *DNSEntry
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DNSEntry{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dns[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnTelemetry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnTelemetry == nil {
				m.ConnTelemetry = &ConnectionsTelemetry{}
			}
			if err := m.ConnTelemetry.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Domains", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Domains = append(m.Domains, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Routes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Routes = append(m.Routes, &Route{})
			if err := m.Routes[len(m.Routes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompilationTelemetryByAsset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompilationTelemetryByAsset == nil {
				m.CompilationTelemetryByAsset = make(map[string]*RuntimeCompilationTelemetry)
			}
			var mapkey string
			var mapvalue *RuntimeCompilationTelemetry
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &RuntimeCompilationTelemetry{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CompilationTelemetryByAsset[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentConfiguration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AgentConfiguration == nil {
				m.AgentConfiguration = &AgentConfiguration{}
			}
			if err := m.AgentConfiguration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnTelemetryMap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnTelemetryMap == nil {
				m.ConnTelemetryMap = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ConnTelemetryMap[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelHeaderFetchResult", wireType)
			}
			m.KernelHeaderFetchResult = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KernelHeaderFetchResult |= KernelHeaderFetchResult(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CORETelemetryByAsset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CORETelemetryByAsset == nil {
				m.CORETelemetryByAsset = make(map[string]COREResult)
			}
			var mapkey string
			var mapvalue COREResult
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthConnections
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= COREResult(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CORETelemetryByAsset[mapkey] = mapvalue
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrebuiltEBPFAssets", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrebuiltEBPFAssets = append(m.PrebuiltEBPFAssets, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Connection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Connection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pid", wireType)
			}
			m.Pid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Pid |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Laddr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Laddr == nil {
				m.Laddr = &Addr{}
			}
			if err := m.Laddr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Raddr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Raddr == nil {
				m.Raddr = &Addr{}
			}
			if err := m.Raddr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Family", wireType)
			}
			m.Family = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Family |= ConnectionFamily(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= ConnectionType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastBytesSent", wireType)
			}
			m.LastBytesSent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastBytesSent |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastBytesReceived", wireType)
			}
			m.LastBytesReceived = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastBytesReceived |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRetransmits", wireType)
			}
			m.LastRetransmits = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastRetransmits |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Direction", wireType)
			}
			m.Direction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Direction |= ConnectionDirection(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetNS", wireType)
			}
			m.NetNS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NetNS |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpTranslation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IpTranslation == nil {
				m.IpTranslation = &IPTranslation{}
			}
			if err := m.IpTranslation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rtt", wireType)
			}
			m.Rtt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Rtt |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RttVar", wireType)
			}
			m.RttVar = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RttVar |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntraHost", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IntraHost = bool(v != 0)
		case 25:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsSuccessfulResponses", wireType)
			}
			m.DnsSuccessfulResponses = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsSuccessfulResponses |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsFailedResponses", wireType)
			}
			m.DnsFailedResponses = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsFailedResponses |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsTimeouts", wireType)
			}
			m.DnsTimeouts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsTimeouts |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 28:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsSuccessLatencySum", wireType)
			}
			m.DnsSuccessLatencySum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsSuccessLatencySum |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 29:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsFailureLatencySum", wireType)
			}
			m.DnsFailureLatencySum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsFailureLatencySum |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 30:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastTcpEstablished", wireType)
			}
			m.LastTcpEstablished = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastTcpEstablished |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 31:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastTcpClosed", wireType)
			}
			m.LastTcpClosed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastTcpClosed |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteNetworkId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteNetworkId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsCountByRcode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsCountByRcode == nil {
				m.DnsCountByRcode = make(map[uint32]uint32)
			}
			var mapkey uint32
			var mapvalue uint32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsCountByRcode[mapkey] = mapvalue
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsByDomain", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsStatsByDomain == nil {
				m.DnsStatsByDomain = make(map[int32]*DNSStats)
			}
			var mapkey int32
			var mapvalue *DNSStats
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DNSStats{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsStatsByDomain[mapkey] = mapvalue
			iNdEx = postIndex
		case 36:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteIdx", wireType)
			}
			m.RouteIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RouteIdx |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpAggregations", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpAggregations = append(m.HttpAggregations[:0], dAtA[iNdEx:postIndex]...)
			if m.HttpAggregations == nil {
				m.HttpAggregations = []byte{}
			}
			iNdEx = postIndex
		case 38:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastPacketsSent", wireType)
			}
			m.LastPacketsSent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastPacketsSent |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 39:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastPacketsReceived", wireType)
			}
			m.LastPacketsReceived = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastPacketsReceived |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 40:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteTargetIdx", wireType)
			}
			m.RouteTargetIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RouteTargetIdx |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 41:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsLocalPortEphemeral", wireType)
			}
			m.IsLocalPortEphemeral = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IsLocalPortEphemeral |= EphemeralPortState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 42:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsByDomainByQueryType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsStatsByDomainByQueryType == nil {
				m.DnsStatsByDomainByQueryType = make(map[int32]*DNSStatsByQueryType)
			}
			var mapkey int32
			var mapvalue *DNSStatsByQueryType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DNSStatsByQueryType{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsStatsByDomainByQueryType[mapkey] = mapvalue
			iNdEx = postIndex
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsByDomainOffsetByQueryType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsStatsByDomainOffsetByQueryType == nil {
				m.DnsStatsByDomainOffsetByQueryType = make(map[int32]*DNSStatsByQueryType)
			}
			var mapkey int32
			var mapvalue *DNSStatsByQueryType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DNSStatsByQueryType{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsStatsByDomainOffsetByQueryType[mapkey] = mapvalue
			iNdEx = postIndex
		case 44:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Tags = append(m.Tags, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthConnections
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthConnections
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Tags) == 0 {
					m.Tags = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Tags = append(m.Tags, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
		case 45:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagsIdx", wireType)
			}
			m.TagsIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagsIdx |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 46:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StateIndex", wireType)
			}
			m.StateIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StateIndex |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 47:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagsChecksum", wireType)
			}
			m.TagsChecksum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagsChecksum |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 48:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Protocol == nil {
				m.Protocol = &ProtocolStack{}
			}
			if err := m.Protocol.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 49:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataStreamsAggregations", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataStreamsAggregations = append(m.DataStreamsAggregations[:0], dAtA[iNdEx:postIndex]...)
			if m.DataStreamsAggregations == nil {
				m.DataStreamsAggregations = []byte{}
			}
			iNdEx = postIndex
		case 50:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http2Aggregations", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Http2Aggregations = append(m.Http2Aggregations[:0], dAtA[iNdEx:postIndex]...)
			if m.Http2Aggregations == nil {
				m.Http2Aggregations = []byte{}
			}
			iNdEx = postIndex
		case 51:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatabaseAggregations", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DatabaseAggregations = append(m.DatabaseAggregations[:0], dAtA[iNdEx:postIndex]...)
			if m.DatabaseAggregations == nil {
				m.DatabaseAggregations = []byte{}
			}
			iNdEx = postIndex
		case 52:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpFailuresByErrCode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpFailuresByErrCode == nil {
				m.TcpFailuresByErrCode = make(map[uint32]uint32)
			}
			var mapkey uint32
			var mapvalue uint32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TcpFailuresByErrCode[mapkey] = mapvalue
			iNdEx = postIndex
		case 53:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteEcsTask", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RemoteEcsTask = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 54:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalContainerTagsIndex", wireType)
			}
			m.LocalContainerTagsIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LocalContainerTagsIndex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ByteKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ByteKey = append(m.ByteKey[:0], dAtA[iNdEx:postIndex]...)
			if m.ByteKey == nil {
				m.ByteKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagIndex", wireType)
			}
			m.TagIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagIndex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagsModified", wireType)
			}
			m.TagsModified = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagsModified |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectionsTelemetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectionsTelemetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectionsTelemetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicKprobesTriggered", wireType)
			}
			m.MonotonicKprobesTriggered = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicKprobesTriggered |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicKprobesMissed", wireType)
			}
			m.MonotonicKprobesMissed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicKprobesMissed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicConntrackRegisters", wireType)
			}
			m.MonotonicConntrackRegisters = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicConntrackRegisters |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicConntrackRegistersDropped", wireType)
			}
			m.MonotonicConntrackRegistersDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicConntrackRegistersDropped |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicDnsPacketsProcessed", wireType)
			}
			m.MonotonicDnsPacketsProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicDnsPacketsProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicConnsClosed", wireType)
			}
			m.MonotonicConnsClosed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicConnsClosed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnsBpfMapSize", wireType)
			}
			m.ConnsBpfMapSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConnsBpfMapSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicUdpSendsProcessed", wireType)
			}
			m.MonotonicUdpSendsProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicUdpSendsProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonotonicUdpSendsMissed", wireType)
			}
			m.MonotonicUdpSendsMissed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MonotonicUdpSendsMissed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConntrackSamplingPercent", wireType)
			}
			m.ConntrackSamplingPercent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConntrackSamplingPercent |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsDropped", wireType)
			}
			m.DnsStatsDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsStatsDropped |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CollectorConnectionsTelemetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectorConnectionsTelemetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectorConnectionsTelemetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KprobesTriggered", wireType)
			}
			m.KprobesTriggered = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KprobesTriggered |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KprobesMissed", wireType)
			}
			m.KprobesMissed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KprobesMissed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConntrackRegisters", wireType)
			}
			m.ConntrackRegisters = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConntrackRegisters |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConntrackRegistersDropped", wireType)
			}
			m.ConntrackRegistersDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConntrackRegistersDropped |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsPacketsProcessed", wireType)
			}
			m.DnsPacketsProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsPacketsProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnsClosed", wireType)
			}
			m.ConnsClosed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConnsClosed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnsBpfMapSize", wireType)
			}
			m.ConnsBpfMapSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConnsBpfMapSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UdpSendsProcessed", wireType)
			}
			m.UdpSendsProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UdpSendsProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UdpSendsMissed", wireType)
			}
			m.UdpSendsMissed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UdpSendsMissed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConntrackSamplingPercent", wireType)
			}
			m.ConntrackSamplingPercent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConntrackSamplingPercent |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsDropped", wireType)
			}
			m.DnsStatsDropped = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsStatsDropped |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuntimeCompilationTelemetry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RuntimeCompilationTelemetry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RuntimeCompilationTelemetry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeCompilationEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RuntimeCompilationEnabled = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeCompilationResult", wireType)
			}
			m.RuntimeCompilationResult = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RuntimeCompilationResult |= RuntimeCompilationResult(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeCompilationDuration", wireType)
			}
			m.RuntimeCompilationDuration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RuntimeCompilationDuration |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KernelHeaderFetchResult", wireType)
			}
			m.KernelHeaderFetchResult = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KernelHeaderFetchResult |= KernelHeaderFetchResult(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AgentConfiguration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AgentConfiguration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AgentConfiguration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NpmEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NpmEnabled = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsmEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UsmEnabled = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DsmEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DsmEnabled = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CcmEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CcmEnabled = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CsmEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CsmEnabled = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Route) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Route: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Route: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subnet", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subnet == nil {
				m.Subnet = &Subnet{}
			}
			if err := m.Subnet.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interface", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Interface == nil {
				m.Interface = &Interface{}
			}
			if err := m.Interface.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Interface) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Interface: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Interface: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HardwareAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HardwareAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Subnet) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subnet: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subnet: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alias", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alias = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Alias", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Alias = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagIndex", wireType)
			}
			m.TagIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagIndex |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagsModified", wireType)
			}
			m.TagsModified = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TagsModified |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPTranslation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPTranslation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPTranslation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplSrcIP", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplSrcIP = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplDstIP", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReplDstIP = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplSrcPort", wireType)
			}
			m.ReplSrcPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplSrcPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplDstPort", wireType)
			}
			m.ReplDstPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplDstPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Addr) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Addr: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Addr: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ip = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProtocolStack) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProtocolStack: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProtocolStack: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v ProtocolType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= ProtocolType(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Stack = append(m.Stack, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthConnections
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthConnections
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Stack) == 0 {
					m.Stack = make([]ProtocolType, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v ProtocolType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= ProtocolType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Stack = append(m.Stack, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Stack", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DNSEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DNSEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DNSEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Names = append(m.Names, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DNSStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DNSStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DNSStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsTimeouts", wireType)
			}
			m.DnsTimeouts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsTimeouts |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsSuccessLatencySum", wireType)
			}
			m.DnsSuccessLatencySum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsSuccessLatencySum |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsFailureLatencySum", wireType)
			}
			m.DnsFailureLatencySum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsFailureLatencySum |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsCountByRcode", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsCountByRcode == nil {
				m.DnsCountByRcode = make(map[uint32]uint32)
			}
			var mapkey uint32
			var mapvalue uint32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsCountByRcode[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DNSStatsByQueryType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DNSStatsByQueryType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DNSStatsByQueryType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsStatsByQueryType", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsStatsByQueryType == nil {
				m.DnsStatsByQueryType = make(map[int32]*DNSStats)
			}
			var mapkey int32
			var mapvalue *DNSStats
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConnections
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConnections
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConnections
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthConnections
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DNSStats{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConnections(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthConnections
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DnsStatsByQueryType[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PublicIpMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PublicIpMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PublicIpMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ip = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloudProvider", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CloudProvider = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConnections
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConnections
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConnections(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthConnections
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConnections(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConnections
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConnections
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConnections
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupConnections
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthConnections
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthConnections        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConnections          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupConnections = fmt.Errorf("proto: unexpected end of group")
)
