---
canonical: https://grafana.com/docs/alloy/latest/troubleshoot/support_bundle/
description: Learn how to generate a support bundle
title: Generate a support bundle
menuTitle: Generate a support bundle
weight: 300
---

# Generate a support bundle

{{< admonition type="note" >}}
Generate support bundle isn't available on {{< param "PRODUCT_NAME" >}} v1.4 and older.
{{< /admonition >}}

The `/-/support?duration=N` endpoint returns a support bundle, a compressed file that contains information
about a running {{< param "PRODUCT_NAME" >}} instance, and can be used as a baseline of information when trying
to debug an [issue][alloy-repo].

This feature isn't covered by the [backward-compatibility][backward-compatibility] guarantees.

{{< admonition type="note" >}}
This endpoint is enabled by default, but may be disabled using the `--disable-support-bundle` runtime flag.
{{< /admonition >}}

The duration parameter is optional, must be less than or equal to the
configured HTTP server write timeout, and if not provided, defaults to it.
The endpoint is only exposed to the {{< param "PRODUCT_NAME" >}} HTTP server listen address, which
defaults to `localhost:12345`.

The support bundle contains all information in plain text, so you can
inspect it before sharing to verify that no sensitive information has leaked.

In addition, you can inspect the [support bundle implementation](https://github.com/grafana/alloy/blob/main/internal/service/http/supportbundle.go)
to verify the code used to generate these bundles.

A support bundle contains the following data:

* `alloy-components.json` contains information about the [components][components] running on this {{< param "PRODUCT_NAME" >}} instance, generated by the `/api/v0/web/components` endpoint.
* `alloy-environment.txt` contains the values of several environment variables relevant to the golang runtime.
* `alloy-logs.txt` contains the logs during the bundle generation.
* `alloy-metadata.yaml` contains the {{< param "PRODUCT_NAME" >}} build version and the installation's operating system, architecture, and uptime.
* `alloy-metrics-sample-start.txt` contains a snapshot of the internal metrics for {{< param "PRODUCT_NAME" >}} at the start of the bundle collection.
* `alloy-metrics-sample-end.txt` contains a snapshot of the internal metrics for {{< param "PRODUCT_NAME" >}} at the end of the bundle collection.
* `alloy-peers.json` contains information about the identified cluster peers of this {{< param "PRODUCT_NAME" >}} instance, generated by the `/api/v0/web/peers` endpoint.
* `alloy-runtime-flags.txt` contains the values of the runtime flags available in {{< param "PRODUCT_NAME" >}}.
* The `pprof/` directory contains Go runtime profiling data (CPU, heap, goroutine, mutex, block profiles) as exported by the pprof package.
Refer to the [profile][profile] documentation for more details on how to use this information.
* The `sources/` directory contains copies of the local configuration files used to configure {{< param "PRODUCT_NAME" >}}.
* `sources/remote-config/remote.alloy` contains a copy of the last received [remote configuration][remotecfg].

[profile]: ../profile/
[components]: ../../get-started/components/
[alloy-repo]: https://github.com/grafana/alloy/issues/
[backward-compatibility]: ../../introduction/backward-compatibility/
[remotecfg]: ../../reference/config-blocks/remotecfg/
