---
canonical: https://grafana.com/docs/alloy/latest/reference/components/loki/loki.source.kubernetes_events/
aliases:
  - ../loki.source.kubernetes_events/ # /docs/alloy/latest/reference/components/loki.source.kubernetes_events/
description: Learn about loki.source.kubernetes_events
labels:
  stage: general-availability
  products:
    - oss
title: loki.source.kubernetes_events
---

# `loki.source.kubernetes_events`

`loki.source.kubernetes_events` tails events from the Kubernetes API and converts them into log lines to forward to other `loki` components.

You can specify multiple `loki.source.kubernetes_events` components by giving them different labels.

## Usage

```alloy
loki.source.kubernetes_events "<LABEL>" {
  forward_to = <RECEIVER_LIST>
}
```

## Arguments

The component starts a new reader for each of the given `targets` and fans out log entries to the list of receivers passed in `forward_to`.

You can use the following arguments with `loki.source.kubernetes_events`:

| Name         | Type                 | Description                                      | Default                           | Required |
| ------------ | -------------------- | ------------------------------------------------ | --------------------------------- | -------- |
| `forward_to` | `list(LogsReceiver)` | List of receivers to send log entries to.        |                                   | yes      |
| `job_name`   | `string`             | Value to use for `job` label for generated logs. | `"loki.source.kubernetes_events"` | no       |
| `log_format` | `string`             | Format of the log.                               | `"logfmt"`                        | no       |
| `namespaces` | `list(string)`       | Namespaces to watch for Events in.               | `[]`                              | no       |

By default, `loki.source.kubernetes_events` watches for events in all namespaces.
A list of explicit namespaces to watch can be provided in the `namespaces` argument.

By default, the generated log lines are in the `logfmt` format.
Use the `log_format` argument to change it to `json`.
These formats are also names of LogQL parsers, which can be used for processing the logs.

{{< admonition type="note" >}}
When watching all namespaces, {{< param "PRODUCT_NAME" >}} must have permissions to watch events at the cluster scope (such as using a ClusterRoleBinding).
If an explicit list of namespaces is provided, {{< param "PRODUCT_NAME" >}} only needs permissions to watch events for those namespaces.
{{< /admonition >}}

Log lines generated by `loki.source.kubernetes_events` have the following labels:

* `namespace`: Namespace of the Kubernetes object involved in the event.
* `job`: Value specified by the `job_name` argument.
* `instance`: Value matching the component ID.

If `job_name` argument is the empty string, the component will fail to load.
To remove the job label, forward the output of `loki.source.kubernetes_events` to [a `loki.relabel` component][loki.relabel].

For compatibility with the `eventhandler` integration from static mode, `job_name` can be set to `"integrations/kubernetes/eventhandler"`.

[loki.relabel]: ../loki.relabel/

## Blocks

You can use the following blocks with `loki.source.kubernetes_events`:

| Block                                            | Description                                                | Required |
| ------------------------------------------------ | ---------------------------------------------------------- | -------- |
| [`client`][client]                               | Configures Kubernetes client used to tail events.          | no       |
| `client` > [`authorization`][authorization]      | Configure generic authorization to the endpoint.           | no       |
| `client` > [`basic_auth`][basic_auth]            | Configure `basic_auth` for authenticating to the endpoint. | no       |
| `client` > [`oauth2`][oauth2]                    | Configure OAuth 2.0 for authenticating to the endpoint.    | no       |
| `client` > `oauth2` > [`tls_config`][tls_config] | Configure TLS settings for connecting to the endpoint.     | no       |
| `client` > [`tls_config`][tls_config]            | Configure TLS settings for connecting to the endpoint.     | no       |

The > symbol indicates deeper levels of nesting.
For example, `client` > `basic_auth` refers to a `basic_auth` block defined inside a `client` block.

[authorization]: #authorization
[basic_auth]: #basic_auth
[client]: #client
[oauth2]: #oauth2
[tls_config]: #tls_config

### `client`

The `client` block configures the Kubernetes client used to tail logs from containers.
If the `client` block isn't provided, the default in-cluster configuration with the service account of the running {{< param "PRODUCT_NAME" >}} Pod is used.

The following arguments are supported:

| Name                     | Type                | Description                                                                                      | Default | Required |
| ------------------------ | ------------------- | ------------------------------------------------------------------------------------------------ | ------- | -------- |
| `api_server`             | `string`            | URL of the Kubernetes API server.                                                                |         | no       |
| `bearer_token_file`      | `string`            | File containing a bearer token to authenticate with.                                             |         | no       |
| `bearer_token`           | `secret`            | Bearer token to authenticate with.                                                               |         | no       |
| `enable_http2`           | `bool`              | Whether HTTP2 is supported for requests.                                                         | `true`  | no       |
| `follow_redirects`       | `bool`              | Whether redirects returned by the server should be followed.                                     | `true`  | no       |
| `http_headers`           | `map(list(secret))` | Custom HTTP headers to be sent along with each request. The map key is the header name.          |         | no       |
| `kubeconfig_file`        | `string`            | Path of the `kubeconfig` file to use for connecting to Kubernetes.                               |         | no       |
| `no_proxy`               | `string`            | Comma-separated list of IP addresses, CIDR notations, and domain names to exclude from proxying. |         | no       |
| `proxy_connect_header`   | `map(list(secret))` | Specifies headers to send to proxies during CONNECT requests.                                    |         | no       |
| `proxy_from_environment` | `bool`              | Use the proxy URL indicated by environment variables.                                            | `false` | no       |
| `proxy_url`              | `string`            | HTTP proxy to send requests through.                                                             |         | no       |

 At most, one of the following can be provided:

* [`authorization`][authorization] block
* [`basic_auth`][basic_auth] block
* [`bearer_token_file`][client] argument
* [`bearer_token`][client] argument
* [`oauth2`][oauth2] block

{{< docs/shared lookup="reference/components/http-client-proxy-config-description.md" source="alloy" version="<ALLOY_VERSION>" >}}

### `authorization`

{{< docs/shared lookup="reference/components/authorization-block.md" source="alloy" version="<ALLOY_VERSION>" >}}

### `basic_auth`

{{< docs/shared lookup="reference/components/basic-auth-block.md" source="alloy" version="<ALLOY_VERSION>" >}}

### `oauth2`

{{< docs/shared lookup="reference/components/oauth2-block.md" source="alloy" version="<ALLOY_VERSION>" >}}

### `tls_config`

{{< docs/shared lookup="reference/components/tls-config-block.md" source="alloy" version="<ALLOY_VERSION>" >}}

## Exported fields

`loki.source.kubernetes_events` doesn't export any fields.

## Component health

`loki.source.kubernetes_events` is only reported as unhealthy if given an invalid configuration.

## Debug information

`loki.source.kubernetes_events` exposes the most recently read timestamp for events in each watched namespace.

## Debug metrics

`loki.source.kubernetes_events` doesn't expose any component-specific debug metrics.

## Component behavior

The component uses its data path, a directory named after the domain's fully qualified name, to store its _positions file_.
The positions file is used to store read offsets, so that if a component or {{< param "PRODUCT_NAME" >}} restarts, `loki.source.kubernetes_events` can pick up tailing from the same spot.

The data path is inside the directory configured by the `--storage.path` [command line argument][cmd-args].

[cmd-args]: ../../../cli/run/

## Example

This example collects watches events in the `kube-system` namespace and forwards them to a `loki.write` component so they're written to Loki.

```alloy
loki.source.kubernetes_events "example" {
  // Only watch for events in the kube-system namespace.
  namespaces = ["kube-system"]

  forward_to = [loki.write.local.receiver]
}

loki.write "local" {
  endpoint {
    url = sys.env("LOKI_URL")
  }
}
```

<!-- START GENERATED COMPATIBLE COMPONENTS -->

## Compatible components

`loki.source.kubernetes_events` can accept arguments from the following components:

- Components that export [Loki `LogsReceiver`](../../../compatibility/#loki-logsreceiver-exporters)


{{< admonition type="note" >}}
Connecting some components may not be sensible or components may require further configuration to make the connection work correctly.
Refer to the linked documentation for more details.
{{< /admonition >}}

<!-- END GENERATED COMPATIBLE COMPONENTS -->
