# Version

Grafana Alloy uses Semantic Versioning. The next version can be determined
by looking at the current version and incrementing it.

## Version

To determine the `VERSION` for a Stable Release or Patch Release, use the Semantic Version `vX.Y.Z`.

To determine the `VERSION` for a Release Candidate, append `-rc.#` to the Semantic Version.

- Examples
  - For example, `v0.31.0` is the Stable Release `VERSION` for the v0.31.0 release.
  - For example, `v0.31.1` is the first Patch Release `VERSION` for the v0.31.0 release.
  - For example, `v0.31.0-rc.0` is the first Release Candidate `VERSION` for the v0.31.0 release.

## Version Prefix

To determine the `VERSION PREFIX`, use only the major and minor version `vX.Y`.

- Examples
  - `v0.31`
