package Agar::Event;

use strict;
use Agar;

1;

__END__

=head1 NAME

Agar::Event - events generated by instances of Agar::Object

=head1 SYNOPSIS

  use Agar;
  use Agar::Event;

=head1 DESCRIPTION

This is the object type that is passed to event handler subroutines.

=head1 METHODS

=item B<$name = $event-E<gt>name()>

Returns a string identifying the event's type.

=item B<$obj = $event-E<gt>receiver()>

Returns the Agar::Object which received this event.

=item B<$obj = $event-E<gt>sender()>

Returns the Agar::Object which sent this event, if there was one, otherwise
undef.

=item B<$arg = $event-E<gt>ptr($index)>

=item B<$arg = $event-E<gt>object($index)>

=item B<$arg = $event-E<gt>string($index)>

=item B<$arg = $event-E<gt>int($index)>

=item B<$arg = $event-E<gt>Uint($index)>

=item B<$arg = $event-E<gt>long($index)>

=item B<$arg = $event-E<gt>Ulong($index)>

=item B<$arg = $event-E<gt>float($index)>

=item B<$arg = $event-E<gt>double($index)>

Each of these methods returns the argument of the specified type at the
specified index in the event's argument list (counting from 1).
Returns undef if the index is out of bounds or the type doesn't match.

=item B<$arg = $event-E<gt>ptrNamed($name)>

=item B<$arg = $event-E<gt>objectNamed($name)>

=item B<$arg = $event-E<gt>stringNamed($name)>

=item B<$arg = $event-E<gt>intNamed($name)>

=item B<$arg = $event-E<gt>UintNamed($name)>

=item B<$arg = $event-E<gt>longNamed($name)>

=item B<$arg = $event-E<gt>UlongNamed($name)>

=item B<$arg = $event-E<gt>floatNamed($name)>

=item B<$arg = $event-E<gt>doubleNamed($name)>

Each of these methods returns the named argument of the specified type.
If there are no arguments of the given name, undef is returned.

=over 4

=back

=head1 AUTHOR

Mat Sutcliffe E<lt>F<oktal@gmx.co.uk>E<gt>

Julien Nadeau Carriere E<lt>F<vedge@csoft.net>E<gt>

=head1 SEE ALSO

L<Agar(3)>, L<Agar::Object(3)>

=cut
