/*
 *  gblc - (G)ude (B)ootloader(L)oader (C)lient
 *
 *  $Id$
 *
 *  Copyright (C) 2006, 2007,
 *    Martin Bachem, Gude Analog- und Digitalsysteme GmbH
 *    info@gudeads.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version
 *  2 of the License, or (at your option) any later version.
 *
 */

/* console output channels for printl */
#define INFO    0
#define WARN    1
#define ERROR   2
#define DEBUG   3


#define TICKS_PER_SEC   1000000
#define MAC_CACHE_SZ    255

void printl(unsigned int channel, char *s, ...);
unsigned char xor_sum(unsigned char * data, int len);
void hex_dump(unsigned char indent, unsigned char *buf, int len);
unsigned char inet_addr_valid(unsigned char * addr);
unsigned long long GetTickCount(void);
unsigned char inet_empty(struct in_addr * addr);
int is_mac_cache(unsigned long long mac);
extern unsigned long long mac_cache[MAC_CACHE_SZ];

// byte order makros
#ifdef __linux__
#define cpu_to_be16(x) __cpu_to_be16(x)
#define be16_to_cpu(x) __be16_to_cpu(x)
#define cpu_to_be32(x) __cpu_to_be32(x)
#define be32_to_cpu(x) __be32_to_cpu(x)
#else
#define cpu_to_be16(x) htons(x)
#define be16_to_cpu(x) ntohs(x)
#define cpu_to_be32(x) htonl(x)
#define be32_to_cpu(x) ntohl(x)
#endif /* __linux__ */
