/*
 *  gblc - (G)ude (B)ootloader(L)oader (C)lient
 *
 *  $Id$
 *
 *  Copyright (C) 2006, 2007,
 *    Martin Bachem, Gude Analog- und Digitalsysteme GmbH
 *    info@gudeads.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version
 *  2 of the License, or (at your option) any later version.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <netinet/in.h>
#include <sys/time.h>
#include "gblc.h"
#include "helper.h"


unsigned long long mac_cache[MAC_CACHE_SZ];

int is_mac_cache(unsigned long long mac) {
    int i, ni;
    i = 0;
    ni = 0;
    while (i < MAC_CACHE_SZ) {
        if (mac_cache[i] == 0) {
            ni = i;
        }
        if (mac_cache[i] == mac) {
            return 1;
        }
        i++;
    }
    mac_cache[ni] = mac;
    return 0;
}

/*
printl, print out log
 */
void printl(unsigned int channel, char *s, ...) {
    va_list argp;
    FILE * pipe;
    unsigned short show;

    show = !silent;

    switch (channel) {
        case INFO:
            pipe = stdout;
            break;

        case WARN:
            pipe = stderr;
            break;

        case ERROR:
            pipe = stderr;
            show = 1;
            break;

        case DEBUG:
            pipe = stdout;
            show = (debug);
            break;

        default:
            pipe = stdout;
            break;
    }

    if (show) {
        va_start(argp, s);
        vfprintf(stdout, s, argp);
        va_end(argp);
    }
    fflush(pipe);
}

/*
byte xor sum of data
 */
unsigned char xor_sum(unsigned char * data, int len) {
    unsigned int i;
    unsigned char sum = 0;

    for (i = 0; i < len; i++) {
        sum ^= data[i];
    }
    return (sum);
}

/*
print n tabs
 */
static void do_indents(unsigned char n) {
    int i;
    for (i = 0; i < n; i++) {
        printl(INFO, "\t");
    }
}

/*
print hex data buffer, 16 bytes per line, use indent tabs nums
 */
void hex_dump(unsigned char indent, unsigned char *buf, int len) {
    int i, j;
    do_indents(indent);

    for (i = 0; i < len; i++) {
        if (i && !(i % 16)) {
            printl(INFO, "\n");
            do_indents(indent);
        }
        if ((*(buf + i)) < 16) {
            printl(INFO, "0");
        }
        printl(INFO, "%x ", *(buf + i));
    }
    printl(INFO, "\n");
}

/*
count occurance of char token within str
 */
unsigned char count_chars(unsigned char token, unsigned char * str) {
    unsigned char i = 0;
    unsigned char count = 0;
    do {
        if (str[i] == token) {
            count++;
        }
    } while (str[i++]);
    return (count);
}

/*
ascii inet syntax ok?
 */
unsigned char inet_addr_valid(unsigned char * addr) {
    unsigned char * indx;
    unsigned char num[4];
    unsigned char i, j = 0;

    /* inetaddresse auf gueltigkeit pruefen: */
    if (count_chars('.', addr) == 3) {
        indx = addr;
        for (i = 0; i < 4; i++) {
            memset(num, 0, 4);
            j = 0;
            while ((*indx != '.') && (*indx != 0)) {
                if (j > 2)
                    return (0);
                num[j] = *indx++;
                if (!(isdigit(num[j]))) {
                    return (0);
                }
                j++;
            }
            *indx++;

            if (atoi(num) > 0xff)
                return (0);
        }
    } else {
        return (0);
    }
    return (1);
}

/*
returns TRUE if addr is 0.0.0.0
 */
unsigned char inet_empty(struct in_addr * addr) {
    struct in_addr i;
    memset(&i, 0, sizeof (i));
    return (memcmp(addr, &i, sizeof (i)) == 0);
}

/*
returns current 64 bit timestamp in TICKS_PER_SEC resolution
 */
unsigned long long GetTickCount(void) {
    struct timeval tp;

    gettimeofday(&tp, 0);
    return ((unsigned long long) ((unsigned) tp.tv_sec) * TICKS_PER_SEC + ((unsigned) tp.tv_usec));
}
