/*
 *  gblc - (G)ude (B)ootloader(L)oader (C)lient
 *
 *  $Id$
 *
 *  Copyright (C) 2006, 2007,
 *    Martin Bachem, Gude Analog- und Digitalsysteme GmbH
 *    info@gudeads.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version
 *  2 of the License, or (at your option) any later version.
 *
 */

#include <sys/types.h>
#include <stdio.h>

#define GBL_PORT            50123

#define GBL_MAX_PAYLOAD     1500
#define GBL_MIN_PAYLOAD     GBL4_PREFIX_LEN + 2

#define GBL4_PREFIX_LEN     4
#define GBL4_CMD_POS        GBL4_PREFIX_LEN
#define GBL4_RETVAL_POS     (GBL4_CMD_POS + 1 + 6)
#define GBL_DATA            (GBL4_CMD_POS + 1)
#define GBL4_PREFIX         "GBL\004"
#define GBL4_PREFIX_CHKSUM  ('G' ^ 'B' ^ 'L' ^ 4)
#define GBL_OK              0

#define GBL_BROADCAST       1
#define GBL_UNICAST         2

#define GBL(x) x

#define GBL_SEARCH          GBL(1)
#define GBL_NETCONF         GBL(2)
#define GBL_FWUPDATE        GBL(3)
#define GBL_FLASHWRITE      GBL(4)
#define GBL_FABSETTINGS     GBL(5)
#define GBL_PING            GBL(9)
#define GBL_SETHOSTNAME     GBL(14)
#define GBL_GOFIRMWARE      GBL(15)
#define GBL_GOBOOTLDR       GBL(16)
#define GBL_FLASHWRITE_SPI  GBL(18)
#define GBL_GETCFGENT       GBL(21)
#define GBL_SETCFGENT       GBL(22)
#define GBL_DELCFGENT       GBL(24)


#define FLASH_PAGE_SZ           512
#define MAX_FW_BYTE_SZ          (FLASH_PAGE_SZ*1024)
#define FLASH_SPI_PAGE_SZ       256
#define FLASH_WRITE_MAX_RETRY   3

typedef struct {
    int len;
    u_int8_t cmd;
    u_int8_t data[GBL_MAX_PAYLOAD];
} gbl_cmd_t;

typedef struct {
    struct in_addr ip;
    struct in_addr nm;
    struct in_addr gw;
    u_int8_t dhcp;
    u_int8_t httpauth;
    u_int8_t ipacl;
    u_int16_t httpport;
    u_int8_t phy;
    u_int32_t useflags;
    u_int8_t gbldr;
    u_int8_t noping;
    u_int8_t indexauth;
    u_int8_t gbldebug;
} netconf_t;

typedef struct {
    u_int32_t cur_page;
    u_int16_t max_page;
    u_int8_t xor_sum;
    u_int8_t retry_cnt;
    int bytesize;
    FILE * fp;

    // spi extension
    u_int32_t max_page_spi;
    u_int8_t xor_sum_spi;
    int bytesize_spi;

    u_int8_t binbuffer[MAX_FW_BYTE_SZ];
    u_int8_t binbuffer_spi[MAX_FW_BYTE_SZ];
} fw_update_t;

typedef struct {
    u_int8_t mac[6]; /**< phsical layer MAC address */
    u_int8_t prod_date[3]; /**< production date mm.dd.yy */
    u_int16_t hw_id_pcb; /**< PCB Version */
    u_int16_t hw_id_equip; /**< konkrete Bestueckung */
    u_int16_t cpu_id; /**< z.B: 1=MCF_52234, 2=MCF_52235 */
    char prod_name[64]; /**< product name */
} __attribute((packed)) ent_1_hw_ids;

// netconf user interface cmd line option flags
#define USE_CONF_DHCP           0x01    // --dhcp=x flag
#define USE_CONF_HTTPAUTH       0x02    // --httpauth=x flag
#define USE_CONF_IPACL          0x04    // --ipcal=x
#define USE_CONF_NOPING         0x08    // --replyping=x
#define USE_CONF_GBLDEBUG       0x10    // --gbldebug=x
#define USE_CONF_INDEXAUTH      0x40    // --indexauth=x
#define USE_CONF_GBLDR          0x80    // --gbldr=x
#define USE_CONF_HTTPPORT       0x0010  // --httpport=x
#define USE_CONF_PHY            0x0020    // --phy=bla
#define USE_CONF_IP             0x0040    // --ip=1.2.3.4
#define USE_CONF_NM             0x0080    // --nm=1.2.3.4
#define USE_CONF_GW             0x0100    // --gw=1.2.3.4


#define PHYCONF_PROBE_10    1
#define PHYCONF_PROBE_100   2
#define PHYCONF_PROBE_FD    4
#define PHYCONF_AUTO        0xFF


/* index pointers in GBL1 dgram */
#define NET_CONF_MAC_POS                (GBL_DATA)
#define NET_CONF_HWMAGIC_POS            (NET_CONF_MAC_POS + 6)
#define NET_CONF_BLDR_MAJOR_POS         (NET_CONF_HWMAGIC_POS + 2)
#define NET_CONF_BLDR_MINOR_POS         (NET_CONF_BLDR_MAJOR_POS + 1)
#define NET_CONF_FMRMW_MAJOR_POS        (NET_CONF_BLDR_MINOR_POS + 1)
#define NET_CONF_FMRMW_MINOR_POS        (NET_CONF_FMRMW_MAJOR_POS + 1)
#define NET_CONF_MODE_POS               (NET_CONF_FMRMW_MINOR_POS + 1)
#define GBL_MODE_BOOTLOADER             1
#define NET_CONF_IP_POS                 (NET_CONF_MODE_POS + 1)
#define NET_CONF_NM_POS                 (NET_CONF_IP_POS + 4)
#define NET_CONF_GW_POS                 (NET_CONF_NM_POS + 4)
#define NET_CONF_PHYCONF_POS            (NET_CONF_GW_POS + 4)
#define NET_CONF_PHYSTATE_POS           (NET_CONF_PHYCONF_POS + 1)
#define NET_CONF_GLOPT_POS              (NET_CONF_PHYSTATE_POS + 1)
#define NET_CONF_GLOPT_DHCP             0x01
#define NET_CONF_GLOPT_AUTH             0x02
#define NET_CONF_GLOPT_ACL              0x04
#define NET_CONF_GLOPT_NOPING           0x08
#define NET_CONF_GLOPT_DEBUG            0x10
#define NET_CONF_GLOPT_INDEXAUTH        0x40
#define NET_CONF_GLOPT_GBLDR            0x80
#define NET_CONF_HTTP_PORT_POS          (NET_CONF_GLOPT_POS + 1)
#define NET_CONF_HWID_POS               (NET_CONF_HTTP_PORT_POS + 2)


#define GBL_DATA_INET(x,y)      (*((struct in_addr *)(x + y)))
#define GBL_DATA_UINT8(x,y)     ((*((u_int8_t *)(x + y))))
#define GBL_DATA_UINT16(x,y)    (be16_to_cpu(*((u_int16_t *)(x + y))))
#define GBL_DATA_UINT32(x,y)    (be32_to_cpu(*((u_int32_t *)(x + y))))


/* gbl commands */
int gbl_search(gbl_cmd_t * gbl_cmd, struct in_addr * targethost,
        unsigned int bootloader_only, unsigned char casttype,
        unsigned char verbose, unsigned int timeout);
int gbl_ping(gbl_cmd_t * gbl_cmd, unsigned int sz);
int gbl_save_netconf(gbl_cmd_t * gbl_cmd, netconf_t * newconf);
int gbl_prepare_fwupdate(gbl_cmd_t * gbl_cmd, fw_update_t * fwupdate);
int gbl_write_flashpage(gbl_cmd_t * gbl_cmd, fw_update_t * fwupdate);
int gbl_write_flashpage_spi(gbl_cmd_t * gbl_cmd, fw_update_t * fwupdate);
int gbl_set_hostname(gbl_cmd_t * gbl_cmd, char * hostname);

/* gbl socket/dgram content helpers */
int gbl_sock_init(void);
void gbl_sock_close(void);
int gbl_prepare_cmd(gbl_cmd_t *gbl_cmd);
int gbl_send_dgram(gbl_cmd_t * gbl_cmd, struct in_addr * addr);
void dump_gbl_dev(gbl_cmd_t *gbl_cmd, unsigned char verbose);
unsigned char gbl_dev_bootloader(gbl_cmd_t *gbl_cmd);
int gbl_query_netconf(struct in_addr * targethost, gbl_cmd_t * gbl_cmd,
        unsigned short timeout, unsigned int unicast, unsigned char show,
        unsigned int bootloader_only, unsigned char verbose);
void gbl_add_xorsum(gbl_cmd_t * gbl_cmd);
int gbl_poll_reply(gbl_cmd_t * gbl_cmd, unsigned short timeout);


/* external symbols */
extern const char * GBL_CMDS[];
extern const unsigned int GBL_TIMEOUTS[];
