/* 
 *  gblc - (G)ude (B)ootloader(L)oader (C)lient
 *
 *  $Id$
 *
 *  Copyright (C) 2006, 2007,
 *    Martin Bachem, Gude Analog- und Digitalsysteme GmbH
 *    info@gudeads.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version
 *  2 of the License, or (at your option) any later version.
 *
 */

#ifndef __GBL_DEVS_H__
#define __GBL_DEVS_H__

typedef struct {
    char * name;
    u_int16_t fw_id; // firmware magic
    u_int16_t hw_id; // hardware magic FreeScale CF only
    u_int8_t uc_id; // uController identifier;
} gbldevs_t;


/*******************************************************/
/* extracted from hw_id.h */
#define HWID_EMC_PROF_NET                       0x01
#define HWID_EMC_PROF_NET_19                    0x02
/*******************************************************/
/* extracted from firmware_magic.h */
#define ATMEL_EPC_MAGIC                         0x0001
#define ATMEL_SNAAK_MAGIC                       0x0004
#define ATMEL_IPCONTROL_MAGIC                   0x0005
#define ATMEL_LINDY_IPC_MAGIC                   0x0006
#define ATMEL_JUNGHANS_IPSWITCH_MAGIC           0x0007
/*******************************************************/
/* FreeScale ColdFire Products */
#define EPC_8X_GUDE_CF_MAGIC                    0x0032
#define EPC_8X_GUDE_V3_CF_MAGIC                 0x0033

#define EPC_8X_LINDY_CF_MAGIC                   0x0034    // Lindy IPower Control 8x
#define EPC_8X_LINDY_V3_CF_MAGIC                0x0031    // Lindy IPower Control 8x v3
#define EPC_8X_BERONET_CF_MAGIC                 0x0035    // bero*rps

#define EPC_8X_RATIO_CF_MAGIC                   0x0036  // Ratio 'IP Power Switch'
#define EPC_8X_DATENN_CF_MAGIC                  0x0037  // Datennet 'IP Control'
#define EPC_8X_JUNGHNS_CF_MAGIC                 0x0038  // Junghanns 'IP Switch'
#define EPC_8X_GSM_CF_MAGIC                     0x0039  // GSM EPC 8x


#define EMC_GUDE_FRSCL_CF_MAGIC                 0x0040  // Gude EMC Prof
#define EMC_LINDY_CF_MAGIC                      0x0041  // Lindy NTP Timeserver
#define EMC_GPS_GUDE_CF_MAGIC                   0x0042  // Gude EMC GPS TEST

#define BEROFOS                                 0x0050  // Berfos (Beronet Autoswitch)

#define EPM_GUDE                                0x0060  // ExpertPowerMeter (Gude)
#define EPM_RATIO                               0x0061  // ExpertPowerMeter (Ratio)

#define ATS_GUDE                                0x0070  // Expert Transfer Switch (Gude)
#define ATS_RATIO                               0x0071  // Auto Transfer Switch (Ratio)

#define EPC_24X_GUDE_CF_MAGIC                   0x0080  // Gude EPC 24x ColdfFire (512b EEProm)
#define EPC_24X_LINDY_CF_MAGIC                  0x0081  // Lindy IPower Control 24x

#define EPC_2X6_GUDE_CF_MAGIC                   0x0090  // Gude EPC 2X6 ColdfFire
#define EPC_2X6_RATIO_CF_MAGIC                  0x0091  // Ratio EPC 2X6 ColdfFire
#define EPC_2X6_LINDY_CF_MAGIC                  0x0092  // Lindy EPC 2X6 ColdfFire

#define EPC_1X_GUDE_CF_MAGIC                    0x00a0  // Gude EPC 1X ColdfFire
#define EPC_1X_LINDY_CF_MAGIC                   0x00a1  // Lindy IEC 1X ColdfFire
#define EPC_1X_FIDUCIA_CF_MAGIC                 0x00a2  // FIDUCIA IEC 1X ColdfFire

#define EPC_4X_GUDE_CF_MAGIC                    0x00b0  // Gude EPC 4X ColdfFire
#define EPC_4X_DIN_CF_MAGIC                     0x00b1  // Gude EPC 4X DIN ColdfFire
#define EPC_4X_LINDY_CF_MAGIC                   0x00b2  // Lindy IPower 4X DIN ColdfFire
#define EPC_4X_DESKTOP_CF_MAGIC                 0x00b3  // Gude EPC 4X Desktop
#define EPC_MASTER_SLAVE_CF_MAGIC               0x00b4  // Gude EPC Master Slave
#define EPC_4X_GUDE_V3_CF_MAGIC                 0x00b5  // Gude EPC 4X ColdfFire  v.3

#define DCF_EMU_PROF_MAGIC                      0x00be  // DCF Emulator Professional

#define PDU_BASIC_CF_MAGIC                      0x00c0  // Gude EPC PDU BASIC ColdfFire

#define ENC_2SO_CF_MAGIC                        0x00d0  // Gude EPC PDU Temp + 2O

#define ENC_2I2O_CF_MAGIC                       0x00e0  // Gude EPC PDU 2I + 2O

#define FAB_CF_MAGIC                            0x00ba

#define GBL_ATMEL_MAGIC                         0x00BD
#define GBL_FRSCL_CF_MAGIC                      0x00BB

/*******************************************************/
#define UC_ATMEL                                0x01
#define UC_FRSCL_HC9S12                         0x02
#define UC_FRSCL_CF_52234                       0x03
#define UC_FRSCL_CF_52235                       0x04
#define UC_FRSCL_CF_52236                       0x05
/*******************************************************/

const gbldevs_t gbldevs[] = {
    /*                           Firmware Magic             Hardware ID              uController Type    */
    /*---------------------------------------------------------------------------------------------------*/
    {"Gude Boot Loader", GBL_FRSCL_CF_MAGIC, 0x00, UC_FRSCL_CF_52235},
    {"berofos", BEROFOS, 0x00, UC_FRSCL_CF_52235},
    {"bero*rps", EPC_8X_BERONET_CF_MAGIC, 0x00, UC_FRSCL_CF_52235},
    {"ExpertPowerControl 8x", EPC_8X_GUDE_CF_MAGIC, 0x00, UC_FRSCL_CF_52235},
    {"ExpertPowerControl 8x", EPC_8X_GUDE_CF_MAGIC, 0x04, UC_FRSCL_CF_52235},
    {"EMC Professional NET", EMC_GUDE_FRSCL_CF_MAGIC, HWID_EMC_PROF_NET, UC_FRSCL_CF_52235},
    {"EMC Professional NET 19", EMC_GUDE_FRSCL_CF_MAGIC, HWID_EMC_PROF_NET_19, UC_FRSCL_CF_52235},
    {"Expert Power Meter", EPM_GUDE, 0x03, UC_FRSCL_CF_52235},
    {"ExpertPowerControl 24x", EPC_24X_GUDE_CF_MAGIC, 0x00, UC_FRSCL_CF_52235},
    {"ExpertTransferSwitch", ATS_GUDE, 0x05, UC_FRSCL_CF_52235},
    {"ExpertPowerControl 2x6", EPC_2X6_GUDE_CF_MAGIC, 0x07, UC_FRSCL_CF_52235},
    {"ExpertPowerControl 1x", EPC_1X_GUDE_CF_MAGIC, 0x04, UC_FRSCL_CF_52235},
    {"ExpertPowerControl 4x", EPC_4X_GUDE_CF_MAGIC, 0x08, UC_FRSCL_CF_52235},
    {"expert net control 2i2o", ENC_2I2O_CF_MAGIC, 0x01, UC_FRSCL_CF_52236},
    {NULL, 0, 0, 0}
};

#endif // __GBL_DEVS_H__
