/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONTokener {
    private int character;
    private boolean eof;
    private int index;
    private int line;
    private char previous;
    private Reader reader;
    private boolean usePrevious;

    public JSONTokener(Reader reader) {
        this.reader = reader.markSupported() ? reader : new BufferedReader(reader);
        this.eof = false;
        this.usePrevious = false;
        this.previous = '\u0000';
        this.index = 0;
        this.character = 1;
        this.line = 1;
    }

    public final void back() throws JSONException {
        if (this.usePrevious || this.index <= 0) {
            throw new JSONException("Stepping back two steps is not supported");
        }
        --this.index;
        --this.character;
        this.usePrevious = true;
        this.eof = false;
    }

    public final char next() throws JSONException {
        int n;
        if (this.usePrevious) {
            this.usePrevious = false;
            n = this.previous;
        } else {
            try {
                n = this.reader.read();
            }
            catch (IOException iOException) {
                throw new JSONException(iOException);
            }
            if (n <= 0) {
                this.eof = true;
                n = 0;
            }
        }
        ++this.index;
        if (this.previous == '\r') {
            ++this.line;
            this.character = n == 10 ? 0 : 1;
        } else if (n == 10) {
            ++this.line;
            this.character = 0;
        } else {
            ++this.character;
        }
        this.previous = (char)n;
        return this.previous;
    }

    private String next(int n) throws JSONException {
        char[] cArray = new char[4];
        for (int i = 0; i < 4; ++i) {
            cArray[i] = this.next();
            JSONTokener jSONTokener = this;
            if (!(jSONTokener.eof && !jSONTokener.usePrevious)) continue;
            throw this.syntaxError("Substring bounds error");
        }
        return new String(cArray);
    }

    public final char nextClean() throws JSONException {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    private String nextString(char c) throws JSONException {
        StringBuffer stringBuffer = new StringBuffer();
        block13: while (true) {
            char c2 = this.next();
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c2 = this.next();
                    switch (c2) {
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block13;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            stringBuffer.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            stringBuffer.append(c2);
                            continue block13;
                        }
                    }
                    throw this.syntaxError("Illegal escape.");
                }
            }
            if (c2 == c) {
                return stringBuffer.toString();
            }
            stringBuffer.append(c2);
        }
    }

    public final Object nextValue() throws JSONException {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            stringBuffer.append(c);
            c = this.next();
        }
        this.back();
        String string = stringBuffer.toString().trim();
        if (string.equals("")) {
            throw this.syntaxError("Missing value");
        }
        return JSONObject.stringToValue(string);
    }

    public final JSONException syntaxError(String string) {
        return new JSONException(string + this.toString());
    }

    public final String toString() {
        return " at " + this.index + " [character " + this.character + " line " + this.line + "]";
    }
}

