/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONString;
import org.json.JSONTokener;

public class JSONObject {
    private Map map = new HashMap();
    public static final Object NULL = new Null();

    public JSONObject() {
    }

    public JSONObject(JSONTokener jSONTokener) throws JSONException {
        this();
        if (jSONTokener.nextClean() != '{') {
            throw jSONTokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = jSONTokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jSONTokener.back();
            String string = jSONTokener.nextValue().toString();
            c = jSONTokener.nextClean();
            if (c == '=') {
                if (jSONTokener.next() != '>') {
                    jSONTokener.back();
                }
            } else if (c != ':') {
                throw jSONTokener.syntaxError("Expected a ':' after a key");
            }
            Object object = jSONTokener.nextValue();
            JSONObject jSONObject = this;
            if (string != null && object != null) {
                if (jSONObject.opt(string) != null) {
                    throw new JSONException("Duplicate key \"" + string + "\"");
                }
                jSONObject.put(string, object);
            }
            switch (jSONTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == '}') {
                        return;
                    }
                    jSONTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or '}'");
    }

    private JSONObject(Map object) {
        if (object != null) {
            for (Map.Entry entry : object.entrySet()) {
                Object v = entry.getValue();
                if (v == null) continue;
                this.map.put(entry.getKey(), JSONObject.wrap(v));
            }
        }
    }

    private JSONObject(Object object) {
        this();
        Object object2 = object;
        object = this;
        Method[] methodArray = object2.getClass();
        int n = methodArray.getClassLoader() != null ? 1 : 0;
        methodArray = n != 0 ? methodArray.getMethods() : methodArray.getDeclaredMethods();
        for (n = 0; n < methodArray.length; ++n) {
            try {
                Object object3 = methodArray[n];
                if (!Modifier.isPublic(((Method)object3).getModifiers())) continue;
                String string = ((Method)object3).getName();
                Object object4 = "";
                if (string.startsWith("get")) {
                    object4 = string.equals("getClass") || string.equals("getDeclaringClass") ? "" : string.substring(3);
                } else if (string.startsWith("is")) {
                    object4 = string.substring(2);
                }
                if (((String)object4).length() <= 0 || !Character.isUpperCase(((String)object4).charAt(0)) || ((Method)object3).getParameterTypes().length != 0) continue;
                if (((String)object4).length() == 1) {
                    object4 = ((String)object4).toLowerCase();
                } else if (!Character.isUpperCase(((String)object4).charAt(1))) {
                    object4 = ((String)object4).substring(0, 1).toLowerCase() + ((String)object4).substring(1);
                }
                object3 = ((Method)object3).invoke(object2, (Object[])null);
                if (object3 == null) continue;
                ((JSONObject)object).map.put(object4, JSONObject.wrap(object3));
                continue;
            }
            catch (Exception exception) {}
        }
    }

    public final Object get(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        Object object = this.opt(string);
        if (object == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] not found.");
        }
        return object;
    }

    public final int getInt(String string) throws JSONException {
        Object object = this.get(string);
        try {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not an int.");
        }
    }

    public static String[] getNames(JSONObject object) {
        int n = ((JSONObject)object).length();
        if (n == 0) {
            return null;
        }
        object = ((JSONObject)object).keys();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (object.hasNext()) {
            stringArray[n2] = (String)object.next();
            ++n2;
        }
        return stringArray;
    }

    public final boolean has(String string) {
        return this.map.containsKey(string);
    }

    private Iterator keys() {
        return this.map.keySet().iterator();
    }

    public final int length() {
        return this.map.size();
    }

    private static String numberToString(Number object) throws JSONException {
        if (object == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(object);
        object = object.toString();
        if (((String)object).indexOf(46) > 0 && ((String)object).indexOf(101) < 0 && ((String)object).indexOf(69) < 0) {
            while (((String)object).endsWith("0")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (((String)object).endsWith(".")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
        }
        return object;
    }

    private Object opt(String string) {
        if (string == null) {
            return null;
        }
        return this.map.get(string);
    }

    public final JSONObject put(String string, int n) throws JSONException {
        this.put(string, (Object)n);
        return this;
    }

    public final JSONObject put(String string, Object object) throws JSONException {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        if (object != null) {
            JSONObject.testValidity(object);
            this.map.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    private static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        stringBuffer.append('\"');
        block9: for (int i = 0; i < n; ++i) {
            char c2 = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block9;
                }
                case '/': {
                    if (c2 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String string2;
                        String string3 = string2 = "000" + Integer.toHexString(c);
                        stringBuffer.append("\\u" + string3.substring(string3.length() - 4));
                        continue block9;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public final Object remove(String string) {
        return this.map.remove(string);
    }

    public static Object stringToValue(String string) {
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("null")) {
            return NULL;
        }
        char c = string.charAt(0);
        if (c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+') {
            if (c == '0' && string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                try {
                    return new Integer(Integer.parseInt(string.substring(2), 16));
                }
                catch (Exception exception) {}
            }
            try {
                if (string.indexOf(46) >= 0 || string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                    return Double.valueOf(string);
                }
                Long l = new Long(string);
                if (l == (long)l.intValue()) {
                    return new Integer(l.intValue());
                }
                return l;
            }
            catch (Exception exception) {}
        }
        return string;
    }

    private static void testValidity(Object object) throws JSONException {
        if (object != null && (object instanceof Double ? ((Double)object).isInfinite() || ((Double)object).isNaN() : object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public String toString() {
        try {
            Iterator iterator = this.keys();
            StringBuffer stringBuffer = new StringBuffer("{");
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object e = iterator.next();
                stringBuffer.append(JSONObject.quote(e.toString()));
                stringBuffer.append(':');
                stringBuffer.append(JSONObject.valueToString(this.map.get(e)));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final String toString(int n) throws JSONException {
        return this.toString(2, 0);
    }

    private String toString(int n, int n2) throws JSONException {
        int n3 = this.length();
        if (n3 == 0) {
            return "{}";
        }
        Iterator iterator = this.keys();
        int n4 = n2 + n;
        StringBuffer stringBuffer = new StringBuffer("{");
        if (n3 == 1) {
            Object e = iterator.next();
            stringBuffer.append(JSONObject.quote(e.toString()));
            stringBuffer.append(": ");
            stringBuffer.append(JSONObject.valueToString(this.map.get(e), n, n2));
        } else {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(",\n");
                } else {
                    stringBuffer.append('\n');
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(JSONObject.quote(e.toString()));
                stringBuffer.append(": ");
                stringBuffer.append(JSONObject.valueToString(this.map.get(e), n, n4));
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append('\n');
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuffer.append(' ');
                }
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static String valueToString(Object object) throws JSONException {
        if (object == null || object.equals(null)) {
            return "null";
        }
        if (object instanceof JSONString) {
            try {
                object = ((JSONString)object).toJSONString();
            }
            catch (Exception exception) {
                throw new JSONException(exception);
            }
            if (object instanceof String) {
                return (String)object;
            }
            throw new JSONException("Bad value from toJSONString: " + object);
        }
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean || object instanceof JSONObject || object instanceof JSONArray) {
            return object.toString();
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object).toString();
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString();
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString();
        }
        return JSONObject.quote(object.toString());
    }

    static String valueToString(Object object, int n, int n2) throws JSONException {
        if (object == null || object.equals(null)) {
            return "null";
        }
        try {
            String string;
            if (object instanceof JSONString && (string = ((JSONString)object).toJSONString()) instanceof String) {
                return string;
            }
        }
        catch (Exception exception) {}
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).toString(n, n2);
        }
        if (object instanceof JSONArray) {
            return ((JSONArray)object).toString(n, n2);
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object).toString(n, n2);
        }
        if (object instanceof Collection) {
            return new JSONArray((Collection)object).toString(n, n2);
        }
        if (object.getClass().isArray()) {
            return new JSONArray(object).toString(n, n2);
        }
        return JSONObject.quote(object.toString());
    }

    public static Object wrap(Object object) {
        try {
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return new JSONArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                return new JSONObject((Map)object);
            }
            Object object2 = object.getClass().getPackage();
            object2 = object2 != null ? ((Package)object2).getName() : "";
            if (((String)object2).startsWith("java.") || ((String)object2).startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JSONObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public final boolean equals(Object object) {
            return object == null || object == this;
        }

        public final String toString() {
            return "null";
        }
    }
}

