/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONArray {
    private ArrayList myArrayList = new ArrayList();

    public JSONArray() {
    }

    public JSONArray(JSONTokener jSONTokener) throws JSONException {
        this();
        if (jSONTokener.nextClean() != '[') {
            throw jSONTokener.syntaxError("A JSONArray text must start with '['");
        }
        if (jSONTokener.nextClean() != ']') {
            jSONTokener.back();
            block4: while (true) {
                if (jSONTokener.nextClean() == ',') {
                    jSONTokener.back();
                    this.myArrayList.add(JSONObject.NULL);
                } else {
                    jSONTokener.back();
                    this.myArrayList.add(jSONTokener.nextValue());
                }
                switch (jSONTokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (jSONTokener.nextClean() == ']') {
                            return;
                        }
                        jSONTokener.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw jSONTokener.syntaxError("Expected a ',' or ']'");
        }
    }

    public JSONArray(Collection object) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                this.myArrayList.add(JSONObject.wrap(object.next()));
            }
        }
    }

    public JSONArray(Object object) throws JSONException {
        this();
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.put(JSONObject.wrap(Array.get(object, i)));
            }
            return;
        }
        throw new JSONException("JSONArray initial value should be a string or collection or array.");
    }

    /*
     * Unable to fully structure code
     */
    public final Object get(int var1_1) throws JSONException {
        var3_2 = var1_1;
        var2_3 = this;
        if (var3_2 < 0) ** GOTO lbl-1000
        var4_4 = var2_3;
        if (var3_2 >= var4_4.myArrayList.size()) lbl-1000:
        // 2 sources

        {
            v0 = null;
        } else {
            v0 = var2_3 = (JSONArray)var2_3.myArrayList.get(var3_2);
        }
        if (v0 == null) {
            throw new JSONException("JSONArray[" + var1_1 + "] not found.");
        }
        return var2_3;
    }

    public final JSONArray getJSONArray(int n) throws JSONException {
        Object object = this.get(n);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONArray[" + n + "] is not a JSONArray.");
    }

    public final String getString(int n) throws JSONException {
        Object object = this.get(n);
        if (object == JSONObject.NULL) {
            return null;
        }
        return object.toString();
    }

    public final int length() {
        return this.myArrayList.size();
    }

    public final JSONArray put(Object object) {
        this.myArrayList.add(object);
        return this;
    }

    public String toString() {
        try {
            JSONArray jSONArray;
            String string = ",";
            JSONArray jSONArray2 = jSONArray = this;
            int n = jSONArray.myArrayList.size();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(JSONObject.valueToString(jSONArray.myArrayList.get(i)));
            }
            return "[" + stringBuffer.toString() + "]";
        }
        catch (Exception exception) {
            return null;
        }
    }

    final String toString(int n, int n2) throws JSONException {
        JSONArray jSONArray = this;
        int n3 = jSONArray.myArrayList.size();
        if (n3 == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        if (n3 == 1) {
            stringBuffer.append(JSONObject.valueToString(this.myArrayList.get(0), n, n2));
        } else {
            int n4;
            int n5 = n2 + n;
            stringBuffer.append('\n');
            for (n4 = 0; n4 < n3; ++n4) {
                if (n4 > 0) {
                    stringBuffer.append(",\n");
                }
                for (int i = 0; i < n5; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(JSONObject.valueToString(this.myArrayList.get(n4), n, n5));
            }
            stringBuffer.append('\n');
            for (n4 = 0; n4 < n2; ++n4) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

