/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.xwd.Table15;
import com.beekeeper.xwd.WordList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class WordListPanel
extends JPanel {
    WordList.MatchInfo mMatch;
    private final Table15 mTable;
    private final MyModel mModel;
    final String[] columns = new String[]{"Word", "Score"};

    public WordListPanel(WordList.MatchInfo object) {
        this.mMatch = object;
        this.mModel = new MyModel(this);
        this.mTable = new Table15(this.mModel);
        object = (DefaultTableColumnModel)this.mTable.getColumnModel();
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, false);
        Font font = UIManager.getDefaults().getFont("Table.font");
        for (int i = 0; i < ((DefaultTableColumnModel)object).getColumnCount(); ++i) {
            TableColumn tableColumn = ((DefaultTableColumnModel)object).getColumn(i);
            String string = i > 0 ? this.mModel.getColumnName(i) : "ABCDEFGHIJKLMNOPQRST";
            int n = (int)font.getStringBounds(string, fontRenderContext).getWidth() + 12;
            tableColumn.setPreferredWidth(n);
        }
        this.mTable.setAutoCreateRowSorter(true);
        this.mTable.setUpdateSelectionOnSort(true);
        this.mTable.setSorting(new int[]{1, -1});
        this.mTable.addMouseListener(new MouseAdapter(this){
            private /* synthetic */ WordListPanel this$0;
            {
                this.this$0 = wordListPanel;
            }

            @Override
            public final void mouseClicked(MouseEvent mouseEvent) {
                mouseEvent.consume();
                if (mouseEvent.getClickCount() == 2) {
                    int n = this.this$0.mTable.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    n = this.this$0.mTable.convertRowIndexToModel(n);
                    this.this$0.wordClicked(this.this$0.mMatch, n);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.mTable);
        jScrollPane.getViewport().setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add("Center", jScrollPane);
    }

    protected void wordClicked(WordList.MatchInfo matchInfo, int n) {
    }

    final class MyModel
    extends AbstractTableModel {
        private /* synthetic */ WordListPanel this$0;

        private MyModel(WordListPanel wordListPanel) {
            this.this$0 = wordListPanel;
        }

        @Override
        public final int getColumnCount() {
            return 2;
        }

        @Override
        public final String getColumnName(int n) {
            return this.this$0.columns[n];
        }

        @Override
        public final int getRowCount() {
            return this.this$0.mMatch.getMatchCount();
        }

        @Override
        public final Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.this$0.mMatch.getOrig(n);
                }
                case 1: {
                    return Float.valueOf(this.this$0.mMatch.getScore(n));
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public final boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public final Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Float.class;
                }
            }
            throw new IllegalStateException();
        }
    }
}

