/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.StringTable;
import com.beekeeper.util.closedhash.GenericHash;
import com.beekeeper.util.closedhash.IntIntHash;
import com.beekeeper.util.closedhash.ObjectHash;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.WordGrid;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public abstract class WordList {
    private static char[] GENERIC_CONV;
    protected char[] letterConv;
    protected char minConv;
    protected char maxConv;
    protected static boolean[] LETTER_DETECT;
    protected static final int[] MASK_BITS;
    private static int[] LETTER_CODES;

    protected static int computeMask(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080') continue;
            n |= MASK_BITS[c];
        }
        return n |= (string.length() & 0xF) << 26;
    }

    protected static int computePosMask(String string) {
        int n = 0;
        int n2 = Math.min(8, string.length());
        for (int i = 0; i < n2; ++i) {
            n <<= 4;
            char c = string.charAt(i);
            if (c >= '\u0080') continue;
            n |= LETTER_CODES[c];
        }
        return n;
    }

    public static char[] makeLetterConv(char[] cArray) {
        int n;
        char[] cArray2 = new char[256];
        IntIntHash intIntHash = new IntIntHash();
        int n2 = 28;
        for (int i = 0; i < n2; ++i) {
            intIntHash.put("\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff".charAt(i), "aaaaaaceeeeiiiinoooooouuuuyy".charAt(i));
        }
        BitSet bitSet = new BitSet(256);
        if (cArray != null) {
            char[] cArray3 = cArray;
            int n3 = cArray.length;
            for (n = 0; n < n3; ++n) {
                char c = cArray3[n];
                bitSet.set(c);
            }
        }
        for (n2 = 0; n2 < 256; n2 = (int)((char)(n2 + 1))) {
            char c = Character.toLowerCase((char)n2);
            if (bitSet.get(c)) {
                cArray2[n2] = c;
                continue;
            }
            n = n2;
            if (!Character.isLetterOrDigit((char)n)) continue;
            char c2 = c;
            cArray2[n2] = (char)intIntHash.get(c2, c2);
        }
        return cArray2;
    }

    public WordList(char[] cArray) {
        for (int i = 0; i < 26; ++i) {
            WordList.LETTER_CODES["etaoinshrdlucmfgypwbvkxjqz".charAt((int)i)] = 1 << i % 4;
        }
        this.letterConv = cArray;
        this.minConv = (char)256;
        this.maxConv = '\u0000';
        for (char c : cArray) {
            if (c == '\u0000') continue;
            if (c < this.minConv) {
                this.minConv = c;
            }
            if (c <= this.maxConv) continue;
            this.maxConv = c;
        }
    }

    public final char translatedCharacter(char c) {
        if (c >= '\u0100') {
            return Character.toLowerCase(c);
        }
        char c2 = this.letterConv[c];
        if (c2 != '\u0000') {
            return c2;
        }
        return c;
    }

    public final String deleteNonLetters(String string) {
        return WordList.deleteNonLetters(string, this.letterConv);
    }

    public static String deleteNonLettersGeneric(String string) {
        return WordList.deleteNonLetters(string, GENERIC_CONV);
    }

    private static String deleteNonLetters(String string, char[] cArray) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0100') {
                char c2 = c;
                if (!Character.isLetterOrDigit(c2)) continue;
                stringBuilder.append(Character.toLowerCase(c));
                continue;
            }
            if ((c = cArray[c]) == '\u0000') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int readUTFChar(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        if (n < 128) {
            return (char)n;
        }
        int n2 = n >> 4 & 0xF;
        switch (n2) {
            case 12: 
            case 13: {
                int n3 = byteBuffer.get() & 0x3F;
                n3 = (n & 0x1F) << 6 | n3;
                return n3;
            }
            case 14: {
                n2 = byteBuffer.get() & 0x3F;
                int n4 = byteBuffer.get() & 0x3F;
                n4 = (n & 0xF) << 12 | n2 << 6 | n4;
                return n4;
            }
            case 15: {
                n2 = byteBuffer.get() & 0xFF;
                int n5 = byteBuffer.get() & 0xFF;
                int n6 = byteBuffer.get() & 0xFF;
                n6 = (n & 7) << 18 | n2 << 12 | n5 << 6 | n6;
                return n6;
            }
        }
        return -1;
    }

    public static String readUTFLine(ByteBuffer byteBuffer) {
        int n;
        if (byteBuffer.remaining() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            n2 = WordList.readUTFChar(byteBuffer);
            if (n2 == -1) {
                n = 0;
                while (byteBuffer.hasRemaining()) {
                    char c = (char)(byteBuffer.get() & 0xFF);
                    n = c;
                    if (c != '\n' && n != 13) continue;
                }
                if (n == 13 && byteBuffer.hasRemaining()) {
                    int n3 = byteBuffer.position();
                    char c = (char)(byteBuffer.get() & 0xFF);
                    n = c;
                    if (c != '\n') {
                        byteBuffer.position(n3);
                    }
                }
                if (byteBuffer.remaining() == 0) {
                    return null;
                }
                stringBuilder.setLength(0);
                continue;
            }
            if (n2 == 10 || n2 == 13) break;
            stringBuilder.append((char)n2);
        }
        if (n2 == 13 && byteBuffer.hasRemaining()) {
            n = byteBuffer.position();
            if (WordList.readUTFChar(byteBuffer) != 10) {
                byteBuffer.position(n);
            }
        }
        return stringBuilder.toString();
    }

    public static String readWindowsLine(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (byteBuffer.hasRemaining() && (n = byteBuffer.get() & 0xFF) != 10 && n != 13) {
            stringBuilder.append((char)n);
        }
        if (n == 13 && byteBuffer.hasRemaining()) {
            n = byteBuffer.position();
            if ((byteBuffer.get() & 0xFF) != 10) {
                byteBuffer.position(n);
            }
        }
        return stringBuilder.toString();
    }

    public static UniqueWordMap createUniqueMap(File file, String[] stringArray, boolean bl, char[] cArray) throws FileNotFoundException, IOException {
        HashSet<String> hashSet = new HashSet<String>(stringArray == null ? 0 : stringArray.length);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        UniqueWordMap uniqueWordMap = new UniqueWordMap(cArray);
        uniqueWordMap.extendUniqueMap(file, hashSet, true, -1);
        return uniqueWordMap;
    }

    public abstract int getMaxLength();

    public abstract MatchInfo search(GridState var1, int var2);

    public abstract MatchInfo search(GridState var1, int var2, float var3);

    public abstract MatchInfo search(char[] var1, WordGrid.Word var2, float var3);

    public abstract MatchInfo search(String var1);

    public abstract float getWordScore(String var1);

    public abstract String getOrigWord(String var1);

    public abstract void writeTextFile(String var1) throws IOException;

    public String getLetters(String string) {
        return this.deleteNonLetters(string);
    }

    public String getTrueLetters(String string) {
        return this.getLetters(string);
    }

    static {
        int n;
        GENERIC_CONV = WordList.makeLetterConv(null);
        LETTER_DETECT = new boolean[256];
        try {
            byte[] byArray = "\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff".getBytes("ISO-8859-1");
            int n2 = byArray.length;
            for (int i = 0; i < n2; ++i) {
                WordList.LETTER_DETECT[byArray[i] & 0xFF] = true;
            }
            byte[] byArray2 = "\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff".toUpperCase().getBytes("ISO-8859-1");
            n = byArray2.length;
            for (n2 = 0; n2 < n; ++n2) {
                WordList.LETTER_DETECT[byArray2[n2] & 0xFF] = true;
            }
            for (n2 = 145; n2 <= 148; ++n2) {
                WordList.LETTER_DETECT[n2] = true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        MASK_BITS = new int[128];
        n = 1;
        for (int n3 = 97; n3 <= 122; n3 = (int)((char)(n3 + 1))) {
            WordList.MASK_BITS[n3] = n;
            n <<= 1;
        }
        LETTER_CODES = new int[128];
    }

    public static final class UniqueWordMap
    extends ObjectHash<String> {
        protected final char[] mLetterConv;
        private int nextIndex;
        int idxBytes = 0;
        byte[] dictSet;

        public UniqueWordMap(char[] cArray) {
            this(cArray, 8, 1.5);
        }

        private UniqueWordMap(char[] cArray, int n, double d) {
            super(8, 1.5);
            this.mLetterConv = cArray;
        }

        public final String getOrig(String object, String string) {
            this.currentKey = object;
            if ((object = (UniqueWordHashCell)this.findCell(((String)object).hashCode())) == null) {
                return string;
            }
            return ((UniqueWordHashCell)object).orig;
        }

        public final float getScore(String object, float f) {
            this.currentKey = object;
            if ((object = (UniqueWordHashCell)this.findCell(((String)object).hashCode())) == null) {
                return f;
            }
            return ((UniqueWordHashCell)object).score;
        }

        public final void put(String string, String string2, float f) {
            this.currentKey = string;
            UniqueWordHashCell uniqueWordHashCell = (UniqueWordHashCell)this.findCell(string.hashCode());
            if (uniqueWordHashCell != null) {
                uniqueWordHashCell.orig = string2;
                uniqueWordHashCell.score = f;
                return;
            }
            this.auxPut(new UniqueWordHashCell(string, string2, f, this.nextIndex++));
        }

        private void addToDictSet(UniqueWordHashCell uniqueWordHashCell, int n) {
            int n2 = n / 8;
            n %= 8;
            if (this.idxBytes == 0) {
                this.idxBytes = n2 + 1;
                this.dictSet = new byte[this.idxBytes * Math.max(8, uniqueWordHashCell.idx + 1)];
            }
            if (this.idxBytes <= n2) {
                int n3 = n2 + 1;
                int n4 = this.dictSet.length / this.idxBytes;
                byte[] byArray = new byte[n4 * n3];
                int n5 = n3 - this.idxBytes;
                int n6 = 0;
                int n7 = 0;
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < this.idxBytes; ++j) {
                        byArray[n7++] = this.dictSet[n6++];
                    }
                    n7 += n5;
                }
                this.dictSet = byArray;
                this.idxBytes = n3;
            }
            if (uniqueWordHashCell.idx * this.idxBytes >= this.dictSet.length) {
                byte[] byArray = new byte[Math.max((uniqueWordHashCell.idx + 1) * this.idxBytes, this.dictSet.length << 1)];
                System.arraycopy(this.dictSet, 0, byArray, 0, this.dictSet.length);
                this.dictSet = byArray;
            }
            int n8 = uniqueWordHashCell.idx * this.idxBytes + n2;
            this.dictSet[n8] = (byte)(this.dictSet[n8] | 1 << n);
        }

        @Override
        public final Iter getIterator() {
            return new Iter(this);
        }

        public static WordInfo findWordInfo(File object, String string, char[] cArray) throws IOException {
            String string2;
            object = new RandomAccessFile((File)object, "r");
            Object object2 = ((RandomAccessFile)object).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)((FileChannel)object2).size());
            ((FileChannel)object2).read(byteBuffer);
            byteBuffer.flip();
            ((RandomAccessFile)object).close();
            do {
                if ((object = WordList.readUTFLine(byteBuffer)) == null) {
                    return null;
                }
                object2 = ((String)object).trim();
                string2 = null;
                int n = ((String)object).lastIndexOf(59);
                if (n <= 0) continue;
                string2 = ((String)object).substring(n + 1);
                object2 = ((String)object).substring(0, n);
            } while (!((String)(object = WordList.deleteNonLetters((String)object2, cArray))).equals(string));
            float f = 5.0f;
            try {
                f = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
            return new WordInfo(string, (String)object2, f);
        }

        public final void extendUniqueMap(File object, Set<String> set, boolean n, int n2) throws FileNotFoundException, IOException {
            boolean bl;
            object = new RandomAccessFile((File)object, "r");
            FileChannel fileChannel = ((RandomAccessFile)object).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
            fileChannel.read(byteBuffer);
            byteBuffer.flip();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (n != 0) {
                n5 = byteBuffer.limit();
                for (n = 0; n < n5; ++n) {
                    int n6 = byteBuffer.get(n) & 0xFF;
                    if (n6 < 128) continue;
                    if (LETTER_DETECT[n6]) {
                        ++n3;
                        continue;
                    }
                    ++n4;
                }
                n5 = n4 == 0 || n3 > n4 * 10 ? 1 : 0;
            }
            do {
                int n7 = n2;
                int n8 = n5;
                Set<String> set2 = set;
                Object object2 = byteBuffer;
                UniqueWordMap uniqueWordMap = this;
                object2 = n8 != 0 ? WordList.readWindowsLine((ByteBuffer)object2) : WordList.readUTFLine((ByteBuffer)object2);
                if (object2 == null) {
                    bl = false;
                    continue;
                }
                Object object3 = ((String)object2).trim();
                if (!((String)object2).startsWith("#")) {
                    float f = 5.0f;
                    int n9 = ((String)object2).lastIndexOf(59);
                    if (n9 > 0) {
                        f = Float.parseFloat(((String)object2).substring(n9 + 1));
                        object3 = ((String)object2).substring(0, n9);
                    }
                    object2 = StringTable.getDefault().intern(WordList.deleteNonLetters((String)object3, uniqueWordMap.mLetterConv), false);
                    if (set2 == null || !set2.contains(object2)) {
                        String string = object3;
                        object3 = object2;
                        float f2 = f;
                        object2 = string;
                        v2.currentKey = object3;
                        UniqueWordHashCell uniqueWordHashCell = (UniqueWordHashCell)uniqueWordMap.findCell(((String)object3).hashCode());
                        if (uniqueWordHashCell == null) {
                            object2 = ((String)object2).equals(object3) ? object3 : new String((String)object2);
                            uniqueWordHashCell = new UniqueWordHashCell(object3, (String)object2, f2, uniqueWordMap.nextIndex++);
                            uniqueWordMap.auxPut(uniqueWordHashCell);
                        }
                        if (n7 != -1) {
                            uniqueWordMap.addToDictSet(uniqueWordHashCell, n7);
                        }
                    }
                }
                bl = true;
            } while (bl);
            ((RandomAccessFile)object).close();
        }

        static final class UniqueWordHashCell
        extends ObjectHash.ObjectHashCell {
            private float score;
            private String orig;
            private final int idx;

            public UniqueWordHashCell(Object object, String string, float f, int n) {
                super(object);
                this.orig = string;
                this.score = f;
                this.idx = n;
            }
        }

        public final class Iter
        extends GenericHash.Iter {
            public Iter(UniqueWordMap uniqueWordMap) {
                super(uniqueWordMap);
            }

            public final String getKey() {
                return (String)((ObjectHash.ObjectHashCell)this.getCell()).key;
            }

            public final String getOrig() {
                return ((UniqueWordHashCell)this.getCell()).orig;
            }

            public final float getScore() {
                return ((UniqueWordHashCell)this.getCell()).score;
            }

            public final int getDictSetIndex() {
                return ((UniqueWordHashCell)this.getCell()).idx;
            }

            @Override
            protected final void appendString(StringBuilder stringBuilder) {
                stringBuilder.append(this.getKey()).append("=>").append(this.getOrig()).append(":").append(this.getScore());
            }
        }
    }

    public static final class WordListChangeMonitor {
        private ArrayList<WordListListener> listeners = new ArrayList();

        public final void addListener(WordListListener wordListListener) {
            this.listeners.add(wordListListener);
        }

        public final void announceSpellingChange(String string, String string2, boolean bl) {
            for (WordListListener wordListListener : this.listeners) {
                wordListListener.spellingChanged(string, string2, bl);
            }
        }

        public final void announceScoreChange(String string, float f, float f2) {
            for (WordListListener wordListListener : this.listeners) {
                wordListListener.scoreChanged(string, f, f2);
            }
        }

        public final void announceWordListChange() {
            for (WordListListener wordListListener : this.listeners) {
                wordListListener.wordListChanged();
            }
        }
    }

    public static final class WordInfo {
        public String orig;
        public float score;

        public WordInfo(String string, String string2, float f) {
            this.orig = string2;
            this.score = f;
        }
    }

    public static abstract class WordListListener {
        public void spellingChanged(String string, String string2, boolean bl) {
        }

        public void scoreChanged(String string, float f, float f2) {
        }

        public void wordListChanged() {
        }
    }

    public abstract class MatchInfo {
        public MatchInfo(WordList wordList) {
        }

        public abstract int getMatchCount();

        public abstract String getMatch(int var1);

        public abstract String getOrig(int var1);

        public abstract float getScore(int var1);

        public abstract float highestMatchScore();
    }
}

