/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;

public final class WordGrid {
    private final Word[] words;
    private final int[][] crossWords;
    private final char[] initChars;
    public static final String[] DIR_NAMES = new String[]{"ACROSS", "DOWN", "OTHER"};
    private final int width;
    private final int height;

    public final int getWordCount() {
        return this.words.length;
    }

    public final Word getWord(int n) {
        return this.words[n];
    }

    public final int getCrossWordCount(int n) {
        if (this.crossWords[n] == null) {
            return 0;
        }
        return this.crossWords[n].length;
    }

    public final int getCrossWord(int n, int n2) {
        return this.crossWords[n][n2];
    }

    public final char[] getInitChars() {
        return this.initChars;
    }

    private WordGrid(int n, int n2, Word[] wordArray, char[] object) {
        int n3;
        Object object2;
        this.width = n;
        this.height = n2;
        this.words = wordArray;
        this.initChars = object;
        Object object3 = new int[((char[])object).length];
        block0: for (n2 = 0; n2 < wordArray.length; ++n2) {
            object = wordArray[n2];
            int n4 = 0;
            while (true) {
                object2 = object;
                if (n4 >= object.letterIndices.length) continue block0;
                int n5 = n4++;
                object2 = object;
                int n6 = object.letterIndices[n5];
                object3[n6] = object3[n6] + 1;
            }
        }
        this.crossWords = new int[((int[])object3).length][];
        n2 = 0;
        for (n3 = 0; n3 < ((int[])object3).length; ++n3) {
            this.crossWords[n3] = new int[object3[n3]];
        }
        block3: for (n3 = 0; n3 < wordArray.length; ++n3) {
            Word word = wordArray[n3];
            int n7 = 0;
            while (true) {
                Word word2 = word;
                object2 = word2;
                if (n7 >= word2.letterIndices.length) continue block3;
                Word word3 = word;
                int n8 = n7++;
                object2 = word3;
                int n9 = word3.letterIndices[n8];
                int[] nArray = this.crossWords[n9];
                int[] nArray2 = nArray;
                int n10 = n9;
                int n11 = object3[n10];
                object3[n10] = n11 - 1;
                nArray[nArray2.length - n11] = n3;
            }
        }
        for (n3 = 0; n3 < this.crossWords.length; ++n3) {
            boolean bl = false;
            for (int n12 : this.crossWords[n3]) {
                Word word = wordArray[n12];
                object3 = word;
                if (word.letterIndices[0] != n3) continue;
                if (!bl) {
                    bl = true;
                    ++n2;
                }
                ((Word)object3).setPrintNumber(n2);
            }
        }
    }

    public WordGrid(int n, int n2, char[] cArray) {
        this(n, n2, WordGrid.computeWords(n, n2, cArray), cArray);
    }

    public static WordGrid createWordSquare(int n, int n2) {
        int n3;
        int[] nArray;
        int n4;
        Word[] wordArray = new Word[n + n2];
        for (n4 = 0; n4 < n2; ++n4) {
            nArray = new int[n];
            for (n3 = 0; n3 < n; ++n3) {
                nArray[n3] = n4 * n + n3;
            }
            wordArray[n4] = new Word(n4, nArray);
        }
        for (n4 = 0; n4 < n; ++n4) {
            nArray = new int[n2];
            n3 = 0;
            while (n3 < n2) {
                int n5 = n3++;
                nArray[n5] = n5 * n + n4;
            }
            wordArray[n4 + n2] = new Word(n4 + n2, nArray);
        }
        char[] cArray = new char[n * n2];
        Arrays.fill(cArray, '\u0000');
        return new WordGrid(n, n2, wordArray, cArray);
    }

    public static WordGrid readGrid(File object) throws IOException {
        object = new FileInputStream((File)object);
        object = new InputStreamReader((InputStream)object);
        return WordGrid.readGrid((Reader)object);
    }

    private static WordGrid readGrid(Reader object) throws IOException {
        String string;
        object = new BufferedReader((Reader)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        while ((string = ((BufferedReader)object).readLine()) != null) {
            if (n == -1) {
                n = string.length();
            } else if (string.length() != n) {
                throw new IllegalArgumentException("Inconsistent line widths in file");
            }
            arrayList.add(string.toLowerCase());
        }
        int n2 = arrayList.size();
        if (n2 == 0) {
            throw new IllegalArgumentException("Empty file");
        }
        object = new char[n * n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)arrayList.get(i);
            for (int j = 0; j < n; ++j) {
                int n4 = string2.charAt(j);
                if (n4 == 32) {
                    n4 = 0;
                } else if (n4 == 95) {
                    n4 = 0;
                } else if (n4 == 35) {
                    n4 = 127;
                }
                object[n3++] = n4;
            }
        }
        return new WordGrid(n, n2, (char[])object);
    }

    private static Word[] computeWords(int n, int n2, char[] cArray) {
        int n3;
        int n4;
        int n5;
        if (cArray.length != n * n2) {
            throw new IllegalArgumentException();
        }
        int[] nArray = new int[Math.max(n, n2)];
        ArrayList<Word> arrayList = new ArrayList<Word>();
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (cArray[n3 + n5 * n] != '\u007f') {
                    nArray[n4++] = n3 + n5 * n;
                    continue;
                }
                n4 = WordGrid.addWord(nArray, arrayList, n4, 0);
            }
            WordGrid.addWord(nArray, arrayList, n4, 0);
        }
        for (n5 = 0; n5 < n; ++n5) {
            n4 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                if (cArray[n5 + n3 * n] != '\u007f') {
                    nArray[n4++] = n5 + n3 * n;
                    continue;
                }
                n4 = WordGrid.addWord(nArray, arrayList, n4, 1);
            }
            WordGrid.addWord(nArray, arrayList, n4, 1);
        }
        ArrayList<Word> arrayList2 = arrayList;
        Word[] wordArray = arrayList2.toArray(new Word[arrayList2.size()]);
        return wordArray;
    }

    private static int addWord(int[] nArray, ArrayList<Word> arrayList, int n, int n2) {
        if (n > 1) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            arrayList.add(new Word(arrayList.size(), nArray2, n2));
        }
        return 0;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int edgeCount(int n) {
        int n2;
        int n3 = n;
        Object object = this;
        Word word = ((WordGrid)object).words[n3];
        int n4 = 0;
        object = word;
        int n5 = ((Word)object).letterIndices.length;
        for (n2 = 0; n2 < n5; ++n2) {
            n3 = n2;
            object = word;
            n3 = ((Word)object).letterIndices[n3];
            object = this;
            if (!((n3 %= ((WordGrid)object).width) == 0 || n3 == ((WordGrid)object).width - 1)) continue;
            ++n4;
            break;
        }
        object = word;
        n5 = ((Word)object).letterIndices.length;
        for (n2 = 0; n2 < n5; ++n2) {
            n3 = n2;
            object = word;
            n3 = ((Word)object).letterIndices[n3];
            object = this;
            if (!((n3 /= ((WordGrid)object).width) == 0 || n3 == ((WordGrid)object).height - 1)) continue;
            ++n4;
            break;
        }
        return n4;
    }

    public final Word getWordAt(int n, int n2, boolean n3) {
        int n4 = this.getCrossWordCount(n);
        for (int i = 0; i < n4; ++i) {
            WordGrid wordGrid = this;
            int n5 = wordGrid.getCrossWord(n, i);
            Object object = wordGrid;
            object = wordGrid.words[n5];
            int n6 = n5 = ((Word)object).direction == n2 ? 1 : 0;
            if (n3 != n5) continue;
            return object;
        }
        return null;
    }

    public static int parseDirection(String string) {
        int n = DIR_NAMES.length;
        for (int i = 0; i < n; ++i) {
            if (!DIR_NAMES[i].equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unrecognized direction name: " + string);
    }

    public static final class Word
    implements Comparable<Word> {
        int[] letterIndices;
        private final int wordIndex;
        private int printNumber;
        private int direction;

        public final int getWordIndex() {
            return this.wordIndex;
        }

        public final char getLetter(int n, char[] cArray) {
            return cArray[this.letterIndices[n]];
        }

        public final String getString(char[] cArray) {
            char[] cArray2 = new char[this.letterIndices.length];
            for (int i = 0; i < cArray2.length; ++i) {
                cArray2[i] = this.getLetter(i, cArray);
            }
            return new String(cArray2);
        }

        public final String getDebugString(char[] cArray) {
            char[] cArray2 = new char[this.letterIndices.length];
            for (int i = 0; i < cArray2.length; ++i) {
                int n = this.getLetter(i, cArray);
                if (n == 0) {
                    n = 95;
                } else if (n == 127) {
                    n = 35;
                }
                cArray2[i] = n;
            }
            return new String(cArray2);
        }

        public Word(int n, int[] nArray) {
            int[] nArray2 = nArray;
            int n2 = 1;
            if (nArray2 == null) {
                n2 = 2;
            } else if (nArray2.length < 2 || nArray2[1] == nArray2[0] + 1) {
                n2 = 0;
            }
            this(n, nArray, n2);
        }

        public Word(int n, int[] nArray, int n2) {
            this.wordIndex = n;
            this.letterIndices = nArray;
            this.direction = n2;
        }

        public final int getPrintNumber() {
            return this.printNumber;
        }

        public final void setPrintNumber(int n) {
            this.printNumber = n;
        }

        public final int getDirection() {
            return this.direction;
        }

        public final String toString() {
            return String.format("%d %s (%d)", this.printNumber, DIR_NAMES[this.direction], this.wordIndex);
        }
    }
}

