/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.closedhash.ObjectSet;
import com.beekeeper.xwd.BadStateError;
import com.beekeeper.xwd.SearchNodeProxy;

public abstract class SearchNode
implements SearchNodeProxy,
Comparable<SearchNode> {
    private static int nextNumber = 0;
    public SearchNode parent;
    public int depth;
    protected int liveChildCount;
    boolean isFinished;

    public SearchNode() {
        this.assignID();
    }

    protected final void assignID() {
        Class<SearchNode> clazz = SearchNode.class;
        synchronized (SearchNode.class) {
            ++nextNumber;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public final int getDepth() {
        return this.depth;
    }

    @Override
    public final SearchNode getParent() {
        return this.parent;
    }

    public final void setLiveChildCount(int n) {
        this.liveChildCount = n;
    }

    public final int getLiveChildCount() {
        return this.liveChildCount;
    }

    public SearchNode(SearchNode searchNode) {
        this.parent = searchNode;
        this.depth = searchNode == null ? 0 : searchNode.depth + 1;
        this.liveChildCount = Integer.MAX_VALUE;
    }

    @Override
    public abstract float getPriority();

    public float getQuality() {
        return this.getPriority();
    }

    public abstract boolean isGoalNode();

    public abstract SearchNodeProxy[] generateSuccessors(float var1);

    @Override
    public int compareTo(SearchNode searchNode) {
        float f;
        float f2 = this.getPriority() - searchNode.getPriority();
        if (f < 0.0f) {
            return 1;
        }
        if (f2 == 0.0f) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SearchNode)) {
            return false;
        }
        return ((SearchNode)object).getPriority() == this.getPriority();
    }

    public abstract Fingerprint getFingerprint();

    public void markDead(boolean bl) throws BadStateError {
    }

    public boolean reconcileWithDeadStates(ObjectSet<Fingerprint> object) {
        object = ((ObjectSet)object).getIterator();
        while (((ObjectSet.Iter)object).advance()) {
            if (!((Fingerprint)((ObjectSet.Iter)object).getKey()).matches(this)) continue;
            return false;
        }
        return true;
    }

    public void markFinished() {
        this.isFinished = true;
    }

    @Override
    public final SearchNode getNode() {
        return this;
    }

    public void initForSearch() {
        this.isFinished = false;
    }

    public static abstract class Fingerprint {
        public abstract boolean matches(SearchNode var1);
    }
}

