/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.closedhash.GenericHash;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class ScoreDatabase {
    private static MessageDigest digest;

    public static ScoreDBHash readScoreStream(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream));
        ScoreDBHash scoreDBHash = new ScoreDBHash();
        new ScoreDBHash().minScore = dataInputStream.readInt();
        block0: while (true) {
            int n;
            byte[] byArray = new byte[16];
            for (int i = 0; i < 16; i += n) {
                n = dataInputStream.read(byArray, i, 16 - i);
                if (n < 0) break block0;
            }
            n = dataInputStream.readInt();
            scoreDBHash.put(byArray, n);
        }
        inputStream.close();
        return scoreDBHash;
    }

    public static synchronized float getScoreForWord(String object, ScoreDBHash scoreDBHash) {
        try {
            object = digest.digest(((String)object).getBytes("UTF-8"));
            int n = scoreDBHash.get((byte[])object);
            return n;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    static {
        try {
            digest = MessageDigest.getInstance("MD5");
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    public static final class ScoreDBHash
    extends GenericHash {
        private int minScore = 5;
        private byte[] currentKey;

        @Override
        protected final boolean matchesCurrentKey(GenericHash.GenericHashCell genericHashCell) {
            return Arrays.equals(((ScoreDBHashCell)genericHashCell).key, this.currentKey);
        }

        public final int get(byte[] object) {
            this.currentKey = object;
            ScoreDBHashCell scoreDBHashCell = (ScoreDBHashCell)this.findCell(Arrays.hashCode(object));
            object = scoreDBHashCell;
            if (scoreDBHashCell == null) {
                return this.minScore;
            }
            return object.value;
        }

        public final void put(byte[] byArray, int n) {
            this.currentKey = byArray;
            ScoreDBHashCell scoreDBHashCell = (ScoreDBHashCell)this.findCell(Arrays.hashCode(byArray));
            if (scoreDBHashCell != null) {
                scoreDBHashCell.value = n;
                return;
            }
            this.auxPut(new ScoreDBHashCell(byArray, n));
        }

        public static final class ScoreDBHashCell
        extends GenericHash.GenericHashCell {
            protected byte[] key;
            int value;

            public ScoreDBHashCell(byte[] byArray, int n) {
                super(Arrays.hashCode(byArray));
                this.key = byArray;
                this.value = n;
            }
        }

        public final class Iter
        extends GenericHash.Iter {
            public Iter(ScoreDBHash scoreDBHash) {
                super(scoreDBHash);
            }

            @Override
            protected final void appendString(StringBuilder object) {
                StringBuilder stringBuilder = object;
                Iter iter = this;
                object = iter;
                object = this;
                stringBuilder.append(Arrays.toString(((ScoreDBHashCell)iter.getCell()).key)).append("=>").append(((ScoreDBHashCell)((GenericHash.Iter)object).getCell()).value);
            }
        }
    }
}

