/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.xwd.CharacterRangeScore;
import com.beekeeper.xwd.CharacterScore;
import com.beekeeper.xwd.ConstantCharacterScore;
import com.beekeeper.xwd.GridSearchNode;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.SearchNode;
import com.beekeeper.xwd.SingleCharacterScore;
import com.beekeeper.xwd.WordGrid;
import com.beekeeper.xwd.WordList;
import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Objects;

public final class QualityGridSearchNode
extends GridSearchNode {
    private float varietyFactor = 0.0f;
    private int depthFirstFactor = 1;
    private float[] charScores;
    private CharacterScore[][] wordScores;
    private WeakReference<float[]> extraCharScores;
    private WeakReference<CharacterScore[][]> extraWordScores;
    public HashMap<Integer, Character> forcedChars;

    @Override
    public final synchronized GridSearchNode.GSNProxy conditionalSuccessor(int n, String string, float f) {
        float f2;
        int n2;
        int n3;
        int n4;
        GridState gridState = new GridState(this.state);
        gridState.setString(n, string);
        Object object = gridState.getChars();
        WordGrid wordGrid = gridState.getGrid();
        WordGrid.Word word = wordGrid.getWord(n);
        Object object2 = word;
        int n5 = word.letterIndices.length;
        object2 = this;
        long l = ((QualityGridSearchNode)object2).depthFirstFactor;
        object = new BitSet(((char[])object).length);
        float f3 = this.options.wordList.getWordScore(string) * (float)l;
        f3 *= this.varietyMult();
        CharacterScore[][] characterScoreArray = this.extraWordScores == null ? null : (CharacterScore[][])this.extraWordScores.get();
        if (characterScoreArray == null) {
            characterScoreArray = new CharacterScore[wordGrid.getWordCount()][];
            this.extraWordScores = new WeakReference<CharacterScore[][]>(characterScoreArray);
        }
        for (n4 = 0; n4 < characterScoreArray.length; ++n4) {
            characterScoreArray[n4] = this.wordScores[n4];
        }
        characterScoreArray[n] = new CharacterScore[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            characterScoreArray[n][n4] = new SingleCharacterScore(string.charAt(n4), f3);
        }
        float f4 = this.options.minCandidateScore;
        for (int i = 0; i < n5; ++i) {
            int n6 = i;
            object2 = word;
            int n7 = ((WordGrid.Word)object2).letterIndices[n6];
            ((BitSet)object).set(n7);
            for (n3 = 0; n3 < wordGrid.getCrossWordCount(n7); ++n3) {
                n2 = wordGrid.getCrossWord(n7, n3);
                if (n2 == n || gridState.isComplete(n2)) continue;
                WordGrid.Word word2 = wordGrid.getWord(n2);
                object2 = word2;
                int n8 = word2.letterIndices.length;
                int n9 = 0;
                while (n9 < n8) {
                    n6 = n9++;
                    object2 = word2;
                    ((BitSet)object).set(((WordGrid.Word)object2).letterIndices[n6]);
                }
                characterScoreArray[n2] = new CharacterScore[n8];
                WordList.MatchInfo matchInfo = this.options.wordList.search(gridState, n2, f4);
                int n10 = matchInfo.getMatchCount();
                if (n10 == 0) {
                    return null;
                }
                for (n10 = 0; n10 < n8; ++n10) {
                    characterScoreArray[n2][n10] = object2 = new CharacterRangeScore(matchInfo, n10, false);
                    if (((CharacterRangeScore)object2).getMaxScore() != 0.0f) continue;
                    return null;
                }
            }
        }
        HashMap<Integer, Character> hashMap = new HashMap<Integer, Character>();
        float[] fArray = this.extraCharScores == null ? null : (float[])this.extraCharScores.get();
        if (fArray == null) {
            fArray = new float[this.charScores.length];
            this.extraCharScores = new WeakReference<float[]>(fArray);
        }
        for (n3 = 0; n3 < fArray.length; ++n3) {
            fArray[n3] = this.charScores[n3];
        }
        CharacterScore[] characterScoreArray2 = new CharacterScore[2];
        n2 = ((BitSet)object).nextSetBit(0);
        while (n2 >= 0) {
            float f5;
            fArray[n2] = f5 = this.computeCharScore(n2, characterScoreArray, hashMap, characterScoreArray2);
            n2 = ((BitSet)object).nextSetBit(n2 + 1);
        }
        float f6 = QualityGridSearchNode.recomputeScore(fArray);
        if (f2 > f) {
            return new GridSearchNode.GSNProxy(f6, this, n, string);
        }
        return null;
    }

    private float varietyMult() {
        float f = 1.0f;
        if (this.varietyFactor != 0.0f) {
            f = 1.0f - this.varietyFactor * rand.nextFloat();
        }
        return f;
    }

    @Override
    protected final GridSearchNode makeSuccessor(GridState object) {
        object = (QualityGridSearchNode)super.makeSuccessor((GridState)object);
        v0.charScores = (float[])this.charScores.clone();
        ((QualityGridSearchNode)object).wordScores = (CharacterScore[][])this.wordScores.clone();
        return object;
    }

    private static float recomputeScore(float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i];
            f += f2;
        }
        return f;
    }

    private synchronized void initWordScores() {
        int n;
        HashMap<Integer, Character> hashMap = new HashMap<Integer, Character>();
        this.forcedChars = hashMap;
        char[] cArray = this.state.getChars();
        Comparable<SearchNode> comparable = this;
        long l = comparable.depthFirstFactor;
        WordGrid wordGrid = this.state.getGrid();
        this.wordScores = new CharacterScore[wordGrid.getWordCount()][];
        this.charScores = new float[cArray.length];
        float f = this.options.minCandidateScore;
        for (n = 0; n < wordGrid.getWordCount(); ++n) {
            int n2;
            WordGrid.Word word = wordGrid.getWord(n);
            comparable = word;
            int n3 = word.letterIndices.length;
            this.wordScores[n] = new CharacterScore[n3];
            if (this.state.isComplete(n)) {
                float f2;
                float f3 = this.options.wordList.getWordScore(word.getString(cArray)) * (float)l;
                f3 *= this.varietyMult();
                if (f2 < 1.0f) {
                    f3 = 1.0f;
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    this.wordScores[n][n2] = new SingleCharacterScore(word.getLetter(n2, cArray), f3);
                }
                continue;
            }
            WordList.MatchInfo matchInfo = this.options.wordList.search(this.state, n, f);
            n2 = matchInfo.getMatchCount();
            if (n2 > 300) {
                float f4 = matchInfo.highestMatchScore();
                float f5 = f4;
                f5 = f4;
                f5 = f4 * this.varietyMult();
                ConstantCharacterScore constantCharacterScore = new ConstantCharacterScore(f5, this.options.wordList);
                for (int i = 0; i < n3; ++i) {
                    this.wordScores[n][i] = constantCharacterScore;
                }
                continue;
            }
            for (int i = 0; i < n3; ++i) {
                this.wordScores[n][i] = new CharacterRangeScore(matchInfo, i, false);
            }
        }
        for (n = 0; n < cArray.length; ++n) {
            this.charScores[n] = this.computeCharScore(n, this.wordScores, hashMap, null);
        }
        this.priority = QualityGridSearchNode.recomputeScore(this.charScores);
    }

    private float computeCharScore(int n, CharacterScore[][] characterScoreArray, HashMap<Integer, Character> hashMap, CharacterScore[] characterScoreArray2) {
        char c;
        char c2;
        int n2;
        WordGrid wordGrid = this.state.getGrid();
        int n3 = wordGrid.getCrossWordCount(n);
        if (n3 == 0) {
            return 0.0f;
        }
        char c22 = '\u0000';
        int c3 = 256;
        int n4 = 0;
        characterScoreArray2 = characterScoreArray2 == null || characterScoreArray2.length < n3 ? new CharacterScore[n3] : characterScoreArray2;
        block0: for (int i = 0; i < n3; ++i) {
            int c4 = wordGrid.getCrossWord(n, i);
            WordGrid.Word word = wordGrid.getWord(c4);
            n2 = 0;
            WordGrid.Word word2 = word;
            int n5 = word2.letterIndices.length;
            while (n2 < n5) {
                int n6 = n2++;
                word2 = word;
                if (word2.letterIndices[n6] != n) continue;
                CharacterScore characterScore = characterScoreArray[c4][n2];
                characterScoreArray2[n4++] = characterScore;
                c22 = (char)Math.max(c22, characterScore.rangeStart());
                c3 = (char)Math.min(c3, characterScore.rangeEnd());
                continue block0;
            }
        }
        float f = 0.0f;
        char c5 = c22;
        while (c2 < c3) {
            float f2 = 1.0f;
            for (n2 = 0; n2 < n4; ++n2) {
                f2 *= characterScoreArray2[n2].getScore(c2);
            }
            if (f2 > f) {
                f = f2;
            }
            c2 = (char)(c2 + true);
        }
        if (f == 0.0f) {
            char c6 = this.state.getChars()[n];
            if (c6 == '\u0000') {
                hashMap.put(n, Character.valueOf(' '));
            }
            return Float.NEGATIVE_INFINITY;
        }
        if (c3 == c22 + 1 && (c = this.state.getChars()[n]) == '\u0000') {
            hashMap.put(n, Character.valueOf(c22));
        }
        return (float)Math.sqrt(f);
    }

    @Override
    public final synchronized void setString(int n, String object) {
        WordGrid.Word word;
        super.setString(n, (String)object);
        this.latestWord = n;
        object = this.state.getChars();
        WordGrid wordGrid = this.state.getGrid();
        Comparable<WordGrid.Word> comparable = word = wordGrid.getWord(n);
        int n2 = word.letterIndices.length;
        comparable = this;
        long l = ((QualityGridSearchNode)comparable).depthFirstFactor;
        BitSet bitSet = new BitSet(((Object)object).length);
        float f = this.options.wordList.getWordScore(word.getString((char[])object)) * (float)l;
        f *= this.varietyMult();
        if (this.priority < 1.0f) {
            this.priority = 1.0f;
        }
        this.wordScores[n] = new CharacterScore[n2];
        for (int i = 0; i < n2; ++i) {
            this.wordScores[n][i] = new SingleCharacterScore(word.getLetter(i, (char[])object), f);
        }
        float f2 = this.options.minCandidateScore;
        int n3 = 0;
        while (true) {
            comparable = word;
            if (n3 >= comparable.letterIndices.length) break;
            int n4 = n3;
            comparable = word;
            n2 = comparable.letterIndices[n4];
            bitSet.set(n2);
            for (int i = 0; i < wordGrid.getCrossWordCount(n2); ++i) {
                WordGrid.Word word2;
                int n5 = wordGrid.getCrossWord(n2, i);
                comparable = word2 = wordGrid.getWord(n5);
                int n6 = word2.letterIndices.length;
                if (n5 == n || this.state.isComplete(n5)) continue;
                int n7 = 0;
                while (n7 < n6) {
                    n4 = n7++;
                    comparable = word2;
                    bitSet.set(comparable.letterIndices[n4]);
                }
                this.wordScores[n5] = new CharacterScore[n6];
                WordList.MatchInfo matchInfo = this.options.wordList.search(this.state, n5, f2);
                int n8 = matchInfo.getMatchCount();
                if (n8 == 0) {
                    this.priority = Float.NEGATIVE_INFINITY;
                    return;
                }
                if (n8 > 300) {
                    float f3 = matchInfo.highestMatchScore();
                    ConstantCharacterScore constantCharacterScore = new ConstantCharacterScore(f3 *= this.varietyMult(), this.options.wordList);
                    for (int j = 0; j < n6; ++j) {
                        this.wordScores[n5][j] = constantCharacterScore;
                    }
                    continue;
                }
                for (n8 = 0; n8 < n6; ++n8) {
                    this.wordScores[n5][n8] = new CharacterRangeScore(matchInfo, n8, false);
                }
            }
            ++n3;
        }
        HashMap<Integer, Character> hashMap = new HashMap<Integer, Character>();
        n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            float f4;
            this.charScores[n2] = f4 = this.computeCharScore(n2, this.wordScores, hashMap, null);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        this.priority = QualityGridSearchNode.recomputeScore(this.charScores);
    }

    public QualityGridSearchNode(GridSearchNode gridSearchNode, GridState gridState, GridSearchNode.SharedOptions sharedOptions, int n, float f) {
        super(gridSearchNode, gridState, sharedOptions);
        if (sharedOptions.orderStrategy == GridSearchNode.FillOrder.UNSPECIFIED) {
            sharedOptions.orderStrategy = GridSearchNode.FillOrder.QUALITY;
        }
        this.initWordScores();
    }

    @Override
    public final String toString() {
        return String.format("%4.2f:%s", Float.valueOf(this.getPriority()), this.dumpSequence());
    }

    @Override
    public final boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (QualityGridSearchNode)object;
        return this.latestWord == ((QualityGridSearchNode)object).latestWord && this.priority == ((QualityGridSearchNode)object).priority && this.chooseWordToFill() == ((GridSearchNode)object).chooseWordToFill();
    }

    public final int hashCode() {
        return Objects.hash(this.latestWord, Float.valueOf(this.priority), this.chooseWordToFill());
    }

    private String dumpSequence() {
        if (this.parent == null) {
            return "<ROOT>";
        }
        return ((QualityGridSearchNode)this.parent).dumpSequence() + ":" + (this.latestWord == -1 ? "???" : this.state.getGrid().getWord(this.latestWord).getDebugString(this.state.getChars()));
    }
}

