/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.GUIUtil;
import com.beekeeper.xwd.GridDisplay;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.WordGrid;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.WeakHashMap;

public final class PuzzlePainter
implements Printable {
    private final GridState state;
    private final boolean showGrid;
    private final boolean showClues;
    private final boolean twoPage;
    private ArrayList<WeakHashMap<PageFormat, MyLayout>> printMaps = new ArrayList();

    public PuzzlePainter(GridState gridState) {
        this(gridState, true, true, false);
    }

    private PuzzlePainter(GridState gridState, boolean bl, boolean bl2, boolean bl3) {
        this.printMaps.add(new WeakHashMap());
        this.printMaps.add(new WeakHashMap());
        this.state = gridState;
        this.showGrid = true;
        this.showClues = true;
        this.twoPage = false;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private MyLayout computeLayout(Graphics2D var1_1, int var2_3, int var3_6, boolean var4_8, boolean var5_11, boolean var6_12, boolean var7_13) {
        var8_14 = 4;
        var9_15 = this.state.getGrid();
        var10_16 = this.state.getSortedWords(0);
        var11_17 = this.state.getSortedWords(1);
        var12_18 = null;
        if (!var6_12) {
            var14_19 = new MyLayout(this);
            new MyLayout(this).colSpace = var2_3 * 15 / 1000;
            var14_19.clueFont = Font.decode("SansSerif").deriveFont(12.0f);
            var14_19.colHeadFont = var14_19.clueFont.deriveFont(1);
            var14_19.cprtFont = var14_19.colHeadFont.deriveFont(9.0f);
            var14_19.noteFont = var14_19.clueFont.deriveFont(2, 10.0f);
            var14_19.colWidth = 0;
            var14_19.frc = var1_1.getFontRenderContext();
            var14_19.chfm = var1_1.getFontMetrics(var14_19.colHeadFont);
            this.computerHeaderLayout(var14_19, (Graphics2D)var1_1, 15, var2_3, var7_13, var5_11);
            var15_21 = var2_3;
            var16_23 = var1_1.getFontMetrics(var14_19.cprtFont);
            var16_24 = var16_23.getHeight();
            var17_28 = var3_6 - var14_19.hdrOffset - var16_24 - var16_24;
            var14_19.squareSize = var18_30 = Math.min((var15_21 - 1) / var9_15.getWidth(), (var17_28 - 1) / var9_15.getHeight());
            var19_33 = new Dimension(var14_19.squareSize * var9_15.getWidth() + 1, var14_19.squareSize * var9_15.getHeight() + 1);
            var14_19.gridDisplay = new GridDisplay(new Font("SansSerif", 1, 24), this.state);
            var14_19.displayLayout = var14_19.gridDisplay.computeLayout((Graphics)var1_1, true, var19_33, (boolean)var4_8);
            return var14_19;
        }
        var14_20 = 5;
        while (true) {
            var13_35 = this.tryLayout$59bc92cc((Graphics2D)var1_1, var2_3, var3_6, var14_20, var10_16, var11_17, var8_14, var5_11, var6_12, var7_13);
            var15_22 = var1_1.getFontMetrics(var13_35.clueFont);
            if (var15_22.stringWidth("Song standard with ") + var13_35.numWidth > var13_35.colWidth) {
                if (var8_14 <= 2) break;
                --var8_14;
                continue;
            }
            var16_26 = var1_1.getFontMetrics(var13_35.cprtFont);
            var16_25 = var16_26.getHeight();
            var17_29 = var13_35.minSmallColHeight;
            var19_34 = var2_3 - var13_35.colWidth - var13_35.colSpace - 1;
            var20_36 = var3_6 - var13_35.hdrOffset - var17_29 - var16_25 - var16_25;
            if (var5_11) {
                var18_31 = Math.min(var19_34 / var9_15.getWidth(), var20_36 / var9_15.getHeight());
                var13_35.gridOffset = var18_31 * var9_15.getHeight() + 1 + var16_25 + var16_25;
                if (var18_31 <= var14_20 * 5 / 3) {
                    break;
                }
            } else {
                var21_37 = Math.min(var19_34 / 15, var20_36 / 15);
                if (var21_37 <= var14_20 * 5 / 3) break;
                var18_31 = 0;
                if (var17_29 > var3_6 - var13_35.hdrOffset) break;
                var13_35.gridOffset = 0;
            }
            var13_35.squareSize = var18_31;
            ++var14_20;
            var12_18 = var13_35;
        }
        var15_22 = var12_18 != null ? var12_18 : var13_35;
        var16_27 /* !! */  = new Dimension(var15_22.squareSize * var9_15.getWidth() + 1, var15_22.squareSize * var9_15.getHeight() + 1);
        var15_22.displayLayout = var15_22.gridDisplay.computeLayout((Graphics)var1_1, true, var16_27 /* !! */ , (boolean)var4_8);
        var16_27 /* !! */  = var1_1.getFontMetrics(var15_22.clueFont);
        var17_29 = var15_22.colWidth - var15_22.numWidth;
        var18_32 = new HashMap<WordGrid.Word, Integer>();
        var19_34 = GUIUtil.textWrapFontHeight(var15_22.clueFont, (Graphics)var1_1, (FontMetrics)var16_27 /* !! */ );
        var20_36 = GUIUtil.textWrapFontHeight(var15_22.colHeadFont, (Graphics)var1_1, var15_22.chfm);
        for (WordGrid.Word var2_4 : var15_22.allWords) {
            var4_8 = GUIUtil.doTextWrapping((Graphics2D)var1_1, var15_22.clueFont, this.state.getClue(var2_4.getWordIndex()), var17_29, var15_22.frc, (FontMetrics)var16_27 /* !! */ , var19_34);
            if (var2_4 == var15_22.acrossWords.get(0)) {
                var4_8 += var20_36;
            } else if (var2_4 == var15_22.downWords.get(0)) {
                var4_8 += var20_36 + var19_34;
            }
            var18_32.put(var2_4, var4_8);
        }
        var21_38 = new ArrayList<E>(var15_22.clueColumns);
        var2_5 = new int[var15_22.clueColumns];
        for (var4_8 = 0; var4_8 < var15_22.clueColumns; ++var4_8) {
            var21_38.add(new LinkedList<E>());
        }
        for (Object var1_1 : var15_22.allWords) {
            ((LinkedList)var21_38.get(0)).add(var1_1);
            var2_5[0] = var2_5[0] + (Integer)var18_32.get(var1_1);
        }
        var2_5[0] = var2_5[0] - var15_22.gridOffset;
        var4_10 = var3_6 - var15_22.hdrOffset - var15_22.gridOffset;
        block4: while (true) {
            var1_2 = 1;
            while (true) {
                if (var1_2 >= var15_22.clueColumns) continue block4;
                var6_12 = var2_5[var1_2 - 1] - var2_5[var1_2];
                var3_7 = (WordGrid.Word)((LinkedList)var21_38.get(var1_2 - 1)).getLast();
                var5_11 = ((Integer)var18_32.get(var3_7)).intValue();
                var7_13 = var6_12 - var5_11 - var5_11;
                if (Math.abs((int)var7_13) > Math.abs((int)var6_12) && var2_5[var1_2 - 1] <= var4_10) {
                    if (var1_2 == 1) ** break;
                    continue block4;
                    break block4;
                }
                ((LinkedList)var21_38.get(var1_2 - 1)).removeLast();
                ((LinkedList)var21_38.get(var1_2)).addFirst(var3_7);
                v0 = var1_2 - 1;
                var2_5[v0] = var2_5[v0] - var5_11;
                v1 = var1_2++;
                var2_5[v1] = var2_5[v1] + var5_11;
            }
            break;
        }
        var15_22.clueDivisions = var21_38;
        return var15_22;
    }

    private void computerHeaderLayout(MyLayout myLayout, Graphics2D graphics2D, int n, int n2, boolean bl, boolean bl2) {
        myLayout.hdrOffset = 0;
        myLayout.hdrFont = myLayout.clueFont.deriveFont(1, n);
        if (!bl) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics(myLayout.hdrFont);
        int n3 = GUIUtil.textWrapFontHeight(myLayout.hdrFont, graphics2D, fontMetrics);
        String string = this.state.getTitle().trim();
        String string2 = this.state.getAuthor().trim();
        String string3 = this.state.getNotepad().trim();
        if (string2.length() > 0 && string.length() > 0) {
            int n4;
            int n5 = fontMetrics.stringWidth(string);
            if (n5 + (n4 = fontMetrics.stringWidth(string2)) + 20 < n2) {
                int n6 = n3;
                myLayout.hdrOffset = n6 + n6 / 4;
                myLayout.titleLoc = new Point(0, 0);
                myLayout.authorLoc = new Point(n2 - n4, 0);
                myLayout.cpLoc = new Point(0, n3);
                if (var6_8 == false) {
                    myLayout.hdrOffset += GUIUtil.textWrapFontHeight(myLayout.cprtFont, graphics2D, null);
                }
            } else {
                myLayout.titleLoc = new Point(0, myLayout.hdrOffset);
                if (string.length() > 0) {
                    myLayout.hdrOffset += GUIUtil.doTextWrapping(graphics2D, myLayout.hdrFont, string, n2, myLayout.frc, fontMetrics, n3);
                }
                myLayout.authorLoc = new Point(0, myLayout.hdrOffset);
                if (string2.length() > 0) {
                    myLayout.hdrOffset += GUIUtil.doTextWrapping(graphics2D, myLayout.hdrFont, string2, n2, myLayout.frc, fontMetrics, n3);
                }
                myLayout.cpLoc = new Point(0, myLayout.hdrOffset);
                if (var6_8 == false) {
                    myLayout.hdrOffset += GUIUtil.textWrapFontHeight(myLayout.cprtFont, graphics2D, null);
                }
                myLayout.hdrOffset += n3 / 4;
            }
        }
        if (string3 != null && !string3.isEmpty()) {
            myLayout.noteLoc = new Point(0, myLayout.hdrOffset);
            myLayout.hdrOffset += GUIUtil.doTextWrapping(graphics2D, myLayout.noteFont, string3, n2, myLayout.frc, null, -1);
            myLayout.hdrOffset += n3 / 4;
        }
    }

    /*
     * WARNING - void declaration
     */
    private MyLayout tryLayout$59bc92cc(Graphics2D object4, int n, int n2, int n3, ArrayList<WordGrid.Word> hashMap2, ArrayList<WordGrid.Word> object2, int n4, boolean bl, boolean bl2, boolean bl3) {
        void var9_24;
        void var8_22;
        void var10_26;
        int n5;
        void var4_12;
        void var2_8;
        MyLayout myLayout = new MyLayout(this);
        new MyLayout(this).colSpace = var2_8 * 15 / 1000;
        int n6 = (var4_12 * 5 + 3) / 4;
        void var13_33 = ((var4_12 << 1) + true) / 3;
        void var14_34 = ((var4_12 << 2) + 3) / 5;
        myLayout.clueColumns = n5;
        myLayout.clueFont = Font.decode("SansSerif").deriveFont((float)var4_12);
        myLayout.colHeadFont = myLayout.clueFont.deriveFont(1);
        myLayout.cprtFont = myLayout.colHeadFont.deriveFont((float)var13_33);
        myLayout.noteFont = myLayout.clueFont.deriveFont(2, (float)var14_34);
        this.computerHeaderLayout(myLayout, (Graphics2D)object4, n6, (int)var2_8, (boolean)var10_26, (boolean)var8_22);
        myLayout.colWidth = (var2_8 + myLayout.colSpace) / n5 - myLayout.colSpace;
        myLayout.frc = ((Graphics2D)object4).getFontRenderContext();
        Object object = ((Graphics)object4).getFontMetrics(myLayout.clueFont);
        myLayout.chfm = ((Graphics)object4).getFontMetrics(myLayout.colHeadFont);
        if (var9_24 != false) {
            int n7;
            int n8;
            String string;
            void var5_15;
            myLayout.acrossWords = var5_15;
            myLayout.downWords = string;
            myLayout.allWords = new ArrayList(myLayout.acrossWords.size() + myLayout.downWords.size());
            myLayout.allWords.addAll(myLayout.acrossWords);
            myLayout.allWords.addAll(myLayout.downWords);
            double d = 0.0;
            for (WordGrid.Word word : myLayout.allWords) {
                string = word.getPrintNumber() + ". ";
                d = Math.max(d, myLayout.chfm.getStringBounds(string, (Graphics)object4).getWidth());
            }
            myLayout.numWidth = (int)Math.ceil(d);
            int n9 = myLayout.colWidth - myLayout.numWidth;
            HashMap<WordGrid.Word, Integer> hashMap = new HashMap<WordGrid.Word, Integer>();
            int n10 = GUIUtil.textWrapFontHeight(myLayout.clueFont, (Graphics)object4, (FontMetrics)object);
            int n11 = GUIUtil.textWrapFontHeight(myLayout.colHeadFont, (Graphics)object4, myLayout.chfm);
            for (WordGrid.Word word : myLayout.allWords) {
                n6 = GUIUtil.doTextWrapping((Graphics2D)object4, myLayout.clueFont, this.state.getClue(word.getWordIndex()), n9, myLayout.frc, (FontMetrics)object, n10);
                if (word == myLayout.acrossWords.get(0)) {
                    n6 += n11;
                } else if (word == myLayout.downWords.get(0)) {
                    n6 += n11 + n10;
                }
                hashMap.put(word, n6);
            }
            ArrayList arrayList = new ArrayList(n5);
            int[] nArray = new int[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                arrayList.add(new LinkedList());
            }
            for (WordGrid.Word n14 : myLayout.allWords) {
                ((LinkedList)arrayList.get(0)).add(n14);
                nArray[0] = nArray[0] + (Integer)hashMap.get(n14);
            }
            void var12_32 = n8 - myLayout.hdrOffset;
            block4: while (nArray[0] > var12_32) {
                void var1_5;
                boolean bl4 = true;
                while (var1_5 < n5) {
                    n9 = nArray[var1_5 - true] - nArray[var1_5];
                    object = (WordGrid.Word)((LinkedList)arrayList.get((int)(var1_5 - true))).getLast();
                    n8 = (Integer)hashMap.get(object);
                    n10 = n9 - n8 - n8;
                    if (Math.abs(n10) > Math.abs(n9)) {
                        if (var1_5 != true) continue block4;
                        break block4;
                    }
                    ((LinkedList)arrayList.get((int)(var1_5 - true))).removeLast();
                    ((LinkedList)arrayList.get((int)var1_5)).addFirst(object);
                    void v0 = var1_5 - true;
                    nArray[v0] = nArray[v0] - n8;
                    void v1 = var1_5++;
                    nArray[v1] = nArray[v1] + n8;
                }
            }
            boolean bl5 = false;
            for (int i = 1; i < n5; ++i) {
                if (nArray[i] <= n7) continue;
                n7 = nArray[i];
            }
            myLayout.minSmallColHeight = n7;
            myLayout.clues = true;
        } else {
            myLayout.minSmallColHeight = 0;
            myLayout.clues = false;
        }
        myLayout.gridDisplay = new GridDisplay(new Font("SansSerif", 1, 24), this.state);
        return myLayout;
    }

    public final void doPaint(Graphics2D graphics2D, int n, int n2) {
        MyLayout myLayout = this.computeLayout(graphics2D, n, n2, false, this.showGrid, this.showClues, true);
        this.doPaint$9222a3f(myLayout, graphics2D, n, n2);
    }

    private void doPaint$9222a3f(MyLayout myLayout, Graphics2D graphics2D, int n, int n2) {
        String string;
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.setColor(Color.black);
        WordGrid wordGrid = this.state.getGrid();
        Object object = graphics2D.getFontMetrics(myLayout.hdrFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(myLayout.cprtFont);
        FontMetrics fontMetrics2 = graphics2D.getFontMetrics(myLayout.clueFont);
        int n3 = myLayout.squareSize * wordGrid.getWidth() + 1;
        int n4 = myLayout.squareSize * wordGrid.getHeight() + 1;
        if (myLayout.hdrOffset > 0) {
            String string2 = this.state.getTitle().trim();
            String string3 = this.state.getAuthor().trim();
            string = this.state.getNotepad().trim();
            if (string2.length() > 0) {
                GUIUtil.doTextWrapping(myLayout.titleLoc.x, myLayout.titleLoc.y, graphics2D, myLayout.hdrFont, string2, n, myLayout.frc, (FontMetrics)object, -1);
            }
            if (string3.length() > 0) {
                GUIUtil.doTextWrapping(myLayout.authorLoc.x, myLayout.authorLoc.y, graphics2D, myLayout.hdrFont, string3, n, myLayout.frc, (FontMetrics)object, -1);
            }
            if (n4 == 1 && ((String)(object = this.state.getCopyright().trim())).length() > 0) {
                graphics2D.setFont(myLayout.cprtFont);
                Object object2 = object;
                if (((String)object2).indexOf(169) == -1) {
                    object2 = "\u00a9 " + (String)object2;
                }
                graphics2D.drawString((String)object2, myLayout.cpLoc.x, myLayout.cpLoc.y + fontMetrics.getAscent());
            }
            if (!string.isEmpty() && myLayout.noteLoc != null) {
                GUIUtil.doTextWrapping(myLayout.noteLoc.x, myLayout.noteLoc.y, graphics2D, myLayout.noteFont, string, n, myLayout.frc, null, -1);
            }
        }
        if (myLayout.clues) {
            int n5 = myLayout.colWidth - myLayout.numWidth;
            int n6 = GUIUtil.textWrapFontHeight(myLayout.clueFont, graphics2D, fontMetrics2);
            int n7 = GUIUtil.textWrapFontHeight(myLayout.colHeadFont, graphics2D, myLayout.chfm);
            int n8 = fontMetrics2.getAscent();
            int n9 = 0;
            int n10 = 0;
            while (n9 < myLayout.clueColumns) {
                int n11 = myLayout.hdrOffset;
                if (n9 > 0) {
                    n11 += myLayout.gridOffset;
                }
                graphics2D.setFont(myLayout.colHeadFont);
                for (WordGrid.Word word : myLayout.clueDivisions.get(n9)) {
                    if (word == myLayout.acrossWords.get(0)) {
                        n11 += GUIUtil.doTextWrapping(n10, n11, graphics2D, myLayout.colHeadFont, "ACROSS", myLayout.colWidth, myLayout.frc, myLayout.chfm, n7);
                    } else if (word == myLayout.downWords.get(0)) {
                        if (word != myLayout.clueDivisions.get(n9).getFirst()) {
                            n11 += n6;
                        }
                        n11 += GUIUtil.doTextWrapping(n10, n11, graphics2D, myLayout.colHeadFont, "DOWN", myLayout.colWidth, myLayout.frc, myLayout.chfm, n7);
                    }
                    String string2 = word.getPrintNumber() + ". ";
                    int n12 = myLayout.numWidth - myLayout.chfm.stringWidth(string2);
                    graphics2D.drawString(string2, n10 + n12, n11 + n8);
                    String object3 = this.state.getClue(word.getWordIndex());
                    n11 += GUIUtil.doTextWrapping(n10 + myLayout.numWidth, n11, graphics2D, myLayout.clueFont, object3, n5, myLayout.frc, fontMetrics2, n6);
                }
                ++n9;
                n10 += myLayout.colWidth + myLayout.colSpace;
            }
        }
        if (n4 > 1) {
            int n13 = 0;
            if (myLayout.clues) {
                n13 = (n + myLayout.colWidth + myLayout.colSpace - n3) / 2;
            }
            int n14 = 0;
            if (myLayout.hdrOffset > 0) {
                n14 = 5 + myLayout.hdrOffset;
            }
            graphics2D.translate(n13, n14);
            myLayout.gridDisplay.paintGrid(myLayout.displayLayout, graphics2D, false, true, false, true);
            string = this.state.getCopyright().trim();
            if (string.length() > 0) {
                graphics2D.setFont(myLayout.cprtFont);
                Object object4 = string;
                if (((String)object4).indexOf(169) == -1) {
                    object4 = "\u00a9 " + (String)object4;
                }
                graphics2D.drawString((String)object4, 0, n4 + fontMetrics.getAscent() + fontMetrics.getLeading());
            }
        }
    }

    @Override
    public final int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        MyLayout myLayout;
        graphics = GUIUtil.setHighQualityHints(graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (n > 1) {
            return 1;
        }
        if (n > 0 && !this.twoPage) {
            return 1;
        }
        int n2 = (int)(pageFormat.getWidth() - pageFormat.getImageableWidth()) / 2;
        n2 = Math.max(0, 36 - n2);
        int n3 = (int)pageFormat.getImageableWidth() - (n2 << 1);
        int n4 = (int)pageFormat.getImageableHeight() - (n2 << 1);
        ArrayList<WeakHashMap<PageFormat, MyLayout>> arrayList = this.printMaps;
        synchronized (arrayList) {
            WeakHashMap<PageFormat, MyLayout> weakHashMap = this.printMaps.get(n);
            myLayout = weakHashMap.get(pageFormat);
            if (myLayout == null) {
                myLayout = this.computeLayout((Graphics2D)graphics, n3, n4, true, this.showGrid && n == 0, this.showClues && (n == 1 || !this.twoPage), n == 0);
                weakHashMap.put(pageFormat, myLayout);
            }
        }
        ((Graphics2D)graphics).translate(pageFormat.getImageableX() + (double)n2, pageFormat.getImageableY() + (double)n2);
        this.doPaint$9222a3f(myLayout, (Graphics2D)graphics, n3, n4);
        return 0;
    }

    final class MyLayout {
        public Font clueFont;
        public Font colHeadFont;
        public Font hdrFont;
        public Font cprtFont;
        public Font noteFont;
        public GridDisplay gridDisplay;
        public int colSpace;
        public int colWidth;
        public FontRenderContext frc;
        public FontMetrics chfm;
        public ArrayList<WordGrid.Word> acrossWords;
        public ArrayList<WordGrid.Word> downWords;
        public int numWidth;
        public int hdrOffset;
        public int clueColumns;
        public GridDisplay.MyLayout displayLayout;
        public int squareSize;
        public boolean clues;
        public Point titleLoc;
        public Point authorLoc;
        public Point cpLoc;
        public Point noteLoc;
        public ArrayList<WordGrid.Word> allWords;
        public int minSmallColHeight;
        public int gridOffset;
        public ArrayList<LinkedList<WordGrid.Word>> clueDivisions;

        MyLayout(PuzzlePainter puzzlePainter) {
        }
    }
}

