/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.ImageUtil;
import com.beekeeper.xwd.RebusConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class JPZGrid
implements RebusConstants {
    public int width = 0;
    public int height = 0;
    public char[] gridChars;
    public String title;
    public String author;
    public String copyright;
    public String notepad;
    public ArrayList<WordInfo> words;
    public BitSet circles = new BitSet();
    public Map<String, ImageUtil> rebuses = new HashMap<String, ImageUtil>();

    public JPZGrid(File file) throws IOException, SAXException {
        this(new FileInputStream(file));
    }

    private JPZGrid(InputStream inputStream) throws IOException, SAXException {
        inputStream = new ZipInputStream(inputStream);
        ((ZipInputStream)inputStream).getNextEntry();
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        JPZTextHandler jPZTextHandler = new JPZTextHandler(this);
        xMLReader.setContentHandler(jPZTextHandler);
        xMLReader.setErrorHandler(jPZTextHandler);
        xMLReader.parse(new InputSource(inputStream));
    }

    final class JPZTextHandler
    extends DefaultHandler {
        private final LinkedList<String> tagStack = new LinkedList();
        private final LinkedList<Object> dataStack = new LinkedList();
        private Boolean handled = Boolean.FALSE;
        private final LinkedList<Boolean> handledStack = new LinkedList();
        private StringBuilder charBuff;
        private int buffLevel;
        private /* synthetic */ JPZGrid this$0;

        public JPZTextHandler(JPZGrid jPZGrid) {
            this.this$0 = jPZGrid;
        }

        @Override
        public final void startElement(String object, String object2, String string, Attributes attributes) {
            this.handledStack.addFirst(this.handled);
            this.tagStack.addFirst((String)object2);
            if (this.charBuff != null) {
                this.charBuff.append("<").append((String)object2);
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    this.charBuff.append(" ").append(attributes.getLocalName(i)).append("=\"");
                    this.charBuff.append(attributes.getValue(i)).append("\"");
                }
                this.charBuff.append(">");
                return;
            }
            this.handled = Boolean.TRUE;
            if (((String)object2).equals("grid")) {
                object2 = attributes;
                object = this;
                this.this$0.width = Integer.parseInt(object2.getValue("width"));
                ((JPZTextHandler)object).this$0.height = Integer.parseInt(object2.getValue("height"));
                ((JPZTextHandler)object).this$0.gridChars = new char[((JPZTextHandler)object).this$0.width * ((JPZTextHandler)object).this$0.height];
                Arrays.fill(((JPZTextHandler)object).this$0.gridChars, '\u0000');
                return;
            }
            if (((String)object2).equals("cell")) {
                object2 = attributes;
                object = this;
                int n = Integer.parseInt(object2.getValue("x"));
                int n2 = Integer.parseInt(object2.getValue("y"));
                String string2 = object2.getValue("solution");
                n = (n2 - 1) * ((JPZTextHandler)object).this$0.width + (n - 1);
                if (string2 != null) {
                    if ((string2 = string2.toLowerCase()).length() == 1) {
                        ((JPZTextHandler)object).this$0.gridChars[n] = string2.charAt(0);
                    } else {
                        ImageUtil imageUtil = ((JPZTextHandler)object).this$0.rebuses.get(string2);
                        if (imageUtil == null) {
                            if (((JPZTextHandler)object).this$0.rebuses.size() >= RebusConstants.REBUS_INPUTS.length) {
                                throw new IllegalArgumentException("No more than " + RebusConstants.REBUS_INPUTS.length + " rebuses allowed.");
                            }
                            char c = string2.charAt(0);
                            char c2 = RebusConstants.REBUS_INPUTS[((JPZTextHandler)object).this$0.rebuses.size()];
                            imageUtil = new ImageUtil(string2, c2, c);
                            ((JPZTextHandler)object).this$0.rebuses.put(string2, imageUtil);
                        }
                        ((JPZTextHandler)object).this$0.gridChars[n] = imageUtil.inputChar;
                    }
                } else if ("block".equals(object2.getValue("type"))) {
                    ((JPZTextHandler)object).this$0.gridChars[n] = 127;
                } else {
                    throw new IllegalArgumentException("Bad cell declaration: " + (Attributes)object2);
                }
                String string3 = object2.getValue("background-shape");
                if ("circle".equals(string3)) {
                    ((JPZTextHandler)object).this$0.circles.set(n);
                }
                return;
            }
            if (((String)object2).equals("word")) {
                this.doWord(attributes);
                return;
            }
            if (((String)object2).equals("clue")) {
                int n = Integer.parseInt(attributes.getValue("word")) - 1;
                int n3 = Integer.parseInt(attributes.getValue("number"));
                if (n >= this.this$0.words.size()) {
                    throw new IllegalStateException("Clue without word: " + attributes);
                }
                WordInfo wordInfo = this.this$0.words.get(n);
                if (wordInfo == null) {
                    throw new IllegalStateException("Clue without word: " + attributes);
                }
                wordInfo.number = n3;
                this.dataStack.addFirst(wordInfo);
            }
        }

        private void doWord(Attributes attributes) {
            int n;
            int n2;
            int n3;
            int n4 = Integer.parseInt(attributes.getValue("id")) - 1;
            String string = attributes.getValue("x");
            String string2 = attributes.getValue("y");
            int n5 = string.indexOf(45);
            if (n5 != -1) {
                n3 = Integer.parseInt(string.substring(0, n5));
                n5 = Integer.parseInt(string.substring(n5 + 1));
                n2 = Integer.parseInt(string2);
                n = n5 - n3 + 1;
                n5 = 0;
            } else {
                n5 = string2.indexOf(45);
                if (n5 == -1) {
                    throw new IllegalStateException("Ill formed word: " + attributes);
                }
                n3 = Integer.parseInt(string);
                n2 = Integer.parseInt(string2.substring(0, n5));
                n5 = Integer.parseInt(string2.substring(n5 + 1));
                n = n5 - n2 + 1;
                n5 = 1;
            }
            WordInfo wordInfo = new WordInfo((n2 - 1) * this.this$0.width + (n3 - 1), n, n5);
            if (this.this$0.words == null) {
                this.this$0.words = new ArrayList();
            }
            while (this.this$0.words.size() < n4) {
                this.this$0.words.add(null);
            }
            this.this$0.words.add(n4, wordInfo);
        }

        @Override
        public final void endElement(String string, String string2, String string3) {
            string = "";
            if (this.charBuff != null) {
                if (this.tagStack.size() > this.buffLevel) {
                    this.charBuff.append("</").append(string2).append(">");
                    this.handledStack.removeFirst();
                    this.tagStack.removeFirst();
                    return;
                }
                string = this.charBuff.toString();
                this.charBuff = null;
            }
            boolean bl = true;
            if (string2.equals("clue")) {
                WordInfo wordInfo = (WordInfo)this.dataStack.removeFirst();
                ((WordInfo)this.dataStack.removeFirst()).clue = string;
            } else if (string2.equals("title")) {
                if (this.tagStack.get(1).equals("metadata")) {
                    this.this$0.title = string;
                }
            } else if (string2.equals("creator")) {
                this.this$0.author = string;
            } else if (string2.equals("copyright")) {
                this.this$0.copyright = string;
            } else if (string2.equals("description")) {
                this.this$0.notepad = string;
            } else {
                bl = false;
            }
            if (bl) {
                this.handled = Boolean.TRUE;
            }
            if (!this.handled.booleanValue()) {
                throw new IllegalStateException("Unhandled tag: " + string2);
            }
            this.handledStack.removeFirst();
            this.tagStack.removeFirst();
        }

        @Override
        public final void characters(char[] cArray, int n, int n2) {
            boolean bl = false;
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    if (Character.isWhitespace(cArray[n + i])) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                return;
            }
            if (this.charBuff == null) {
                this.charBuff = new StringBuilder();
                this.buffLevel = this.tagStack.size();
            }
            this.charBuff.append(cArray, n, n2);
        }
    }

    public static final class WordInfo {
        public final int square;
        public final int dir;
        public String clue;
        public int number;

        public WordInfo(int n, int n2, int n3) {
            this.square = n;
            this.dir = n3;
        }
    }
}

