/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.ImageUtil;
import com.beekeeper.util.StringUtil;
import com.beekeeper.util.closedhash.IntObjectHash;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.RebusConstants;
import com.beekeeper.xwd.WordGrid;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class IPuzGrid {
    protected String title;
    protected String author;
    protected String copyright;
    protected String notePad;
    protected int width;
    protected int height;
    protected char[] chars;
    protected BitSet circles;
    protected Map<String, String> acrossClues;
    protected Map<String, String> downClues;
    public StringUtil rebuses$6d32e3b8;
    public final Map<Integer, String> cellNumbers;
    private String origin;
    private Set<String> reports;

    public IPuzGrid(GridState gridState) {
        this.title = gridState.getTitle();
        this.author = gridState.getAuthor();
        this.copyright = gridState.getCopyright();
        this.notePad = gridState.getNotepad();
        WordGrid wordGrid = gridState.getGrid();
        this.width = wordGrid.getWidth();
        this.height = wordGrid.getHeight();
        this.chars = gridState.getChars();
        this.circles = gridState.circles;
        this.rebuses$6d32e3b8 = gridState.getRebuses$e04f0f9();
        this.cellNumbers = new HashMap<Integer, String>();
        this.acrossClues = new HashMap<String, String>();
        this.downClues = new HashMap<String, String>();
        int n = gridState.getWordCount();
        for (int i = 0; i < n; ++i) {
            Map<String, String> map;
            int n2;
            WordGrid.Word word;
            WordGrid.Word word2 = word = gridState.getWord(i);
            if (word.letterIndices.length > 0) {
                int n3 = 0;
                word2 = word;
                this.cellNumbers.put(word2.letterIndices[n3], Integer.toString(word.getPrintNumber()));
            }
            if ((n2 = word.getDirection()) == 0) {
                map = this.acrossClues;
            } else {
                if (n2 != 1) continue;
                map = this.downClues;
            }
            map.put(Integer.toString(word.getPrintNumber()), gridState.getClue(word.getWordIndex()));
        }
    }

    private IPuzGrid(String string, String string2, String string3, String string4, int n, int n2, char[] cArray, BitSet bitSet, Map<Integer, String> map, Map<String, String> map2, Map<String, String> map3, StringUtil stringUtil, String string5, Set<String> set) {
        this.title = string;
        this.author = string2;
        this.copyright = string3;
        this.notePad = string4;
        this.width = n;
        this.height = n2;
        this.chars = cArray;
        this.circles = bitSet;
        this.cellNumbers = map;
        this.acrossClues = map2;
        this.downClues = map3;
        this.rebuses$6d32e3b8 = stringUtil;
        this.origin = string5;
        this.reports = set;
    }

    public final void maybeReportIssues(Component component) {
        if (this.reports.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ignored non-fatal issues in '").append(this.origin).append("' puzzle file");
        this.reports.stream().sorted().forEach(string -> stringBuilder.append("\n  ").append((String)string));
        JOptionPane.showMessageDialog(component, stringBuilder.toString(), "Output error", 2);
    }

    private static <T> T getArrayObject(JSONArray object, int n, Class<T> clazz) {
        try {
            object = ((JSONArray)object).get(n);
            if (!clazz.isInstance(object)) {
                throw new IllegalArgumentException("Element '" + n + "' is malformed");
            }
            if (object == JSONObject.NULL) {
                return null;
            }
            return (T)object;
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Element '" + n + "' is malformed");
        }
    }

    private static <T> T eatRequired(JSONObject jSONObject, String string, Class<T> clazz) {
        if (!jSONObject.has(string)) {
            throw new IllegalArgumentException("Missing required field: " + string);
        }
        try {
            Object object = jSONObject.get(string);
            if (!clazz.isInstance(object)) {
                throw new IllegalArgumentException("Field '" + string + "' is malformed");
            }
            jSONObject.remove(string);
            if (object == JSONObject.NULL) {
                return null;
            }
            return (T)object;
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Field '" + string + "' is malformed");
        }
    }

    private static <T> void eatOptional(JSONObject jSONObject, String string, Class<T> clazz, Consumer<T> consumer) {
        if (!jSONObject.has(string)) {
            return;
        }
        try {
            Object object = jSONObject.get(string);
            if (!clazz.isInstance(object)) {
                throw new IllegalArgumentException("Field '" + string + "' is malformed");
            }
            jSONObject.remove(string);
            consumer.accept(object == JSONObject.NULL ? null : object);
            return;
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Field '" + string + "' is malformed");
        }
    }

    private static String eatString(JSONObject jSONObject, String string, String object) throws JSONException {
        if (jSONObject.has(string)) {
            String string2 = string;
            object = jSONObject;
            object = (object = ((JSONObject)object).get(string2)) == JSONObject.NULL ? null : object.toString();
            jSONObject.remove(string);
            return object;
        }
        return object;
    }

    private static int eatInt(JSONObject jSONObject, String string, int n) throws JSONException {
        if (jSONObject.has(string)) {
            n = jSONObject.getInt(string);
            jSONObject.remove(string);
            return n;
        }
        return 0;
    }

    private static Object eatObject(JSONObject jSONObject, String string, Object object) {
        if (jSONObject.has(string)) {
            return jSONObject.remove(string);
        }
        if (object == JSONObject.NULL) {
            return null;
        }
        return object;
    }

    private static Object simplify(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void write(Writer writer) throws IOException {
        try {
            Object object;
            int n;
            int n2;
            void var5_9;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("version", "http://ipuz.org/v2");
            List<String> object4 = Collections.singletonList("http://ipuz.org/crossword#1");
            Object object2 = "kind";
            Object object3 = jSONObject;
            ((JSONObject)object3).put((String)object2, new JSONArray(object4));
            jSONObject.put("origin", "CrossFire encoder v1");
            IPuzGrid.condPut(jSONObject, "copyright", this.copyright);
            IPuzGrid.condPut(jSONObject, "title", this.title);
            IPuzGrid.condPut(jSONObject, "author", this.author);
            IPuzGrid.condPut(jSONObject, "intro", this.notePad);
            object3 = new HashSet();
            for (ImageUtil string2 : this.rebuses$6d32e3b8.getRebuses()) {
                object3.add(string2.letters);
            }
            object2 = this.chars;
            int n3 = this.chars.length;
            for (int i = 0; i < n3; ++i) {
                Object object5 = object2[i];
                object3.add(Character.toString((char)object5));
            }
            int n4 = -1;
            String string = "0";
            while (object3.contains(var5_9)) {
                String string2 = Integer.toString(n4--);
            }
            IPuzGrid.condPut(jSONObject, "empty", (String)var5_9);
            String string3 = "#";
            while (object3.contains(string3)) {
                string3 = Integer.toString(n4--);
            }
            IPuzGrid.condPut(jSONObject, "block", string3);
            jSONObject.put("dimensions", new JSONObject().put("width", this.width).put("height", this.height));
            IntObjectHash<String> intObjectHash = new IntObjectHash<String>();
            n4 = this.rebuses$6d32e3b8.getRebusCount();
            for (int i = 0; i < n4; ++i) {
                ImageUtil imageUtil = this.rebuses$6d32e3b8.getRebus$69a8c889(i);
                intObjectHash.put(imageUtil.inputChar, imageUtil.letters);
            }
            JSONArray jSONArray = new JSONArray();
            int n5 = this.height;
            int n6 = 0;
            for (n4 = 0; n4 < n5; ++n4) {
                JSONArray jSONArray2 = new JSONArray();
                int n7 = 0;
                n2 = this.width;
                while (n7 < n2) {
                    n = this.chars[n6];
                    object = this.cellNumbers.get(n6);
                    if (n == 127) {
                        object = string3;
                    } else if (object == null) {
                        object = var5_9;
                    }
                    if (this.circles.get(n6)) {
                        jSONArray2.put(new JSONObject().put("cell", IPuzGrid.simplify(object)).put("style", new JSONObject().put("shapebg", "circle")));
                    } else {
                        jSONArray2.put(IPuzGrid.simplify(object));
                    }
                    ++n7;
                    ++n6;
                }
                jSONArray.put(jSONArray2);
            }
            jSONObject.put("puzzle", jSONArray);
            JSONArray jSONArray3 = new JSONArray();
            n6 = this.height;
            int n8 = 0;
            for (n5 = 0; n5 < n6; ++n5) {
                JSONArray jSONArray4 = new JSONArray();
                n2 = 0;
                n = this.width;
                while (n2 < n) {
                    char c = this.chars[n8];
                    object = c == '\u007f' ? string3 : (c == '\u0000' ? var5_9 : (intObjectHash.hasKey(c) ? ((String)intObjectHash.get(c)).toUpperCase() : Character.toString(Character.toUpperCase(c))));
                    jSONArray4.put(IPuzGrid.simplify(object));
                    ++n2;
                    ++n8;
                }
                jSONArray3.put(jSONArray4);
            }
            jSONObject.put("solution", jSONArray3);
            JSONObject jSONObject2 = new JSONObject();
            this.addClues(jSONObject2, "Across", this.acrossClues);
            this.addClues(jSONObject2, "Down", this.downClues);
            jSONObject.put("clues", jSONObject2);
            writer.write(jSONObject.toString(2));
            writer.close();
            return;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    static IPuzGrid read(Reader object) {
        try {
            Object object2;
            int n;
            Object object3;
            int n2;
            HashSet<String> hashSet = new HashSet<String>();
            object = new BufferedReader((Reader)object);
            object = new JSONTokener((Reader)object);
            object = new JSONObject((JSONTokener)object);
            Object object4 = IPuzGrid.eatString((JSONObject)object, "version", "unknown");
            if (!((String)object4).startsWith("http://ipuz.org/v")) {
                throw new IllegalArgumentException("IPuz version '" + (String)object4 + "' unrecognized.");
            }
            object4 = IPuzGrid.eatString((JSONObject)object, "origin", "unknown") + " (" + (String)object4 + ")";
            Object object5 = IPuzGrid.eatObject((JSONObject)object, "kind", "unknown");
            if (object5 instanceof String) {
                object5 = (String)object5;
            } else {
                if (!(object5 instanceof JSONArray) || ((JSONArray)object5).length() != 1) {
                    throw new IllegalArgumentException("Cannot read non-American puzzle kind: " + object5);
                }
                object5 = ((JSONArray)object5).getString(0);
            }
            object5 = object5.split("#");
            if (!object5[0].equals("http://ipuz.org/crossword")) {
                throw new IllegalArgumentException("Cannot read non-American puzzle kind: " + object5[0]);
            }
            object5 = IPuzGrid.eatString((JSONObject)object, "author", "");
            String string = IPuzGrid.eatString((JSONObject)object, "title", "");
            String string2 = IPuzGrid.eatString((JSONObject)object, "copyright", "");
            String string3 = StringUtil.join2("\n\n", IPuzGrid.eatString((JSONObject)object, "intro", null), IPuzGrid.eatString((JSONObject)object, "notes", null));
            String string4 = IPuzGrid.eatString((JSONObject)object, "empty", "0");
            String string5 = IPuzGrid.eatString((JSONObject)object, "block", "#");
            Object object6 = IPuzGrid.eatRequired((JSONObject)object, "dimensions", JSONObject.class);
            int n3 = IPuzGrid.eatInt((JSONObject)object6, "width", 0);
            int n4 = IPuzGrid.eatInt((JSONObject)object6, "height", 0);
            IPuzGrid.reportUnhandled(hashSet, (JSONObject)object6);
            object6 = new BitSet();
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            Object object7 = IPuzGrid.eatRequired((JSONObject)object, "puzzle", JSONArray.class);
            if (n4 != ((JSONArray)object7).length()) {
                throw new IllegalArgumentException("Grid height doesn't match declaration");
            }
            char[] cArray = new char[n3 * n4];
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                JSONArray jSONArray = ((JSONArray)object7).getJSONArray(i);
                if (n3 != jSONArray.length()) {
                    throw new IllegalArgumentException("Grid width doesn't match declaration");
                }
                n2 = 0;
                while (n2 < n3) {
                    object3 = IPuzGrid.getArrayObject(jSONArray, n2, Object.class);
                    n = n5;
                    if (object3 instanceof JSONObject) {
                        object2 = (JSONObject)object3;
                        IPuzGrid.eatOptional((JSONObject)object2, "style", JSONObject.class, arg_0 -> IPuzGrid.lambda$read$2((BitSet)object6, n, hashSet, arg_0));
                        object3 = IPuzGrid.eatObject((JSONObject)object2, "cell", null);
                        IPuzGrid.reportUnhandled(hashSet, (JSONObject)object2);
                    }
                    if (object3 == null || object3 instanceof JSONArray) {
                        hashSet.add("Omitted cell interpreted as block.");
                        cArray[n5] = 127;
                    } else if (string5.equals(object3)) {
                        cArray[n5] = 127;
                    } else {
                        cArray[n5] = '\u0000';
                        if (!string4.equals(object3)) {
                            hashMap.put(n5, object3.toString());
                        }
                    }
                    ++n2;
                    ++n5;
                }
            }
            HashMap<Object, ImageUtil> hashMap2 = new HashMap<Object, ImageUtil>();
            JSONArray jSONArray = IPuzGrid.eatRequired((JSONObject)object, "solution", JSONArray.class);
            if (jSONArray.length() != n4) {
                throw new IllegalArgumentException("Solution height doesn't match puzzle height");
            }
            n2 = 0;
            for (int i = 0; i < n4; ++i) {
                object3 = jSONArray.getJSONArray(i);
                if (((JSONArray)object3).length() != n3) {
                    throw new IllegalArgumentException("Solution width doesn't match puzzle width.");
                }
                n = 0;
                while (n < n3) {
                    object2 = IPuzGrid.getArrayObject((JSONArray)object3, n, Object.class);
                    if (string5.equals(object2) || object2 == null || object2 instanceof JSONArray) {
                        if (cArray[n2] != '\u007f') {
                            throw new IllegalArgumentException("Solution structure doesn't match puzzle structure.");
                        }
                    } else {
                        if (cArray[n2] != '\u0000') {
                            throw new IllegalArgumentException("Solution structure doesn't match puzzle structure.");
                        }
                        if (object2 instanceof String && !string4.equals(object2)) {
                            object7 = ((String)object2).toLowerCase();
                            if (((String)object7).length() > 1) {
                                object2 = (ImageUtil)hashMap2.get(object7);
                                if (object2 == null) {
                                    if (hashMap2.size() >= RebusConstants.REBUS_INPUTS.length) {
                                        throw new IllegalArgumentException("Too many rebuses.");
                                    }
                                    char c = RebusConstants.REBUS_INPUTS[hashMap2.size()];
                                    object2 = new ImageUtil((String)object7, c, ((String)object7).charAt(0));
                                    hashMap2.put(object7, (ImageUtil)object2);
                                }
                                cArray[n2] = ((ImageUtil)object2).inputChar;
                            } else if (((String)object7).length() == 1) {
                                cArray[n2] = ((String)object7).charAt(0);
                            }
                        }
                    }
                    ++n;
                    ++n2;
                }
            }
            StringUtil stringUtil = new StringUtil(hashMap2.values());
            JSONObject jSONObject = IPuzGrid.eatRequired((JSONObject)object, "clues", JSONObject.class);
            object3 = IPuzGrid.readClues$62ea1585(IPuzGrid.eatRequired(jSONObject, "Across", JSONArray.class));
            Map<String, String> map = IPuzGrid.readClues$62ea1585(IPuzGrid.eatRequired(jSONObject, "Down", JSONArray.class));
            IPuzGrid.reportUnhandled(hashSet, jSONObject);
            IPuzGrid.reportUnhandled(hashSet, (JSONObject)object);
            return new IPuzGrid(string, (String)object5, string2, string3, n3, n4, cArray, (BitSet)object6, (Map<Integer, String>)hashMap, (Map<String, String>)object3, map, stringUtil, (String)object4, (Set<String>)hashSet);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Invalid file format.");
        }
    }

    private static void reportUnhandled(Set<String> set, JSONObject stringArray) {
        if (stringArray.length() == 0) {
            return;
        }
        for (String string : JSONObject.getNames((JSONObject)stringArray)) {
            set.add("Unrecognized field '" + string + "'");
        }
    }

    private static Map<String, String> readClues$62ea1585(JSONArray jSONArray) throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONArray jSONArray2 = jSONArray.getJSONArray(i);
            String string = jSONArray2.getString(1).replace("&lt;", "<").replace("&amp;", "&").replace("&gt;", ">");
            hashMap.put(jSONArray2.getString(0), string);
        }
        return hashMap;
    }

    private static void condPut(JSONObject jSONObject, String string, String string2) throws JSONException {
        if (string2 != null && string2.length() > 0) {
            jSONObject.put(string, string2);
        }
    }

    private void addClues(JSONObject jSONObject, String string2, Map<String, String> map) throws JSONException {
        Object object = map.keySet().stream().map(string -> new LabelSorter((String)string)).sorted().map(labelSorter -> labelSorter.label).collect(Collectors.toList());
        JSONArray jSONArray = new JSONArray();
        object = object.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            String string4 = map.get(string3);
            if (string4 == null || string4.length() <= 0) continue;
            JSONArray jSONArray2 = new JSONArray();
            jSONArray2.put(IPuzGrid.simplify(string3));
            string3 = string4;
            jSONArray2.put(string3.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
            jSONArray.put(jSONArray2);
        }
        jSONObject.put(string2, jSONArray);
    }

    private static /* synthetic */ void lambda$read$2(BitSet bitSet, int n, Set set, JSONObject jSONObject) {
        IPuzGrid.eatOptional(jSONObject, "shapebg", String.class, string -> {
            if (string.equals("circle")) {
                bitSet.set(n);
                return;
            }
            set.add("Unsupported shape '" + string + "'");
        });
    }

    static final class LabelSorter
    implements Comparable<LabelSorter> {
        String label;
        private int intValue = Integer.MAX_VALUE;

        public LabelSorter(String string) {
            this.label = string;
            try {
                this.intValue = Integer.parseInt(string);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
    }
}

