/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.Starlog;
import com.beekeeper.util.StringUtil;
import com.beekeeper.xwd.AcrossLiteGrid;
import com.beekeeper.xwd.CFPGrid;
import com.beekeeper.xwd.IPuzGrid;
import com.beekeeper.xwd.JPZGrid;
import com.beekeeper.xwd.WordGrid;
import com.beekeeper.xwd.WordList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GridState {
    private static final Starlog WARNINGS = Starlog.get(1);
    private final WordGrid grid;
    private final char[] gridChars;
    private final String[] completeWords;
    private final String[] clues;
    private String title;
    private String author;
    private String copyright;
    private String notepad;
    private BitSet themes;
    public BitSet circles;
    private final boolean[] completeSet;
    private boolean storeCompleteWords;
    private StringUtil rebuses$6d32e3b8;
    private static final StringUtil EMPTY_REBUSES$6d32e3b8 = new StringUtil();

    public final WordGrid getGrid() {
        return this.grid;
    }

    public final char[] getChars() {
        return this.gridChars;
    }

    public final int getWordCount() {
        return this.grid.getWordCount();
    }

    public final WordGrid.Word getWord(int n) {
        return this.grid.getWord(n);
    }

    public final ArrayList<WordGrid.Word> getSortedWords(int n) {
        ArrayList<WordGrid.Word> arrayList = new ArrayList<WordGrid.Word>();
        GridState gridState = this;
        int n2 = gridState.grid.getWordCount();
        for (int i = 0; i < n2; ++i) {
            WordGrid.Word word = this.getWord(i);
            int n3 = word.getDirection();
            if (n3 != n) continue;
            arrayList.add(word);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public final boolean isComplete(int n) {
        return this.completeSet[n];
    }

    public final boolean isTheme(int n) {
        return this.themes.get(n);
    }

    public final void setTheme(int n, boolean bl) {
        this.themes.set(n, bl);
    }

    public final boolean isCircle(int n) {
        return this.circles.get(n);
    }

    public final String getString(int n) {
        String string = this.completeWords[n];
        if (string != null) {
            return string;
        }
        string = this.getWord(n).getString(this.gridChars);
        if (this.storeCompleteWords) {
            int n2 = n;
            GridState gridState = this;
            if (gridState.completeSet[n2]) {
                this.completeWords[n] = string;
            }
        }
        return string;
    }

    public final String getDebugString(int n) {
        return this.getWord(n).getDebugString(this.gridChars);
    }

    public final void setString(int n, String object) {
        WordGrid.Word word = this.getWord(n);
        Object object2 = word;
        String string = object;
        object2 = this.gridChars;
        object = word;
        for (int i = 0; i < string.length(); ++i) {
            object2[((WordGrid.Word)object).letterIndices[i]] = string.charAt(i);
        }
        boolean bl = true;
        int n2 = n;
        object = this;
        ((GridState)object).completeSet[n2] = true;
        if (((GridState)object).storeCompleteWords) {
            ((GridState)object).completeWords[n2] = ((GridState)object).getWord(n2).getString(((GridState)object).gridChars);
            return;
        }
        ((GridState)object).completeWords[n2] = null;
    }

    public final String getClue(int n) {
        if (this.clues[n] == null) {
            return "";
        }
        return this.clues[n];
    }

    public final void setClue(int n, String string) {
        this.clues[n] = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GridState)) {
            return false;
        }
        object = (GridState)object;
        if (this.gridChars.length != ((GridState)object).gridChars.length) {
            return false;
        }
        if (this.grid != ((GridState)object).grid) {
            return false;
        }
        for (int i = 0; i < this.gridChars.length; ++i) {
            if (this.gridChars[i] == ((GridState)object).gridChars[i]) continue;
            return false;
        }
        return Arrays.equals(this.completeSet, ((GridState)object).completeSet);
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.gridChars.length; ++n) {
            n2 = n2 * 17 + this.gridChars[n];
        }
        GridState gridState = this;
        int n3 = gridState.grid.getWordCount();
        for (n = 0; n < n3; ++n) {
            n2 = n2 * 19 + (this.completeSet[n] ? 3 : 0);
        }
        return n2;
    }

    public GridState(WordGrid wordGrid) {
        WordGrid wordGrid2 = wordGrid;
        this(wordGrid2, (char[])wordGrid2.getInitChars().clone());
    }

    private GridState(WordGrid wordGrid, char[] cArray) {
        this.title = "";
        this.author = "";
        this.copyright = "";
        this.storeCompleteWords = true;
        this.grid = wordGrid;
        this.gridChars = cArray;
        this.completeWords = new String[wordGrid.getWordCount()];
        this.completeSet = new boolean[wordGrid.getWordCount()];
        this.clues = new String[wordGrid.getWordCount()];
        this.themes = new BitSet(wordGrid.getWordCount());
        this.circles = new BitSet(cArray.length);
        this.computeComplete();
    }

    public GridState(GridState gridState, char[] cArray) {
        this.title = "";
        this.author = "";
        this.copyright = "";
        this.storeCompleteWords = true;
        this.grid = gridState.grid;
        this.gridChars = cArray;
        this.clues = (String[])gridState.clues.clone();
        this.themes = new BitSet(this.grid.getWordCount());
        this.circles = new BitSet(cArray.length);
        this.rebuses$6d32e3b8 = new StringUtil(gridState.getRebuses$e04f0f9());
        this.completeWords = new String[this.grid.getWordCount()];
        this.completeSet = new boolean[this.grid.getWordCount()];
        this.computeComplete();
        this.updateClues(gridState);
    }

    /*
     * Unable to fully structure code
     */
    public final void updateClues(GridState var1_1) {
        this.title = var1_1.title;
        this.author = var1_1.author;
        this.copyright = var1_1.copyright;
        this.notepad = var1_1.notepad;
        this.rebuses$6d32e3b8 = new StringUtil(var1_1.getRebuses$e04f0f9());
        this.themes = new BitSet(this.grid.getWordCount());
        if (this.grid == var1_1.grid) {
            for (var2_2 = 0; var2_2 < this.completeWords.length; ++var2_2) {
                this.clues[var2_2] = var1_1.clues[var2_2];
                var11_6 = var2_2;
                var10_4 = this;
                if (!var10_4.completeSet[var11_6]) {
                    var11_6 = var2_2;
                    var10_4 = var1_1;
                    if (!var10_4.completeSet[var11_6]) continue;
                    this.clues[var2_2] = "";
                    continue;
                }
                if (this.getCompleteWord(var2_2).equals(var1_1.getCompleteWord(var2_2))) continue;
                this.clues[var2_2] = "";
            }
            this.themes.or(var1_1.themes);
            this.circles.or(var1_1.circles);
            return;
        }
        var3_8 = this.completeWords.length;
        for (var2_3 = 0; var2_3 < var3_8; ++var2_3) {
            var4_9 = this.getWord(var2_3);
            v0 = var1_1;
            var10_5 = v0;
            var11_7 = 0;
            var10_5 = var4_9;
            var5_10 = v0.grid.getWordAt(var10_5.letterIndices[var11_7], var4_9.getDirection(), true);
            if (var5_10 == null) ** GOTO lbl-1000
            v1 = var4_9;
            var10_5 = v1;
            var10_5 = var5_10;
            if (v1.letterIndices.length == var10_5.letterIndices.length) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = var6_11 = false;
            }
            if (v2) {
                var7_12 = 0;
                var10_5 = var4_9;
                var8_13 = var10_5.letterIndices.length;
                while (var7_12 < var8_13) {
                    var11_7 = var7_12;
                    var10_5 = var4_9;
                    var9_14 = var10_5.letterIndices[var11_7];
                    var11_7 = var7_12++;
                    var10_5 = var5_10;
                    if (var9_14 == var10_5.letterIndices[var11_7] && this.gridChars[var9_14] == var1_1.gridChars[var9_14]) continue;
                    var6_11 = false;
                    break;
                }
            }
            this.clues[var2_3] = var6_11 != false ? var1_1.clues[var5_10.getWordIndex()] : "";
            this.themes.set(var2_3, var6_11 != false ? var1_1.themes.get(var5_10.getWordIndex()) : false);
        }
        var2_3 = var1_1.circles.nextSetBit(0);
        while (var2_3 != -1) {
            if (this.gridChars[var2_3] != '\u007f') {
                this.circles.set(var2_3);
            }
            var2_3 = var1_1.circles.nextSetBit(var2_3 + 1);
        }
    }

    private void computeComplete() {
        int n = 0;
        while (true) {
            block3: {
                Object object = this;
                if (n >= ((GridState)object).grid.getWordCount()) break;
                int n2 = 0;
                while (true) {
                    object = this.getWord(n);
                    if (n2 >= ((WordGrid.Word)object).letterIndices.length) break;
                    int n3 = n2++;
                    object = this;
                    int n4 = n;
                    if (((GridState)object).getWord(n4).getLetter(n3, ((GridState)object).gridChars) != '\u0000') {
                        continue;
                    }
                    break block3;
                    break;
                }
                this.completeSet[n] = true;
            }
            ++n;
        }
    }

    public GridState(GridState gridState) {
        this.title = "";
        this.author = "";
        this.copyright = "";
        this.storeCompleteWords = true;
        this.grid = gridState.grid;
        this.gridChars = new char[gridState.gridChars.length];
        System.arraycopy(gridState.gridChars, 0, this.gridChars, 0, this.gridChars.length);
        this.completeWords = new String[gridState.completeWords.length];
        System.arraycopy(gridState.completeWords, 0, this.completeWords, 0, this.completeWords.length);
        this.completeSet = new boolean[this.completeWords.length];
        System.arraycopy(gridState.completeSet, 0, this.completeSet, 0, this.completeSet.length);
        this.clues = new String[gridState.clues.length];
        System.arraycopy(gridState.clues, 0, this.clues, 0, this.clues.length);
        this.title = gridState.title;
        this.author = gridState.author;
        this.copyright = gridState.copyright;
        this.notepad = gridState.notepad;
        this.themes = (BitSet)gridState.themes.clone();
        this.rebuses$6d32e3b8 = new StringUtil(gridState.getRebuses$e04f0f9());
        this.circles = new BitSet(this.gridChars.length);
        this.circles.or(gridState.circles);
    }

    public GridState(IPuzGrid object) {
        this(((IPuzGrid)object).width, ((IPuzGrid)object).height, ((IPuzGrid)object).chars, null, ((IPuzGrid)object).title, ((IPuzGrid)object).author, ((IPuzGrid)object).copyright, ((IPuzGrid)object).notePad, ((IPuzGrid)object).circles, ((IPuzGrid)object).rebuses$6d32e3b8);
        int n;
        Object object2;
        Comparable<WordGrid.Word> comparable;
        Object object3;
        Map<Integer, String> object42 = ((IPuzGrid)object).cellNumbers;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Map.Entry<Integer, String> entry : object42.entrySet()) {
            hashMap.put(entry.getValue(), entry.getKey());
        }
        Map<String, String> map = ((IPuzGrid)object).acrossClues;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Map.Entry<String, String> entry2 = entry.getKey();
            object3 = (Integer)hashMap.get(entry2);
            if (object3 == null || (comparable = this.grid.getWordAt((Integer)object3, 0, true)) == null) continue;
            object2 = comparable;
            if (((WordGrid.Word)object2).letterIndices.length <= 0) continue;
            n = 0;
            object2 = comparable;
            if (((WordGrid.Word)object2).letterIndices[n] != (Integer)object3) continue;
            entry2 = entry.getValue();
            n = ((WordGrid.Word)comparable).getWordIndex();
            object2 = this;
            ((GridState)object2).clues[n] = entry2;
        }
        Map<String, String> map2 = ((IPuzGrid)object).downClues;
        for (Map.Entry<String, String> entry2 : map2.entrySet()) {
            object3 = entry2.getKey();
            comparable = (Integer)hashMap.get(object3);
            if (comparable == null || (object = this.grid.getWordAt((Integer)comparable, 1, true)) == null) continue;
            object2 = object;
            if (((WordGrid.Word)object2).letterIndices.length <= 0) continue;
            n = 0;
            object2 = object;
            if (((WordGrid.Word)object2).letterIndices[n] != (Integer)comparable) continue;
            entry2 = (String)entry2.getValue();
            n = ((WordGrid.Word)object).getWordIndex();
            object2 = this;
            ((GridState)object2).clues[n] = entry2;
        }
    }

    public GridState(AcrossLiteGrid acrossLiteGrid) {
        this(acrossLiteGrid.width, acrossLiteGrid.height, acrossLiteGrid.chars, acrossLiteGrid.userChars, acrossLiteGrid.title, acrossLiteGrid.author, acrossLiteGrid.copyright, acrossLiteGrid.notePad, acrossLiteGrid.circles, acrossLiteGrid.rebuses$6d32e3b8);
        GridState gridState;
        int n;
        String string;
        ArrayList<WordGrid.Word> arrayList = this.getSortedWords(0);
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            string = acrossLiteGrid.acrossClues[i];
            n = arrayList.get(i).getWordIndex();
            gridState = this;
            gridState.clues[n] = string;
        }
        ArrayList<WordGrid.Word> arrayList2 = this.getSortedWords(1);
        int n3 = arrayList2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = acrossLiteGrid.downClues[n2];
            n = arrayList2.get(n2).getWordIndex();
            gridState = this;
            gridState.clues[n] = string;
        }
    }

    private GridState(int n, int n2, char[] cArray, char[] cArray2, String string, String string2, String string3, String string4, BitSet bitSet, StringUtil stringUtil) {
        this.title = "";
        this.author = "";
        this.copyright = "";
        this.storeCompleteWords = true;
        if (cArray2 == null) {
            cArray2 = new char[cArray.length];
            int n3 = cArray2.length;
            for (int i = 0; i < n3; ++i) {
                cArray2[i] = cArray[i] == '\u007f' ? 127 : 0;
            }
        }
        this.grid = new WordGrid(n, n2, cArray2);
        this.gridChars = (char[])cArray.clone();
        this.completeWords = new String[this.grid.getWordCount()];
        this.completeSet = new boolean[this.completeWords.length];
        this.computeComplete();
        this.title = string;
        this.author = string2;
        this.copyright = string3;
        this.notepad = string4;
        this.clues = new String[this.grid.getWordCount()];
        this.themes = new BitSet(this.grid.getWordCount());
        this.circles = bitSet == null ? new BitSet(cArray.length) : (BitSet)bitSet.clone();
        this.rebuses$6d32e3b8 = stringUtil == null ? new StringUtil() : new StringUtil(stringUtil);
    }

    public GridState(JPZGrid object, boolean bl) {
        this(((JPZGrid)((Object)object)).width, ((JPZGrid)((Object)object)).height, ((JPZGrid)((Object)object)).gridChars, null, ((JPZGrid)((Object)object)).title, ((JPZGrid)((Object)object)).author, ((JPZGrid)((Object)object)).copyright, ((JPZGrid)((Object)object)).notepad, ((JPZGrid)((Object)object)).circles, new StringUtil(((JPZGrid)((Object)object)).rebuses.values()));
        int n = 1;
        GridState object22 = this;
        this.storeCompleteWords = n;
        for (JPZGrid.WordInfo wordInfo : ((JPZGrid)((Object)object)).words) {
            if (wordInfo == null) continue;
            WordGrid.Word word = this.grid.getWordAt(wordInfo.square, wordInfo.dir, true);
            if (wordInfo.clue != null && word.getPrintNumber() != wordInfo.number && WARNINGS != null) {
                WARNINGS.logf("Number mismatch: %d vs. %d%n", word.getPrintNumber(), wordInfo.number);
            }
            String string = wordInfo.clue;
            n = word.getWordIndex();
            GridState gridState = this;
            gridState.clues[n] = string;
        }
    }

    public GridState(CFPGrid cFPGrid) {
        this(cFPGrid.width, cFPGrid.height, cFPGrid.chars, null, cFPGrid.title, cFPGrid.author, cFPGrid.copyright, cFPGrid.notePad, cFPGrid.circles, cFPGrid.rebuses$6d32e3b8);
        for (CFPGrid.Clue clue : cFPGrid.clues) {
            String string = clue.text;
            int n = clue.cfNumber;
            GridState gridState = this;
            gridState.clues[n] = string;
            if (!clue.isTheme) continue;
            this.setTheme(clue.cfNumber, true);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getNotepad() {
        if (this.notepad == null) {
            return "";
        }
        return this.notepad;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public void setCopyright(String string) {
        this.copyright = string;
    }

    public void setNotepad(String string) {
        this.notepad = string;
    }

    public final BitSet allCrosses(int n) {
        WordGrid.Word word = this.grid.getWord(n);
        Object object = this;
        BitSet bitSet = new BitSet(((GridState)object).grid.getWordCount());
        int n2 = 0;
        while (true) {
            object = word;
            if (n2 >= ((WordGrid.Word)object).letterIndices.length) break;
            int n3 = n2;
            object = word;
            int n4 = ((WordGrid.Word)object).letterIndices[n3];
            for (n3 = 0; n3 < this.grid.getCrossWordCount(n4); ++n3) {
                bitSet.set(this.grid.getCrossWord(n4, n3));
            }
            ++n2;
        }
        return bitSet;
    }

    public final BitSet findIsland(int n) {
        Object object = this;
        BitSet bitSet = new BitSet(((GridState)object).grid.getWordCount());
        int n2 = n;
        object = this;
        if (((GridState)object).completeSet[n2]) {
            return bitSet;
        }
        ArrayList<WordGrid.Word> arrayList = new ArrayList<WordGrid.Word>();
        arrayList.add(this.grid.getWord(n));
        bitSet.set(n);
        while (!arrayList.isEmpty()) {
            ArrayList<WordGrid.Word> arrayList2 = arrayList;
            WordGrid.Word word = (WordGrid.Word)arrayList2.remove(arrayList2.size() - 1);
            int n3 = word.getDirection();
            object = word;
            int n4 = ((WordGrid.Word)object).letterIndices.length;
            for (int i = 0; i < n4; ++i) {
                int n5;
                WordGrid.Word word2;
                n2 = i;
                object = word;
                int n6 = ((WordGrid.Word)object).letterIndices[n2];
                if (this.gridChars[n6] != '\u0000' || (word2 = this.grid.getWordAt(n6, n3, false)) == null || bitSet.get(n5 = word2.getWordIndex())) continue;
                n2 = n5;
                object = this;
                if (((GridState)object).completeSet[n2]) continue;
                bitSet.set(n5);
                arrayList.add(word2);
            }
        }
        return bitSet;
    }

    public final BitSet findIslandNeighbors(BitSet bitSet) {
        Object object = this;
        BitSet bitSet2 = new BitSet(((GridState)object).grid.getWordCount());
        int n = bitSet.nextSetBit(0);
        while (n != -1) {
            WordGrid.Word word = this.grid.getWord(n);
            int n2 = word.getDirection();
            object = word;
            int n3 = ((WordGrid.Word)object).letterIndices.length;
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5 = i;
                object = word;
                WordGrid.Word word2 = this.grid.getWordAt(((WordGrid.Word)object).letterIndices[n5], n2, false);
                if (word2 == null || bitSet2.get(n4 = word2.getWordIndex())) continue;
                n5 = n4;
                object = this;
                if (!((GridState)object).completeSet[n5]) continue;
                bitSet2.set(n4);
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return bitSet2;
    }

    public final String getCompleteWord(int n) {
        int n2 = n;
        GridState gridState = this;
        if (gridState.completeSet[n2]) {
            return this.getString(n);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = this.grid.getHeight();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.grid.getWidth();
            for (int j = 0; j < n3; ++j) {
                char c;
                if ((c = this.gridChars[n++]) == '\u0000') {
                    stringBuilder.append('_');
                    continue;
                }
                if (c == '\u007f') {
                    stringBuilder.append('#');
                    continue;
                }
                stringBuilder.append(c);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    final boolean isThemeLetter(int n) {
        int n2 = this.grid.getCrossWordCount(n);
        for (int i = 0; i < n2; ++i) {
            GridState gridState = this;
            if (!gridState.isTheme(gridState.grid.getCrossWord(n, i))) continue;
            return true;
        }
        return false;
    }

    public final StringUtil getRebuses$e04f0f9() {
        if (this.rebuses$6d32e3b8 == null) {
            return EMPTY_REBUSES$6d32e3b8;
        }
        return this.rebuses$6d32e3b8;
    }

    public final void setRebuses$6a41c4d3(StringUtil stringUtil) {
        this.rebuses$6d32e3b8 = stringUtil;
    }

    public final int countUncluedWords() {
        int n = 0;
        for (String string : this.clues) {
            if (string != null && string.length() != 0) continue;
            ++n;
        }
        return n;
    }

    final float getQuality(WordList wordList) {
        int n;
        GridState gridState = this;
        float[] fArray = new float[gridState.grid.getWordCount()];
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            n = i;
            gridState = this;
            fArray[i] = !gridState.completeSet[n] ? 1.0f : Math.max(1.0f, wordList.getWordScore(this.getCompleteWord(i)));
        }
        float f = 0.0f;
        gridState = this;
        n2 = gridState.gridChars.length;
        for (int i = 0; i < n2; ++i) {
            float f2 = 1.0f;
            n = this.grid.getCrossWordCount(i);
            for (int j = 0; j < n; ++j) {
                f2 *= fArray[this.grid.getCrossWord(i, j)];
            }
            f = (float)((double)f + Math.pow(f2, -0.1));
        }
        float f3 = (float)Math.pow(f, -10.0);
        return f3;
    }
}

