/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.OpenHashUtil;
import com.beekeeper.util.Starlog;
import com.beekeeper.util.closedhash.ObjectSet;
import com.beekeeper.xwd.BadStateError;
import com.beekeeper.xwd.FrontierPrint;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.GridStrategies;
import com.beekeeper.xwd.SearchNode;
import com.beekeeper.xwd.SearchNodeProxy;
import com.beekeeper.xwd.WordGrid;
import com.beekeeper.xwd.WordList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Random;
import java.util.TreeSet;
import java.util.regex.Pattern;

public abstract class GridSearchNode
extends SearchNode
implements Cloneable {
    private static final Starlog DEBUG = Starlog.get(5);
    protected GridState state;
    protected float priority;
    protected SharedOptions options;
    private BitSet nodesExplored;
    private BitSet blockingDuplicates;
    protected int childBranchCount = 1;
    int latestWord = -1;
    int[] nextWords = new int[0];
    protected static Random rand = new Random();
    private float cachedQuality = -1.0f;
    private FrontierPrint fingerPrint;
    private BitSet acceptableWords;
    private static int BAD_WORD_THRESH = 7;
    private static int BAD_WORD_COUNT_THRESH = 20;
    private static int[] EMPTY_NEXT_WORDS = new int[0];
    private static float[] LETTER_SCORES = new float[128];
    protected static final int[] DEPTH_DIVISORS;
    private boolean DONT_FAIL_ENTIRELY = false;

    @Override
    public final float getPriority() {
        return this.priority;
    }

    public final void setOptions(SharedOptions sharedOptions) {
        this.options = sharedOptions;
    }

    public final GridSearchNode clone() {
        try {
            return (GridSearchNode)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public final float getQuality() {
        if (this.cachedQuality < 0.0f) {
            this.cachedQuality = this.state.getQuality(this.options.wordList);
        }
        return this.cachedQuality;
    }

    public final void cloneOptions() {
        this.options = this.options.clone();
    }

    @Override
    public boolean isGoalNode() {
        BitSet bitSet = this.options.neighborhood;
        if (bitSet != null) {
            int n = bitSet.nextSetBit(0);
            while (n != -1) {
                if (!this.state.isComplete(n)) {
                    return false;
                }
                n = bitSet.nextSetBit(n + 1);
            }
        } else {
            for (int i = 0; i < this.state.getWordCount(); ++i) {
                if (this.state.isComplete(i)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final int compareTo(SearchNode searchNode) {
        int n = super.compareTo(searchNode);
        if (n != 0 || !(searchNode instanceof GridSearchNode)) {
            return n;
        }
        searchNode = (GridSearchNode)searchNode;
        n = this.state.getString(this.latestWord).compareTo(((GridSearchNode)searchNode).state.getString(((GridSearchNode)searchNode).latestWord));
        if (n != 0) {
            return n;
        }
        return Math.abs(Arrays.hashCode(this.state.getChars())) - Math.abs(Arrays.hashCode(((GridSearchNode)searchNode).state.getChars()));
    }

    public String toString() {
        return String.format("%s -- Depth = %d; Score = %3.2f", "<<GridSearchNode>>", this.depth, Float.valueOf(this.priority));
    }

    public GSNProxy conditionalSuccessor(int n, String string, float f) {
        GridSearchNode gridSearchNode;
        GridSearchNode gridSearchNode2 = this.makeSuccessor();
        gridSearchNode2.setString(n, string);
        GridSearchNode gridSearchNode3 = gridSearchNode2;
        if (gridSearchNode.priority > f) {
            gridSearchNode3 = gridSearchNode2;
            return new GSNProxy(gridSearchNode3.priority, this, n, string);
        }
        return null;
    }

    @Override
    public final SearchNodeProxy[] generateSuccessors(float f) {
        int n = this.chooseWordToFill();
        if (n == -1) {
            return new SearchNodeProxy[0];
        }
        int n2 = this.options.beam;
        if (this.depth == 0 && this.options.rootBeam != -1) {
            n2 = this.options.rootBeam;
        }
        SearchNodeProxy[] searchNodeProxyArray = this.generateSuccessors(n, n2, Float.NEGATIVE_INFINITY, null);
        return searchNodeProxyArray;
    }

    public final SearchNodeProxy[] generateSuccessors(int n) {
        int n2 = this.options.beam;
        if (this.depth == 0 && this.options.rootBeam != -1) {
            n2 = this.options.rootBeam;
        }
        return this.generateSuccessors(n, n2, Float.NEGATIVE_INFINITY, null);
    }

    private SearchNodeProxy[] generateSuccessors(int n, int n2, float f, Pattern pattern) {
        return this.generateSuccessors(n, n2, f, pattern, this.options.beamMultiplier);
    }

    final ArrayList<String> generateCandidateWords(int n, Pattern pattern, BitSet bitSet) {
        WordList.MatchInfo matchInfo = this.options.wordList.search(this.state, n);
        if (DEBUG != null && matchInfo.getMatchCount() > 1000) {
            DEBUG.logf("Evaluating %d successors for %s:", matchInfo.getMatchCount(), this);
        }
        int n2 = this.state.getWordCount();
        ArrayList<String> arrayList = new ArrayList<String>(matchInfo.getMatchCount());
        int n3 = matchInfo.getMatchCount();
        block0: for (int i = 0; i < n3; ++i) {
            int n4;
            String string = matchInfo.getMatch(i);
            if (matchInfo.getScore(i) < (float)this.options.minCandidateScore) continue;
            for (n4 = 0; n4 < n2; ++n4) {
                String string2 = this.state.getCompleteWord(n4);
                if (string2 == null || !string.equals(string2)) continue;
                bitSet.set(n4);
                continue block0;
            }
            n4 = this.options.longestSubstring;
            int n5 = string.length() - n4;
            for (int j = 0; j < n5; ++j) {
                for (int k = 0; k < n2; ++k) {
                    String string3 = this.state.getCompleteWord(k);
                    if (string3 == null || string3.length() <= n4) continue;
                    int n6 = string3.length() - n4;
                    block4: for (int i2 = 0; i2 < n6; ++i2) {
                        for (int i3 = 0; i3 <= n4; ++i3) {
                            if (string.charAt(j + i3) != string3.charAt(i2 + i3)) continue block4;
                        }
                        bitSet.set(k);
                        continue block0;
                    }
                }
            }
            if (pattern != null && !pattern.matcher(string).find() || matchInfo.getScore(i) < 1.0f) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public SearchNodeProxy[] generateSuccessors(int n, int n2, float f, Pattern iterator, int n3) {
        Object object;
        this.nodesExplored.set(n);
        int n4 = -1;
        int n5 = 0;
        BitSet bitSet = new BitSet(this.state.getWordCount());
        iterator = new CandidateGenerator(this, n, (Pattern)((Object)iterator), bitSet);
        TreeSet<Object> treeSet = new TreeSet<Object>();
        int n6 = 0;
        while (((CandidateGenerator)((Object)iterator)).advance()) {
            object = iterator;
            object = ((CandidateGenerator)object).value;
            if (n5 >= n2) {
                if (n4 == -1) {
                    n4 = n6 * n3;
                } else if (n6 > n4) break;
                var12_14 = (GSNProxy)treeSet.last();
                object = this.conditionalSuccessor(n, (String)object, var12_14.getPriority());
                if (object != null) {
                    treeSet.remove(var12_14);
                    treeSet.add(object);
                }
            } else {
                var12_14 = this.conditionalSuccessor(n, (String)object, f);
                if (var12_14 != null) {
                    treeSet.add(var12_14);
                    ++n5;
                }
            }
            ++n6;
        }
        if (DEBUG != null) {
            object = treeSet.iterator();
            for (n6 = 0; n6 < 15 && object.hasNext(); ++n6) {
                DEBUG.log("  " + ((GSNProxy)object.next()).word);
            }
        }
        TreeSet<Object> treeSet2 = treeSet;
        SearchNodeProxy[] searchNodeProxyArray = treeSet2.toArray(new SearchNodeProxy[treeSet2.size()]);
        this.childBranchCount = searchNodeProxyArray.length;
        object = this.options;
        synchronized (object) {
            if (this.options.failureCounts == null) {
                this.options.failureCounts = new int[this.state.getWordCount()];
                this.options.successCounts = new int[this.state.getWordCount()];
                this.options.persistentFailureCounts = new int[this.state.getWordCount()];
                this.options.persistentSuccessCounts = new int[this.state.getWordCount()];
                Arrays.fill(this.options.successCounts, 1);
                Arrays.fill(this.options.persistentSuccessCounts, 1);
            }
            if (searchNodeProxyArray.length == 0) {
                int n7 = n;
                this.options.failureCounts[n7] = this.options.failureCounts[n7] + 1;
                int n8 = n;
                this.options.persistentFailureCounts[n8] = this.options.persistentFailureCounts[n8] + 1;
            } else {
                int n9 = n;
                this.options.successCounts[n9] = this.options.successCounts[n9] + 1;
                int n10 = n;
                this.options.persistentSuccessCounts[n10] = this.options.persistentSuccessCounts[n10] + 1;
            }
            int n11 = this.options.failureCounts[n] / this.options.successCounts[n];
            if (this.options.useForceWords && n11 >= 5) {
                this.options.forcedNext = n;
                Arrays.fill(this.options.successCounts, 1);
                Arrays.fill(this.options.failureCounts, 0);
            }
            if (this.options.trackBlockingWords && searchNodeProxyArray.length < Math.max(n2, 500) && bitSet.cardinality() > 0) {
                this.blockingDuplicates = bitSet;
            }
        }
        return searchNodeProxyArray;
    }

    @Override
    private FrontierPrint getFingerprint() {
        if (this.fingerPrint == null) {
            this.fingerPrint = new FrontierPrint(this.state, this.options.neighborhood);
        }
        return this.fingerPrint;
    }

    protected final GridSearchNode makeSuccessor() {
        GridState gridState = new GridState(this.state);
        return this.makeSuccessor(gridState);
    }

    protected GridSearchNode makeSuccessor(GridState gridState) {
        GridSearchNode gridSearchNode = this.clone();
        this.clone().state = gridState;
        this.assignID();
        gridSearchNode.parent = this;
        ++gridSearchNode.depth;
        gridSearchNode.acceptableWords = null;
        gridSearchNode.cachedQuality = -1.0f;
        gridSearchNode.fingerPrint = null;
        gridSearchNode.nextWords = EMPTY_NEXT_WORDS;
        gridSearchNode.nodesExplored = new BitSet(this.state.getWordCount());
        gridSearchNode.blockingDuplicates = new BitSet(this.state.getWordCount());
        return gridSearchNode;
    }

    @Override
    public final void initForSearch() {
        super.initForSearch();
        this.nodesExplored = new BitSet(this.state.getWordCount());
        this.blockingDuplicates = new BitSet(this.state.getWordCount());
        this.options.failureCounts = null;
        this.options.successCounts = null;
        this.options.persistentFailureCounts = null;
        this.options.persistentSuccessCounts = null;
        this.options.forcedNext = -1;
    }

    @Override
    public final void markFinished() {
        super.markFinished();
    }

    @Override
    public final void markDead(boolean bl) throws BadStateError {
        SharedOptions sharedOptions = this.options;
        synchronized (sharedOptions) {
            Object object;
            if (this.parent != null) {
                object = (GridSearchNode)this.parent;
                ((GridSearchNode)object).nodesExplored.or(this.nodesExplored);
                ((GridSearchNode)object).blockingDuplicates.or(this.blockingDuplicates);
            }
            if (this.latestWord == -1) {
                return;
            }
            object = this.state.getString(this.latestWord);
            if (((String)object).length() > BAD_WORD_THRESH) {
                int n;
                WordGrid.Word word = this.state.getWord(this.latestWord);
                int n2 = n = this.options.badWords == null ? 0 : this.options.badWords.get(word, (String)object, 0);
                if (bl && n >= BAD_WORD_COUNT_THRESH) {
                    WordStringIntMap.Iter iter = this.options.badWords.getIterator();
                    while (iter.advance()) {
                        this.options.badWords.remove(iter.getWord(), iter.getString());
                    }
                    throw new BadStateError(this){
                        private /* synthetic */ GridSearchNode this$0;
                        {
                            this.this$0 = gridSearchNode;
                        }

                        @Override
                        public final boolean acceptableState(SearchNode searchNode, SearchNode searchNode2) {
                            boolean bl = searchNode.depth <= searchNode2.depth;
                            return bl;
                        }

                        @Override
                        public final SearchNode getSource() {
                            return this.this$0;
                        }
                    };
                }
                if (this.options.badWords != null) {
                    this.options.badWords.put(word, (String)object, n + 1);
                }
            }
            if (bl) {
                int n = 0;
                Object object2 = this.getFingerprint();
                SearchNode searchNode = this.parent;
                while (searchNode != null) {
                    ++n;
                    if (!((FrontierPrint)object2).matches(searchNode)) break;
                    searchNode = searchNode.parent;
                }
                if (n > 1) {
                    int n3;
                    int n4;
                    WordGrid.Word word;
                    int n5 = 0;
                    if (this.options.aggressiveBacktracking) {
                        while (rand.nextFloat() > 0.8f) {
                            ++n5;
                        }
                    }
                    int n6 = n5;
                    GridSearchNode gridSearchNode = this;
                    n6 = gridSearchNode.options.aggressiveBacktracking ? n6 : 0;
                    n = gridSearchNode.chooseWordToFill();
                    object2 = gridSearchNode.state.getGrid();
                    BitSet bitSet = gridSearchNode.state.findIsland(n);
                    BitSet bitSet2 = gridSearchNode.nodesExplored;
                    BitSet bitSet3 = new BitSet(gridSearchNode.state.getWordCount());
                    int n7 = bitSet2.nextSetBit(0);
                    while (n7 != -1) {
                        WordGrid.Word word2 = ((WordGrid)object2).getWord(n7);
                        int n8 = 0;
                        while (true) {
                            word = word2;
                            if (n8 >= word.letterIndices.length) break;
                            n4 = n8;
                            word = word2;
                            n3 = word.letterIndices[n4];
                            for (int i = 0; i < ((WordGrid)object2).getCrossWordCount(n3); ++i) {
                                n4 = ((WordGrid)object2).getCrossWord(n3, i);
                                if (gridSearchNode.state.isComplete(n4)) continue;
                                bitSet3.set(n4);
                            }
                            ++n8;
                        }
                        n7 = bitSet2.nextSetBit(n7 + 1);
                    }
                    BitSet bitSet4 = new BitSet(gridSearchNode.state.getWordCount());
                    int n9 = bitSet3.nextSetBit(0);
                    while (n9 != -1) {
                        WordGrid.Word word3 = ((WordGrid)object2).getWord(n9);
                        n3 = 0;
                        while (true) {
                            word = word3;
                            if (n3 >= word.letterIndices.length) break;
                            n4 = n3;
                            word = word3;
                            int n10 = word.letterIndices[n4];
                            for (n4 = 0; n4 < ((WordGrid)object2).getCrossWordCount(n10); ++n4) {
                                int n11 = ((WordGrid)object2).getCrossWord(n10, n4);
                                if (gridSearchNode.state.isComplete(n11)) continue;
                                bitSet4.set(n11);
                            }
                            ++n3;
                        }
                        n9 = bitSet3.nextSetBit(n9 + 1);
                    }
                    bitSet3.or(bitSet4);
                    bitSet.and(bitSet3);
                    BitSet bitSet5 = gridSearchNode.state.findIslandNeighbors(bitSet);
                    int n12 = gridSearchNode.blockingDuplicates.nextSetBit(0);
                    while (n12 != -1) {
                        if (gridSearchNode.state.isComplete(n12)) {
                            bitSet5.set(n12);
                        }
                        n12 = gridSearchNode.blockingDuplicates.nextSetBit(n12 + 1);
                    }
                    throw new BadStateError(gridSearchNode, n6, bitSet5, n){
                        private /* synthetic */ int val$severity;
                        private /* synthetic */ BitSet val$neighbors;
                        private /* synthetic */ GridSearchNode this$0;
                        {
                            this.this$0 = gridSearchNode;
                            this.val$severity = n;
                            this.val$neighbors = bitSet;
                        }

                        @Override
                        public final boolean acceptableState(SearchNode searchNode, SearchNode searchNode2) {
                            return this.this$0.checkNeighborsAccessible(this.val$severity, this.val$neighbors, searchNode, searchNode2);
                        }

                        @Override
                        public final SearchNode getSource() {
                            return this.this$0;
                        }
                    };
                }
            }
            return;
        }
    }

    @Override
    public final boolean reconcileWithDeadStates(ObjectSet<SearchNode.Fingerprint> objectSet) {
        return true;
    }

    public GridSearchNode(GridSearchNode gridSearchNode, GridState gridState, SharedOptions sharedOptions) {
        super(gridSearchNode);
        this.state = gridState;
        this.options = sharedOptions;
        this.nodesExplored = new BitSet(gridState.getWordCount());
        this.blockingDuplicates = new BitSet(gridState.getWordCount());
    }

    public void setString(int n, String string) {
        this.state.setString(n, string);
        this.latestWord = n;
        this.fingerPrint = null;
        this.cachedQuality = -1.0f;
    }

    public final int chooseWordToFill() {
        int n = this.auxChooseWordToFill();
        if (n == -1) {
            return n;
        }
        return n;
    }

    private int auxChooseWordToFill() {
        switch (this.options.orderStrategy) {
            case STANDARD: {
                return this.chooseWordToFillStd();
            }
            case QUALITY: {
                return this.chooseWordToFillQuality();
            }
            case FRONTIER: {
                return this.chooseWordToFillFrontier();
            }
        }
        throw new IllegalStateException();
    }

    protected int chooseWordToFillFrontier() {
        return this.chooseWordToFillQuality();
    }

    protected int chooseWordToFillQuality() {
        int n;
        Object object;
        int n2;
        int n3;
        Object object2;
        int n4 = -1;
        char[] cArray = this.state.getChars();
        float[] fArray = new float[cArray.length];
        Arrays.fill(fArray, 1.0f);
        int n5 = this.state.getWordCount();
        block3: for (int i = 0; i < n5; ++i) {
            if (this.state.isComplete(i)) continue;
            object2 = this.state.getWord(i);
            WordList.MatchInfo matchInfo = this.options.wordList.search(this.state, i);
            float f = matchInfo.getMatchCount();
            n3 = 0;
            while (true) {
                Object object3 = object2;
                if (n3 >= ((WordGrid.Word)object3).letterIndices.length) continue block3;
                n2 = n3++;
                object3 = object2;
                int n6 = ((WordGrid.Word)object3).letterIndices[n2];
                fArray[n6] = fArray[n6] * f;
            }
        }
        float[] fArray2 = new float[n5];
        object2 = this.state.getGrid();
        for (int i = 0; i < fArray2.length; ++i) {
            float f;
            if (this.state.isComplete(i)) {
                fArray2[i] = Float.NEGATIVE_INFINITY;
                continue;
            }
            WordGrid.Word word = this.state.getWord(i);
            object = word;
            n3 = word.letterIndices.length;
            float f2 = 0.0f;
            int n7 = 0;
            while (true) {
                object = word;
                if (n7 >= ((WordGrid.Word)object).letterIndices.length) break;
                n2 = n7++;
                object = word;
                f2 += fArray[((WordGrid.Word)object).letterIndices[n2]];
            }
            float f3 = (float)(-Math.sqrt(f2 / (float)n3 / (float)n3 / (float)n3));
            float f4 = 1.0f;
            n = 1;
            SearchNode searchNode = this.parent;
            while (searchNode != null) {
                GridSearchNode gridSearchNode = (GridSearchNode)searchNode;
                int[] nArray = gridSearchNode.nextWords;
                for (int j = 0; j < nArray.length; ++j) {
                    if (nArray[j] != word.getWordIndex()) continue;
                    if (this.options.crossOlderWords) {
                        f4 += n >= DEPTH_DIVISORS.length ? 5.0f : (float)DEPTH_DIVISORS[n];
                        break;
                    }
                    f4 += 1.0f;
                    break;
                }
                searchNode = searchNode.parent;
                ++n;
            }
            if (this.options.fillEdgesFirst) {
                f4 += (float)((WordGrid)object2).edgeCount(i);
            }
            fArray2[i] = f = f3 / f4;
        }
        if (this.latestWord != -1) {
            int n8;
            int n9;
            BitSet bitSet = this.state.allCrosses(this.latestWord);
            Object object4 = this.options;
            synchronized (object4) {
                n9 = this.options.forcedNext;
            }
            if (n9 != -1 && !this.state.isComplete(n9)) {
                object4 = this.state.allCrosses(n9);
                n5 = ((BitSet)object4).nextSetBit(0);
                while (n5 != -1) {
                    if (!this.state.isComplete(n5)) {
                        int n10 = n5;
                        fArray2[n10] = fArray2[n10] / 16.0f;
                        bitSet.set(n5);
                    }
                    n5 = ((BitSet)object4).nextSetBit(n5 + 1);
                }
            }
            object4 = this.state.getWord(this.latestWord);
            n5 = ((WordGrid)object2).getWidth();
            int n11 = ((WordGrid)object2).getHeight();
            int[] nArray = new int[((WordGrid)object2).getWordCount()];
            n = ((WordGrid.Word)object4).getDirection();
            object = object4;
            int n12 = ((WordGrid.Word)object).letterIndices.length;
            for (n8 = 0; n8 < n12; ++n8) {
                int n13;
                n2 = n8;
                Object object5 = object4;
                int n14 = ((WordGrid.Word)object5).letterIndices[n2];
                int n15 = n14 % n5;
                n9 = n14 / n5;
                if (n == 0) {
                    n14 = 1;
                    n2 = n11;
                    if (n9 + 2 < n11) {
                        n2 = n9 + 2;
                    }
                    for (n13 = n9 + 1; n13 < n2; ++n13) {
                        if (cArray[n15 + n13 * n5] == '\u007f') {
                            n14 = -1000;
                            continue;
                        }
                        GridSearchNode.incrAdj((WordGrid)object2, nArray, n15, n13, n, cArray, true, n14);
                    }
                    n14 = 1;
                    n13 = 0;
                    if (n9 - 1 > 0) {
                        n13 = n9 - 1;
                    }
                    for (n2 = n9 - 1; n2 >= n13; --n2) {
                        if (cArray[n15 + n2 * n5] == '\u007f') {
                            n14 = -1000;
                            continue;
                        }
                        GridSearchNode.incrAdj((WordGrid)object2, nArray, n15, n2, n, cArray, true, n14);
                    }
                    continue;
                }
                n14 = 1;
                n2 = n5;
                if (n15 + 2 < n5) {
                    n2 = n15 + 2;
                }
                for (n13 = n15 + 1; n13 < n2; ++n13) {
                    if (cArray[n13 + n9 * n5] == '\u007f') {
                        n14 = -1000;
                        continue;
                    }
                    GridSearchNode.incrAdj((WordGrid)object2, nArray, n13, n9, n, cArray, true, n14);
                }
                n14 = 1;
                n13 = 0;
                if (n15 - 1 > 0) {
                    n13 = n15 - 1;
                }
                for (n2 = n15 - 1; n2 >= n13; --n2) {
                    if (cArray[n2 + n9 * n5] == '\u007f') {
                        n14 = -1000;
                        continue;
                    }
                    GridSearchNode.incrAdj((WordGrid)object2, nArray, n2, n9, n, cArray, true, n14);
                }
            }
            for (n8 = 0; n8 < nArray.length; ++n8) {
                if (nArray[n8] <= 1) continue;
                bitSet.set(n8);
            }
            n8 = 0;
            n12 = bitSet.nextSetBit(0);
            while (n12 != -1) {
                if (!this.state.isComplete(n12)) {
                    ++n8;
                }
                n12 = bitSet.nextSetBit(n12 + 1);
            }
            if (n8 > 0) {
                WordGrid.Word[] wordArray = new WordGrid.Word[n8];
                n8 = 0;
                int n16 = bitSet.nextSetBit(0);
                while (n16 != -1) {
                    if (!this.state.isComplete(n16)) {
                        wordArray[n8++] = ((WordGrid)object2).getWord(n16);
                    }
                    n16 = bitSet.nextSetBit(n16 + 1);
                }
                Arrays.sort(wordArray, new Comparator<WordGrid.Word>(){
                    private /* synthetic */ float[] val$scores;
                    {
                        this.val$scores = fArray;
                    }
                });
                this.nextWords = new int[n8];
                for (n16 = 0; n16 < n8; ++n16) {
                    this.nextWords[n16] = wordArray[n16].getWordIndex();
                }
                for (n16 = 0; n16 < this.nextWords.length; ++n16) {
                    if (fArray2[this.nextWords[n16]] == Float.NEGATIVE_INFINITY) continue;
                    n4 = this.nextWords[n16];
                    break;
                }
            }
        }
        if (n4 == -1) {
            float f = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < fArray2.length; ++i) {
                if (!(fArray2[i] > f)) continue;
                f = fArray2[i];
                n4 = i;
            }
        }
        return n4;
    }

    /*
     * WARNING - void declaration
     */
    protected static void incrAdj(WordGrid wordGrid, int[] nArray, int n, int n2, int n3, char[] cArray, boolean bl, int n4) {
        if (n < 0 || n >= wordGrid.getWidth()) {
            return;
        }
        if (n2 < 0 || n2 >= wordGrid.getHeight()) {
            return;
        }
        if (cArray[n += wordGrid.getWidth() * n2] != '\u0000') {
            return;
        }
        int n5 = wordGrid.getCrossWordCount(n);
        for (n2 = 0; n2 < n5; ++n2) {
            void var7_9;
            int n6 = wordGrid.getCrossWord(n, n2);
            if (wordGrid.getWord(n6).getDirection() != n3) continue;
            int n7 = n6;
            nArray[n7] = nArray[n7] + var7_9;
        }
    }

    protected int chooseWordToFillStd() {
        int n;
        int n2;
        Object object;
        int n3 = -1;
        BitSet bitSet = new BitSet(this.state.getWordCount());
        Object object2 = this.parent;
        while (object2 != null) {
            GridSearchNode gridSearchNode = (GridSearchNode)object2;
            object = gridSearchNode.nextWords;
            for (n2 = 0; n2 < ((int[])object).length; ++n2) {
                if (this.state.isComplete(object[n2])) continue;
                bitSet.set(object[n2]);
            }
            object2 = ((SearchNode)object2).parent;
        }
        object2 = this.state.getGrid();
        if (this.latestWord != -1) {
            int n4;
            Object object3;
            int n5 = 0;
            object = ((WordGrid)object2).getWord(this.latestWord);
            n2 = 0;
            while (true) {
                object3 = object;
                if (n2 >= object.letterIndices.length) break;
                n4 = n2;
                object3 = object;
                int n6 = object.letterIndices[n4];
                int n7 = ((WordGrid)object2).getCrossWordCount(n6);
                for (n = 0; n < n7; ++n) {
                    n4 = ((WordGrid)object2).getCrossWord(n6, n);
                    if (n4 == this.latestWord || this.state.isComplete(n4) || this.acceptableWords != null && !this.acceptableWords.get(n4)) continue;
                    ++n5;
                }
                ++n2;
            }
            if (n5 > 0) {
                int[] nArray = new int[n5];
                int[] nArray2 = new int[n5];
                n = 0;
                while (true) {
                    object3 = object;
                    if (n >= object.letterIndices.length) break;
                    n4 = n;
                    object3 = object;
                    int n8 = object.letterIndices[n4];
                    n3 = ((WordGrid)object2).getCrossWordCount(n8);
                    for (n4 = 0; n4 < n3; ++n4) {
                        int n9 = ((WordGrid)object2).getCrossWord(n8, n4);
                        if (n9 == this.latestWord || this.state.isComplete(n9) || this.acceptableWords != null && !this.acceptableWords.get(n9)) continue;
                        nArray[--n5] = n9;
                        nArray2[n5] = this.options.wordList.search(this.state, n9).getMatchCount();
                        int n10 = n5;
                        nArray2[n10] = nArray2[n10] / (1 + ((WordGrid)object2).edgeCount(n9));
                    }
                    ++n;
                }
                GridSearchNode.sortCandidates(nArray, nArray2);
                this.nextWords = nArray;
                n3 = nArray[0];
            }
        }
        if (n3 == -1) {
            int n11 = 0;
            int n12 = ((WordGrid)object2).getWordCount();
            for (int i = 0; i < n12; ++i) {
                int n13 = ((WordGrid)object2).getWord(i).getWordIndex();
                if (this.state.isComplete(n13) || this.acceptableWords != null && !this.acceptableWords.get(n13)) continue;
                ++n11;
            }
            if (n11 > 0) {
                int n14;
                int[] nArray = new int[n11];
                int[] nArray3 = new int[n11];
                n = ((WordGrid)object2).getWordCount();
                for (n14 = 0; n14 < n; ++n14) {
                    int n15 = ((WordGrid)object2).getWord(n14).getWordIndex();
                    if (this.state.isComplete(n15) || this.acceptableWords != null && !this.acceptableWords.get(n15)) continue;
                    nArray[--n11] = n15;
                    nArray3[n11] = this.options.wordList.search(this.state, n15).getMatchCount();
                    int n16 = n11;
                    nArray3[n16] = nArray3[n16] / (1 + ((WordGrid)object2).edgeCount(n15));
                }
                GridSearchNode.sortCandidates(nArray, nArray3);
                if (!bitSet.isEmpty()) {
                    for (n14 = 0; n14 < nArray.length; ++n14) {
                        if (!bitSet.get(nArray[n14])) continue;
                        n3 = nArray[n14];
                        break;
                    }
                }
                if (n3 == -1) {
                    n3 = nArray[0];
                }
            }
        }
        return n3;
    }

    private static void sortCandidates(int[] nArray, int[] nArray2) {
        int n = nArray.length - 1;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = i;
            int n4 = nArray2[i];
            int n5 = nArray.length;
            for (n2 = i + 1; n2 < n5; ++n2) {
                if (nArray2[n2] >= n4) continue;
                n3 = n2;
                n4 = nArray2[n2];
            }
            n2 = nArray[n3];
            nArray[n3] = nArray[i];
            nArray2[n3] = nArray2[i];
            nArray[i] = n2;
            nArray2[i] = n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean checkNeighborsAccessible(int n, BitSet bitSet, SearchNode searchNode, SearchNode searchNode2) {
        Object object = (GridSearchNode)searchNode;
        object = ((GridSearchNode)object).state;
        GridState gridState = ((GridSearchNode)searchNode2).state;
        int n2 = 0;
        int n3 = 0;
        int n4 = bitSet.nextSetBit(0);
        while (n4 >= 0) {
            if (!gridState.isComplete(n4)) {
                ++n3;
            }
            n4 = bitSet.nextSetBit(n4 + 1);
        }
        if (n > 0 && n >= n3) {
            if (searchNode.parent != searchNode2) return false;
            return true;
        }
        n4 = bitSet.nextSetBit(0);
        while (n4 >= 0) {
            if (!((GridState)object).isComplete(n4)) {
                ++n2;
            }
            n4 = bitSet.nextSetBit(n4 + 1);
        }
        if (n2 > n) {
            return true;
        }
        SharedOptions sharedOptions = this.options;
        // MONITORENTER : sharedOptions
        // MONITOREXIT : sharedOptions
        return false;
    }

    static {
        Arrays.fill(LETTER_SCORES, -5.0f);
        for (int i = 0; i < 26; ++i) {
            GridSearchNode.LETTER_SCORES["etaoinshrdlucmfgypwbvkxjqz".charAt((int)i)] = -100.0f / (float)(i + 1);
        }
        DEPTH_DIVISORS = new int[]{1, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4};
    }

    public static final class SharedOptions
    extends GridStrategies
    implements Cloneable {
        public int beam = 20;
        public int beamMultiplier = 5;
        public int minCandidateScore = 1;
        public boolean aggressiveBacktracking = false;
        public boolean generousParallels = false;
        public int longestSubstring = Integer.MAX_VALUE;
        public FillOrder orderStrategy = FillOrder.QUALITY;
        protected WordStringIntMap badWords;
        public WordList wordList;
        public BitSet neighborhood;
        public int[] failureCounts;
        public int[] successCounts;
        public int[] persistentFailureCounts;
        public int[] persistentSuccessCounts;
        public int forcedNext;
        public int rootBeam;
        public boolean fastCount;
        public boolean trackBlockingWords;

        public final SharedOptions clone() {
            try {
                return (SharedOptions)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }

        public SharedOptions(int n, WordList wordList) {
            new ArrayList();
            this.forcedNext = -1;
            this.rootBeam = -1;
            this.fastCount = true;
            this.trackBlockingWords = true;
            this.wordList = wordList;
            this.beam = n;
        }

        public final void setBadWordsHeuristic(boolean bl) {
            this.badWords = null;
        }
    }

    public static final class GSNProxy
    implements SearchNodeProxy,
    Comparable<GSNProxy> {
        float priority;
        private int wordNum;
        String word;
        private GridSearchNode parent;

        public GSNProxy(float f, GridSearchNode gridSearchNode, int n, String string) {
            this.priority = f;
            this.parent = gridSearchNode;
            this.wordNum = n;
            this.word = string;
        }

        @Override
        public final int getDepth() {
            GridSearchNode gridSearchNode = this.parent;
            return gridSearchNode.depth + 1;
        }

        @Override
        public final SearchNode getParent() {
            return this.parent;
        }

        @Override
        public final SearchNode getNode() {
            GridSearchNode gridSearchNode = this.parent.makeSuccessor();
            gridSearchNode.setString(this.wordNum, this.word);
            gridSearchNode.priority = this.priority;
            return gridSearchNode;
        }

        @Override
        public final float getPriority() {
            return this.priority;
        }

        public final String toString() {
            return this.word;
        }

        public final boolean equals(Object object) {
            return object instanceof GSNProxy && this.compareTo((GSNProxy)object) == 0;
        }

        @Override
        private int compareTo(GSNProxy gSNProxy) {
            float f;
            GSNProxy gSNProxy2 = this;
            GSNProxy gSNProxy3 = gSNProxy2;
            gSNProxy3 = gSNProxy;
            float f2 = gSNProxy2.priority - gSNProxy3.priority;
            if (f < 0.0f) {
                return 1;
            }
            if (f2 > 0.0f) {
                return -1;
            }
            int n = this.wordNum - gSNProxy.wordNum;
            if (n != 0) {
                return n;
            }
            return this.word.compareTo(gSNProxy.word);
        }
    }

    public final class CandidateGenerator {
        String value;
        private WordList.MatchInfo match;
        private BitSet blocking;
        private int thisIndex = -1;
        private Pattern filter;
        private /* synthetic */ GridSearchNode this$0;

        public CandidateGenerator(GridSearchNode gridSearchNode, int n, Pattern pattern, BitSet bitSet) {
            this.this$0 = gridSearchNode;
            this.filter = pattern;
            this.blocking = bitSet;
            this.match = gridSearchNode.options.wordList.search(gridSearchNode.state, n);
        }

        public final boolean advance() {
            String string;
            boolean bl;
            do {
                boolean bl2;
                CandidateGenerator candidateGenerator;
                String string2;
                block8: {
                    int n;
                    ++this.thisIndex;
                    if (this.thisIndex == this.match.getMatchCount()) {
                        return false;
                    }
                    string2 = string = this.match.getMatch(this.thisIndex);
                    candidateGenerator = this;
                    float f = candidateGenerator.match.getScore(candidateGenerator.thisIndex);
                    if (f < 1.0f || f < (float)candidateGenerator.this$0.options.minCandidateScore) {
                        bl = false;
                        continue;
                    }
                    String string3 = string2;
                    CandidateGenerator candidateGenerator2 = candidateGenerator;
                    int n2 = candidateGenerator2.this$0.state.getWordCount();
                    for (n = 0; n < n2; ++n) {
                        String string4 = candidateGenerator2.this$0.state.getCompleteWord(n);
                        if (string4 == null || !string3.equals(string4)) continue;
                        candidateGenerator2.blocking.set(n);
                        bl2 = true;
                        break block8;
                    }
                    n = candidateGenerator2.this$0.options.longestSubstring;
                    int n3 = string3.length() - n;
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            String string5 = candidateGenerator2.this$0.state.getCompleteWord(j);
                            if (string5 == null || string5.length() <= n) continue;
                            int n4 = string5.length() - n;
                            block4: for (int k = 0; k < n4; ++k) {
                                if (string3.charAt(i) != string5.charAt(k)) continue;
                                for (int i2 = 1; i2 <= n; ++i2) {
                                    if (string3.charAt(i + i2) != string5.charAt(k + i2)) continue block4;
                                }
                                candidateGenerator2.blocking.set(j);
                                bl2 = true;
                                break block8;
                            }
                        }
                    }
                    bl2 = false;
                }
                bl = bl2 ? false : candidateGenerator.filter == null || candidateGenerator.filter.matcher(string2).find();
            } while (!bl);
            this.value = string;
            return true;
        }
    }

    public static final class WordStringIntMap
    extends OpenHashUtil.GenericDoubleHash {
        private static final WordGrid.Word DELETED_WORD = new WordGrid.Word(-1, null);
        WordGrid.Word[] wordArray;
        String[] stringArray;
        int[] intArray;
        private WordGrid.Word wordKey;
        private String stringKey;

        @Override
        public final Iter getIterator() {
            return new Iter(this);
        }

        @Override
        protected final boolean hasDeletedKey(int n) {
            return this.wordArray[n] == DELETED_WORD;
        }

        @Override
        protected final boolean hasNullKey(int n) {
            return this.wordArray[n] == null;
        }

        @Override
        protected final boolean matchesCurrentKey(int n) {
            return this.wordArray[n] == this.wordKey && this.stringArray[n].equals(this.stringKey);
        }

        @Override
        protected final void init(int n) {
            this.wordArray = new WordGrid.Word[n];
            this.stringArray = new String[n];
            this.intArray = new int[n];
        }

        @Override
        protected final void rehash(int n) {
            WordGrid.Word word = this.wordKey;
            String string = this.stringKey;
            WordGrid.Word[] wordArray = this.wordArray;
            String[] stringArray = this.stringArray;
            int[] nArray = this.intArray;
            this.init(n);
            for (n = 0; n < wordArray.length; ++n) {
                WordGrid.Word word2 = wordArray[n];
                if (word2 == null || word2 == DELETED_WORD) continue;
                this.put(wordArray[n], stringArray[n], nArray[n]);
            }
            this.wordKey = word;
            this.stringKey = string;
        }

        public final int get(WordGrid.Word word, String string, int n) {
            this.wordKey = word;
            this.stringKey = string;
            int n2 = this.findIndex(WordStringIntMap.hash(word, string));
            if (n2 == -1) {
                return 0;
            }
            return this.intArray[n2];
        }

        public final void put(WordGrid.Word word, String string, int n) {
            this.wordKey = word;
            this.stringKey = string;
            int n2 = this.auxPut(WordStringIntMap.hash(word, string));
            this.wordArray[n2] = word;
            this.stringArray[n2] = string;
            this.intArray[n2] = n;
        }

        public final void remove(WordGrid.Word word, String string) {
            this.wordKey = word;
            this.stringKey = string;
            int n = this.auxRemove(WordStringIntMap.hash(word, string));
            if (n != -1) {
                this.wordArray[n] = DELETED_WORD;
                this.stringArray[n] = null;
            }
        }

        private static int hash(WordGrid.Word word, String string) {
            return word.getWordIndex() * 57 + string.hashCode();
        }

        public final class Iter
        extends OpenHashUtil.GenericDoubleHash.Iter {
            private /* synthetic */ WordStringIntMap this$0;

            public Iter(WordStringIntMap wordStringIntMap) {
                this.this$0 = wordStringIntMap;
                super(wordStringIntMap);
            }

            @Override
            protected final void appendString(StringBuilder object, int n) {
                object = new Formatter((Appendable)object);
                try {
                    ((Formatter)object).format("{%d,%s}=>%d", this.this$0.wordArray[n].getWordIndex(), this.this$0.stringArray[n], this.this$0.intArray[n]);
                    return;
                }
                finally {
                    ((Formatter)object).close();
                }
            }

            public final WordGrid.Word getWord() {
                return this.this$0.wordArray[this.getIndex()];
            }

            public final String getString() {
                return this.this$0.stringArray[this.getIndex()];
            }
        }
    }

    static final class FillOrder
    extends Enum<FillOrder> {
        public static final /* enum */ FillOrder STANDARD = new FillOrder();
        public static final /* enum */ FillOrder QUALITY = new FillOrder();
        public static final /* enum */ FillOrder FRONTIER = new FillOrder();
        public static final /* enum */ FillOrder UNSPECIFIED = new FillOrder();
        private static final /* synthetic */ FillOrder[] $VALUES;

        public static FillOrder[] values() {
            return (FillOrder[])$VALUES.clone();
        }

        static {
            $VALUES = new FillOrder[]{STANDARD, QUALITY, FRONTIER, UNSPECIFIED};
        }
    }
}

