/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.GUIUtil;
import com.beekeeper.util.GridHelper;
import com.beekeeper.util.ImageUtil;
import com.beekeeper.util.IntSet;
import com.beekeeper.util.StringUtil;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.WordGrid;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class GridDisplay
extends JPanel {
    public static final Color DEFAULT_WORD_SELECTION = new Color(0xAACCFF);
    public static final Color DEFAULT_CHAR_SELECTION = new Color(0x7777FF);
    private static Color SELECTED_BLOCK_COLOR = new Color(0x666666);
    private Color selectedCharColor;
    private Color selectedWordColor;
    private FocusListener repaintFocusListener = new FocusListener(this){
        private /* synthetic */ GridDisplay this$0;
        {
            this.this$0 = gridDisplay;
        }

        @Override
        public final void focusGained(FocusEvent focusEvent) {
            this.this$0.repaint();
        }

        @Override
        public final void focusLost(FocusEvent focusEvent) {
            this.this$0.repaint();
        }
    };
    protected final TreeSet<DisplaySet> displays = new TreeSet();
    private final HashMap<String, DisplaySet> displayNames = new HashMap();
    private boolean showThemeLetters = true;
    protected boolean showWordNumbers = true;
    protected int minSquareSize = 11;
    private int maxSquareSize = Integer.MAX_VALUE;
    private int preferredSquareSize = 36;
    protected final AuxGridDisplay painter = new AuxGridDisplay(this);
    private StringUtil rebuses$6d32e3b8 = null;
    protected int width;
    protected int height;
    protected GridState state;
    private final Font baseNumberFont = new Font("Dialog", 0, 24);
    private Font baseFont;
    private boolean selectionVertical = false;
    protected IntSet wordSelection = new IntSet();
    private int selectedChar = -1;
    private final ArrayList<Runnable> selectActions = new ArrayList();
    private MyLayout lastLayout = null;
    private boolean lastShowNumbers = false;
    private Dimension lastSize = null;
    private boolean lastIsPrinter = false;
    private static final Color THEME_COLOR = new Color(0x880099);
    private final Color circleColor = new Color(96, 96, 96);
    GridState oldState;
    protected String lastToolTip;
    protected int lastToolTipChar;
    boolean ttComputing = false;
    boolean ttUpdatePending = false;
    private int oldInitDelay = -1;
    private int oldDismissDelay = -1;
    protected boolean inGrid = false;
    private boolean virtuallyInGrid = false;
    private boolean delayAdjusted = false;
    protected WeakHashMap<PageFormat, MyLayout> printMap = new WeakHashMap();
    protected boolean showTooltips;
    protected final JScrollBar vScroll = new JScrollBar(1);
    protected final JScrollBar hScroll = new JScrollBar(0);
    protected Dimension virtualSize;
    protected int squareSize = this.preferredSquareSize;
    private int tooltipDismiss = Integer.MAX_VALUE;

    public GridDisplay(Color color, Color color2) {
        this(GridDisplay.getDefaultFont(), color, color2);
    }

    public GridDisplay(Font object, Color color, Color color2) {
        this.baseFont = object;
        this.selectedCharColor = color;
        this.selectedWordColor = color2;
        object = new GridHelper(this);
        ((GridHelper)object).stretch().space().advance();
        ((GridHelper)object).add(this.painter).add(this.vScroll).advance(0, 1.0);
        ((GridHelper)object).add(this.hScroll).advance();
        object = new AdjustmentListener(this){
            private /* synthetic */ GridDisplay this$0;
            {
                this.this$0 = gridDisplay;
            }

            @Override
            public final void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                this.this$0.painter.repaint();
            }
        };
        this.vScroll.addAdjustmentListener((AdjustmentListener)object);
        this.hScroll.addAdjustmentListener((AdjustmentListener)object);
        this.setOpaque(true);
        this.setForeground(Color.black);
        object = ToolTipManager.sharedInstance();
        ((ToolTipManager)object).registerComponent(this);
        GridDisplay gridDisplay = this;
        gridDisplay.addFocusListener(gridDisplay.repaintFocusListener);
        this.addMouseListener(new MouseAdapter(this){
            private /* synthetic */ GridDisplay this$0;
            {
                this.this$0 = gridDisplay;
            }

            @Override
            public final void mouseEntered(MouseEvent mouseEvent) {
                this.this$0.inGrid = true;
                this.this$0.updateDelays();
            }

            @Override
            public final void mouseExited(MouseEvent mouseEvent) {
                this.this$0.inGrid = false;
                this.this$0.updateDelays();
            }
        });
    }

    public GridDisplay(Font font, GridState gridState) {
        this(font, DEFAULT_CHAR_SELECTION, DEFAULT_WORD_SELECTION);
        this.setState(gridState, true);
    }

    private static Font getDefaultFont() {
        try {
            return Font.createFont(0, GridDisplay.class.getResourceAsStream("resources/VeraMoBd.ttf")).deriveFont(24.0f);
        }
        catch (Exception exception) {
            return new Font("SansSerif", 1, 24);
        }
    }

    public final void addSelectionListener(Runnable runnable) {
        this.selectActions.add(runnable);
    }

    public final int getSelection() {
        return this.selectedChar;
    }

    public final boolean isSelectionVertical() {
        return this.selectionVertical;
    }

    public void setSelection(int n) {
        this.selectedChar = n;
        this.updateSelectedWord();
    }

    public void setSelection(int n, boolean bl) {
        this.selectedChar = n;
        this.selectionVertical = bl;
        this.updateSelectedWord();
    }

    /*
     * Unable to fully structure code
     */
    public final void setSelectedWord(int var1_1) {
        block4: {
            if (var1_1 != -1) break block4;
            v0 = this;
            v1 = -1;
            ** GOTO lbl-1000
        }
        var1_2 = this.state.getWord(var1_1);
        var4_4 = 0;
        var3_5 = var1_2;
        var2_6 = var1_2.letterIndices[var4_4];
        var3_5 = var1_2;
        if (var3_5.letterIndices.length < 2) ** GOTO lbl-1000
        var4_4 = 1;
        var3_5 = var1_2;
        if (var3_5.letterIndices[var4_4] == var2_6 + 1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        var1_3 = v2;
        v0 = this;
        v1 = var2_6;
        if (!var1_3) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        v0.setSelection(v1, v3);
    }

    public final int getSelectedWord() {
        if (this.state == null) {
            return -1;
        }
        WordGrid wordGrid = this.state.getGrid();
        if (this.selectedChar < 0) {
            return -1;
        }
        int n = wordGrid.getCrossWordCount(this.selectedChar);
        for (int i = 0; i < n; ++i) {
            WordGrid.Word word;
            WordGrid wordGrid2 = wordGrid;
            WordGrid.Word word2 = word = wordGrid2.getWord(wordGrid2.getCrossWord(this.selectedChar, i));
            if (word.letterIndices.length < 2) continue;
            int n2 = 1;
            word2 = word;
            int n3 = word2.letterIndices[n2];
            n2 = 0;
            word2 = word;
            boolean bl = n3 - word2.letterIndices[n2] > 1;
            if (bl != this.selectionVertical) continue;
            return word.getWordIndex();
        }
        return -1;
    }

    protected final void updateSelectedWord() {
        GridDisplay gridDisplay = this;
        synchronized (gridDisplay) {
            int n;
            this.wordSelection = new IntSet();
            int n2 = this.selectedChar;
            if (n2 == -1) {
                return;
            }
            int n3 = n2 % this.width;
            int n4 = n3 + 1;
            int n5 = n2 / this.width;
            int n6 = n5 + 1;
            int n7 = n3;
            int n8 = n5;
            WordGrid n13 = this.state.getGrid();
            WordGrid.Word object = n13.getWordAt(n2, this.selectionVertical ? 1 : 0, true);
            if (object != null) {
                WordGrid.Word word = object;
                int n14 = word.letterIndices.length;
                for (n = 0; n < n14; ++n) {
                    int n9 = n;
                    word = object;
                    int n10 = word.letterIndices[n9];
                    n9 = n10 % this.width;
                    int n11 = n10 / this.width;
                    n3 = Math.min(n3, n9);
                    n4 = Math.max(n4, n9 + 1);
                    n5 = Math.min(n5, n11);
                    n6 = Math.max(n6, n11 + 1);
                    this.wordSelection.add(n10);
                }
            }
            if (this.hScroll.isVisible()) {
                int n12 = this.hScroll.getValue();
                n = this.painter.getWidth() / this.squareSize;
                if (n3 < n12 && n4 < n12 + n) {
                    this.hScroll.setValue(Math.max(n3, n4 - n));
                } else if (n > 0 && n4 > n12 + n && n3 > n12) {
                    this.hScroll.setValue(Math.min(n4 - n, n3));
                }
                if (n7 < n12) {
                    this.hScroll.setValue(n7);
                } else if (n > 0 && n7 + 1 > n12 + n) {
                    this.hScroll.setValue(n7 + 1 - n);
                }
            }
            if (this.vScroll.isVisible()) {
                int n14 = this.vScroll.getValue();
                n = this.painter.getHeight() / this.squareSize;
                if (n5 < n14 && n6 < n14 + n) {
                    this.vScroll.setValue(Math.max(n5, n6 - n));
                } else if (n > 0 && n6 > n14 + n && n5 > n14) {
                    this.vScroll.setValue(Math.min(n6 - n, n5));
                }
                if (n8 < n14) {
                    this.vScroll.setValue(n8);
                } else if (n > 0 && n8 + 1 > n14 + n) {
                    this.vScroll.setValue(n8 + 1 - n);
                }
            }
        }
        this.repaint();
        for (Runnable runnable : this.selectActions) {
            runnable.run();
        }
    }

    public void setSelectionVertical(boolean bl) {
        this.selectionVertical = bl;
        this.updateSelectedWord();
    }

    public final int getSquareIndex(Point point) {
        Dimension dimension = this.virtualSize();
        int n = this.squareSize;
        int n2 = (dimension.width - this.width * n) / 2 - this.hScroll.getValue() * n;
        int n3 = 0 - this.vScroll.getValue() * n;
        if ((n2 = (point.x - n2) / n) < 0 || n2 >= this.width) {
            return -1;
        }
        int n4 = (point.y - n3) / n;
        if (n4 < 0 || n4 >= this.height) {
            return -1;
        }
        return n4 * this.width + n2;
    }

    private Dimension virtualSize() {
        if (this.virtualSize == null) {
            return this.getSize();
        }
        return this.virtualSize;
    }

    protected final MyLayout computeLayout(Graphics graphics, boolean bl, Dimension dimension, boolean bl2) {
        int n;
        double d;
        double d2;
        int string;
        if (dimension.equals(this.lastSize) && this.lastShowNumbers == bl && this.lastIsPrinter == bl2) {
            return this.lastLayout;
        }
        this.lastSize = dimension;
        this.lastIsPrinter = bl2;
        this.lastShowNumbers = bl;
        Graphics2D graphics2D = GUIUtil.setHighQualityHints(graphics);
        MyLayout myLayout = new MyLayout();
        Object f4 = graphics2D;
        f4 = ((Graphics2D)f4).getFontRenderContext();
        StringBuffer stringBuffer = new StringBuffer();
        for (string = 65; string <= 90; string = (char)(string + '\u0001')) {
            stringBuffer.append((char)string);
        }
        for (string = 48; string <= 57; string = (char)(string + '\u0001')) {
            stringBuffer.append((char)string);
        }
        int glyphVector = 60;
        for (string = 0; string < glyphVector; ++string) {
            stringBuffer.append(Character.toUpperCase("\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff,.?!;:~@#$%^&|_=-+*/\\`'\"<>()[]{}".charAt(string)));
        }
        String string2 = stringBuffer.toString();
        GlyphVector glyphVector2 = this.baseFont.createGlyphVector((FontRenderContext)f4, string2);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int d8 = 0; d8 < 36; ++d8) {
            double d9;
            GlyphMetrics glyphMetrics = glyphVector2.getGlyphMetrics(d8);
            Rectangle2D d22 = glyphMetrics.getBounds2D();
            double d10 = d22.getY();
            double n5 = d10 + d22.getHeight();
            if (d9 < d10) {
                double f2 = n5;
                n5 = d10;
                d10 = f2;
            }
            if (n5 < 0.0) {
                n5 = 0.0;
            }
            if (d10 > 0.0) {
                d10 = 0.0;
            }
            d3 = Math.max(n5, d3);
            d4 = Math.min(d10, d4);
            d7 = Math.max(d22.getWidth(), d7);
            d6 += d10;
            d5 += n5;
        }
        if (d5 > -d6) {
            d2 = -d6 * 1.5 / 36.0;
            d = d3 + d2;
        } else {
            d2 = d5 * 1.5 / 36.0;
            d = -d4 + d2;
        }
        float f = (float)d;
        myLayout.lineWidth = bl2 ? 0.5f : 1.0f;
        myLayout.cellSize = Math.min(Math.max(Math.min((dimension.width - 1) / this.width, (dimension.height - 1) / this.height), this.minSquareSize), this.maxSquareSize);
        if (myLayout.cellSize <= 0) {
            myLayout.cellSize = 1;
        }
        myLayout.letterSize = myLayout.cellSize;
        myLayout.numberSize = 0;
        myLayout.numberFont = null;
        myLayout.numberFontBase = 0.0f;
        if (bl != 0) {
            int f6;
            myLayout.numberSize = myLayout.cellSize / 4;
            int n2 = bl2 ? 11 : 13;
            int n3 = f6 = bl2 ? 7 : 8;
            if (myLayout.numberSize < n2) {
                myLayout.numberSize = Math.min(n2, (int)((double)myLayout.cellSize / 3.2));
            }
            if (myLayout.numberSize < f6) {
                myLayout.numberSize = Math.min(f6, (int)((double)myLayout.cellSize / 2.3));
            }
            float n7 = GUIUtil.getTrueFontHeight(graphics2D, this.baseNumberFont, "0123456789");
            float fontRenderContext = ((float)myLayout.numberSize - 1.0f) / n7;
            myLayout.numberFont = this.baseNumberFont.deriveFont(0, (int)(24.0f * fontRenderContext));
            float glyphVector22 = GUIUtil.getTrueFontHeight(graphics2D, myLayout.numberFont, "0123456789");
            myLayout.numberFontBase = glyphVector22 + (bl2 ? 1.0f : 2.65f);
            myLayout.numberFontLeading = bl2 ? 0.5f : 2.0f;
            myLayout.numberSize = (int)myLayout.numberFontBase;
            myLayout.letterSize -= myLayout.numberSize;
        }
        float f2 = Math.max((float)myLayout.letterSize / (bl2 ? 6.0f : 15.0f), bl2 ? 3.2f : 1.4f);
        float f3 = ((float)myLayout.letterSize - f2 * 2.0f + (float)(bl != 0 ? 1 : 0)) / (float)d;
        int n4 = (int)((double)f3 * d7);
        if ((float)n > (float)myLayout.cellSize - f2 * 2.0f) {
            f3 = ((float)myLayout.cellSize - f2 * 2.0f) / (float)d7;
        }
        myLayout.font = this.baseFont.deriveFont((float)((int)(24.0f * f3)));
        graphics2D.getFontMetrics(myLayout.font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        GlyphVector glyphVector3 = myLayout.font.createGlyphVector(fontRenderContext, string2);
        myLayout.fgm = new HashMap();
        int n5 = string2.length();
        for (bl = 0; bl < n5; ++bl) {
            myLayout.fgm.put(Character.valueOf(string2.charAt(bl)), glyphVector3.getGlyphMetrics(bl));
        }
        myLayout.ascent = (int)((double)(f3 * (float)d) + 0.5);
        myLayout.medfont = this.baseFont.deriveFont((float)Math.floor(10.0f * f3));
        myLayout.medfm = graphics.getFontMetrics(myLayout.medfont);
        myLayout.medAscent = (int)((double)(f * (10.0f * f3) / 24.0f) + 0.5);
        myLayout.smfont = this.baseFont.deriveFont((float)Math.floor(7.0f * f3));
        myLayout.smfm = graphics.getFontMetrics(myLayout.smfont);
        myLayout.smAscent = (int)((double)(f * (7.0f * f3) / 24.0f) + 0.5);
        myLayout.xOffset = (dimension.width - this.width * myLayout.cellSize) / 2;
        if (myLayout.xOffset < 0) {
            myLayout.xOffset = 0;
        }
        myLayout.yOffset = 0;
        float f7 = (float)(d2 * (double)f3);
        myLayout.fontBase = (int)((double)((float)myLayout.cellSize - f2 - (float)myLayout.numberSize - (float)((int)f7)) + 0.5);
        this.lastLayout = myLayout;
        return myLayout;
    }

    public final synchronized void paintGrid(Graphics graphics, Dimension object, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        object = this.computeLayout(graphics, bl2, (Dimension)object, false);
        this.paintGrid((MyLayout)object, graphics, bl, bl2, bl3, bl4);
    }

    public final synchronized void paintGrid(MyLayout myLayout, Graphics object, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Serializable serializable;
        Object object2;
        Graphics2D graphics2D = GUIUtil.setHighQualityHints((Graphics)object);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (this.state == null) {
            return;
        }
        HashMap<Character, ImageUtil> hashMap = null;
        Font font = null;
        int n = 0;
        if (this.rebuses$6d32e3b8 != null) {
            object2 = new HashMap();
            hashMap = new HashMap<Character, ImageUtil>();
            serializable = graphics2D.getFontMetrics(this.baseFont);
            for (ImageUtil object3 : this.rebuses$6d32e3b8.getRebuses()) {
                int n5 = myLayout.font.getSize();
                String string = object3.letters.toUpperCase();
                int n2 = Math.max(serializable.stringWidth(string), 1);
                int n3 = myLayout.cellSize - 2;
                Font font2 = null;
                if (n2 >= n5) {
                    font2 = myLayout.font;
                } else {
                    for (n2 = n3 * 24 / n2; n2 > 2; --n2) {
                        font2 = (Font)((HashMap)object2).get(n2);
                        if (font2 == null) {
                            font2 = this.baseFont.deriveFont((float)n2);
                            ((HashMap)object2).put(n2, font2);
                        }
                        if (graphics2D.getFontMetrics(font2).stringWidth(string) <= n3) break;
                    }
                    if (font2 == null && (font2 = (Font)((HashMap)object2).get(2)) == null) {
                        font2 = this.baseFont.deriveFont(2.0f);
                        ((HashMap)object2).put(2, font2);
                    }
                }
                if (font == null || font2.getSize() < font.getSize()) {
                    font = font2;
                }
                hashMap.put(Character.valueOf(object3.inputChar), object3);
            }
            if (font != null) {
                n = (int)GUIUtil.getTrueFontHeight(graphics2D, font);
            }
        }
        ((Graphics)object).setFont(myLayout.font);
        object2 = this.state.getChars();
        ((Graphics)object).setColor(Color.white);
        ((Graphics)object).fillRect(myLayout.xOffset, 0, this.width * myLayout.cellSize, this.height * myLayout.cellSize);
        this.paintBlackSquares$c258257((Graphics)object, myLayout, (char[])object2);
        if (bl3) {
            this.paintWordSelection((Graphics)object, myLayout);
            this.paintAreaSelection$57de468d((Graphics)object, myLayout);
            Object object3 = object2;
            MyLayout n9 = myLayout;
            Object object5 = object;
            serializable = this;
            if (((GridDisplay)serializable).selectedChar != -1) {
                ((Graphics)object5).setColor(object3[((GridDisplay)serializable).selectedChar] == 127 ? SELECTED_BLOCK_COLOR : ((GridDisplay)serializable).selectedCharColor);
                int n4 = ((GridDisplay)serializable).selectedChar % ((GridDisplay)serializable).width;
                int n6 = ((GridDisplay)serializable).selectedChar / ((GridDisplay)serializable).width;
                ((Graphics)object5).fillRect(n9.xOffset + n4 * n9.cellSize, 0 + n6 * n9.cellSize, n9.cellSize, n9.cellSize);
            }
            this.paintChangedBackgrounds((Graphics)object, myLayout, (char[])object2);
        }
        this.paintCircles(graphics2D, myLayout);
        this.paintLetters(graphics2D, bl, myLayout, (char[])object2, hashMap, font, n);
        this.paintWordNumbers(graphics2D, bl2, myLayout);
        if (bl4) {
            this.paintThemeLetters(graphics2D, bl, bl3, myLayout, (char[])object2, hashMap, font, n);
        }
        this.paintExtraDecorations(graphics2D, bl3, myLayout, hashMap, font, n);
        this.paintStdBorders(graphics2D, myLayout);
        if (bl3 && this.hasFocus()) {
            object = this;
            int n7 = ((GridDisplay)object).selectedChar;
            if (n7 != -1) {
                graphics2D.setColor(new Color(0xFF33DD));
                int n8 = n7 % this.width * myLayout.cellSize;
                int n5 = n7 / this.width * myLayout.cellSize;
                graphics2D.drawRect(myLayout.xOffset + n8 + 1, n5 + 0 + 1, myLayout.cellSize - 2, myLayout.cellSize - 2);
            }
        }
    }

    void paintExtraDecorations(Graphics2D graphics2D, boolean bl, MyLayout myLayout, HashMap<Character, ImageUtil> hashMap, Font font, int n) {
        if (bl) {
            for (DisplaySet displaySet : this.displays) {
                int n2;
                int n3;
                graphics2D.setColor(displaySet.background);
                for (int n4 : displaySet.values.keySet()) {
                    n3 = n4 % this.width;
                    n2 = n4 / this.width;
                    graphics2D.fillRect(myLayout.xOffset + n3 * myLayout.cellSize, 0 + n2 * myLayout.cellSize, myLayout.cellSize, myLayout.cellSize);
                }
                for (Integer object : displaySet.values.keySet()) {
                    n3 = object % this.width;
                    n2 = object / this.width;
                    IntSet c = displaySet.values.get(object);
                    n3 = myLayout.xOffset + n3 * myLayout.cellSize;
                    n2 = 0 + n2 * myLayout.cellSize;
                    if (c.size() != 1) continue;
                    graphics2D.setColor(displaySet.foreground);
                    graphics2D.setFont(myLayout.font);
                    IntSet.Iter iter = c.getIterator();
                    iter.advance();
                    int n4 = iter.getKey();
                    char c2 = (char)n4;
                    if (c2 == ' ') continue;
                    this.paintLetter(c2, graphics2D, n3, n2, myLayout, hashMap, font, n);
                }
            }
        }
    }

    protected void paintChangedBackgrounds(Graphics graphics, MyLayout myLayout, char[] cArray) {
    }

    protected void paintAreaSelection$57de468d(Graphics graphics, MyLayout myLayout) {
    }

    private void paintThemeLetters(Graphics2D graphics2D, boolean n, boolean n2, MyLayout myLayout, char[] cArray, HashMap<Character, ImageUtil> hashMap, Font font, int n3) {
        if (n != 0) {
            if (n2 != 0) {
                graphics2D.setColor(THEME_COLOR);
            }
            for (n = 0; n < this.width; ++n) {
                for (n2 = 0; n2 < this.height; ++n2) {
                    int n4 = n2 * this.width + n;
                    char c = cArray[n4];
                    if (c == '\u0000') continue;
                    boolean bl = this.state.isThemeLetter(n4);
                    n4 = bl ? 1 : 0;
                    if (!bl) continue;
                    n4 = 0 + n2 * myLayout.cellSize;
                    int n5 = myLayout.xOffset + n * myLayout.cellSize;
                    this.paintLetter(c, graphics2D, n5, n4, myLayout, hashMap, font, n3);
                }
            }
        }
    }

    private void paintCircles(Graphics2D graphics2D, MyLayout myLayout) {
        graphics2D.setColor(this.circleColor);
        int n = 0;
        int n2 = myLayout.xOffset + 1;
        while (n < this.width) {
            int n3 = 0;
            int n4 = 1;
            while (n3 < this.height) {
                int n5 = n3 * this.width + n;
                if (this.state.isCircle(n5)) {
                    graphics2D.drawOval(n2, n4, myLayout.cellSize - 2, myLayout.cellSize - 2);
                }
                ++n3;
                n4 += myLayout.cellSize;
            }
            ++n;
            n2 += myLayout.cellSize;
        }
    }

    private void paintStdBorders(Graphics2D graphics2D, MyLayout myLayout) {
        int n;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(myLayout.lineWidth));
        int n2 = myLayout.xOffset;
        int n3 = 0 + this.height * myLayout.cellSize;
        for (n = 0; n <= this.width; ++n) {
            graphics2D.drawLine(n2, 0, n2, n3);
            n2 += myLayout.cellSize;
        }
        n = 0;
        n2 = myLayout.xOffset;
        n3 = n2 + this.width * myLayout.cellSize;
        for (int i = 0; i <= this.height; ++i) {
            graphics2D.drawLine(n2, n, n3, n);
            n += myLayout.cellSize;
        }
        graphics2D.setStroke(stroke);
    }

    private void paintWordNumbers(Graphics2D graphics2D, boolean n, MyLayout myLayout) {
        graphics2D.setColor(Color.black);
        WordGrid wordGrid = this.state.getGrid();
        if (n != 0) {
            graphics2D.setFont(myLayout.numberFont);
            int n2 = wordGrid.getWordCount();
            for (n = 0; n < n2; ++n) {
                WordGrid.Word word = wordGrid.getWord(n);
                int n3 = word.getPrintNumber();
                String string = Integer.toString(n3);
                int n4 = 0;
                int n5 = word.letterIndices[n4];
                n4 = n5 % this.width;
                graphics2D.drawString(string, (float)(myLayout.xOffset + n4 * myLayout.cellSize) + myLayout.numberFontLeading, (float)(0 + (n5 /= this.width) * myLayout.cellSize) + myLayout.numberFontBase);
            }
            graphics2D.setFont(myLayout.font);
        }
    }

    private void paintBlackSquares$c258257(Graphics graphics, MyLayout myLayout, char[] cArray) {
        graphics.setColor(Color.black);
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            int n2 = 0;
            while (n2 < this.width) {
                char c = cArray[n];
                if (c == '\u007f') {
                    graphics.fillRect(myLayout.xOffset + n2 * myLayout.cellSize, 0 + i * myLayout.cellSize, myLayout.cellSize, myLayout.cellSize);
                }
                ++n2;
                ++n;
            }
        }
    }

    private void paintLetters(Graphics2D graphics2D, boolean bl, MyLayout myLayout, char[] cArray, HashMap<Character, ImageUtil> hashMap, Font font, int n) {
        if (bl) {
            graphics2D.setColor(Color.black);
            bl = false;
            for (int i = 0; i < this.height; ++i) {
                int n2 = 0;
                while (n2 < this.width) {
                    char c = cArray[bl];
                    if (c != '\u007f' && c != '\u0000') {
                        int n3 = myLayout.xOffset + n2 * myLayout.cellSize;
                        int n4 = 0 + i * myLayout.cellSize;
                        this.paintLetter(c, graphics2D, n3, n4, myLayout, hashMap, font, n);
                    }
                    ++n2;
                    bl += 1;
                }
            }
        }
    }

    private void paintLetter(char c, Graphics2D graphics2D, int n, int n2, MyLayout myLayout, HashMap<Character, ImageUtil> hashMap, Font font, int n3) {
        int n4 = n2 + myLayout.fontBase + myLayout.numberSize;
        if ((hashMap = hashMap == null ? null : hashMap.get(Character.valueOf(c))) == null) {
            GridDisplay.drawGlyph(c, graphics2D, n, n4, myLayout.cellSize, myLayout.fgm);
            return;
        }
        String string = ((ImageUtil)((Object)hashMap)).letters.toUpperCase();
        int n5 = graphics2D.getFontMetrics(font).stringWidth(string);
        graphics2D.setFont(font);
        n = n + (myLayout.cellSize - n5) / 2 + 1;
        n2 = n2 + myLayout.fontBase + myLayout.numberSize - (myLayout.ascent - n3) / 2;
        graphics2D.drawString(string, n, n2);
        graphics2D.setFont(myLayout.font);
    }

    protected static void drawGlyph(char c, Graphics graphics, int n, int n2, int n3, HashMap<Character, GlyphMetrics> hashMap) {
        Cloneable cloneable;
        c = Character.toUpperCase(c);
        String string = new String(new char[]{c});
        Object object = hashMap.get(Character.valueOf(c));
        if (object == null) {
            cloneable = hashMap;
            synchronized (cloneable) {
                object = (Graphics2D)graphics;
                FontRenderContext fontRenderContext = ((Graphics2D)object).getFontRenderContext();
                GlyphVector glyphVector = ((Graphics)object).getFont().createGlyphVector(fontRenderContext, string);
                object = glyphVector.getGlyphMetrics(0);
                hashMap.put(Character.valueOf(c), (GlyphMetrics)object);
            }
        }
        cloneable = ((GlyphMetrics)object).getBounds2D();
        int n4 = (int)(((double)n3 - ((RectangularShape)cloneable).getWidth()) / 2.0 - (double)((int)((RectangularShape)cloneable).getX()) + (double)0.2f);
        double d = ((RectangularShape)cloneable).getY();
        double d2 = d + ((RectangularShape)cloneable).getHeight();
        n3 = (int)Math.min(Math.abs(d), Math.abs(d2));
        int n5 = 0;
        if (n3 > 2 && c != 'Q') {
            n5 = 2 - n3;
        }
        ((Graphics2D)graphics).drawString(string, n + n4 + 1, n2 + n5);
    }

    private void paintWordSelection(Graphics graphics, MyLayout myLayout) {
        graphics.setColor(this.selectedWordColor);
        IntSet.Iter iter = this.wordSelection.getIterator();
        while (iter.advance()) {
            int n = iter.getKey();
            int n2 = n % this.width;
            graphics.fillRect(myLayout.xOffset + n2 * myLayout.cellSize, 0 + (n /= this.width) * myLayout.cellSize, myLayout.cellSize, myLayout.cellSize);
        }
    }

    public final synchronized GridState getState() {
        return this.state;
    }

    public final synchronized void setState(GridState object, boolean bl) {
        this.width = ((GridState)object).getGrid().getWidth();
        this.height = ((GridState)object).getGrid().getHeight();
        this.oldState = bl ? this.state : null;
        bl = this.state != null && this.state.getGrid() != ((GridState)object).getGrid();
        this.state = object;
        if (bl) {
            GridDisplay gridDisplay = this;
            object = gridDisplay;
            object = this;
            gridDisplay.setSelection(gridDisplay.selectedChar, ((GridDisplay)object).selectionVertical);
        }
        object = this.printMap;
        synchronized (object) {
            this.printMap.clear();
        }
        this.repaint();
        this.toolTipDirty();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSquareSize * this.width + 1, this.preferredSquareSize * this.height + 1);
    }

    public final synchronized void setComputingToolTipInfo(boolean bl) {
        this.ttComputing = bl;
    }

    private synchronized void updateToolTips() {
        if (this.ttComputing || this.ttUpdatePending) {
            return;
        }
        this.ttUpdatePending = true;
        SwingUtilities.invokeLater(new Runnable(this){
            private /* synthetic */ GridDisplay this$0;
            {
                this.this$0 = gridDisplay;
            }

            @Override
            public final void run() {
                GridDisplay gridDisplay = this.this$0;
                synchronized (gridDisplay) {
                    Serializable serializable;
                    if (!this.this$0.ttComputing && this.this$0.showTooltips && this.this$0.isShowing() && (serializable = this.this$0.getMousePosition()) != null) {
                        serializable = new MouseEvent(this.this$0, 0, 0L, 0, serializable.x, serializable.y, 0, false, 0);
                        ToolTipManager.sharedInstance().mouseMoved((MouseEvent)serializable);
                    }
                    this.this$0.ttUpdatePending = false;
                    return;
                }
            }
        });
    }

    @Override
    public synchronized String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public Point getToolTipLocation(MouseEvent serializable) {
        int n = this.getSquareIndex((Point)(serializable = serializable.getPoint()));
        if (n < 0 || n >= this.state.getChars().length) {
            return null;
        }
        if (this.state.getChars()[n] == '\u007f') {
            return null;
        }
        Dimension dimension = this.virtualSize();
        int n2 = this.squareSize;
        int n3 = (dimension.width - this.width * n2) / 2 - n2 * this.hScroll.getValue();
        int n4 = 0 - n2 * this.vScroll.getValue();
        int n5 = n % this.width + 1;
        n = n / this.width + 1;
        return new Point(n5 * n2 + n2 / 2 + n3, n * n2 + n2 / 2 + n4);
    }

    protected final void updateDelays() {
        if (this.inGrid) {
            if (this.delayAdjusted) {
                return;
            }
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            this.oldInitDelay = toolTipManager.getInitialDelay();
            toolTipManager.setInitialDelay(0);
            this.oldDismissDelay = toolTipManager.getDismissDelay();
            toolTipManager.setDismissDelay(this.tooltipDismiss);
            this.delayAdjusted = true;
            return;
        }
        if (!this.delayAdjusted) {
            return;
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setInitialDelay(this.oldInitDelay);
        toolTipManager.setDismissDelay(this.oldDismissDelay);
        toolTipManager.mousePressed(new MouseEvent(this, 0, System.currentTimeMillis(), 0, 0, 0, 1, false));
        this.delayAdjusted = false;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.squareSize = Math.min((n3 - 1) / this.width, (n4 - 1) / this.height);
        if (this.squareSize < this.minSquareSize) {
            this.squareSize = this.minSquareSize;
        }
        if (this.squareSize > this.maxSquareSize) {
            this.squareSize = this.maxSquareSize;
        }
        boolean bl = this.squareSize * this.width > n3 || this.squareSize * this.height > n4;
        this.hScroll.setVisible(bl);
        this.vScroll.setVisible(bl);
        super.setBounds(n, n2, n3, n4);
    }

    public final void setShowWordNumbers(boolean bl) {
        this.showWordNumbers = bl;
        this.repaint();
    }

    public final boolean getShowWordNumbers() {
        return this.showWordNumbers;
    }

    public final void setShowTooltips(boolean bl) {
        this.showTooltips = bl;
    }

    public final void setPreferredSquareSize(int n) {
        this.preferredSquareSize = n;
    }

    public final int getPreferredSquareSize() {
        return this.preferredSquareSize;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.painter.print(graphics, pageFormat, n);
    }

    public final StringUtil getRebuses$e04f0f9() {
        return this.rebuses$6d32e3b8;
    }

    public final void setRebuses$6a41c4d3(StringUtil stringUtil) {
        this.rebuses$6d32e3b8 = stringUtil;
        this.lastSize = null;
        this.repaint();
    }

    public final synchronized void addCharDisplay(String string, HashMap<Integer, Character> hashMap, int n, Color color, Color color2, HashMap<Integer, List<String>> hashMap2) {
        Object object;
        this.toolTipDirty();
        HashMap<Integer, IntSet> hashMap3 = new HashMap<Integer, IntSet>();
        Object object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            object = new IntSet();
            Integer n2 = object2.next();
            Character c = hashMap.get(n2);
            ((IntSet)object).add(c.charValue());
            hashMap3.put(n2, (IntSet)object);
        }
        object2 = new DisplaySet(this, string, hashMap3, n, color, color2, Color.black, hashMap2);
        object = this.displayNames.get(string);
        if (object != null) {
            this.displays.remove(object);
        }
        this.displays.add((DisplaySet)object2);
        this.displayNames.put(string, (DisplaySet)object2);
        this.repaint();
    }

    private void toolTipDirty() {
        this.lastToolTipChar = -1;
        this.updateToolTips();
    }

    public final synchronized void addDisplay(String string, HashMap<Integer, IntSet> object, int n, Color color, Color color2, HashMap<Integer, List<String>> hashMap) {
        this.toolTipDirty();
        object = new DisplaySet(this, string, (HashMap<Integer, IntSet>)object, n, color, color2, Color.black, hashMap);
        DisplaySet displaySet = this.displayNames.get(string);
        if (displaySet != null) {
            this.displays.remove(displaySet);
        }
        this.displays.add((DisplaySet)object);
        this.displayNames.put(string, (DisplaySet)object);
        this.repaint();
    }

    public final synchronized void removeDisplay(String object) {
        this.toolTipDirty();
        object = this.displayNames.remove(object);
        if (object != null) {
            this.displays.remove(object);
        }
        this.repaint();
    }

    public final class AuxGridDisplay
    extends JComponent
    implements Printable {
        private /* synthetic */ GridDisplay this$0;

        public AuxGridDisplay(GridDisplay gridDisplay) {
            this.this$0 = gridDisplay;
        }

        @Override
        public final void paint(Graphics graphics) {
            Dimension dimension = this.this$0.virtualSize != null ? this.this$0.virtualSize : this.getSize();
            graphics = GUIUtil.setHighQualityHints(graphics);
            int n = this.this$0.hScroll.isVisible() ? this.this$0.squareSize * this.this$0.hScroll.getValue() : 0;
            int n2 = this.this$0.vScroll.isVisible() ? this.this$0.squareSize * this.this$0.vScroll.getValue() : 0;
            ((Graphics2D)graphics).translate(-n, -n2);
            this.this$0.paintGrid(graphics, dimension, true, this.this$0.showWordNumbers, true, this.this$0.showThemeLetters);
        }

        @Override
        public final void setBounds(int n, int n2, int n3, int n4) {
            int n5 = n4 / this.this$0.squareSize;
            int n6 = n3 / this.this$0.squareSize;
            int n7 = this.this$0.height;
            int n8 = this.this$0.width;
            int n9 = this.this$0.vScroll.getValue();
            this.this$0.vScroll.setValues(Math.max(Math.min(n9, n7 - n5), 0), n5, 0, n7);
            this.this$0.vScroll.setBlockIncrement(Math.max(1, n5 - 1));
            n5 = this.this$0.hScroll.getValue();
            this.this$0.hScroll.setValues(Math.max(Math.min(n5, n8 - n6), 0), n6, 0, n8);
            this.this$0.hScroll.setBlockIncrement(Math.max(1, n6 - 1));
            this.this$0.virtualSize = new Dimension(Math.max(n8 * this.this$0.minSquareSize, n3), Math.max(n7 * this.this$0.minSquareSize, n4));
            super.setBounds(n, n2, n3, n4);
        }

        @Override
        public final int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            MyLayout myLayout;
            graphics = (Graphics2D)graphics;
            if (n > 0) {
                return 1;
            }
            n = (int)(pageFormat.getWidth() - pageFormat.getImageableWidth());
            n = Math.max(0, 72 - n);
            int n2 = (int)pageFormat.getImageableWidth() - (n << 1);
            int n3 = (int)pageFormat.getImageableHeight() - (n << 1);
            Dimension dimension = new Dimension(n2, n3);
            WeakHashMap<PageFormat, MyLayout> weakHashMap = this.this$0.printMap;
            synchronized (weakHashMap) {
                myLayout = this.this$0.printMap.get(pageFormat);
                if (myLayout == null) {
                    myLayout = this.this$0.computeLayout(graphics, this.this$0.showWordNumbers, dimension, true);
                    this.this$0.printMap.put(pageFormat, myLayout);
                }
            }
            ((Graphics2D)graphics).translate(pageFormat.getImageableX() + (double)n, pageFormat.getImageableY() + (double)n);
            this.this$0.paintGrid(myLayout, graphics, true, this.this$0.showWordNumbers, false, true);
            return 0;
        }
    }

    public static final class MyLayout {
        public int xOffset;
        public int yOffset;
        public int ascent;
        public int fontBase;
        public int cellSize;
        public int numberSize;
        public float numberFontBase;
        public float numberFontLeading;
        public FontMetrics medfm;
        public FontMetrics smfm;
        public Font font;
        public Font numberFont;
        public Font medfont;
        public Font smfont;
        public int letterSize;
        public HashMap<Character, GlyphMetrics> fgm;
        public int smAscent;
        public int medAscent;
        public float lineWidth;
    }

    public final class DisplaySet
    implements Comparable<DisplaySet> {
        private String name;
        HashMap<Integer, IntSet> values;
        private int priority;
        Color foreground;
        Color background;
        public Color smallForeground;
        public HashMap<Integer, List<String>> wordValues;

        public DisplaySet(GridDisplay gridDisplay, String string, HashMap<Integer, IntSet> hashMap, int n, Color color, Color color2, Color color3, HashMap<Integer, List<String>> hashMap2) {
            this.name = string;
            this.values = hashMap;
            this.priority = n;
            this.foreground = color;
            this.background = color2;
            this.smallForeground = color3;
            this.wordValues = hashMap2;
        }
    }
}

