/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.closedhash.IntIntHash;
import com.beekeeper.xwd.CharacterRangeCount;
import com.beekeeper.xwd.CharacterScore;
import com.beekeeper.xwd.GridSearchNode;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.GridStrategies;
import com.beekeeper.xwd.SearchNode;
import com.beekeeper.xwd.SingleCharacterScore;
import com.beekeeper.xwd.WordGrid;
import com.beekeeper.xwd.WordList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;

public class GreedyGridSearchNode
extends GridSearchNode {
    private float varietyFactor = 0.1f;
    private int depthFirstFactor = 65536;
    private float[] charScores;
    private CharacterScore[][] wordScores;
    private int qualityFactor = 10;
    private final Map<WordList.MatchInfo, CharacterScore[]> rangeCache = Collections.synchronizedMap(new WeakHashMap());
    private float[] chooseNextCharScores;
    private float[] chooseNextScores;
    private static boolean useEffectivelyComplete = false;

    public final void setQualityFactor(int n) {
        this.qualityFactor = 25;
    }

    @Override
    public final void setString(int n, String object) {
        WordGrid.Word word;
        super.setString(n, (String)object);
        this.latestWord = n;
        char[] cArray = this.state.getChars();
        WordGrid wordGrid = this.state.getGrid();
        Comparable<WordGrid.Word> comparable = word = wordGrid.getWord(n);
        int n2 = word.letterIndices.length;
        comparable = this;
        long l = ((GreedyGridSearchNode)comparable).depthFirstFactor;
        float f = ((float)l + this.options.wordList.getWordScore((String)object) * (float)this.qualityFactor) * this.varietyMult();
        this.wordScores[n] = new CharacterScore[n2];
        Arrays.setAll(this.wordScores[n], arg_0 -> GreedyGridSearchNode.lambda$setString$0((String)object, f, arg_0));
        float f2 = this.options.minCandidateScore;
        object = new BitSet(cArray.length);
        n2 = 0;
        while (true) {
            comparable = word;
            if (n2 >= comparable.letterIndices.length) break;
            int n3 = n2;
            comparable = word;
            int n4 = comparable.letterIndices[n3];
            ((BitSet)object).set(n4);
            CharacterScore[] characterScoreArray = wordGrid.getWordAt(n4, word.getDirection(), false);
            if (characterScoreArray != null && !this.state.isComplete(n4 = characterScoreArray.getWordIndex())) {
                comparable = characterScoreArray;
                int n5 = characterScoreArray.letterIndices.length;
                int n6 = 0;
                while (n6 < n5) {
                    n3 = n6++;
                    comparable = characterScoreArray;
                    ((BitSet)object).set(characterScoreArray.letterIndices[n3]);
                }
                WordList.MatchInfo matchInfo = this.options.wordList.search(this.state, n4, f2);
                if (matchInfo.getMatchCount() == 0) {
                    this.priority = Float.NEGATIVE_INFINITY;
                    return;
                }
                characterScoreArray = this.rangeCache.get(matchInfo);
                if (characterScoreArray == null) {
                    characterScoreArray = new CharacterScore[n5];
                    for (int i = 0; i < n5; ++i) {
                        CharacterRangeCount characterRangeCount = new CharacterRangeCount(matchInfo, i, this.options.fastCount);
                        characterScoreArray[i] = characterRangeCount;
                        if (characterRangeCount.getMaxScore() != 0.0f) continue;
                        this.priority = Float.NEGATIVE_INFINITY;
                        return;
                    }
                    this.rangeCache.put(matchInfo, characterScoreArray);
                }
                this.wordScores[n4] = characterScoreArray;
            }
            ++n2;
        }
        n2 = 0;
        int n7 = cArray.length;
        for (int i = 0; i < n7; ++i) {
            n2 = Math.max(n2, wordGrid.getCrossWordCount(i));
        }
        CharacterScore[] characterScoreArray = new CharacterScore[n2];
        n7 = ((BitSet)object).nextSetBit(0);
        while (n7 >= 0) {
            this.charScores[n7] = this.computeCharScore(n7, this.wordScores, null, false, characterScoreArray);
            n7 = ((BitSet)object).nextSetBit(n7 + 1);
        }
        this.priority = GreedyGridSearchNode.recomputeScore(this.charScores);
    }

    @Override
    public GridSearchNode.GSNProxy conditionalSuccessor(int n2, String string, float f) {
        float f2;
        int n3;
        int n4;
        int n5;
        char[] cArray = this.state.getChars();
        cArray = (char[])cArray.clone();
        WordGrid.Word word = this.state.getWord(n2);
        for (int i = 0; i < string.length(); ++i) {
            cArray[word.letterIndices[i]] = string.charAt(i);
        }
        WordGrid wordGrid = this.state.getGrid();
        Comparable<WordGrid.Word> comparable = word;
        int n6 = comparable.letterIndices.length;
        comparable = this;
        long l = ((GreedyGridSearchNode)comparable).depthFirstFactor;
        float f3 = ((float)l + this.options.wordList.getWordScore(string) * (float)this.qualityFactor) * this.varietyMult();
        BitSet bitSet = new BitSet(cArray.length);
        CharacterScore[][] characterScoreArray = (CharacterScore[][])this.wordScores.clone();
        CharacterScore[][] characterScoreArray2 = characterScoreArray;
        characterScoreArray[n2] = new CharacterScore[n6];
        Arrays.setAll(characterScoreArray2[n2], n -> new SingleCharacterScore(string.charAt(n), f3));
        f3 = this.options.minCandidateScore;
        for (int i = 0; i < n6; ++i) {
            int n7 = i;
            comparable = word;
            n5 = comparable.letterIndices[n7];
            bitSet.set(n5);
            for (n4 = 0; n4 < wordGrid.getCrossWordCount(n5); ++n4) {
                n3 = wordGrid.getCrossWord(n5, n4);
                if (n3 == n2 || this.state.isComplete(n3)) continue;
                CharacterScore[] characterScoreArray3 = wordGrid.getWord(n3);
                comparable = characterScoreArray3;
                int n8 = characterScoreArray3.letterIndices.length;
                int n9 = 0;
                while (n9 < n8) {
                    n7 = n9++;
                    comparable = characterScoreArray3;
                    bitSet.set(characterScoreArray3.letterIndices[n7]);
                }
                WordList.MatchInfo matchInfo = this.options.wordList.search(cArray, (WordGrid.Word)characterScoreArray3, f3);
                int n10 = matchInfo.getMatchCount();
                if (n10 == 0) {
                    return null;
                }
                characterScoreArray3 = this.rangeCache.get(matchInfo);
                if (characterScoreArray3 == null) {
                    characterScoreArray3 = new CharacterScore[n8];
                    for (int j = 0; j < n8; ++j) {
                        CharacterRangeCount characterRangeCount = new CharacterRangeCount(matchInfo, j, this.options.fastCount);
                        characterScoreArray3[j] = characterRangeCount;
                        if (characterRangeCount.getMaxScore() != 0.0f) continue;
                        return null;
                    }
                    this.rangeCache.put(matchInfo, characterScoreArray3);
                }
                characterScoreArray2[n3] = characterScoreArray3;
            }
        }
        float[] fArray = (float[])this.charScores.clone();
        n5 = 0;
        n3 = cArray.length;
        for (n4 = 0; n4 < n3; ++n4) {
            n5 = Math.max(n5, wordGrid.getCrossWordCount(n4));
        }
        CharacterScore[] characterScoreArray4 = new CharacterScore[n5];
        n3 = bitSet.nextSetBit(0);
        while (n3 >= 0) {
            float f4;
            fArray[n3] = f4 = this.computeCharScore(n3, characterScoreArray2, null, false, characterScoreArray4);
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        float f5 = GreedyGridSearchNode.recomputeScore(fArray);
        if (f2 > f) {
            return new GridSearchNode.GSNProxy(f5, this, n2, string);
        }
        return null;
    }

    @Override
    public final int chooseWordToFillQuality() {
        return this.chooseWordToFillGreedy();
    }

    @Override
    public final int chooseWordToFillStd() {
        return this.chooseWordToFillGreedy();
    }

    @Override
    protected final int chooseWordToFillFrontier() {
        int n;
        int n2;
        int n3;
        if (this.latestWord == -1) {
            return this.chooseWordToFillGreedy();
        }
        WordGrid wordGrid = this.state.getGrid();
        char[] cArray = this.state.getChars();
        WordGrid.Word word = this.state.getWord(this.latestWord);
        int n4 = wordGrid.getWidth();
        int n5 = wordGrid.getHeight();
        BitSet bitSet = this.options.neighborhood;
        int[] nArray = new int[wordGrid.getWordCount()];
        int n6 = wordGrid.getWordCount();
        for (int i = 0; i < n6; ++i) {
            WordGrid.Word word2;
            if (this.state.isComplete(i) || bitSet != null && !bitSet.get(i)) {
                nArray[i] = Integer.MAX_VALUE;
                continue;
            }
            WordGrid.Word word3 = word2 = wordGrid.getWord(i);
            n3 = word2.letterIndices.length;
            n2 = 0;
            int n7 = word2.getDirection();
            n = 0;
            word3 = word2;
            int n8 = word3.letterIndices[n];
            int n9 = n8 % n4;
            n = n8 / n4;
            boolean bl = false;
            int n10 = 0;
            for (int j = 0; j < n3; ++j) {
                boolean bl2 = cArray[n8] == '\u0000';
                if (bl2) {
                    if (!bl) {
                        n2 -= 2;
                    }
                    ++n10;
                    switch (n7) {
                        case 0: {
                            n2 = n == 0 || cArray[n8 - n4] != '\u0000' ? --n2 : ++n2;
                            if (n == n5 - 1 || cArray[n8 + n4] != '\u0000') {
                                --n2;
                                break;
                            }
                            ++n2;
                            break;
                        }
                        case 1: {
                            n2 = n9 == 0 || cArray[n8 - 1] != '\u0000' ? --n2 : ++n2;
                            if (n9 == n4 - 1 || cArray[n8 + 1] != '\u0000') {
                                --n2;
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                switch (n7) {
                    case 0: {
                        n2 = n == 0 || cArray[n8 - n4] != '\u0000' ? --n2 : ++n2;
                        n2 = n == n5 - 1 || cArray[n8 + n4] != '\u0000' ? --n2 : ++n2;
                        ++n8;
                        ++n9;
                        break;
                    }
                    case 1: {
                        n2 = n9 == 0 || cArray[n8 - 1] != '\u0000' ? --n2 : ++n2;
                        n2 = n9 == n4 - 1 || cArray[n8 + 1] != '\u0000' ? --n2 : ++n2;
                        n8 += n4;
                        ++n;
                    }
                }
                bl = bl2;
            }
            nArray[i] = n2;
            if (n10 != 0) continue;
            nArray[i] = Integer.MIN_VALUE;
        }
        BitSet bitSet2 = this.state.allCrosses(this.latestWord);
        n6 = this.options.forcedNext;
        if (n6 != -1 && !this.state.isComplete(n6)) {
            BitSet bitSet3 = this.state.allCrosses(n6);
            n3 = bitSet3.nextSetBit(0);
            while (n3 != -1) {
                if (!this.state.isComplete(n3)) {
                    bitSet2.set(n3);
                }
                n3 = bitSet3.nextSetBit(n3 + 1);
            }
        }
        int[] nArray2 = this.cwFindAdjacentParallels(wordGrid, cArray, word, n4, n5);
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            if (nArray2[n3] <= 1) continue;
            bitSet2.set(n3);
        }
        n3 = -1;
        n2 = this.cwCountCrossesOrEquivalent(bitSet2);
        if (n2 > 0) {
            WordGrid.Word[] wordArray = new WordGrid.Word[n2];
            n2 = 0;
            int n11 = bitSet2.nextSetBit(0);
            while (n11 != -1) {
                if (!this.state.isComplete(n11)) {
                    n = n11;
                    GreedyGridSearchNode greedyGridSearchNode = this;
                    wordArray[n2++] = wordGrid.getWord(n11);
                }
                n11 = bitSet2.nextSetBit(n11 + 1);
            }
            Arrays.sort(wordArray, new Comparator<WordGrid.Word>(){
                private /* synthetic */ int[] val$frontierDiffs;
                {
                    this.val$frontierDiffs = nArray;
                }
            });
            this.cwSetNextWords(n2, wordArray);
            for (n11 = 0; n11 < this.nextWords.length; ++n11) {
                if (nArray[this.nextWords[n11]] == Integer.MAX_VALUE) continue;
                n3 = this.nextWords[n11];
                break;
            }
        }
        if (n3 == -1) {
            return this.chooseWordToFillGreedy();
        }
        return n3;
    }

    private int chooseWordToFillGreedy() {
        int n = -1;
        WordGrid.Word[] wordArray = this.state.getGrid();
        Object[] objectArray = this.state.getChars();
        float[] fArray = this.chooseNextCharScores;
        synchronized (this.chooseNextCharScores) {
            int n2;
            Object object;
            int n3;
            Object object2 = objectArray;
            WordGrid.Word[] wordArray2 = wordArray;
            Comparable<SearchNode> comparable = this;
            int n4 = 0;
            int n5 = ((char[])object2).length;
            for (int i = 0; i < n5; ++i) {
                n4 = Math.max(n4, wordArray2.getCrossWordCount(i));
            }
            CharacterScore[] characterScoreArray = new CharacterScore[n4];
            for (n5 = 0; n5 < ((char[])object2).length; ++n5) {
                comparable.chooseNextCharScores[n5] = comparable.computeCharScore(n5, comparable.wordScores, null, true, characterScoreArray);
            }
            comparable = this;
            for (n3 = 0; n3 < comparable.chooseNextScores.length; ++n3) {
                if (comparable.state.isComplete(n3)) {
                    comparable.chooseNextScores[n3] = Float.NEGATIVE_INFINITY;
                    continue;
                }
                object2 = comparable.state.getWord(n3);
                n4 = ((WordGrid.Word)object).letterIndices.length;
                float f = 0.0f;
                n5 = 0;
                while (n5 < n4) {
                    int n6 = n5++;
                    object = object2;
                    float f2 = comparable.chooseNextCharScores[object2.letterIndices[n6]];
                    f += f2;
                }
                if (f < 0.0f) {
                    f = 0.0f;
                }
                comparable.chooseNextScores[n3] = f;
            }
            comparable = this;
            for (n3 = 0; n3 < comparable.chooseNextScores.length; ++n3) {
                float f;
                float f3 = comparable.chooseNextScores[n3];
                if (f3 < 0.0f) continue;
                WordGrid.Word word2 = comparable.state.getWord(n3);
                object = word2;
                int n7 = word2.letterIndices.length;
                double d = GridStrategies.USE_1_1_STRATEGIES ? Math.pow(n7, -1.8) : Math.pow(n7, -2.8);
                comparable.chooseNextScores[n3] = f = (float)(-Math.sqrt((double)f3 * d));
            }
            Object object3 = wordArray;
            comparable = this;
            for (n2 = 0; n2 < comparable.chooseNextScores.length; ++n2) {
                if (Float.isInfinite(comparable.chooseNextScores[n2])) continue;
                float f = 1.0f;
                int n8 = 1;
                SearchNode searchNode = comparable.parent;
                while (searchNode != null) {
                    GridSearchNode gridSearchNode = (GridSearchNode)searchNode;
                    int[] nArray = gridSearchNode.nextWords;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] != n2) continue;
                        if (comparable.options.crossOlderWords) {
                            f += n8 >= DEPTH_DIVISORS.length ? 5.0f : (float)DEPTH_DIVISORS[n8];
                            break;
                        }
                        f += 1.0f;
                        break;
                    }
                    searchNode = searchNode.parent;
                    ++n8;
                }
                if (comparable.options.fillEdgesFirst) {
                    f += (float)((WordGrid)object3).edgeCount(n2);
                }
                int n9 = n2;
                comparable.chooseNextScores[n9] = comparable.chooseNextScores[n9] / f;
            }
            BitSet bitSet = this.options.neighborhood;
            object3 = bitSet;
            comparable = this;
            if (object3 != null) {
                n2 = ((BitSet)object3).nextSetBit(0);
                while (n2 != -1) {
                    int n10 = n2;
                    comparable.chooseNextScores[n10] = comparable.chooseNextScores[n10] / 1000000.0f;
                    n2 = ((BitSet)object3).nextSetBit(n2 + 1);
                }
            }
            if (this.latestWord != -1) {
                bitSet = this.state.allCrosses(this.latestWord);
                object3 = bitSet;
                comparable = this;
                n2 = comparable.options.forcedNext;
                if (n2 != -1 && !comparable.state.isComplete(n2)) {
                    BitSet bitSet2 = comparable.state.allCrosses(n2);
                    int n11 = bitSet2.nextSetBit(0);
                    while (n11 != -1) {
                        if (!comparable.state.isComplete(n11)) {
                            int n12 = n11;
                            comparable.chooseNextScores[n12] = comparable.chooseNextScores[n12] / 16.0f;
                            ((BitSet)object3).set(n11);
                        }
                        n11 = bitSet2.nextSetBit(n11 + 1);
                    }
                }
                comparable = this.state.getWord(this.latestWord);
                int n13 = wordArray.getWidth();
                n2 = wordArray.getHeight();
                objectArray = this.cwFindAdjacentParallels((WordGrid)wordArray, (char[])objectArray, (WordGrid.Word)comparable, n13, n2);
                Comparable<SearchNode> comparable2 = comparable;
                n4 = ((WordGrid.Word)comparable2).letterIndices.length >= 7 ? 1 : 0;
                Object object4 = objectArray;
                Object object5 = bitSet;
                comparable = this;
                for (int i = 0; i < ((char[])object4).length; ++i) {
                    if (object4[i] <= '\u0001') continue;
                    ((BitSet)object5).set(i);
                    if (n4 == 0 || !comparable.options.preferParallels) continue;
                    comparable2 = comparable.state.getGrid().getWord(i);
                    if (((WordGrid.Word)comparable2).letterIndices.length <= 6) continue;
                    int n14 = i;
                    comparable.chooseNextScores[n14] = comparable.chooseNextScores[n14] / 5.0f;
                }
                int n15 = this.cwCountCrossesOrEquivalent(bitSet);
                if (n15 > 0) {
                    n4 = n15;
                    object4 = bitSet;
                    object5 = wordArray;
                    comparable = this;
                    WordGrid.Word[] wordArray3 = new WordGrid.Word[n4];
                    n5 = 0;
                    int n16 = ((BitSet)object4).nextSetBit(0);
                    while (n16 != -1) {
                        if (!comparable.state.isComplete(n16)) {
                            int n17 = n16;
                            comparable2 = comparable;
                            wordArray3[n5++] = ((WordGrid)object5).getWord(n16);
                            if (comparable.depth > comparable.options.softAdjacencyDepth) {
                                int n18 = n16;
                                comparable.chooseNextScores[n18] = comparable.chooseNextScores[n18] / 8.0f;
                            }
                        }
                        n16 = ((BitSet)object4).nextSetBit(n16 + 1);
                    }
                    wordArray = wordArray3;
                    Arrays.sort(wordArray3, Comparator.comparingDouble(word -> this.chooseNextScores[word.getWordIndex()]).reversed());
                    this.cwSetNextWords(n15, wordArray);
                    if (this.depth <= this.options.softAdjacencyDepth) {
                        int n19 = -1;
                        comparable = this;
                        for (int i = 0; i < comparable.nextWords.length; ++i) {
                            if (comparable.chooseNextScores[comparable.nextWords[i]] == Float.NEGATIVE_INFINITY) continue;
                            n19 = comparable.nextWords[i];
                            break;
                        }
                        n = n19;
                    }
                }
            }
            if (n == -1) {
                int n20;
                comparable = this;
                int n21 = -1;
                float f = Float.NEGATIVE_INFINITY;
                for (int i = 0; i < comparable.chooseNextScores.length; ++i) {
                    if (!(comparable.chooseNextScores[i] > f)) continue;
                    f = comparable.chooseNextScores[i];
                    n21 = i;
                }
                n = n20 = n21;
            }
            // ** MonitorExit[var4_6] (shouldn't be in output)
            return n;
        }
    }

    private void cwSetNextWords(int n2, WordGrid.Word[] wordArray) {
        this.nextWords = new int[n2];
        Arrays.setAll(this.nextWords, n -> wordArray[n].getWordIndex());
    }

    private int cwCountCrossesOrEquivalent(BitSet bitSet) {
        int n = 0;
        int n2 = bitSet.nextSetBit(0);
        while (n2 != -1) {
            if (!this.state.isComplete(n2)) {
                int n3 = n2;
                GreedyGridSearchNode greedyGridSearchNode = this;
                ++n;
            }
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return n;
    }

    private int[] cwFindAdjacentParallels(WordGrid wordGrid, char[] cArray, WordGrid.Word word, int n, int n2) {
        int[] nArray = new int[wordGrid.getWordCount()];
        int n3 = word.getDirection();
        WordGrid.Word word2 = word;
        int n4 = word2.letterIndices.length;
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            int n7;
            int n8 = i;
            word2 = word;
            int n9 = word2.letterIndices[n8];
            n8 = n9 % n;
            n9 /= n;
            if (n3 == 0) {
                n7 = 1;
                n6 = n2;
                if (n9 + 2 < n2) {
                    n6 = n9 + 2;
                }
                for (n5 = n9 + 1; n5 < n6; ++n5) {
                    if (cArray[n8 + n5 * n] == '\u007f') {
                        n7 = -1000;
                        continue;
                    }
                    GreedyGridSearchNode.incrAdj(wordGrid, nArray, n8, n5, n3, cArray, true, n7);
                }
                n7 = 1;
                n5 = 0;
                if (n9 - 1 > 0) {
                    n5 = n9 - 1;
                }
                for (n6 = n9 - 1; n6 >= n5; --n6) {
                    if (cArray[n8 + n6 * n] == '\u007f') {
                        n7 = -1000;
                        continue;
                    }
                    GreedyGridSearchNode.incrAdj(wordGrid, nArray, n8, n6, n3, cArray, true, n7);
                }
                continue;
            }
            n7 = 1;
            n6 = n;
            if (n8 + 2 < n) {
                n6 = n8 + 2;
            }
            for (n5 = n8 + 1; n5 < n6; ++n5) {
                if (cArray[n5 + n9 * n] == '\u007f') {
                    n7 = -1000;
                    continue;
                }
                GreedyGridSearchNode.incrAdj(wordGrid, nArray, n5, n9, n3, cArray, true, n7);
            }
            n7 = 1;
            n5 = 0;
            if (n8 - 1 > 0) {
                n5 = n8 - 1;
            }
            for (n6 = n8 - 1; n6 >= n5; --n6) {
                if (cArray[n6 + n9 * n] == '\u007f') {
                    n7 = -1000;
                    continue;
                }
                GreedyGridSearchNode.incrAdj(wordGrid, nArray, n6, n9, n3, cArray, true, n7);
            }
        }
        return nArray;
    }

    public final void setVarietyFactor(float f) {
        this.varietyFactor = f;
    }

    private float varietyMult() {
        float f;
        float f2 = 1.0f;
        for (f = this.varietyFactor; f > 1.0f; f -= 1.0f) {
            f2 *= rand.nextFloat();
        }
        float f3 = 1.0f;
        if (this.varietyFactor != 0.0f) {
            f3 = 1.0f - f * rand.nextFloat();
        }
        return f3 * f2;
    }

    @Override
    protected final GridSearchNode makeSuccessor(GridState object) {
        object = (GreedyGridSearchNode)super.makeSuccessor((GridState)object);
        v0.charScores = (float[])this.charScores.clone();
        ((GreedyGridSearchNode)object).wordScores = (CharacterScore[][])this.wordScores.clone();
        return object;
    }

    private static float recomputeScore(float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
        }
        return f;
    }

    private void initWordScores() {
        int n2;
        char[] cArray = this.state.getChars();
        CharacterScore[] characterScoreArray = this;
        long l = characterScoreArray.depthFirstFactor;
        WordGrid wordGrid = this.state.getGrid();
        this.wordScores = new CharacterScore[wordGrid.getWordCount()][];
        this.charScores = new float[cArray.length];
        this.chooseNextCharScores = new float[cArray.length];
        this.chooseNextScores = new float[this.state.getWordCount()];
        float f = this.options.minCandidateScore;
        for (n2 = 0; n2 < wordGrid.getWordCount(); ++n2) {
            WordGrid.Word word = wordGrid.getWord(n2);
            characterScoreArray = word;
            int n3 = word.letterIndices.length;
            this.wordScores[n2] = new CharacterScore[n3];
            characterScoreArray = this.wordScores[n2];
            if (this.state.isComplete(n2)) {
                float f2 = this.options.wordList.getWordScore(word.getString(cArray));
                f2 = ((float)l + f2 * (float)this.qualityFactor) * this.varietyMult();
                Arrays.setAll(characterScoreArray, n -> new SingleCharacterScore(word.getLetter(n, cArray), f2));
                continue;
            }
            WordList.MatchInfo matchInfo = this.options.wordList.search(this.state, n2, f);
            Arrays.setAll(this.wordScores[n2], n -> new CharacterRangeCount(matchInfo, n, Integer.MAX_VALUE, 0));
        }
        n2 = 0;
        int n4 = cArray.length;
        for (int i = 0; i < n4; ++i) {
            n2 = Math.max(n2, wordGrid.getCrossWordCount(i));
        }
        CharacterScore[] characterScoreArray2 = new CharacterScore[n2];
        for (n4 = 0; n4 < cArray.length; ++n4) {
            this.charScores[n4] = this.computeCharScore(n4, this.wordScores, null, false, characterScoreArray2);
        }
        this.priority = GreedyGridSearchNode.recomputeScore(this.charScores);
    }

    private float computeCharScore(int n, CharacterScore[][] characterScoreArray, IntIntHash intIntHash, boolean bl, CharacterScore[] characterScoreArray2) {
        char c;
        char c2;
        int n2;
        WordGrid wordGrid = this.state.getGrid();
        int n3 = wordGrid.getCrossWordCount(n);
        if (n3 == 0) {
            return 0.0f;
        }
        int c22 = 0;
        int c3 = 65535;
        int n4 = 0;
        int n5 = 1;
        block0: for (int i = 0; i < n3; ++i) {
            WordGrid.Word word;
            int c4 = wordGrid.getCrossWord(n, i);
            WordGrid.Word word2 = word = wordGrid.getWord(c4);
            n5 *= word2.letterIndices.length;
            n2 = 0;
            word2 = word;
            int n6 = word2.letterIndices.length;
            while (n2 < n6) {
                int n7 = n2++;
                word2 = word;
                if (word2.letterIndices[n7] != n) continue;
                CharacterScore characterScore = characterScoreArray[c4][n2];
                characterScoreArray2[n4++] = characterScore;
                c22 = (char)Math.max(c22, characterScore.rangeStart());
                c3 = (char)Math.min(c3, characterScore.rangeEnd());
                continue block0;
            }
        }
        float f = 0.0f;
        int n8 = c22;
        while (c2 < c3) {
            float f2 = 1.0f;
            if (bl) {
                for (n2 = 0; n2 < n4; ++n2) {
                    f2 *= characterScoreArray2[n2].getChooseNextScore(c2);
                }
            } else {
                for (n2 = 0; n2 < n4; ++n2) {
                    f2 *= characterScoreArray2[n2].getScore(c2);
                }
            }
            f += f2;
            c2 = (char)(c2 + true);
        }
        if (f == 0.0f) {
            return Float.NEGATIVE_INFINITY;
        }
        if (c3 == c22 + 1 && intIntHash != null && (c = this.state.getChars()[n]) == '\u0000') {
            intIntHash.put(n, c22);
        }
        if (GridStrategies.USE_1_1_STRATEGIES) {
            return f / (float)n5;
        }
        return f;
    }

    public GreedyGridSearchNode(GridSearchNode gridSearchNode, GridState gridState, GridSearchNode.SharedOptions sharedOptions, int n, float f) {
        super(gridSearchNode, gridState, sharedOptions);
        this.depthFirstFactor = n;
        this.varietyFactor = f;
        this.initWordScores();
    }

    @Override
    public String toString() {
        return String.format("%4.2f:%s", Float.valueOf(this.getPriority()), this.dumpSequence());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (GreedyGridSearchNode)object;
        return this.latestWord == ((GreedyGridSearchNode)object).latestWord && this.priority == ((GreedyGridSearchNode)object).priority && this.chooseWordToFill() == ((GridSearchNode)object).chooseWordToFill() && Arrays.equals(this.state.getChars(), ((GreedyGridSearchNode)object).state.getChars());
    }

    public int hashCode() {
        return Objects.hash(this.latestWord, Float.valueOf(this.priority), this.chooseWordToFill()) & Arrays.hashCode(this.state.getChars());
    }

    private String dumpSequence() {
        if (this.parent == null) {
            return "<ROOT>";
        }
        return ((GreedyGridSearchNode)this.parent).dumpSequence() + ":" + (this.latestWord == -1 ? "???" : this.state.getGrid().getWord(this.latestWord).getDebugString(this.state.getChars()));
    }
}

