/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.closedhash.IntIntHash;
import com.beekeeper.xwd.GridSearchNode;
import com.beekeeper.xwd.GridState;
import com.beekeeper.xwd.SearchNode;
import com.beekeeper.xwd.WordGrid;
import java.util.Arrays;
import java.util.BitSet;

public final class FrontierPrint
extends SearchNode.Fingerprint {
    private final char[] chars;

    public FrontierPrint(GridState gridState, BitSet bitSet) {
        this(FrontierPrint.getStateChars(gridState, bitSet));
    }

    private static char[] getStateChars(GridState gridState, BitSet bitSet) {
        int n;
        char[] cArray = gridState.getChars();
        IntIntHash intIntHash = new IntIntHash(cArray.length, 0.7);
        int n2 = gridState.getWordCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            WordGrid.Word word;
            if (bitSet != null && !bitSet.get(i)) continue;
            WordGrid.Word word2 = word = gridState.getWord(i);
            n = word.letterIndices.length;
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (!FrontierPrint.isFrontierSquare(cArray, word, n3)) continue;
                ++n4;
            }
            if (n4 == 0 || gridState.isComplete(i)) continue;
            for (n3 = 0; n3 < n; ++n3) {
                if (!FrontierPrint.isFrontierSquare(cArray, word, n3)) continue;
                int n5 = n3;
                WordGrid.Word word3 = word;
                intIntHash.put(word3.letterIndices[n5], word.getLetter(n3, cArray));
            }
        }
        char[] cArray2 = new char[intIntHash.size() << 1];
        n2 = 0;
        for (int n6 = 0; n6 < cArray.length; n6 = (int)((char)(n6 + 1))) {
            n = intIntHash.get(n6, -1);
            if (n == -1) continue;
            cArray2[n2++] = n6;
            cArray2[n2++] = (char)n;
        }
        if (n2 != cArray2.length) {
            throw new IllegalStateException();
        }
        return cArray2;
    }

    private static boolean isFrontierSquare(char[] cArray, WordGrid.Word word, int n) {
        return word.getLetter(n, cArray) != '\u0000';
    }

    private FrontierPrint(char[] cArray) {
        this.chars = cArray;
    }

    public final int hashCode() {
        int n = 31 + Arrays.hashCode(this.chars);
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (FrontierPrint)object;
        return Arrays.equals(this.chars, ((FrontierPrint)object).chars);
    }

    @Override
    public final boolean matches(SearchNode object) {
        object = ((GridSearchNode)object).state.getChars();
        for (int i = 0; i < this.chars.length; i += 2) {
            if (object[this.chars[i]] == this.chars[i + 1]) continue;
            return false;
        }
        return true;
    }
}

