/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.GUIUtil;
import com.beekeeper.util.GridHelper;
import com.beekeeper.util.NumberVerifier;
import com.beekeeper.xwd.BuffWordList;
import com.beekeeper.xwd.CCDictionaries;
import com.beekeeper.xwd.ClueData;
import com.beekeeper.xwd.WordList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class EditWordsDialog
extends JDialog {
    final Preferences prefsNode = Preferences.userRoot().node("/beekeeper labs/crossfire");
    private int currentIndex;
    private final BuffWordList list;
    private final String[] compWords;
    private JTextField scoreField;
    private JTextField wordField;
    private final String[] words;
    private boolean changeMade = false;
    private JButton nextButton;
    private JLabel letterLabel;
    private JLabel clueLabel;
    private final ClueData clueData;
    private final CCDictionaries.CCWordList baseList;
    private JButton advancedButton;
    private Component stretchBox;
    private JComponent dictBox;
    private int primaryIndex;
    private int dictHeight;
    private ArrayList<JCheckBox> dictChecks;
    private ArrayList<JCheckBox> dictDelChecks;
    private final boolean isAddDialog;
    protected boolean isChanged;
    private boolean ignoreFieldChanges;

    public final boolean wasChangeMade() {
        return this.changeMade;
    }

    public EditWordsDialog(Component component, String[] object, BuffWordList object2, ClueData object3, boolean bl) {
        super(JOptionPane.getFrameForComponent(component), bl ? "Add words" : "Edit words", true);
        this.words = object;
        this.currentIndex = 0;
        this.list = object2;
        this.baseList = object2 instanceof CCDictionaries.CCWordList ? (CCDictionaries.CCWordList)object2 : (CCDictionaries.CCWordList)((BuffWordList)object2).getSource();
        this.clueData = object3;
        this.isAddDialog = bl;
        if (!bl) {
            this.compWords = new String[((String[])object).length];
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.compWords[i] = ((BuffWordList)object2).getLetters(object[i]);
            }
        } else {
            this.compWords = null;
        }
        AbstractAction abstractAction = new AbstractAction(this, "Exit"){
            private /* synthetic */ EditWordsDialog this$0;
            {
                this.this$0 = editWordsDialog;
                super(string);
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.dispose();
            }
        };
        object = new JPanel();
        Serializable serializable = abstractAction;
        object3 = object;
        object2 = this;
        object3 = new GridHelper((Container)object3);
        Object object4 = new GUIUtil.SelectAllFocusAdapter();
        ((EditWordsDialog)object2).letterLabel = new JLabel("");
        ((EditWordsDialog)object2).clueLabel = new JLabel("");
        ((EditWordsDialog)object2).scoreField = new JTextField(6);
        ((EditWordsDialog)object2).scoreField.setInputVerifier(new NumberVerifier("word score", true, false));
        ((EditWordsDialog)object2).scoreField.addFocusListener((FocusListener)object4);
        ((EditWordsDialog)object2).wordField = new JTextField(35);
        ((EditWordsDialog)object2).wordField.addFocusListener((FocusListener)object4);
        Object object5 = object2;
        object4 = new AbstractAction((EditWordsDialog)object5, "Next"){
            private /* synthetic */ EditWordsDialog this$0;
            {
                this.this$0 = editWordsDialog;
                super(string);
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n;
                    int n2;
                    String string;
                    String string2;
                    Object object;
                    if (!this.this$0.scoreField.getInputVerifier().shouldYieldFocus(this.this$0.scoreField)) {
                        return;
                    }
                    float f = Float.parseFloat(this.this$0.scoreField.getText());
                    String string3 = this.this$0.wordField.getText();
                    Object object2 = this.this$0.list.getLetters(string3);
                    if (this.this$0.isAddDialog) {
                        object = string3;
                        string2 = object2;
                        if (string3.trim().length() == 0) {
                            this.this$0.dispose();
                            return;
                        }
                    } else {
                        string2 = this.this$0.compWords[this.this$0.currentIndex];
                        object = this.this$0.words[this.this$0.currentIndex];
                    }
                    String string4 = string = this.this$0.list != this.this$0.baseList ? this.this$0.baseList.getLetters(string3) : object2;
                    if (!((String)object2).equals(string2)) {
                        JOptionPane.showMessageDialog(this.this$0, "Misspelled word: " + string3 + " vs. " + (String)object);
                        return;
                    }
                    object2 = this.this$0.list.getWordDictionaries(string2);
                    object = new BitSet(this.this$0.dictChecks.size());
                    BitSet bitSet = new BitSet(this.this$0.dictChecks.size());
                    int n3 = 0;
                    int n4 = this.this$0.dictChecks.size();
                    for (n2 = 0; n2 < n4; ++n2) {
                        if (this.this$0.dictChecks.get(n2).isSelected()) {
                            ((BitSet)object).set(n2);
                        }
                        if (!this.this$0.dictDelChecks.get(n2).isSelected()) continue;
                        bitSet.set(n2);
                    }
                    n4 = this.this$0.dictChecks.size();
                    for (n2 = 0; n2 < n4; ++n2) {
                        if (((BitSet)object).get(n2)) {
                            n3 = 1;
                            break;
                        }
                        if (!((BitSet)object2).get(n2)) continue;
                        if (bitSet.get(n2)) {
                            n3 = 2;
                            continue;
                        }
                        if (n3 == 2) {
                            n3 = -1 - n2;
                            break;
                        }
                        n3 = 0;
                        break;
                    }
                    float f2 = f;
                    String string5 = string3;
                    boolean bl = false;
                    if (n3 == 2) {
                        f2 = -1.0f;
                    } else if (n3 < 0) {
                        try {
                            int n5 = -1 - n3;
                            WordList.WordInfo wordInfo = this.this$0.baseList.findWordInfo(n5, string);
                            f2 = wordInfo.score;
                            string5 = wordInfo.orig;
                        }
                        catch (IOException iOException) {}
                    }
                    if (n3 != 0) {
                        if (!this.this$0.list.hasWord(string2)) {
                            if (f2 != 0.0f || !string3.equals(string2)) {
                                this.this$0.list.addWord(string3, f2);
                                if (this.this$0.baseList != this.this$0.list) {
                                    this.this$0.baseList.addWord(string5, f2);
                                }
                                bl = true;
                            }
                        } else {
                            if (!string5.equals(this.this$0.list.getOrigWord(string2))) {
                                this.this$0.list.setOrigWord(string2, string5);
                                if (this.this$0.baseList != this.this$0.list) {
                                    this.this$0.baseList.setOrigWord(string, string5);
                                }
                                bl = true;
                            }
                            if (f2 != this.this$0.list.getWordScore(string2)) {
                                this.this$0.list.setWordScore(string2, f2);
                                if (this.this$0.baseList != this.this$0.list) {
                                    this.this$0.baseList.setWordScore(string, f2);
                                }
                                bl = true;
                            }
                        }
                    }
                    if (!(((BitSet)object).isEmpty() || (n = ((BitSet)object2).nextSetBit(0)) != -1 && ((BitSet)object).cardinality() == 1 && ((BitSet)object).get(n) && !bl)) {
                        this.this$0.baseList.change(string, string3, f, (BitSet)object);
                        this.this$0.changeMade = true;
                    }
                    if (!bitSet.isEmpty()) {
                        this.this$0.baseList.change(string, string3, -1.0f, bitSet);
                        this.this$0.changeMade = true;
                    }
                }
                catch (Exception exception) {
                    GUIUtil.showStackTraceDialog(this.this$0, exception);
                }
                if (!this.this$0.isAddDialog) {
                    ++this.this$0.currentIndex;
                    if (this.this$0.currentIndex >= this.this$0.words.length) {
                        this.this$0.dispose();
                        return;
                    }
                    this.this$0.isChanged = false;
                } else {
                    this.this$0.ignoreFieldChanges = true;
                    this.this$0.wordField.setText("");
                    this.this$0.ignoreFieldChanges = false;
                    this.this$0.isChanged = true;
                }
                this.this$0.showCurrentWord(true);
            }
        };
        ((EditWordsDialog)object2).nextButton = new JButton((Action)object4);
        serializable = new JButton((Action)((Object)serializable));
        object5 = object2;
        ((EditWordsDialog)object2).advancedButton = new JButton(new AbstractAction((EditWordsDialog)object5, ">> Advanced"){
            private boolean isAdvancedShowing;
            private /* synthetic */ EditWordsDialog this$0;
            {
                this.this$0 = editWordsDialog;
                super(string);
            }

            @Override
            public final void actionPerformed(ActionEvent serializable) {
                serializable = this.this$0.getSize();
                if (this.isAdvancedShowing) {
                    this.isAdvancedShowing = false;
                    this.this$0.advancedButton.setText(">> Advanced");
                    this.this$0.dictBox.setVisible(false);
                    this.this$0.stretchBox.setVisible(true);
                    this.this$0.setSize(new Dimension(((Dimension)serializable).width, ((Dimension)serializable).height - this.this$0.getDictHeight()));
                    this.this$0.prefsNode.putBoolean("advanced edit", false);
                    return;
                }
                this.isAdvancedShowing = true;
                this.this$0.advancedButton.setText("<< Advanced");
                this.this$0.dictBox.setVisible(true);
                this.this$0.stretchBox.setVisible(false);
                this.this$0.setSize(new Dimension(((Dimension)serializable).width, ((Dimension)serializable).height + this.this$0.getDictHeight()));
                this.this$0.prefsNode.putBoolean("advanced edit", true);
            }
        });
        ((EditWordsDialog)object2).advancedButton.setFocusable(false);
        ((EditWordsDialog)object2).wordField.addActionListener((ActionListener)object4);
        ((EditWordsDialog)object2).scoreField.addActionListener((ActionListener)object4);
        if (((EditWordsDialog)object2).isAddDialog) {
            object5 = object2;
            ((EditWordsDialog)object2).wordField.addKeyListener(new KeyAdapter(){

                @Override
                public final void keyTyped(KeyEvent keyEvent) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        @Override
                        public final void run() {
                            this.this$1.EditWordsDialog.this.showCurrentWord(false);
                        }
                    });
                    super.keyTyped(keyEvent);
                }
            });
            ((EditWordsDialog)object2).isChanged = true;
        } else {
            object5 = object2;
            object4 = new KeyAdapter(){

                @Override
                public final void keyTyped(KeyEvent keyEvent) {
                    super.keyTyped(keyEvent);
                    if (!EditWordsDialog.this.ignoreFieldChanges && !EditWordsDialog.this.isChanged && keyEvent.getKeyChar() != '\n') {
                        EditWordsDialog.this.isChanged = true;
                        SwingUtilities.invokeLater(new Runnable(this){
                            private /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            @Override
                            public final void run() {
                                this.this$1.EditWordsDialog.this.updateFieldSelections(this.this$1.EditWordsDialog.this.compWords[this.this$1.EditWordsDialog.this.currentIndex]);
                            }
                        });
                    }
                }
            };
            ((EditWordsDialog)object2).wordField.addKeyListener((KeyListener)object4);
            ((EditWordsDialog)object2).scoreField.addKeyListener((KeyListener)object4);
        }
        ((GridHelper)object3).space().stretch().space().advance();
        ((GridHelper)object3).add(new GUIUtil.RightLabel("Letters: ")).add(((EditWordsDialog)object2).letterLabel).advance();
        if (((EditWordsDialog)object2).clueData != null) {
            ((GridHelper)object3).add(new GUIUtil.RightLabel("Clue: ")).add(((EditWordsDialog)object2).clueLabel).advance();
        }
        ((GridHelper)object3).advance(10);
        if (!((EditWordsDialog)object2).isAddDialog) {
            ((GridHelper)object3).add(new GUIUtil.RightLabel("Score: ")).add(((EditWordsDialog)object2).scoreField).advance();
        }
        ((GridHelper)object3).add(new GUIUtil.RightLabel("Spelling: ")).add(((EditWordsDialog)object2).wordField).advance();
        if (((EditWordsDialog)object2).isAddDialog) {
            ((GridHelper)object3).add(new GUIUtil.RightLabel("Score: ")).add(((EditWordsDialog)object2).scoreField).advance();
        }
        ((EditWordsDialog)object2).stretchBox = Box.createVerticalStrut(20);
        ((GridHelper)object3).weight(0.0, 1.0).add(((EditWordsDialog)object2).stretchBox).advance();
        ((EditWordsDialog)object2).dictBox = ((EditWordsDialog)object2).buildBoxPanel();
        ((GridHelper)object3).size(3, 1).weight(1.0, 1.0).add(((EditWordsDialog)object2).dictBox).advance();
        ((EditWordsDialog)object2).dictBox.setVisible(false);
        object4 = new JPanel();
        object5 = new GridHelper((Container)object4);
        ((GridHelper)object5).add(((EditWordsDialog)object2).advancedButton).stretch();
        ((GridHelper)object5).add(((EditWordsDialog)object2).nextButton).space(5).add((Component)serializable);
        ((GridHelper)object3).size(3, 1).add((Component)object4);
        this.showCurrentWord(false);
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.getContentPane().add((Component)object);
        ((JComponent)object).registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.setDefaultCloseOperation(2);
        this.pack();
        boolean bl2 = this.prefsNode.getBoolean("advanced edit", false);
        if (bl2) {
            this.advancedButton.doClick();
        }
    }

    private JComponent buildBoxPanel() {
        this.primaryIndex = CCDictionaries.getPrimaryIndex();
        Serializable serializable = new JPanel();
        JScrollPane jScrollPane = new JScrollPane((Component)serializable);
        jScrollPane.setPreferredSize(new Dimension(10, 100));
        jScrollPane.setBorder(null);
        serializable = new GridHelper((Container)serializable);
        ((GridHelper)serializable).space().stretch().space();
        ((GridHelper)serializable).space(10).space();
        ((GridHelper)serializable).advance();
        this.dictChecks = new ArrayList();
        this.dictDelChecks = new ArrayList();
        ArrayList<File> arrayList = CCDictionaries.getDictionaries();
        ((GridHelper)serializable).add(new JLabel("Dictionary")).space().add(new JLabel("Change"));
        ((GridHelper)serializable).space().add(new JLabel("Delete"));
        ((GridHelper)serializable).advance();
        ((GridHelper)serializable).size(5, 1).add(new JSeparator()).advance();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object = arrayList.get(i).getName();
            if (i == this.primaryIndex) {
                object = "<html><b><i>" + (String)object + "</i></b></html>";
            }
            object = new JLabel((String)object);
            ((GridHelper)serializable).add((Component)object);
            object = new JCheckBox();
            ((JComponent)object).setOpaque(false);
            ((GridHelper)serializable).space().add((Component)object);
            this.dictChecks.add((JCheckBox)object);
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setOpaque(false);
            ((GridHelper)serializable).space().add(jCheckBox);
            ((GridHelper)serializable).advance();
            this.dictDelChecks.add(jCheckBox);
            ((AbstractButton)object).addItemListener(new XorListener(this, (JCheckBox)object, jCheckBox));
            jCheckBox.addItemListener(new XorListener(this, jCheckBox, (JCheckBox)object));
            ((Component)object).setFocusable(false);
            jCheckBox.setFocusable(false);
        }
        ((GridHelper)serializable).advance(0, 1.0);
        JPanel jPanel = new JPanel();
        GridHelper gridHelper = new GridHelper(jPanel);
        gridHelper.stretch().advance(20);
        gridHelper.add(jScrollPane).advance(0, 1.0);
        gridHelper.advance(20);
        return jPanel;
    }

    public final int getDictHeight() {
        if (this.dictHeight == 0) {
            this.dictHeight = 20;
            Container container = this.dictChecks.get(0).getParent();
            this.dictHeight += container.getPreferredSize().height;
            Insets insets = container.getInsets();
            this.dictHeight += insets.top + insets.bottom;
            container = container.getParent();
            insets = container.getInsets();
            this.dictHeight += insets.top + insets.bottom;
            container = container.getParent();
            insets = container.getInsets();
            this.dictHeight += insets.top + insets.bottom;
            container = container.getParent();
            insets = container.getInsets();
            this.dictHeight += insets.top + insets.bottom;
            if (this.dictHeight > 200) {
                this.dictHeight = 200;
            }
        }
        return this.dictHeight;
    }

    private void showCurrentWord(boolean bl) {
        ClueData.Clue clue;
        String string;
        String string2;
        String string3;
        if (!this.isAddDialog) {
            string3 = this.compWords[this.currentIndex];
            string2 = this.list.getOrigWord(string3);
            string = this.list.deleteNonLetters(string2);
        } else {
            string2 = this.wordField.getText();
            string = string3 = this.list.deleteNonLetters(string2);
        }
        float f = this.list.getWordScore(string3);
        String string4 = "???";
        if (this.clueData != null && (clue = this.clueData.getBestClue(string2)) != null) {
            string4 = clue.definition;
        }
        this.letterLabel.setText(string);
        this.clueLabel.setText(string4);
        this.ignoreFieldChanges = true;
        if (!this.isAddDialog) {
            this.wordField.setText(string2);
            float f2 = f;
            this.scoreField.setText(Integer.toString((int)f2));
            if (bl) {
                this.scoreField.requestFocusInWindow();
                this.scoreField.selectAll();
            }
        } else {
            if (this.scoreField.getText().trim().length() == 0) {
                this.scoreField.setText("5");
            }
            if (bl) {
                this.wordField.requestFocusInWindow();
                this.wordField.selectAll();
            }
        }
        this.ignoreFieldChanges = false;
        this.updateFieldSelections(string3);
    }

    private void updateFieldSelections(String object) {
        object = this.list.getWordDictionaries((String)object);
        this.ignoreFieldChanges = true;
        int n = ((BitSet)object).nextSetBit(0);
        if (n == -1 || n > this.primaryIndex) {
            n = this.primaryIndex;
        }
        int n2 = this.dictChecks.size();
        for (int i = 0; i < n2; ++i) {
            boolean bl = ((BitSet)object).get(i);
            JCheckBox jCheckBox = this.dictChecks.get(i);
            JCheckBox jCheckBox2 = this.dictDelChecks.get(i);
            jCheckBox.setSelected(this.isChanged && i == n);
            jCheckBox2.setSelected(false);
            jCheckBox2.setVisible(bl);
        }
        this.ignoreFieldChanges = false;
    }

    final class XorListener
    implements ItemListener {
        private final JCheckBox mDb;
        private final JCheckBox mCb;
        private /* synthetic */ EditWordsDialog this$0;

        private XorListener(EditWordsDialog editWordsDialog, JCheckBox jCheckBox, JCheckBox jCheckBox2) {
            this.this$0 = editWordsDialog;
            this.mDb = jCheckBox2;
            this.mCb = jCheckBox;
        }

        @Override
        public final void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this.mCb && this.mCb.isSelected() && this.mDb.isSelected()) {
                this.mDb.setSelected(false);
            }
            if (!this.this$0.ignoreFieldChanges) {
                this.this$0.isChanged = true;
            }
        }
    }
}

