/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.xwd.BadStateError;
import com.beekeeper.xwd.SearchNode;
import com.beekeeper.xwd.SearchNodeProxy;
import com.beekeeper.xwd.Threads;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DepthPlusSearch {
    private final int optWidth;
    private final SearchNode startNode;
    private final LinkedList<SearchNode.Fingerprint> deadStateList = new LinkedList();
    private int maxDeadStates;
    private HashSet<SearchNode.Fingerprint> deadStates;
    private boolean isExhaustive;
    public int maxWidth = Integer.MAX_VALUE;
    private int randomizeCount = -1;
    private volatile int searchCount = 0;
    private volatile int maxDepth;
    private final Random rand = new Random();
    private TreeSet<SearchNodeProxy> queue = new TreeSet((searchNodeProxy, searchNodeProxy2) -> {
        int n = searchNodeProxy2.getDepth() - searchNodeProxy.getDepth();
        if (n != 0) {
            return n;
        }
        float f = searchNodeProxy2.getPriority() - searchNodeProxy.getPriority();
        if (f != 0.0f) {
            if (f < 0.0f) {
                return -1;
            }
            return 1;
        }
        return searchNodeProxy.hashCode() - searchNodeProxy2.hashCode();
    });

    public DepthPlusSearch(SearchNode searchNode) {
        this(searchNode, 5);
    }

    public DepthPlusSearch(SearchNode searchNode, int n) {
        this.startNode = searchNode;
        this.optWidth = n;
        this.setMaxDeadStates(4096);
    }

    public final SearchNode search2(int n) {
        SearchNode searchNode = this.search(Integer.MAX_VALUE);
        if (searchNode == null || !searchNode.isGoalNode()) {
            return null;
        }
        return searchNode;
    }

    public final synchronized SearchNode search(int n) {
        this.startNode.initForSearch();
        this.searchCount = 0;
        this.deadStateList.clear();
        this.deadStates.clear();
        this.queue.clear();
        this.queue.add(this.startNode);
        float f = Float.NEGATIVE_INFINITY;
        SearchNode searchNode = null;
        SearchNode searchNode2 = null;
        while (!this.queue.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            SearchNode searchNode3 = this.advance();
            if (searchNode3 != null) {
                if (searchNode3.isGoalNode()) {
                    float f2;
                    if (!this.isExhaustive) {
                        searchNode = searchNode3;
                        break;
                    }
                    float f3 = searchNode3.getQuality();
                    if (f2 > f) {
                        searchNode = searchNode3;
                        f = f3;
                    }
                } else if (searchNode2 == null || searchNode3.depth > searchNode2.depth) {
                    searchNode2 = searchNode3;
                }
            }
            if (this.searchCount <= n) continue;
            if (searchNode != null) break;
            searchNode = searchNode2;
            break;
        }
        this.startNode.markFinished();
        return searchNode;
    }

    private SearchNode advance() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object[] objectArray = new ArrayList();
            for (int i = 0; i < this.optWidth && !this.queue.isEmpty(); ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                SearchNodeProxy searchNodeProxy = this.queue.first();
                object3 = searchNodeProxy.getParent();
                int n = this.randomizeCount;
                if (object3 != null) {
                    SearchNode searchNode = object3;
                    searchNode.getLiveChildCount();
                    n = this.getRandomizeCount$7f9542f1(searchNode);
                }
                int n2 = Math.max(1, Math.min(n, this.queue.size()));
                int n3 = this.rand.nextInt(n2);
                object2 = this.queue.iterator();
                for (int j = 0; j < n3; ++j) {
                    object2.next();
                }
                object = (SearchNodeProxy)object2.next();
                object2.remove();
                objectArray.add(() -> this.lambda$advance$1((SearchNodeProxy)object));
            }
            List list = Threads.getInstance().invokeAll(objectArray);
            ++this.searchCount;
            Object object4 = new ArrayList<Callable<SuccessorsResult>>();
            object3 = null;
            Object object5 = null;
            for (Future future : list) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                ExpandResult expandResult = (ExpandResult)future.get();
                if (expandResult == null) continue;
                object2 = expandResult.node;
                if (object3 == null) {
                    object3 = object2;
                }
                if (object5 != null) {
                    this.queue.add(expandResult.proxy);
                    continue;
                }
                if (((SearchNode)object2).isGoalNode()) {
                    object5 = object2;
                    continue;
                }
                ((ArrayList)object4).add(() -> DepthPlusSearch.lambda$advance$2((SearchNode)object2));
            }
            if (object5 != null) {
                return object5;
            }
            object = Threads.getInstance().invokeAll(object4);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Future future = iterator.next();
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                object2 = (SuccessorsResult)future.get();
                object4 = ((SuccessorsResult)object2).node;
                objectArray = ((SuccessorsResult)object2).successors;
                if (((SuccessorsResult)object2).successors == null || objectArray.length == 0) {
                    if (this.maxDeadStates > 0) {
                        if (this.deadStateList.size() == this.maxDeadStates) {
                            this.deadStates.remove(this.deadStateList.removeFirst());
                        }
                        SearchNode.Fingerprint fingerprint = ((SearchNode)object4).getFingerprint();
                        this.deadStateList.addLast(fingerprint);
                        this.deadStates.add(fingerprint);
                    }
                    try {
                        ((SearchNode)object4).markDead(true);
                    }
                    catch (BadStateError badStateError) {
                        this.doBacktrack(badStateError, (SearchNode)object4);
                    }
                    SearchNode searchNode = ((SearchNode)object4).parent;
                    while (searchNode != null && --searchNode.liveChildCount == 0) {
                        try {
                            searchNode.markDead(true);
                        }
                        catch (BadStateError badStateError) {
                            this.doBacktrack(badStateError, searchNode);
                        }
                        if (this.maxDeadStates <= 0) continue;
                        if (this.deadStateList.size() == this.maxDeadStates) {
                            this.deadStates.remove(this.deadStateList.removeFirst());
                        }
                        SearchNode.Fingerprint fingerprint = searchNode.getFingerprint();
                        this.deadStateList.addLast(fingerprint);
                        this.deadStates.add(fingerprint);
                    }
                    continue;
                }
                Arrays.sort(objectArray);
                int n = Math.min(objectArray.length, this.maxWidth);
                for (int i = 0; i < n; ++i) {
                    this.queue.add((SearchNodeProxy)objectArray[i]);
                }
                ((SearchNode)object4).setLiveChildCount(n);
            }
            return object3;
        }
        catch (InterruptedException | ExecutionException exception) {
            return null;
        }
    }

    private synchronized void doBacktrack(BadStateError badStateError, SearchNode searchNode) {
        SearchNode searchNode2 = searchNode;
        do {
            searchNode2.markFinished();
            if (searchNode2 != searchNode) {
                if (this.maxDeadStates > 0) {
                    if (this.deadStateList.size() == this.maxDeadStates) {
                        this.deadStates.remove(this.deadStateList.removeFirst());
                    }
                    SearchNode.Fingerprint fingerprint = searchNode2.getFingerprint();
                    this.deadStateList.addLast(fingerprint);
                    this.deadStates.add(fingerprint);
                }
                try {
                    searchNode2.markDead(false);
                }
                catch (BadStateError badStateError2) {}
            }
            searchNode2 = searchNode2.parent;
        } while (searchNode2.parent != null && !badStateError.acceptableState(searchNode2, this.startNode));
    }

    public final void setRandomizeCount(int n) {
        this.randomizeCount = 50;
    }

    public int getRandomizeCount$7f9542f1(SearchNode searchNode) {
        return this.randomizeCount;
    }

    public final void setExhaustive(boolean bl) {
        this.isExhaustive = true;
    }

    public final void setMaxDeadStates(int n) {
        this.maxDeadStates = n;
        this.deadStates = new HashSet(this.maxDeadStates, 0.7f);
    }

    private static /* synthetic */ SuccessorsResult lambda$advance$2(SearchNode searchNode) throws Exception {
        SearchNode searchNode2 = searchNode;
        return new SuccessorsResult(searchNode2, searchNode2.generateSuccessors(Float.NEGATIVE_INFINITY));
    }

    private /* synthetic */ ExpandResult lambda$advance$1(SearchNodeProxy searchNodeProxy) throws Exception {
        int n = searchNodeProxy.getDepth();
        if (n > this.maxDepth) {
            this.maxDepth = n;
        }
        SearchNode searchNode = searchNodeProxy.getParent();
        while (searchNode != null) {
            SearchNode searchNode2 = searchNode;
            if (searchNode2.isFinished) {
                return null;
            }
            searchNode = searchNode.parent;
        }
        SearchNodeProxy searchNodeProxy2 = searchNodeProxy;
        return new ExpandResult(searchNodeProxy2, searchNodeProxy2.getNode());
    }

    static final class ExpandResult {
        public final SearchNodeProxy proxy;
        public final SearchNode node;

        public ExpandResult(SearchNodeProxy searchNodeProxy, SearchNode searchNode) {
            this.proxy = searchNodeProxy;
            this.node = searchNode;
        }
    }

    static final class SuccessorsResult {
        public final SearchNode node;
        public final SearchNodeProxy[] successors;

        public SuccessorsResult(SearchNode searchNode, SearchNodeProxy[] searchNodeProxyArray) {
            this.node = searchNode;
            this.successors = searchNodeProxyArray;
        }
    }
}

