/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.closedhash.ObjectSet;
import com.beekeeper.xwd.BadStateError;
import com.beekeeper.xwd.SearchNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;

public class DepthFirstSearch {
    private int maxDeadStates = 4096;
    public int searchCount = 0;
    private final SearchNode startNode;
    private int mxNodes;
    private final LinkedList<SearchNode.Fingerprint> deadStateList = new LinkedList();
    private final ObjectSet<SearchNode.Fingerprint> deadStates = new ObjectSet(this.maxDeadStates, 0.7);
    private int maxDepth;
    private boolean isExhaustive;
    public int maxWidth = Integer.MAX_VALUE;
    private int randomizeCount = -1;

    public DepthFirstSearch(SearchNode searchNode) {
        this.startNode = searchNode;
    }

    public final SearchNode search(int n) {
        this.startNode.initForSearch();
        this.searchCount = 0;
        this.mxNodes = n;
        this.deadStateList.clear();
        this.deadStates.clear();
        try {
            DepthFirstSearch depthFirstSearch = this;
            SearchNode searchNode = depthFirstSearch.search(depthFirstSearch.startNode);
            return searchNode;
        }
        catch (BadStateError badStateError) {
            SearchNode searchNode = null;
            return searchNode;
        }
        finally {
            this.startNode.markFinished();
        }
    }

    public final SearchNode search2(int n) {
        SearchNode searchNode = this.search(n);
        if (searchNode == null || !searchNode.isGoalNode()) {
            return null;
        }
        return searchNode;
    }

    private SearchNode search(SearchNode searchNode) throws BadStateError {
        int n = searchNode.depth;
        if (n > this.maxDepth) {
            this.maxDepth = n;
        }
        ++this.searchCount;
        if (searchNode.isGoalNode()) {
            return searchNode;
        }
        Object[] objectArray = searchNode.generateSuccessors(Float.NEGATIVE_INFINITY);
        Arrays.sort(objectArray);
        int n2 = Math.min(this.getRandomizeCount$7f9542f1(searchNode), objectArray.length);
        if (n2 > 0) {
            Collections.shuffle(Arrays.asList(objectArray).subList(0, n2));
        }
        n2 = Math.min(objectArray.length, this.maxWidth);
        float f = Float.NEGATIVE_INFINITY;
        ObjectSet<SearchNode.Fingerprint> objectSet = null;
        for (int i = 0; i < n2; ++i) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            SearchNode searchNode2 = objectArray[i].getNode();
            objectArray[i] = null;
            ObjectSet<SearchNode.Fingerprint> objectSet2 = this.deadStates;
            SearchNode.Fingerprint fingerprint = searchNode2.getFingerprint();
            if (objectSet2.hasKey(fingerprint) || this.maxDeadStates > 0 && !searchNode2.reconcileWithDeadStates(this.deadStates)) continue;
            try {
                objectSet2 = this.search(searchNode2);
                if (objectSet2 != null) {
                    float f2;
                    if (!this.isExhaustive) {
                        return objectSet2;
                    }
                    float f3 = ((SearchNode)((Object)objectSet2)).getQuality();
                    if (f2 > f) {
                        f = f3;
                        objectSet = objectSet2;
                    }
                }
                if (this.searchCount < this.mxNodes) continue;
                if (objectSet != null) {
                    return objectSet;
                }
                return searchNode;
            }
            catch (BadStateError badStateError) {
                if (searchNode2 != badStateError.getSource()) {
                    if (this.maxDeadStates > 0) {
                        if (this.deadStateList.size() == this.maxDeadStates) {
                            this.deadStates.remove(this.deadStateList.removeFirst());
                        }
                        fingerprint = searchNode2.getFingerprint();
                        this.deadStateList.addLast(fingerprint);
                        this.deadStates.add(fingerprint);
                    }
                    searchNode2.markDead(false);
                }
                if (badStateError.acceptableState(searchNode, this.startNode)) continue;
                throw badStateError;
            }
        }
        if (objectSet != null) {
            return objectSet;
        }
        if (this.maxDeadStates > 0) {
            if (this.deadStateList.size() == this.maxDeadStates) {
                this.deadStates.remove(this.deadStateList.removeFirst());
            }
            SearchNode.Fingerprint fingerprint = searchNode.getFingerprint();
            this.deadStateList.addLast(fingerprint);
            this.deadStates.add(fingerprint);
        }
        searchNode.markDead(true);
        return null;
    }

    public final void setRandomizeCount(int n) {
        this.randomizeCount = 50;
    }

    public int getRandomizeCount$7f9542f1(SearchNode searchNode) {
        return this.randomizeCount;
    }

    public final void setExhaustive(boolean bl) {
        this.isExhaustive = true;
    }

    public final void setMaxDeadStates(int n) {
        this.maxDeadStates = 0;
    }
}

