/*
 * Decompiled with CFR 0.152.
 */
package com.beekeeper.xwd;

import com.beekeeper.util.StringTable;
import com.beekeeper.util.closedhash.ObjectFloatHash;
import com.beekeeper.util.closedhash.ObjectIntHash;
import com.beekeeper.xwd.WordList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ClueData {
    private final ObjectIntHash<String> map;
    private final FileChannel channel;
    private final ByteBuffer buffer;
    private int version;
    private int[] clueOffsets;
    private String[] words;
    private final boolean includeThesaurus;
    private String[] pubNames = new String[]{"CHE", "CSy", "Jon", "LAT", null, "NYS", "NYT", "Rea", "Tau", null, "WaP", "WSJ", "UNK", "Thesaurus"};
    private float[] pubAuthorities = new float[]{0.8f, 0.8f, 0.5f, 1.0f, 0.0f, 1.0f, 1.0f, 0.8f, 0.8f, 0.0f, 1.0f, 0.8f, 0.2f, 0.01f};

    /*
     * Loose catch block
     */
    public ClueData(File file) throws IOException {
        this.includeThesaurus = false;
        this.map = new ObjectIntHash();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            this.channel = randomAccessFile.getChannel();
            this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            try {
                this.buffer.clear();
                this.tryVersion3();
                return;
            }
            catch (Throwable throwable) {
                this.buffer.clear();
                this.tryVersion2();
                randomAccessFile.close();
                return;
                {
                    catch (Throwable throwable2) {
                        throw new IllegalArgumentException("Couldn't read clue file:" + file);
                    }
                }
            }
        }
    }

    private void tryVersion3() throws UnsupportedEncodingException {
        int n;
        int n2;
        int n3 = this.buffer.getInt();
        this.words = new String[n3];
        byte[] byArray = new byte[30];
        for (n2 = 0; n2 < n3; ++n2) {
            String string;
            n = this.buffer.get() & 0xFF;
            if (n > byArray.length) {
                byArray = new byte[n];
            }
            this.buffer.get(byArray, 0, n);
            this.words[n2] = string = StringTable.getDefault().intern(new String(byArray, 0, n, "utf-8").toLowerCase(), false);
        }
        n2 = this.buffer.getInt();
        this.clueOffsets = new int[n2];
        for (n = 0; n < n2; ++n) {
            int n4;
            this.clueOffsets[n] = n4 = this.buffer.position();
            n3 = this.buffer.get() & 0xFF;
            this.buffer.position(n4 + n3 + 1);
            n3 = this.buffer.getInt();
            this.buffer.position(this.buffer.position() + (n3 << 2));
        }
        while (this.buffer.hasRemaining()) {
            n = this.buffer.position();
            int n5 = this.buffer.getInt();
            if (!this.map.hasKey(this.words[n5])) {
                this.map.put(this.words[n5], n);
            }
            this.buffer.position(n + 16);
        }
        this.version = 4;
    }

    private void tryVersion2() {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            char c;
            int n = this.buffer.position();
            Object object = this.readLine();
            if (object == null) break;
            int n2 = 0;
            while ((c = ((String)object).charAt(n2++)) != ' ') {
                stringBuilder.append(Character.toLowerCase(c));
            }
            String string = stringBuilder.toString();
            object = StringTable.getDefault();
            String string2 = ((StringTable)object).intern(string, true);
            stringBuilder.setLength(0);
            if (this.map.hasKey(string2)) continue;
            this.map.put(string2, n);
        }
        this.version = 2;
    }

    private String readLine() {
        char c;
        if (!this.buffer.hasRemaining()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(80);
        while (this.buffer.hasRemaining() && (c = (char)(this.buffer.get() & 0xFF)) != '\n') {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public final synchronized List<Clue> getClues(String string) {
        ArrayList<Clue> arrayList = new ArrayList<Clue>();
        string = WordList.deleteNonLettersGeneric(string);
        int n = this.map.get(string, -1);
        if (this.version == 2) {
            if (n != -1) {
                String[] stringArray;
                String string2;
                this.buffer.position(n);
                while ((string2 = this.readLine()) != null && (stringArray = string2.split(" ++", 8))[0].equalsIgnoreCase(string)) {
                    int n2 = Integer.parseInt(stringArray[1]);
                    float f = (float)Integer.parseInt(stringArray[2]) / (float)n2;
                    String[] stringArray2 = stringArray[7].split(" @@ ");
                    String[] stringArray3 = stringArray2.length == 1 ? new String[]{} : stringArray2[1].split(" ++");
                    String string3 = stringArray[6];
                    if (string3 == null) {
                        string3 = "Unknown";
                    }
                    if ("Thesaurus".equals(string3)) continue;
                    arrayList.add(new Clue(string, n2, f, stringArray[3], stringArray[4].equals("1"), string3, 1.0f, stringArray2[0], -1, stringArray3));
                }
            }
            return arrayList;
        }
        if (this.version <= 4) {
            if (n != -1) {
                int n3;
                int n4;
                this.buffer.position(n);
                n = -1;
                while (this.buffer.hasRemaining()) {
                    int n5 = this.buffer.getInt();
                    if (n == -1) {
                        n = n5;
                    } else if (n != n5) break;
                    short s = this.buffer.getShort();
                    n4 = this.buffer.getShort();
                    short s2 = this.buffer.getShort();
                    boolean bl = this.buffer.get() == 1;
                    n3 = this.buffer.get();
                    if (n3 == 12) {
                        if (this.version == 4 && n4 == 0) {
                            this.version = 3;
                        }
                        if (this.version < 4) {
                            n3 = 13;
                        }
                    }
                    int n6 = this.buffer.getInt();
                    String string4 = n3 >= this.pubNames.length ? null : this.pubNames[n3];
                    if (string4 == null) {
                        string4 = "Unknown";
                    }
                    if ("Thesaurus".equals(string4)) continue;
                    float f = n3 >= this.pubNames.length ? 0.0f : this.pubAuthorities[n3];
                    arrayList.add(new Clue(string, s, (float)n4 / (float)s, Integer.toString(s2), bl, string4, f, null, this.clueOffsets[n6], null));
                }
                for (Clue clue : arrayList) {
                    String string5;
                    this.buffer.position(clue.defOffset);
                    n4 = this.buffer.get() & 0xFF;
                    byte[] byArray = new byte[n4];
                    this.buffer.get(byArray);
                    clue.definition = string5 = ClueData.guessEncoding(byArray, 0, n4);
                    n3 = this.buffer.getInt();
                    if (n3 == 1) {
                        clue.setConfusers(new String[0]);
                        continue;
                    }
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (int i = 0; i < n3; ++i) {
                        int n7 = this.buffer.getInt();
                        n = n7 % 2 != 0 ? 1 : 0;
                        if (n != 0 || this.words[n = n7 / 2].equals(string)) continue;
                        arrayList2.add(this.words[n]);
                    }
                    ArrayList<String> arrayList3 = arrayList2;
                    clue.setConfusers(arrayList3.toArray(new String[arrayList3.size()]));
                }
            }
            return arrayList;
        }
        throw new IllegalStateException("Unknown database version.");
    }

    private static String guessEncoding(byte[] object, int n, int n2) {
        object = ByteBuffer.wrap((byte[])object, 0, n2);
        StringBuilder stringBuilder = new StringBuilder();
        while (((Buffer)object).remaining() > 0) {
            int n3;
            n2 = ((Buffer)object).position();
            boolean bl = false;
            try {
                n3 = WordList.readUTFChar((ByteBuffer)object);
                if (n3 != -1 && n3 <= 256) {
                    stringBuilder.append((char)n3);
                    bl = true;
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {}
            if (bl) continue;
            ((ByteBuffer)object).position(n2);
            byte by = ((ByteBuffer)object).get();
            n3 = by;
            n2 = (char)(by & 0xFF);
            stringBuilder.append((char)n2);
        }
        return stringBuilder.toString();
    }

    public final Clue getBestClue(String object) {
        Object object2 = new ObjectFloatHash<String>();
        if ((object = this.getClues((String)object)).isEmpty()) {
            return null;
        }
        Object object3 = object.iterator();
        while (object3.hasNext()) {
            Clue clue = (Clue)object3.next();
            float f = clue.sourceAuthority / (clue.difficulty + 1.0f);
            ((ObjectFloatHash)object2).put(clue.definition, ((ObjectFloatHash)object2).get(clue.definition, 0.0f) + f);
        }
        object3 = null;
        float f = -1.0f;
        ObjectFloatHash.Iter iter = ((ObjectFloatHash)object2).getIterator();
        while (iter.advance()) {
            float f2;
            object2 = (String)iter.getKey();
            float f3 = iter.getValue();
            if (!(f2 > f)) continue;
            object3 = object2;
            f = f3;
        }
        float f4 = -1.0f;
        object2 = null;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (Clue)iterator.next();
            if (!((Clue)object).definition.equals(object3) || !(((Clue)object).sourceAuthority > f4)) continue;
            object2 = object;
            f4 = ((Clue)object).sourceAuthority;
        }
        return object2;
    }

    public static final class Clue {
        public String word;
        public float difficulty;
        public String publication;
        public float sourceAuthority;
        public String definition;
        public String[] confusers;
        public int defOffset;
        public int confusionRank;

        public Clue(String string, int n, float f, String string2, boolean bl, String string3, float f2, String string4, int n2, String[] stringArray) {
            this.word = string;
            this.difficulty = f;
            this.publication = string3;
            this.sourceAuthority = f2;
            this.definition = string4;
            this.defOffset = n2;
            this.setConfusers(stringArray);
        }

        private void setConfusers(String[] stringArray) {
            this.confusionRank = 0;
            this.confusers = stringArray;
            if (stringArray != null) {
                for (String string : stringArray) {
                    if (string.length() != this.word.length()) continue;
                    int n = 1;
                    int n2 = string.length();
                    for (int i = 0; i < n2; ++i) {
                        if (string.charAt(i) != this.word.charAt(i)) continue;
                        ++n;
                    }
                    int n3 = n;
                    this.confusionRank += n3 * n3;
                }
            }
        }
    }
}

